/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.atom.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.core.approve.repository.api.ApproveRepository;
import com.tydic.dyc.base.core.approve.repository.bo.FlowTaskInfoDo;
import com.tydic.dyc.base.core.approve.repository.bo.FlowTaskQryDo;
import com.tydic.fsc.busibase.atom.api.FscBussiBackStepAtomService;
import com.tydic.fsc.busibase.atom.bo.FscBussiBackStepAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscBussiBackStepAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscLogOrdBusiMapper;
import com.tydic.fsc.dao.FscOrdStateChgLogMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscLogOrdBusiPO;
import com.tydic.fsc.po.FscOrdStateChgLogPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.osworkflow.ability.OsworkflowBackStepAbilityService;
import com.tydic.osworkflow.ability.bo.BackToLastStepReqBO;
import com.tydic.osworkflow.ability.bo.BackToLastStepRespBO;
import com.tydic.osworkflow.ability.bo.TaskInfo;
import com.tydic.osworkflow.ability.bo.TaskInfoWithInst;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscBussiBackStepAtomServiceImpl
implements FscBussiBackStepAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscBussiBackStepAtomServiceImpl.class);
    @Autowired
    private OsworkflowBackStepAbilityService osworkflowBackStepAbilityService;
    @Autowired
    private ApproveRepository approveRepository;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscLogOrdBusiMapper fscLogOrdBusiMapper;
    @Autowired
    private FscOrdStateChgLogMapper fscOrdStateChgLogMapper;

    @Override
    public FscBussiBackStepAtomRspBO dealBussiBackStep(FscBussiBackStepAtomReqBO reqBO) {
        FlowTaskInfoDo taskInstPo = this.getUocOrderTaskInstPo(reqBO);
        if (ObjectUtil.isNull((Object)taskInstPo)) {
            log.info("\u6ca1\u6709\u67e5\u8be2\u5230\u4e1a\u52a1\u6d41\u5f53\u524d\u73af\u8282\u4fe1\u606f");
            return new FscBussiBackStepAtomRspBO();
        }
        FscOrderPO fscOrderPo = this.getFscOrderPo(reqBO);
        BackToLastStepRespBO backToLastStepRespBO = this.backToLastStep(taskInstPo);
        TaskInfoWithInst taskInfoWithInst = backToLastStepRespBO.getTaskInfoWithInst();
        List taskInfoList = taskInfoWithInst.getTaskInfoList();
        if (CollectionUtil.isNotEmpty((Collection)taskInfoList)) {
            TaskInfo taskInfo = (TaskInfo)taskInfoList.get(0);
            this.updateStatus(reqBO, taskInfo);
            this.writeLog(reqBO, fscOrderPo, taskInfo);
        }
        FscBussiBackStepAtomRspBO backStepAtomRspBO = new FscBussiBackStepAtomRspBO();
        backStepAtomRspBO.setRespCode("0000");
        backStepAtomRspBO.setRespDesc("\u6210\u529f");
        return backStepAtomRspBO;
    }

    private FscOrderPO getFscOrderPo(FscBussiBackStepAtomReqBO reqBO) {
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getOrderId());
        List<FscOrderPO> fscOrderPOS = this.fscOrderMapper.getList(fscOrderPO);
        if (CollectionUtils.isEmpty(fscOrderPOS)) {
            throw new FscBusinessException("194309", "\u7ed3\u7b97\u72b6\u6001\u673a\u6ca1\u6709\u67e5\u8be2\u5230\u6d41\u7a0b\u5931\u8d25");
        }
        fscOrderPO = fscOrderPOS.get(0);
        if (null == fscOrderPO) {
            throw new FscBusinessException("194309", "\u7ed3\u7b97\u72b6\u6001\u673a\u6ca1\u6709\u67e5\u8be2\u5230\u6d41\u7a0b");
        }
        return fscOrderPO;
    }

    private void updateStatus(FscBussiBackStepAtomReqBO reqBO, TaskInfo taskInfo) {
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(reqBO.getOrderId());
        fscOrderPo.setOrderState(Integer.valueOf(taskInfo.getStepId()));
        if (null != reqBO.getUserId()) {
            fscOrderPo.setUpdateOperId(reqBO.getUserId().toString());
        }
        fscOrderPo.setUpdateOperName(reqBO.getUserName());
        fscOrderPo.setUpdateTime(new Date());
        fscOrderPo.setUpdateTimeEnd(new Date());
        fscOrderPo.setTaskId(taskInfo.getTaskId());
        this.fscOrderMapper.updateById(fscOrderPo);
    }

    private BackToLastStepRespBO backToLastStep(FlowTaskInfoDo taskInstPo) {
        BackToLastStepReqBO backToLastStepReqBO = new BackToLastStepReqBO();
        backToLastStepReqBO.setStepId(taskInstPo.getStepCode());
        backToLastStepReqBO.setProcInstId(taskInstPo.getProcInstId());
        log.info("\u8c03\u7528\u6d41\u7a0b\u4e2d\u5fc3\u56de\u9000\u4e0a\u4e00\u4e2a\u73af\u8282\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)backToLastStepReqBO));
        BackToLastStepRespBO backToLastStepRespBO = this.osworkflowBackStepAbilityService.backToLastStep(backToLastStepReqBO);
        log.info("\u8c03\u7528\u6d41\u7a0b\u4e2d\u5fc3\u56de\u9000\u4e0a\u4e00\u4e2a\u73af\u8282\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)backToLastStepRespBO));
        if (!"0000".equals(backToLastStepRespBO.getRespCode())) {
            throw new FscBusinessException("191036", "\u6d41\u7a0b\u4e2d\u5fc3\u56de\u9000\u4e0a\u4e00\u4e2a\u73af\u8282\u5931\u8d25: " + backToLastStepRespBO.getRespDesc());
        }
        return backToLastStepRespBO;
    }

    private FlowTaskInfoDo getUocOrderTaskInstPo(FscBussiBackStepAtomReqBO reqBO) {
        FlowTaskQryDo uocOrderProcInstPo = new FlowTaskQryDo();
        uocOrderProcInstPo.setObjId(reqBO.getOrderId());
        uocOrderProcInstPo.setObjType(FscConstants.OBJ_TYPE.FSC_ORDER);
        uocOrderProcInstPo.setFinishTag(FscConstants.FinishTag.NO);
        uocOrderProcInstPo.setOrderBy("CREATE_TIME DESC");
        uocOrderProcInstPo.setCenterCode("FSC");
        List uocOrderProcInstPos = this.approveRepository.queryFlowTask(uocOrderProcInstPo);
        return CollectionUtil.isEmpty((Collection)uocOrderProcInstPos) ? null : (FlowTaskInfoDo)uocOrderProcInstPos.get(0);
    }

    private void writeLog(FscBussiBackStepAtomReqBO reqBO, FscOrderPO fscOrderPO, TaskInfo taskInfo) {
        FscLogOrdBusiPO fscLogOrdBusiPo = new FscLogOrdBusiPO();
        fscLogOrdBusiPo.setBusiName(taskInfo.getStepName());
        fscLogOrdBusiPo.setBusiType(fscOrderPO.getOrderFlow());
        fscLogOrdBusiPo.setCreateCompanyId(reqBO.getCompanyId());
        fscLogOrdBusiPo.setCreateCompanyName(reqBO.getCompanyName());
        fscLogOrdBusiPo.setCreateOperId(reqBO.getUserId());
        fscLogOrdBusiPo.setCreateOperName(reqBO.getName());
        fscLogOrdBusiPo.setCreateOrgId(reqBO.getOrgId());
        fscLogOrdBusiPo.setCreateOrgName(reqBO.getOrgName());
        fscLogOrdBusiPo.setCreateTime(new Date());
        fscLogOrdBusiPo.setFscOrderId(reqBO.getOrderId());
        this.fscLogOrdBusiMapper.insert(fscLogOrdBusiPo);
        FscOrdStateChgLogPO fscOrdStateChgLogPo = new FscOrdStateChgLogPO();
        fscOrdStateChgLogPo.setFscOrderId(fscOrderPO.getFscOrderId());
        fscOrdStateChgLogPo.setOldState(fscOrderPO.getOrderState());
        fscOrdStateChgLogPo.setNewState(Integer.valueOf(taskInfo.getStepId()));
        fscOrdStateChgLogPo.setChgTime(new Date());
        if (null != reqBO.getUserId()) {
            fscOrdStateChgLogPo.setOperId(reqBO.getUserId().toString());
        }
        fscOrdStateChgLogPo.setChgDesc(taskInfo.getStepName() + "backToLastStep");
        this.fscOrdStateChgLogMapper.insert(fscOrdStateChgLogPo);
    }
}

