/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.atom.impl;

import com.tydic.fsc.bo.InvoiceBO;
import com.tydic.fsc.busibase.atom.api.FscInvoiceCheckAtomService;
import com.tydic.fsc.busibase.atom.bo.FscInvoiceCheckAtomServiceReqBo;
import com.tydic.fsc.busibase.atom.bo.FscInvoiceCheckAtomServiceRspBo;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class FscInvoiceCheckAtomServiceImpl
implements FscInvoiceCheckAtomService {
    @Override
    public FscInvoiceCheckAtomServiceRspBo checkInvoice(FscInvoiceCheckAtomServiceReqBo reqBo) {
        this.val(reqBo);
        Integer invoiceCombine = FscConstants.invoiceCombine((Integer)reqBo.getInvoiceCategory(), (String)reqBo.getInvoiceType());
        InvoiceBO invoiceBO = reqBo.getInvoiceBO();
        if (FscConstants.InvoiceCategory.ALL_ELECTRON.equals(reqBo.getInvoiceCategory())) {
            if ("01".equals(reqBo.getInvoiceType())) {
                this.allElecGeneralCheck(invoiceCombine, invoiceBO);
            }
            if ("00".equals(reqBo.getInvoiceType())) {
                this.allElecSpecialCheck(invoiceCombine, invoiceBO);
            }
        }
        if (FscConstants.InvoiceCategory.PAPER.equals(reqBo.getInvoiceCategory())) {
            if ("01".equals(reqBo.getInvoiceType())) {
                this.paperGeneralCheck(invoiceCombine, invoiceBO);
            }
            if ("00".equals(reqBo.getInvoiceType())) {
                this.paperSpecialCheck(invoiceCombine, invoiceBO);
            }
        }
        if (FscConstants.InvoiceCategory.ELECTRON.equals(reqBo.getInvoiceCategory())) {
            if ("01".equals(reqBo.getInvoiceType())) {
                this.elecGeneralCheck(invoiceCombine, invoiceBO);
            }
            if ("00".equals(reqBo.getInvoiceType())) {
                this.elecSpecialCheck(invoiceCombine, invoiceBO);
            }
        }
        return new FscInvoiceCheckAtomServiceRspBo();
    }

    private void paperSpecialCheck(Integer invoiceCombine, InvoiceBO invoiceBO) {
        if (FscConstants.FscElecInvoiceType.SPECIAL.equals(invoiceCombine) && StringUtils.isBlank((CharSequence)invoiceBO.getInvoiceCode())) {
            throw new FscBusinessException("191011", "\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\u3010\u53d1\u7968\u4ee3\u7801\u3011\u4e3a\u7a7a");
        }
        if (FscConstants.FscElecInvoiceType.SPECIAL.equals(invoiceCombine) && StringUtils.isNotBlank((CharSequence)invoiceBO.getInvoiceCode()) && !FscConstants.FscInvoiceVerifyParam.INVOICE_CODE_PAPER_LENGTH.equals(invoiceBO.getInvoiceCode().length())) {
            throw new FscBusinessException("191011", "\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\u3010\u53d1\u7968\u4ee3\u7801\u3011\u957f\u5ea6\u5e94\u4e3a" + FscConstants.FscInvoiceVerifyParam.INVOICE_CODE_PAPER_LENGTH);
        }
        if (FscConstants.FscElecInvoiceType.SPECIAL.equals(invoiceCombine) && StringUtils.isBlank((CharSequence)invoiceBO.getInvoiceNo())) {
            throw new FscBusinessException("191011", "\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\u3010\u53d1\u7968\u53f7\u7801\u3011\u4e3a\u7a7a");
        }
        if (FscConstants.FscElecInvoiceType.SPECIAL.equals(invoiceCombine) && StringUtils.isNotBlank((CharSequence)invoiceBO.getInvoiceNo()) && !FscConstants.FscInvoiceVerifyParam.INVOICE_NO_LENGTH.equals(invoiceBO.getInvoiceNo().length())) {
            throw new FscBusinessException("191011", "\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\u3010\u53d1\u7968\u53f7\u7801\u3011\u957f\u5ea6\u5e94\u4e3a" + FscConstants.FscInvoiceVerifyParam.INVOICE_NO_LENGTH);
        }
        if (FscConstants.FscElecInvoiceType.SPECIAL.equals(invoiceCombine) && StringUtils.isBlank((CharSequence)invoiceBO.getBillDate())) {
            throw new FscBusinessException("191011", "\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\u3010\u5f00\u7968\u65e5\u671f\u3011\u4e3a\u7a7a");
        }
    }

    private void paperGeneralCheck(Integer invoiceCombine, InvoiceBO invoiceBO) {
        if (FscConstants.FscElecInvoiceType.SPECIAL.equals(invoiceCombine) && StringUtils.isBlank((CharSequence)invoiceBO.getInvoiceCode())) {
            throw new FscBusinessException("191011", "\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968\u3010\u53d1\u7968\u4ee3\u7801\u3011\u4e3a\u7a7a");
        }
        if (FscConstants.FscElecInvoiceType.SPECIAL.equals(invoiceCombine) && StringUtils.isNotBlank((CharSequence)invoiceBO.getInvoiceCode()) && !FscConstants.FscInvoiceVerifyParam.INVOICE_CODE_PAPER_LENGTH.equals(invoiceBO.getInvoiceCode().length())) {
            throw new FscBusinessException("191011", "\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968\u3010\u53d1\u7968\u4ee3\u7801\u3011\u957f\u5ea6\u5e94\u4e3a" + FscConstants.FscInvoiceVerifyParam.INVOICE_CODE_PAPER_LENGTH);
        }
        if (FscConstants.FscElecInvoiceType.SPECIAL.equals(invoiceCombine) && StringUtils.isBlank((CharSequence)invoiceBO.getInvoiceNo())) {
            throw new FscBusinessException("191011", "\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968\u3010\u53d1\u7968\u53f7\u7801\u3011\u4e3a\u7a7a");
        }
        if (FscConstants.FscElecInvoiceType.SPECIAL.equals(invoiceCombine) && StringUtils.isNotBlank((CharSequence)invoiceBO.getInvoiceNo()) && !FscConstants.FscInvoiceVerifyParam.INVOICE_NO_LENGTH.equals(invoiceBO.getInvoiceNo().length())) {
            throw new FscBusinessException("191011", "\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968\u3010\u53d1\u7968\u53f7\u7801\u3011\u957f\u5ea6\u5e94\u4e3a" + FscConstants.FscInvoiceVerifyParam.INVOICE_NO_LENGTH);
        }
        if (FscConstants.FscElecInvoiceType.SPECIAL.equals(invoiceCombine) && StringUtils.isBlank((CharSequence)invoiceBO.getBillDate())) {
            throw new FscBusinessException("191011", "\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968\u3010\u5f00\u7968\u65e5\u671f\u3011\u4e3a\u7a7a");
        }
    }

    private void elecGeneralCheck(Integer invoiceCombine, InvoiceBO invoiceBO) {
        if (FscConstants.FscElecInvoiceType.ELEC.equals(invoiceCombine) && StringUtils.isBlank((CharSequence)invoiceBO.getInvoiceCode())) {
            throw new FscBusinessException("191011", "\u589e\u503c\u7a0e\u7535\u5b50\u666e\u901a\u53d1\u7968\u3010\u53d1\u7968\u4ee3\u7801\u3011\u4e3a\u7a7a");
        }
        if (FscConstants.FscElecInvoiceType.ELEC.equals(invoiceCombine) && StringUtils.isNotBlank((CharSequence)invoiceBO.getInvoiceCode()) && !FscConstants.FscInvoiceVerifyParam.INVOICE_CODE_ELEC_LENGTH.equals(invoiceBO.getInvoiceCode().length())) {
            throw new FscBusinessException("191011", "\u589e\u503c\u7a0e\u7535\u5b50\u666e\u901a\u53d1\u7968\u3010\u53d1\u7968\u4ee3\u7801\u3011\u957f\u5ea6\u5e94\u4e3a" + FscConstants.FscInvoiceVerifyParam.INVOICE_CODE_ELEC_LENGTH);
        }
        if (FscConstants.FscElecInvoiceType.ELEC.equals(invoiceCombine) && StringUtils.isBlank((CharSequence)invoiceBO.getInvoiceNo())) {
            throw new FscBusinessException("191011", "\u589e\u503c\u7a0e\u7535\u5b50\u666e\u901a\u53d1\u7968\u3010\u53d1\u7968\u53f7\u7801\u3011\u4e3a\u7a7a");
        }
        if (FscConstants.FscElecInvoiceType.ELEC.equals(invoiceCombine) && StringUtils.isNotBlank((CharSequence)invoiceBO.getInvoiceNo()) && !FscConstants.FscInvoiceVerifyParam.INVOICE_NO_LENGTH.equals(invoiceBO.getInvoiceNo().length())) {
            throw new FscBusinessException("191011", "\u589e\u503c\u7a0e\u7535\u5b50\u666e\u901a\u53d1\u7968\u3010\u53d1\u7968\u53f7\u7801\u3011\u957f\u5ea6\u5e94\u4e3a" + FscConstants.FscInvoiceVerifyParam.INVOICE_NO_LENGTH);
        }
        if (FscConstants.FscElecInvoiceType.ELEC.equals(invoiceCombine) && StringUtils.isBlank((CharSequence)invoiceBO.getVerificationCode())) {
            throw new FscBusinessException("191011", "\u589e\u503c\u7a0e\u7535\u5b50\u666e\u901a\u53d1\u7968\u3010\u53d1\u7968\u6821\u9a8c\u7801\u3011\u4e3a\u7a7a");
        }
        if (FscConstants.FscElecInvoiceType.ELEC.equals(invoiceCombine) && StringUtils.isBlank((CharSequence)invoiceBO.getBillDate())) {
            throw new FscBusinessException("191011", "\u589e\u503c\u7a0e\u7535\u5b50\u666e\u901a\u53d1\u7968\u3010\u5f00\u7968\u65e5\u671f\u3011\u4e3a\u7a7a");
        }
    }

    private void elecSpecialCheck(Integer invoiceCombine, InvoiceBO invoiceBO) {
        if (FscConstants.FscElecInvoiceType.ELEC_SPECIAL.equals(invoiceCombine) && StringUtils.isBlank((CharSequence)invoiceBO.getInvoiceCode())) {
            throw new FscBusinessException("191011", "\u589e\u503c\u7a0e\u7535\u5b50\u4e13\u7528\u53d1\u7968\u3010\u53d1\u7968\u4ee3\u7801\u3011\u4e3a\u7a7a");
        }
        if (FscConstants.FscElecInvoiceType.ELEC_SPECIAL.equals(invoiceCombine) && StringUtils.isNotBlank((CharSequence)invoiceBO.getInvoiceCode()) && !FscConstants.FscInvoiceVerifyParam.INVOICE_CODE_ELEC_LENGTH.equals(invoiceBO.getInvoiceCode().length())) {
            throw new FscBusinessException("191011", "\u589e\u503c\u7a0e\u7535\u5b50\u4e13\u7528\u53d1\u7968\u3010\u53d1\u7968\u4ee3\u7801\u3011\u957f\u5ea6\u5e94\u4e3a" + FscConstants.FscInvoiceVerifyParam.INVOICE_CODE_ELEC_LENGTH);
        }
        if (FscConstants.FscElecInvoiceType.ELEC_SPECIAL.equals(invoiceCombine) && StringUtils.isBlank((CharSequence)invoiceBO.getInvoiceNo())) {
            throw new FscBusinessException("191011", "\u589e\u503c\u7a0e\u7535\u5b50\u4e13\u7528\u53d1\u7968\u3010\u53d1\u7968\u53f7\u7801\u3011\u4e3a\u7a7a");
        }
        if (FscConstants.FscElecInvoiceType.ELEC_SPECIAL.equals(invoiceCombine) && StringUtils.isNotBlank((CharSequence)invoiceBO.getInvoiceNo()) && !FscConstants.FscInvoiceVerifyParam.INVOICE_NO_LENGTH.equals(invoiceBO.getInvoiceNo().length())) {
            throw new FscBusinessException("191011", "\u589e\u503c\u7a0e\u7535\u5b50\u4e13\u7528\u53d1\u7968\u3010\u53d1\u7968\u53f7\u7801\u3011\u957f\u5ea6\u5e94\u4e3a" + FscConstants.FscInvoiceVerifyParam.INVOICE_NO_LENGTH);
        }
        if (FscConstants.FscElecInvoiceType.ELEC_SPECIAL.equals(invoiceCombine) && StringUtils.isBlank((CharSequence)invoiceBO.getBillDate())) {
            throw new FscBusinessException("191011", "\u589e\u503c\u7a0e\u7535\u5b50\u4e13\u7528\u53d1\u7968\u3010\u5f00\u7968\u65e5\u671f\u3011\u4e3a\u7a7a");
        }
    }

    private void allElecGeneralCheck(Integer invoiceCombine, InvoiceBO invoiceBO) {
        if (FscConstants.FscElecInvoiceType.DIGITAL_GENERAL.equals(invoiceCombine) && StringUtils.isBlank((CharSequence)invoiceBO.getInvoiceNo())) {
            throw new FscBusinessException("191011", "\u5168\u7535\u53d1\u7968\uff08\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968\uff09\u3010\u53d1\u7968\u53f7\u7801\u3011\u4e3a\u7a7a");
        }
        if (FscConstants.FscElecInvoiceType.DIGITAL_GENERAL.equals(invoiceCombine) && StringUtils.isNotBlank((CharSequence)invoiceBO.getInvoiceNo()) && !FscConstants.FscInvoiceVerifyParam.INVOICE_NO_ALL_ELEC_LENGTH.equals(invoiceBO.getInvoiceNo().length())) {
            throw new FscBusinessException("191011", "\u5168\u7535\u53d1\u7968\uff08\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968\uff09\u3010\u53d1\u7968\u53f7\u7801\u3011\u957f\u5ea6\u5e94\u4e3a" + FscConstants.FscInvoiceVerifyParam.INVOICE_NO_ALL_ELEC_LENGTH);
        }
        if (FscConstants.FscElecInvoiceType.DIGITAL_GENERAL.equals(invoiceCombine) && StringUtils.isBlank((CharSequence)invoiceBO.getBillDate())) {
            throw new FscBusinessException("191011", "\u5168\u7535\u53d1\u7968\uff08\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968\uff09\u3010\u5f00\u7968\u65e5\u671f\u3011\u4e3a\u7a7a");
        }
    }

    private void allElecSpecialCheck(Integer invoiceCombine, InvoiceBO invoiceBO) {
        if (FscConstants.FscElecInvoiceType.DIGITAL_SPECIAL.equals(invoiceCombine) && StringUtils.isBlank((CharSequence)invoiceBO.getInvoiceNo())) {
            throw new FscBusinessException("191011", "\u5168\u7535\u53d1\u7968\uff08\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff09\u3010\u53d1\u7968\u53f7\u7801\u3011\u4e3a\u7a7a");
        }
        if (FscConstants.FscElecInvoiceType.DIGITAL_SPECIAL.equals(invoiceCombine) && StringUtils.isNotBlank((CharSequence)invoiceBO.getInvoiceNo()) && !FscConstants.FscInvoiceVerifyParam.INVOICE_NO_ALL_ELEC_LENGTH.equals(invoiceBO.getInvoiceNo().length())) {
            throw new FscBusinessException("191011", "\u5168\u7535\u53d1\u7968\uff08\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff09\u3010\u53d1\u7968\u53f7\u7801\u3011\u957f\u5ea6\u5e94\u4e3a" + FscConstants.FscInvoiceVerifyParam.INVOICE_NO_ALL_ELEC_LENGTH);
        }
        if (FscConstants.FscElecInvoiceType.DIGITAL_SPECIAL.equals(invoiceCombine) && StringUtils.isBlank((CharSequence)invoiceBO.getBillDate())) {
            throw new FscBusinessException("191011", "\u5168\u7535\u53d1\u7968\uff08\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff09\u3010\u5f00\u7968\u65e5\u671f\u3011\u4e3a\u7a7a");
        }
    }

    private void val(FscInvoiceCheckAtomServiceReqBo reqBo) {
        if (null == reqBo.getInvoiceCategory()) {
            throw new FscBusinessException("FSC00002", "\u53d1\u7968\u7c7b\u522b\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getInvoiceType())) {
            throw new FscBusinessException("FSC00002", "\u53d1\u7968\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (null == reqBo.getInvoiceBO()) {
            throw new FscBusinessException("FSC00002", "\u53d1\u7968\u4e3a\u7a7a");
        }
    }
}

