/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.atom.impl;

import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.api.FscPayConfirmDealAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscPayConfirmDealAtomReqBo;
import com.tydic.fsc.busibase.atom.bo.FscPayConfirmDealAtomRspBo;
import com.tydic.fsc.busibase.external.api.bo.FscUocUpdateSaleOrderPayStateAtomReqBo;
import com.tydic.fsc.busibase.external.api.uoc.FscUocUpdateSaleOrderPayStateAtomService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscShouldPayPO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscPayConfirmDealAtomServiceImpl
implements FscPayConfirmDealAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscPayConfirmDealAtomServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscUocUpdateSaleOrderPayStateAtomService fscUocUpdateSaleOrderPayStateAtomService;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;

    @Override
    public FscPayConfirmDealAtomRspBo payConfirm(FscPayConfirmDealAtomReqBo reqBo) {
        List<FscShouldPayPO> fscShouldPayPOS;
        this.val(reqBo);
        FscPayConfirmDealAtomRspBo fscPayConfirmDealAtomRspBo = new FscPayConfirmDealAtomRspBo();
        if (CollectionUtils.isNotEmpty(reqBo.getFscOrderIds()) && CollectionUtils.isNotEmpty(fscShouldPayPOS = this.fscShouldPayMapper.getByFscOrderIds(reqBo.getFscOrderIds()))) {
            this.dealOrderPay(fscShouldPayPOS, reqBo);
            if (!reqBo.getPayFlag().booleanValue()) {
                this.dealServicePay(fscShouldPayPOS, fscPayConfirmDealAtomRspBo);
            }
        }
        return fscPayConfirmDealAtomRspBo;
    }

    private void val(FscPayConfirmDealAtomReqBo reqBo) {
        if (null == reqBo.getPayFlag()) {
            throw new FscBusinessException("191000", "\u786e\u8ba4\u4ed8\u6b3e\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(reqBo.getFscOrderIds())) {
            throw new FscBusinessException("191000", "\u7ed3\u7b97\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void dealOrderPay(List<FscShouldPayPO> fscShouldPayPOS, FscPayConfirmDealAtomReqBo reqBo) {
        List<FscOrderPO> fscOrderPOs;
        List orderShouldPayPOS = fscShouldPayPOS.stream().filter(fscShouldPayPO -> FscConstants.ShouldObjectType.SALE_ORDER.equals(fscShouldPayPO.getObjectType()) && FscConstants.ShouldPayType.ADVANCE_PAY.equals(fscShouldPayPO.getShouldPayType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(orderShouldPayPOS) && CollectionUtils.isNotEmpty(fscOrderPOs = this.getFscOrderPO(orderShouldPayPOS.stream().map(FscShouldPayPO::getFscOrderId).collect(Collectors.toList())))) {
            Map<Long, Integer> fscOrderStateMap = fscOrderPOs.stream().collect(Collectors.toMap(FscOrderPO::getFscOrderId, FscOrderPO::getOrderState));
            for (FscShouldPayPO shouldPayPO : orderShouldPayPOS) {
                try {
                    FscUocUpdateSaleOrderPayStateAtomReqBo fscUocUpdateSaleOrderPayStateAtomReqBo = new FscUocUpdateSaleOrderPayStateAtomReqBo();
                    fscUocUpdateSaleOrderPayStateAtomReqBo.setSaleOrderId(shouldPayPO.getObjectId());
                    if (null == fscOrderStateMap.get(shouldPayPO.getFscOrderId()) || reqBo.getPayFlag().booleanValue()) continue;
                    fscUocUpdateSaleOrderPayStateAtomReqBo.setPayState(FscConstants.FscPayOrderState.PAY_FAIL);
                    this.fscUocUpdateSaleOrderPayStateAtomService.updateOrderPayState(fscUocUpdateSaleOrderPayStateAtomReqBo);
                }
                catch (Exception e) {
                    log.error("\u540c\u6b65\u8ba2\u5355\u5f02\u5e38\uff1a", (Throwable)e);
                }
            }
        }
    }

    private void dealServicePay(List<FscShouldPayPO> fscShouldPayPOS, FscPayConfirmDealAtomRspBo fscPayConfirmDealAtomRspBo) {
        List<FscShouldPayPO> serviceShouldPayPOS = fscShouldPayPOS.stream().filter(fscShouldPay -> FscConstants.ShouldObjectType.DEAL_ORDER.equals(fscShouldPay.getShouldPayType()) || FscConstants.ShouldObjectType.USR_ORDER.equals(fscShouldPay.getShouldPayType())).collect(Collectors.toList());
        ArrayList<Long> fscOrderIds = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty(serviceShouldPayPOS)) {
            FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
            HashMap<String, Integer> serviceParamMap = new HashMap<String, Integer>();
            serviceParamMap.put("payFlag", FscConstants.ProcessParam.payFlag0);
            serviceShouldPayPOS.forEach(shouldPayPO -> {
                fscOrderIds.add(shouldPayPO.getObjectId());
                fscOrderStatusFlowAtomReqBO.setOrderId(shouldPayPO.getObjectId());
                fscOrderStatusFlowAtomReqBO.setParamMap(serviceParamMap);
                FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
                if (!"0000".equals(fscOrderStatusFlowAtomRspBO.getRespCode())) {
                    throw new FscBusinessException("194202", fscOrderStatusFlowAtomRspBO.getRespDesc());
                }
            });
        }
        fscPayConfirmDealAtomRspBo.setFscOrderIds(fscOrderIds);
    }

    private List<FscOrderPO> getFscOrderPO(List<Long> fscOrderIds) {
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderIds(fscOrderIds);
        fscOrderPO.setOrderFlow(FscConstants.OrderFlow.PAY);
        return this.fscOrderMapper.getList(fscOrderPO);
    }
}

