/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.external.impl.esb;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.fsc.busibase.external.api.bo.FscCancelInvoiceRspBo;
import com.tydic.fsc.busibase.external.api.bo.FscEcomInvoiceCancelExternalReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscEcomInvoiceCancelExternalRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscEcomInvoiceCancelExternalService;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.utils.EsbParamUtil;
import com.tydic.fsc.utils.SSLClient;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class FscEcomInvoiceCancelExternalServiceImpl
implements FscEcomInvoiceCancelExternalService {
    private static final Logger log = LoggerFactory.getLogger(FscEcomInvoiceCancelExternalServiceImpl.class);
    @Autowired
    private Environment environment;
    @Value(value="${esb.cancel.invoice.url:${ESB_ACCESS_IP}/OSN/api/cancelInvoice/v1}")
    private String ESB_CANCEL_INVOICE_INFO_URL;
    private static final String JD_SUP_ID = "JD_SUP_ID";
    private static final String JD_SUP_ID_VOP = "JD_SUP_ID_VOP";

    @Override
    public FscEcomInvoiceCancelExternalRspBO cancelInvoice(FscEcomInvoiceCancelExternalReqBO reqBO) {
        this.val(reqBO);
        String hsn = this.environment.getProperty("SUPPLIER_ID_" + reqBO.getSupplierId());
        String reqStr = JSON.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        JSONObject jsonObject = JSON.parseObject((String)reqStr);
        if (null != reqBO.getPurchaserId()) {
            jsonObject.put("orgId", (Object)reqBO.getPurchaserId());
        }
        reqStr = JSON.toJSONString((Object)jsonObject);
        String reqEsbStr = EsbParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_PAY");
        log.debug("\u53d6\u6d88\u7535\u5546\u4fa7\u53d1\u7968\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)this.ESB_CANCEL_INVOICE_INFO_URL);
        log.debug("\u53d6\u6d88\u7535\u5546\u4fa7\u53d1\u7968\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)reqEsbStr);
        String rspJson = SSLClient.doPost(this.ESB_CANCEL_INVOICE_INFO_URL, reqEsbStr);
        log.debug("\u53d6\u6d88\u7535\u5546\u4fa7\u53d1\u7968\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)rspJson);
        if (StringUtils.isBlank((String)rspJson)) {
            throw new FscBusinessException("194318", "\u8bf7\u6c42ESB\u53d6\u6d88\u7535\u5546\u53d1\u7968\u6570\u636e\u63a5\u53e3\u8fd4\u56de\u7a7a");
        }
        if (!reqBO.getSupplierId().equals(this.environment.getProperty(JD_SUP_ID)) && !reqBO.getSupplierId().equals(this.environment.getProperty(JD_SUP_ID_VOP))) {
            JSONObject jdRspJsonObject = JSON.parseObject((String)rspJson);
            FscEcomInvoiceCancelExternalRspBO rspBO = new FscEcomInvoiceCancelExternalRspBO();
            rspBO.setSuccess(jdRspJsonObject.getBoolean("success"));
            rspBO.setResultCode(jdRspJsonObject.getString("resultCode"));
            rspBO.setResultMessage(jdRspJsonObject.getString("resultMessage"));
            String result = jdRspJsonObject.getString("result");
            rspBO.setResult((FscCancelInvoiceRspBo)JSON.parseObject((String)result, FscCancelInvoiceRspBo.class));
            if (null == rspBO.getSuccess() || !rspBO.getSuccess().booleanValue() || null == rspBO.getResult()) {
                throw new FscBusinessException("194318", "\u8bf7\u6c42ESB\u53d6\u6d88\u7535\u5546\u53d1\u7968\u7535\u5546\u8fd4\u56de\u9519\u8bef\u63cf\u8ff0\uff1a" + rspBO.getResultMessage());
            }
            if (rspBO.getResult().getCancelResult() == 1) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
            } else {
                rspBO.setRespCode("191125");
                rspBO.setRespDesc(rspBO.getResult().getResultDesc());
            }
            rspBO.setResultCode("0000");
            return rspBO;
        }
        FscEcomInvoiceCancelExternalRspBO rspBO = (FscEcomInvoiceCancelExternalRspBO)((Object)JSON.parseObject((String)rspJson, FscEcomInvoiceCancelExternalRspBO.class));
        FscCancelInvoiceRspBo fscCancelInvoiceRspBo = new FscCancelInvoiceRspBo();
        fscCancelInvoiceRspBo.setCancelResult(1);
        fscCancelInvoiceRspBo.setResultDesc("\u6210\u529f");
        if (null == rspBO.getSuccess() || !rspBO.getSuccess().booleanValue()) {
            fscCancelInvoiceRspBo.setCancelResult(0);
            fscCancelInvoiceRspBo.setResultDesc(rspBO.getResultMessage());
        }
        rspBO.setResult(fscCancelInvoiceRspBo);
        return rspBO;
    }

    private void val(FscEcomInvoiceCancelExternalReqBO reqBO) {
        if (log.isDebugEnabled()) {
            log.debug("\u53d6\u6d88\u7535\u5546\u53d1\u7968\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBO));
        }
        if (StringUtils.isBlank((String)reqBO.getMarkId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[markId]\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)reqBO.getSupplierId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[supplierId]\u4e3a\u7a7a");
        }
    }
}

