/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.atom.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.atom.api.FscOrderHistoryAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderHistoryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderHistoryAtomRspBO;
import com.tydic.fsc.dao.FscOrderHistoryMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderHistoryPo;
import com.tydic.fsc.po.FscOrderPO;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscOrderHistoryAtomServiceImpl
implements FscOrderHistoryAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscOrderHistoryAtomServiceImpl.class);
    @Autowired
    private FscOrderHistoryMapper fscOrderHistoryMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;

    @Override
    public FscOrderHistoryAtomRspBO insertFscOrderHistory(FscOrderHistoryAtomReqBO fscOrderHistoryAtomReqBO) {
        this.check(fscOrderHistoryAtomReqBO);
        List<FscOrderPO> fscOrderList = this.qryFscOrderList(fscOrderHistoryAtomReqBO);
        this.insertFscOrderHistoryBatch(fscOrderList);
        FscOrderHistoryAtomRspBO rspBO = new FscOrderHistoryAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void insertFscOrderHistoryBatch(List<FscOrderPO> fscOrderList) {
        List<FscOrderHistoryPo> fscOrderHistoryPoList = fscOrderList.stream().map(e -> {
            FscOrderHistoryPo fscOrderHistoryPo = (FscOrderHistoryPo)JSON.parseObject((String)JSON.toJSONString((Object)e), FscOrderHistoryPo.class);
            fscOrderHistoryPo.setHistoryId(Sequence.getInstance().nextId());
            return fscOrderHistoryPo;
        }).collect(Collectors.toList());
        this.fscOrderHistoryMapper.insertBatch(fscOrderHistoryPoList);
    }

    private List<FscOrderPO> qryFscOrderList(FscOrderHistoryAtomReqBO fscOrderHistoryAtomReqBO) {
        FscOrderPO where = new FscOrderPO();
        where.setFscOrderIds(fscOrderHistoryAtomReqBO.getFscOrderIdList());
        return this.fscOrderMapper.getList(where);
    }

    private void check(FscOrderHistoryAtomReqBO reqBO) {
        if (CollectionUtil.isEmpty(reqBO.getFscOrderIdList())) {
            throw new FscBusinessException("191000", "\u65b0\u589e\u7ed3\u7b97\u5355\u5386\u53f2\u4fe1\u606f\u5931\u8d25,\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[fscOrderIdList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

