/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.fsc.bo.FscAuditBaseBo;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalRspBO;
import com.tydic.fsc.busibase.external.api.cfc.FscCfcUniteParamQryListDetailExternalService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.FscPayServiceBillProcessAbilityService;
import com.tydic.fsc.pay.ability.bo.FscPayServiceBillProcessAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscPayServiceBillProcessAbilityRspBO;
import com.tydic.fsc.pay.busi.api.FscPayServiceBillProcessBusiService;
import com.tydic.fsc.pay.busi.bo.FscPayServiceBillProcessBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscPayServiceBillProcessBusiRspBO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.utils.BigDecimalConvert;
import com.tydic.osworkflow.approve.ability.EacProjectAbilityService;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityReqBO;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityRspBO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.FscPayServiceBillProcessAbilityService"})
public class FscPayServiceBillProcessAbilityServiceImpl
implements FscPayServiceBillProcessAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscPayServiceBillProcessAbilityServiceImpl.class);
    @Autowired
    private FscPayServiceBillProcessBusiService fscPayServiceBillProcessBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscCfcUniteParamQryListDetailExternalService fscCfcUniteParamQryListDetailExternalService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Value(value="${process.sysCode}")
    private String processSysCode;
    @Autowired
    private EacProjectAbilityService eacProjectAbilityService;
    private static final String NO_EXEMPTION = "2";
    private static final String CFC_MONTH_FEE = "1";
    private static final String CFC_YEAR_FEE = "2";

    @BigDecimalConvert
    @PostMapping(value={"dealPayServiceBillProcess"})
    public FscPayServiceBillProcessAbilityRspBO dealPayServiceBillProcess(@RequestBody FscPayServiceBillProcessAbilityReqBO abilityReqBO) {
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(abilityReqBO.getFscOrderId());
        FscOrderPO rspPo = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (null == rspPo) {
            throw new FscBusinessException("191000", "\u67e5\u8be2\u4e3b\u5355\u4e3a\u7a7a\uff01");
        }
        FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO = this.queryConfig(rspPo);
        this.verifyIsCanExemption(fscCfcUniteParamQryListDetailExternalRspBO, fscOrderPO, abilityReqBO);
        if (null == abilityReqBO.getFscOrderId()) {
            throw new FscBusinessException("191000", "\u7ed3\u7b97\u5355id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == abilityReqBO.getCreditAmount()) {
            throw new FscBusinessException("191000", "\u51cf\u514d\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscPayServiceBillProcessBusiReqBO busiReqBO = (FscPayServiceBillProcessBusiReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)abilityReqBO), FscPayServiceBillProcessBusiReqBO.class));
        busiReqBO.setFscOrderPO(rspPo);
        FscPayServiceBillProcessBusiRspBO busiRspBO = this.fscPayServiceBillProcessBusiService.dealPayServiceBillProcess(busiReqBO);
        if ("0000".equals(busiRspBO.getRespCode())) {
            if (busiRspBO.getIsStartAuditFlow().booleanValue()) {
                this.startAuditFlow(abilityReqBO, busiRspBO.getFscAuditBaseBo());
            }
            FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
            fscComOrderListSyncAbilityReqBO.setFscOrderId(busiReqBO.getFscOrderId());
            this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        }
        return (FscPayServiceBillProcessAbilityRspBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)busiRspBO)), FscPayServiceBillProcessAbilityRspBO.class);
    }

    private void startAuditFlow(FscPayServiceBillProcessAbilityReqBO reqBO, FscAuditBaseBo fscAuditBaseBo) {
        EacStartProjectAbilityReqBO eacStartProjectAbilityReqBO = (EacStartProjectAbilityReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), EacStartProjectAbilityReqBO.class);
        eacStartProjectAbilityReqBO.setSysCode(this.processSysCode);
        eacStartProjectAbilityReqBO.setProcDefKey(fscAuditBaseBo.getProcDefKey());
        eacStartProjectAbilityReqBO.setPartitionKey(fscAuditBaseBo.getPartitionKey());
        eacStartProjectAbilityReqBO.setVariables(fscAuditBaseBo.getVariables());
        eacStartProjectAbilityReqBO.setBusinessIdList(fscAuditBaseBo.getBusinessIdList());
        eacStartProjectAbilityReqBO.setUserName(reqBO.getName());
        log.info("\u8c03\u7528\u6d41\u7a0b\u5ba1\u6279\u542f\u52a8\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)eacStartProjectAbilityReqBO));
        EacStartProjectAbilityRspBO eacStartProjectAbilityRspBO = this.eacProjectAbilityService.startProjectByMq(eacStartProjectAbilityReqBO);
        log.info("\u8c03\u7528\u6d41\u7a0b\u5ba1\u6279\u542f\u52a8\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)eacStartProjectAbilityRspBO));
        if (!"0000".equals(eacStartProjectAbilityRspBO.getRespCode())) {
            throw new ZTBusinessException("\u8c03\u7528\u6d41\u7a0b\u5ba1\u6279\u542f\u52a8\u5931\u8d25,\u5f02\u5e38\u7f16\u7801\u3010" + eacStartProjectAbilityRspBO.getRespCode() + "\u3011," + eacStartProjectAbilityRspBO.getRespDesc());
        }
    }

    private void verifyIsCanExemption(FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO, FscOrderPO fscOrderPO, FscPayServiceBillProcessAbilityReqBO abilityReqBO) {
        String serviceFeeType = null;
        if (FscConstants.OrderFlow.MONTH_SERVICE_FEE.equals(fscOrderPO.getOrderFlow())) {
            serviceFeeType = CFC_MONTH_FEE;
        } else if (FscConstants.OrderFlow.YEAR_ORDER_SERVICE_FEE.equals(fscOrderPO.getOrderFlow()) || FscConstants.OrderFlow.YEAR_ACCEPT_SERVICE_FEE.equals(fscOrderPO.getOrderFlow())) {
            serviceFeeType = "2";
        }
        if (null != serviceFeeType && fscCfcUniteParamQryListDetailExternalRspBO.getDealFeeBusiType().contains(serviceFeeType) && "2".equals(fscCfcUniteParamQryListDetailExternalRspBO.getIsAllowReduce()) && abilityReqBO.getCreditAmount() != null) {
            throw new FscBusinessException("191205", "\u4e0d\u5141\u8bb8\u51cf\u514d\u6210\u4ea4\u670d\u52a1\u8d39");
        }
        if (null != fscOrderPO.getCreditDealDueDate() && System.currentTimeMillis() > fscOrderPO.getCreditDealDueDate().getTime()) {
            throw new FscBusinessException("191205", "\u8d85\u8fc7\u51cf\u514d\u65f6\u9650\uff0c\u4e0d\u5141\u8bb8\u51cf\u514d\u6210\u4ea4\u670d\u52a1\u8d39");
        }
    }

    private FscCfcUniteParamQryListDetailExternalRspBO queryConfig(FscOrderPO fscOrderPO) {
        FscCfcUniteParamQryListDetailExternalReqBO fscCfcUniteParamQryListDetailExternalReqBO = new FscCfcUniteParamQryListDetailExternalReqBO();
        fscCfcUniteParamQryListDetailExternalReqBO.setParamCode("transaction_service_fee_rules");
        fscCfcUniteParamQryListDetailExternalReqBO.setRelId(fscOrderPO.getSupplierId().toString());
        FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO = this.fscCfcUniteParamQryListDetailExternalService.qryListDetail(fscCfcUniteParamQryListDetailExternalReqBO);
        if (!"0000".equals(fscCfcUniteParamQryListDetailExternalRspBO.getRespCode())) {
            throw new FscBusinessException("191205", fscCfcUniteParamQryListDetailExternalRspBO.getRespDesc());
        }
        if (StringUtils.isBlank((CharSequence)fscCfcUniteParamQryListDetailExternalRspBO.getIsAllowReduce())) {
            throw new FscBusinessException("191205", "\u8bf7\u914d\u7f6e\u6210\u4ea4\u670d\u52a1\u8d39\u89c4\u5219");
        }
        if (fscCfcUniteParamQryListDetailExternalRspBO.getMaxDealTime().contains(".")) {
            throw new FscBusinessException("191205", "\u51cf\u514d\u6210\u4ea4\u670d\u52a1\u8d39\u6700\u5927\u5904\u7406\u65f6\u9650 \u5355\u4f4d\uff08\u81ea\u7136\u65e5\uff09\uff0c\u8bf7\u914d\u7f6e\u6b63\u6574\u6570");
        }
        if (fscCfcUniteParamQryListDetailExternalRspBO.getSupConfirmationTime().contains(".")) {
            throw new FscBusinessException("191205", "\u51cf\u514d\u540e\u4f9b\u5e94\u5546\u786e\u8ba4\u65f6\u9650 \u5355\u4f4d\uff08\u81ea\u7136\u65e5\uff09\uff0c\u8bf7\u914d\u7f6e\u6b63\u6574\u6570");
        }
        return fscCfcUniteParamQryListDetailExternalRspBO;
    }
}

