/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl;

import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.FscUocOrderPayCheckAbilityService;
import com.tydic.fsc.pay.ability.bo.FscUocOrderPayCheckAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscUocOrderPayCheckAbilityRspBO;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.FscUocOrderPayCheckAbilityService"})
public class FscUocOrderPayCheckAbilityServiceImpl
implements FscUocOrderPayCheckAbilityService {
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;

    @PostMapping(value={"orderPayCheck"})
    public FscUocOrderPayCheckAbilityRspBO orderPayCheck(@RequestBody FscUocOrderPayCheckAbilityReqBO reqBO) {
        this.val(reqBO);
        FscOrderPayItemPO fscOrderPayItemPO = new FscOrderPayItemPO();
        fscOrderPayItemPO.setShouldPayId(reqBO.getShouldPayId());
        FscOrderPayItemPO orderPayItemPO = this.fscOrderPayItemMapper.getModelBy(fscOrderPayItemPO);
        FscUocOrderPayCheckAbilityRspBO fscUocOrderPayCheckAbilityRspBO = new FscUocOrderPayCheckAbilityRspBO();
        if (null == orderPayItemPO) {
            fscUocOrderPayCheckAbilityRspBO.setIsSettlePay(FscConstants.IsSettlePay.NOT_CREATE);
        } else {
            fscUocOrderPayCheckAbilityRspBO.setIsSettlePay(orderPayItemPO.getIsSettlePay());
            fscUocOrderPayCheckAbilityRspBO.setFscOrderId(orderPayItemPO.getFscOrderId());
            FscOrderPO fscOrderPO = new FscOrderPO();
            fscOrderPO.setFscOrderId(orderPayItemPO.getFscOrderId());
            FscOrderPO fscOrder = this.fscOrderMapper.getModelBy(fscOrderPO);
            fscUocOrderPayCheckAbilityRspBO.setFscOrderNo(fscOrder.getOrderNo());
            fscUocOrderPayCheckAbilityRspBO.setPayChannel(fscOrder.getPayChannel());
            fscUocOrderPayCheckAbilityRspBO.setPayMethod(fscOrder.getPayMethod());
            if ("3".equals(fscOrder.getPayChannel())) {
                FscAttachmentPO fscAttachmentPO = new FscAttachmentPO();
                fscAttachmentPO.setFscOrderId(fscOrder.getFscOrderId());
                fscAttachmentPO.setAttachmentType(FscConstants.AttachmentType.PAY_EVIDENCE);
                List fscAttachmentPOS = this.fscAttachmentMapper.getList(fscAttachmentPO);
                if (CollectionUtils.isNotEmpty((Collection)fscAttachmentPOS)) {
                    List attachmentBOList = fscAttachmentPOS.stream().map(fscAttachment -> {
                        AttachmentBO attachmentBO = new AttachmentBO();
                        attachmentBO.setAttachmentName(fscAttachment.getAttachmentName());
                        attachmentBO.setAttachmentType(fscAttachment.getAttachmentType());
                        attachmentBO.setAttachmentUrl(fscAttachment.getAttachmentUrl());
                        attachmentBO.setAttachmentUrlSource(fscAttachment.getAttachmentUrlSource());
                        return attachmentBO;
                    }).collect(Collectors.toList());
                    fscUocOrderPayCheckAbilityRspBO.setFscAttachmentBOS(attachmentBOList);
                }
            }
            if (FscConstants.FscPayOrderState.CANCEL.equals(fscOrder.getOrderState())) {
                fscUocOrderPayCheckAbilityRspBO.setPayAuditResult(FscConstants.AuditResultStatus.REFUSE);
            }
            if (FscConstants.FscPayOrderState.TO_PAY.equals(fscOrder.getOrderState())) {
                fscUocOrderPayCheckAbilityRspBO.setPayAuditResult(FscConstants.AuditResultStatus.PASS);
            }
            if (FscConstants.FscPayOrderState.TO_AUDIT.equals(fscOrder.getOrderState())) {
                fscUocOrderPayCheckAbilityRspBO.setPayAuditResult(FscConstants.AuditResultStatus.TO_AUDIT);
            }
        }
        return fscUocOrderPayCheckAbilityRspBO;
    }

    private void val(FscUocOrderPayCheckAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getShouldPayId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[shouldPayId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

