/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.atom.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayBackRelationMapper;
import com.tydic.fsc.dao.FscPayBackOrderMapper;
import com.tydic.fsc.dao.FscPayOrderMapper;
import com.tydic.fsc.dao.FscPayRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.atom.api.FscCreatePayBackAtomService;
import com.tydic.fsc.pay.atom.bo.FscCreatePayBackAtomServiceReqBO;
import com.tydic.fsc.pay.atom.bo.FscCreatePayBackAtomServiceRspBO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayBackRelationPO;
import com.tydic.fsc.po.FscPayBackOrderPO;
import com.tydic.fsc.po.FscPayOrderPO;
import com.tydic.fsc.po.FscPayRelationPO;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscCreatePayBackAtomServiceImpl
implements FscCreatePayBackAtomService {
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscPayRelationMapper fscPayRelationMapper;
    @Autowired
    private FscPayOrderMapper fscPayOrderMapper;
    @Autowired
    private FscPayBackOrderMapper fscPayBackOrderMapper;
    @Autowired
    private FscOrderPayBackRelationMapper fscOrderPayBackRelationMapper;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    public static final String PAY_BACK_FLOW_KEY = "pay_back_flow_key";

    @Override
    public FscCreatePayBackAtomServiceRspBO createPayBackOrder(FscCreatePayBackAtomServiceReqBO reqBO) {
        FscCreatePayBackAtomServiceRspBO rspBO = new FscCreatePayBackAtomServiceRspBO();
        FscOrderPO fscOrderPO = this.createFscPayBackOrder(reqBO, rspBO);
        this.createPayBackRelation(reqBO, fscOrderPO);
        this.createPayOrder(reqBO, rspBO, fscOrderPO);
        return rspBO;
    }

    private void createPayOrder(FscCreatePayBackAtomServiceReqBO reqBO, FscCreatePayBackAtomServiceRspBO rspBO, FscOrderPO fscOrderPO) {
        if (!"3".equals(reqBO.getPayChannel())) {
            FscPayBackOrderPO fscPayBackOrderPO = new FscPayBackOrderPO();
            fscPayBackOrderPO.setPayOrderId(reqBO.getPayOrderId());
            fscPayBackOrderPO.setPayBackOrderId(Long.valueOf(Sequence.getInstance().nextId()));
            fscPayBackOrderPO.setPayBackStatus(FscConstants.PayBackStatus.TO_PAY_BACK);
            fscPayBackOrderPO.setPayBackChannel(reqBO.getPayChannel());
            fscPayBackOrderPO.setPayBackMethod(reqBO.getPayMethod());
            fscPayBackOrderPO.setPayBackAmount(reqBO.getPayBackAmount());
            fscPayBackOrderPO.setCreateTime(new Date());
            this.fscPayBackOrderMapper.insert(fscPayBackOrderPO);
            FscPayOrderPO where = new FscPayOrderPO();
            where.setPayOrderId(reqBO.getPayOrderId());
            FscPayOrderPO set = new FscPayOrderPO();
            set.setPayStatus(FscConstants.PayOrderPayStatus.REFUNDING);
            set.setPayBackAmount(reqBO.getPayBackAmount());
            this.fscPayOrderMapper.updateBy(set, where);
            FscPayRelationPO fscPayRelationPO = new FscPayRelationPO();
            fscPayRelationPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            fscPayRelationPO.setFscOrderId(fscOrderPO.getFscOrderId());
            fscPayRelationPO.setPayOrderId(fscPayBackOrderPO.getPayBackOrderId());
            this.fscPayRelationMapper.insert(fscPayRelationPO);
            rspBO.setPayBackOrderId(fscPayBackOrderPO.getPayBackOrderId());
            rspBO.setPayOrderId(reqBO.getPayOrderId());
        }
    }

    private void createPayBackRelation(FscCreatePayBackAtomServiceReqBO reqBO, FscOrderPO fscOrderPO) {
        FscOrderPayBackRelationPO fscOrderPayBackRelationPO = new FscOrderPayBackRelationPO();
        fscOrderPayBackRelationPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        fscOrderPayBackRelationPO.setFscOrderId(fscOrderPO.getFscOrderId());
        fscOrderPayBackRelationPO.setFscPayOrderId(reqBO.getFscPayOrderId());
        fscOrderPayBackRelationPO.setFscPayOrderNo(reqBO.getFscPayOrderNo());
        fscOrderPayBackRelationPO.setPayBackAmt(fscOrderPO.getTotalCharge());
        fscOrderPayBackRelationPO.setRefundOrderId(reqBO.getSaleOrderId());
        fscOrderPayBackRelationPO.setRefundOrderNo(reqBO.getSaleOrderNo());
        fscOrderPayBackRelationPO.setShouldPayId(reqBO.getShouldPayId());
        fscOrderPayBackRelationPO.setRefundObjId(reqBO.getRefundObjId());
        fscOrderPayBackRelationPO.setRefundObjType(reqBO.getRefundObjType());
        this.fscOrderPayBackRelationMapper.insert(fscOrderPayBackRelationPO);
    }

    private FscOrderPO createFscPayBackOrder(FscCreatePayBackAtomServiceReqBO reqBO, FscCreatePayBackAtomServiceRspBO rspBO) {
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(Long.valueOf(Sequence.getInstance().nextId()));
        fscOrderPO.setOrderFlow(FscConstants.OrderFlow.PAY_BACK);
        fscOrderPO.setOrderFlowKey(PAY_BACK_FLOW_KEY);
        fscOrderPO.setOrderNo(this.getSerial());
        fscOrderPO.setCreateTime(new Date());
        fscOrderPO.setTotalCharge(reqBO.getPayBackAmount());
        fscOrderPO.setCreateOperId(reqBO.getCreateOperId());
        fscOrderPO.setCreateOperName(reqBO.getCreateOperName());
        fscOrderPO.setCreateOrgId(reqBO.getCreateOrgId());
        fscOrderPO.setCreateOrgName(reqBO.getCreateOrgName());
        fscOrderPO.setCreateCompanyId(reqBO.getCreateCompanyId());
        fscOrderPO.setCreateCompanyName(reqBO.getCreateCompanyName());
        fscOrderPO.setPayMethod(reqBO.getPayMethod());
        fscOrderPO.setPayChannel(reqBO.getPayChannel());
        fscOrderPO.setPayerId(reqBO.getPayerId());
        fscOrderPO.setPayerName(reqBO.getPayerName());
        fscOrderPO.setPayeeId(reqBO.getPayeeId());
        fscOrderPO.setPayeeName(reqBO.getPayeeName());
        fscOrderPO.setPayeeBankAccount(reqBO.getPayeeBankAccount());
        fscOrderPO.setPayeeBankName(reqBO.getPayeeBankName());
        fscOrderPO.setPayeeAccountName(reqBO.getPayeeAccountName());
        fscOrderPO.setBusiCategory(FscConstants.FscOrderBusiCategory.REFUND);
        fscOrderPO.setTransactionId(reqBO.getTransactionId());
        if (FscConstants.ShouldPayType.PAYMENT_DAY_PAY.equals(reqBO.getPayType())) {
            fscOrderPO.setPayType(FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD);
        } else if (FscConstants.ShouldPayType.ADVANCE_PAY.equals(reqBO.getPayType())) {
            fscOrderPO.setPayType(FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PREP);
        }
        this.fscOrderMapper.insert(fscOrderPO);
        rspBO.setFscPayBackOrderId(fscOrderPO.getFscOrderId());
        return fscOrderPO;
    }

    private String getSerial() {
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setEncodedRuleCode("PAYMENT_BACK_REQUEST_NO");
        encodedSerialGetServiceReqBO.setNum(Integer.valueOf(1));
        encodedSerialGetServiceReqBO.setOrgType("-1");
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        if (null == encodedSerialGetServiceRspBO || CollectionUtils.isEmpty((Collection)encodedSerialGetServiceRspBO.getSerialNoList()) || StringUtils.isBlank((CharSequence)((CharSequence)encodedSerialGetServiceRspBO.getSerialNoList().get(0)))) {
            throw new FscBusinessException("191014", "\u83b7\u53d6\u914d\u7f6e\u6d41\u6c34\u53f7\u5f02\u5e38");
        }
        return (String)encodedSerialGetServiceRspBO.getSerialNoList().get(0);
    }
}

