/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dycpro.saas.mall.se.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.bo.esmapping.DycProEsIndexMappingSkuBO;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommSkuEsScopeType;
import com.tydic.dyc.pro.dmc.service.agreement.api.DycProAgrItemListQryApiService;
import com.tydic.dyc.pro.dmc.service.agreement.bo.DycProAgrItemApiBO;
import com.tydic.dyc.pro.dmc.service.agreement.bo.DycProAgrItemListQryApiReqBO;
import com.tydic.dyc.pro.dmc.service.agreement.bo.DycProAgrItemListQryApiRspBO;
import com.tydic.dyc.pro.dmc.service.purchaseAuth.api.DycProCommPurchaseAuthListQryAllService;
import com.tydic.dyc.pro.dmc.service.purchaseAuth.bo.DycProCommPurchaseAuthListQryReqBO;
import com.tydic.dyc.pro.dmc.service.purchaseAuth.bo.DycProCommPurchaseAuthListQryRspBO;
import com.tydic.dyc.pro.dmc.service.stock.api.DycProCommQrySkuStockInfoListService;
import com.tydic.dyc.pro.dmc.service.stock.bo.DycProCommQrySkuStockInfoBO;
import com.tydic.dyc.pro.dmc.service.stock.bo.DycProCommQrySkuStockInfoListReqBO;
import com.tydic.dyc.pro.dmc.service.stock.bo.DycProCommQrySkuStockInfoListRspBO;
import com.tydic.dycpro.saas.mall.contants.DycProSaasMallConstants;
import com.tydic.dycpro.saas.mall.se.api.DycProSaasMallSearchService;
import com.tydic.dycpro.saas.mall.se.bo.DycProSaasMallSearchFilterBO;
import com.tydic.dycpro.saas.mall.se.bo.DycProSaasMallSearchPropertyRspBO;
import com.tydic.dycpro.saas.mall.se.bo.DycProSaasMallSearchReqBO;
import com.tydic.dycpro.saas.mall.se.bo.DycProSaasMallSearchResultBO;
import com.tydic.dycpro.saas.mall.se.bo.DycProSaasMallSearchRspBO;
import com.tydic.se.app.ability.SeAppQueryService;
import com.tydic.se.app.ability.bo.SeAppSearchReqBO;
import com.tydic.se.app.ability.bo.SeAppSearchRspBO;
import com.tydic.se.base.ability.bo.SeComSortBO;
import com.tydic.se.base.ability.bo.SeQueryFilterBO;
import com.tydic.se.base.ability.bo.SeRangeFilterBo;
import com.tydic.se.base.ability.bo.SeShouldBO;
import com.tydic.se.base.ability.bo.SeTermsBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_PRO_GROUP/4.0.0/com.tydic.dycpro.saas.mall.se.api.DycProSaasMallSearchService"})
public class DycProSaasMallSearchServiceImpl
implements DycProSaasMallSearchService {
    private static final Logger log = LoggerFactory.getLogger(DycProSaasMallSearchServiceImpl.class);
    @Autowired
    private SeAppQueryService seAppQueryService;
    @Value(value="${ucc.upc.enable}")
    private boolean upcEnable;
    @Value(value="${purchaseAuthType}")
    private Integer purchaseAuthType;
    @Autowired
    private DycProAgrItemListQryApiService dycProAgrItemListQryApiService;
    @Autowired
    private DycProCommPurchaseAuthListQryAllService dycProCommPurchaseAuthListQryAllService;
    @Autowired
    private DycProCommQrySkuStockInfoListService dycProCommQrySkuStockInfoListService;

    @Override
    @PostMapping(value={"searchGoods"})
    public DycProSaasMallSearchRspBO searchGoods(@RequestBody DycProSaasMallSearchReqBO reqBO) {
        this.val(reqBO);
        if (DycProSaasMallConstants.SearchGoodsQryFlag.SAME.equals(reqBO.getQryFlag())) {
            if (null == reqBO.getUpcId() && this.upcEnable) {
                return new DycProSaasMallSearchRspBO();
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getEanCode()) && !this.upcEnable) {
                return new DycProSaasMallSearchRspBO();
            }
        }
        if (DycProSaasMallConstants.SearchGoodsQryFlag.CMP.equals(reqBO.getQryFlag())) {
            if (DycProSaasMallConstants.SearchGoodsQryCondition.UPC.equals(reqBO.getQryCondition())) {
                if (null == reqBO.getUpcId() && this.upcEnable) {
                    return new DycProSaasMallSearchRspBO();
                }
                if (StringUtils.isBlank((CharSequence)reqBO.getEanCode()) && !this.upcEnable) {
                    return new DycProSaasMallSearchRspBO();
                }
            }
            if (DycProSaasMallConstants.SearchGoodsQryCondition.SKU.equals(reqBO.getQryCondition()) && null == reqBO.getManageCatalogIdCondition() && StringUtils.isBlank((CharSequence)reqBO.getBrandNameCondition()) && StringUtils.isBlank((CharSequence)reqBO.getBrandNameCondition())) {
                return new DycProSaasMallSearchRspBO();
            }
        }
        SeAppSearchReqBO seAppSearchReqBO = new SeAppSearchReqBO();
        this.buildSeReqBo(reqBO, seAppSearchReqBO);
        log.debug("\u641c\u7d22\u5f15\u64ce\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)seAppSearchReqBO));
        SeAppSearchRspBO seAppSearchRspBO = this.seAppQueryService.search(seAppSearchReqBO);
        log.debug("\u641c\u7d22\u5f15\u64ce\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)seAppSearchRspBO));
        if (!"0".equals(seAppSearchRspBO.getCode())) {
            throw new ZTBusinessException(seAppSearchRspBO.getMessage());
        }
        DycProSaasMallSearchRspBO rspBO = new DycProSaasMallSearchRspBO();
        rspBO.setPageNo(seAppSearchRspBO.getPageNo());
        rspBO.setTotal(seAppSearchRspBO.getTotal());
        rspBO.setRecordsTotal(seAppSearchRspBO.getRecordsTotal());
        rspBO.setTraceId(seAppSearchRspBO.getTraceId());
        rspBO.setSearchId(seAppSearchRspBO.getSearchId());
        rspBO.setRows(JSON.parseArray((String)JSON.toJSONString((Object)seAppSearchRspBO.getSkuList()), DycProSaasMallSearchResultBO.class));
        if (DycProSaasMallConstants.SearchGoodsQryFlag.AGR.equals(reqBO.getQryFlag())) {
            this.setAgrInfo(rspBO);
        }
        this.setStockInfo(rspBO);
        return rspBO;
    }

    private void setStockInfo(DycProSaasMallSearchRspBO rspBO) {
        if (!CollectionUtils.isEmpty((Collection)rspBO.getRows())) {
            List skuIdList = rspBO.getRows().stream().map(DycProEsIndexMappingSkuBO::getSkuId).collect(Collectors.toList());
            DycProCommQrySkuStockInfoListReqBO dycProCommQrySkuStockInfoListReqBO = new DycProCommQrySkuStockInfoListReqBO();
            dycProCommQrySkuStockInfoListReqBO.setSkuIdList(skuIdList);
            DycProCommQrySkuStockInfoListRspBO dycProCommQrySkuStockInfoListRspBO = this.dycProCommQrySkuStockInfoListService.qrySkuStockList(dycProCommQrySkuStockInfoListReqBO);
            if (!CollectionUtils.isEmpty((Collection)dycProCommQrySkuStockInfoListRspBO.getRows())) {
                Map<Long, DycProCommQrySkuStockInfoBO> skuStockMap = dycProCommQrySkuStockInfoListRspBO.getRows().stream().collect(Collectors.toMap(DycProCommQrySkuStockInfoBO::getSkuId, o -> o, (o1, o2) -> o1));
                for (DycProSaasMallSearchResultBO row : rspBO.getRows()) {
                    if (!skuStockMap.containsKey(row.getSkuId())) continue;
                    DycProCommQrySkuStockInfoBO dycProCommQrySkuStockInfoBO = skuStockMap.get(row.getSkuId());
                    row.setOriginNum(dycProCommQrySkuStockInfoBO.getOriginNum());
                    row.setTotalNum(dycProCommQrySkuStockInfoBO.getTotalNum());
                    row.setUnsaleNum(dycProCommQrySkuStockInfoBO.getUnsaleNum());
                    row.setSaledNum(dycProCommQrySkuStockInfoBO.getSaledNum());
                    row.setDecimalLimit(dycProCommQrySkuStockInfoBO.getDecimalLimit());
                }
            }
        }
    }

    @Override
    @PostMapping(value={"searchProperty"})
    public DycProSaasMallSearchPropertyRspBO searchProperty(@RequestBody DycProSaasMallSearchReqBO reqBO) {
        SeAppSearchReqBO seAppSearchReqBO = new SeAppSearchReqBO();
        this.buildSeReqBo(reqBO, seAppSearchReqBO);
        SeAppSearchRspBO seAppSearchRspBO = this.seAppQueryService.categoryList(seAppSearchReqBO);
        if (!"0".equals(seAppSearchRspBO.getCode())) {
            throw new ZTBusinessException(seAppSearchRspBO.getMessage());
        }
        DycProSaasMallSearchPropertyRspBO rspBO = new DycProSaasMallSearchPropertyRspBO();
        rspBO.setQueryFilterList(JSON.parseArray((String)JSON.toJSONString((Object)seAppSearchRspBO.getQueryFilterList()), DycProSaasMallSearchFilterBO.class));
        return rspBO;
    }

    private void setAgrInfo(DycProSaasMallSearchRspBO rspBO) {
        List agrItemIdList = rspBO.getRows().stream().map(DycProEsIndexMappingSkuBO::getAgrItemId).filter(Objects::nonNull).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(agrItemIdList)) {
            DycProAgrItemListQryApiReqBO dycProAgrItemListQryApiReqBO = new DycProAgrItemListQryApiReqBO();
            dycProAgrItemListQryApiReqBO.setAgrItemIds(agrItemIdList);
            DycProAgrItemListQryApiRspBO dycProAgrItemListQryApiRspBO = this.dycProAgrItemListQryApiService.qryAgrItemList(dycProAgrItemListQryApiReqBO);
            if (!CollectionUtils.isEmpty((Collection)dycProAgrItemListQryApiRspBO.getRows())) {
                Map<Long, DycProAgrItemApiBO> agrItemMap = dycProAgrItemListQryApiRspBO.getRows().stream().collect(Collectors.toMap(DycProAgrItemApiBO::getAgrItemId, o -> o, (o1, o2) -> o1));
                for (DycProSaasMallSearchResultBO row : rspBO.getRows()) {
                    if (null == row.getAgrItemId() || !agrItemMap.containsKey(row.getAgrItemId())) continue;
                    DycProAgrItemApiBO dycProAgrItemApiBO = agrItemMap.get(row.getAgrItemId());
                    row.setSupplyCycle(dycProAgrItemApiBO.getSupplyCycle());
                }
            }
        }
    }

    private void val(DycProSaasMallSearchReqBO reqBO) {
        if (DycProSaasMallConstants.SearchGoodsQryFlag.AGR.equals(reqBO.getQryFlag())) {
            if (null == reqBO.getAgrId()) {
                throw new ZTBusinessException("\u534f\u8baeID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == reqBO.getSkuId()) {
                throw new ZTBusinessException("\u5546\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (DycProSaasMallConstants.SearchGoodsQryFlag.SAME.equals(reqBO.getQryFlag()) && null == reqBO.getSkuId()) {
            throw new ZTBusinessException("\u5546\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void buildSeReqBo(DycProSaasMallSearchReqBO reqBO, SeAppSearchReqBO seAppSearchReqBO) {
        seAppSearchReqBO.setSearchHostGoods(reqBO.getSearchHostGoods());
        seAppSearchReqBO.setPageNo(reqBO.getPageNo());
        seAppSearchReqBO.setPageSize(reqBO.getPageSize());
        seAppSearchReqBO.setUserId(reqBO.getUserId());
        seAppSearchReqBO.setQueryStr(reqBO.getQueryStr());
        if (!CollectionUtils.isEmpty(reqBO.getQueryFilterList())) {
            seAppSearchReqBO.setQueryFilterList(JSON.parseArray((String)JSON.toJSONString(reqBO.getQueryFilterList()), SeQueryFilterBO.class));
        }
        if (null != reqBO.getSalesPriceEnd()) {
            seAppSearchReqBO.setMaxSalePrice(reqBO.getSalesPriceEnd().toString());
        }
        if (null != reqBO.getSalesPriceStart()) {
            seAppSearchReqBO.setMinSalePrice(reqBO.getSalesPriceStart().toString());
        }
        this.setTerms(reqBO, seAppSearchReqBO);
        DycProSaasMallSearchServiceImpl.setSort(reqBO, seAppSearchReqBO);
        this.setRange(reqBO, seAppSearchReqBO);
    }

    private void setRange(DycProSaasMallSearchReqBO reqBO, SeAppSearchReqBO seAppSearchReqBO) {
        ArrayList<SeRangeFilterBo> seRangeFilterBos = new ArrayList<SeRangeFilterBo>();
        Date now = new Date();
        JSONObject banEndDateRangeFilter = new JSONObject();
        banEndDateRangeFilter.put("gt", (Object)now.getTime());
        SeRangeFilterBo bansRuleRangeFilterBoEnd = new SeRangeFilterBo();
        bansRuleRangeFilterBoEnd.setRangeFilters(banEndDateRangeFilter);
        bansRuleRangeFilterBoEnd.setRangeName("bansRuleList.bansEndDate");
        bansRuleRangeFilterBoEnd.setMustNot(Boolean.valueOf(true));
        bansRuleRangeFilterBoEnd.setExistsField("bansRuleList");
        bansRuleRangeFilterBoEnd.setExists(Boolean.valueOf(true));
        bansRuleRangeFilterBoEnd.setGroupBy("bans");
        bansRuleRangeFilterBoEnd.setIsMerge(Boolean.valueOf(true));
        bansRuleRangeFilterBoEnd.setIsNested(Boolean.valueOf(true));
        JSONObject banStartDateRangeFilter = new JSONObject();
        banStartDateRangeFilter.put("lt", (Object)now.getTime());
        SeRangeFilterBo bansRuleRangeFilterBoStart = new SeRangeFilterBo();
        bansRuleRangeFilterBoStart.setRangeFilters(banStartDateRangeFilter);
        bansRuleRangeFilterBoStart.setRangeName("bansRuleList.bansStartDate");
        bansRuleRangeFilterBoStart.setMustNot(Boolean.valueOf(true));
        bansRuleRangeFilterBoStart.setExistsField("bansRuleList");
        bansRuleRangeFilterBoStart.setExists(Boolean.valueOf(true));
        bansRuleRangeFilterBoStart.setGroupBy("bans");
        bansRuleRangeFilterBoStart.setIsMerge(Boolean.valueOf(true));
        bansRuleRangeFilterBoStart.setIsNested(Boolean.valueOf(true));
        seRangeFilterBos.add(bansRuleRangeFilterBoEnd);
        seRangeFilterBos.add(bansRuleRangeFilterBoStart);
        seAppSearchReqBO.setSeRangeFilterList(seRangeFilterBos);
    }

    private void setTerms(DycProSaasMallSearchReqBO reqBO, SeAppSearchReqBO seAppSearchReqBO) {
        SeTermsBO skuNameTerm;
        ArrayList<SeTermsBO> mustTermsList = new ArrayList<SeTermsBO>();
        ArrayList<SeTermsBO> mustNotTermsList = new ArrayList<SeTermsBO>();
        ArrayList<SeShouldBO> shouldList = new ArrayList<SeShouldBO>();
        SeTermsBO skuStatus = new SeTermsBO();
        skuStatus.setName("skuStatus");
        skuStatus.setIsWildcard(Boolean.valueOf(true));
        skuStatus.setValueList(Collections.singletonList("2"));
        mustTermsList.add(skuStatus);
        if (!CollectionUtils.isEmpty(reqBO.getManageCatalogIdList())) {
            SeTermsBO manageCatalogTerm = new SeTermsBO();
            manageCatalogTerm.setName("manageCatalogList.manageCatalogId");
            manageCatalogTerm.setIsWildcard(Boolean.valueOf(true));
            manageCatalogTerm.setValueList(reqBO.getManageCatalogIdList().stream().map(Object::toString).collect(Collectors.toList()));
            mustTermsList.add(manageCatalogTerm);
        }
        if (null != reqBO.getChannelId()) {
            SeTermsBO channelIdTerm = new SeTermsBO();
            channelIdTerm.setName("channelList.channelId");
            channelIdTerm.setIsWildcard(Boolean.valueOf(true));
            channelIdTerm.setValueList(Collections.singletonList(reqBO.getChannelId().toString()));
            mustTermsList.add(channelIdTerm);
        }
        if (!StringUtils.isBlank((CharSequence)reqBO.getSkuCode())) {
            SeTermsBO skuCodeTerm = new SeTermsBO();
            skuCodeTerm.setName("skuCode.keyword");
            skuCodeTerm.setIsWildcard(Boolean.valueOf(true));
            skuCodeTerm.setValueList(Collections.singletonList(reqBO.getSkuCode()));
            mustTermsList.add(skuCodeTerm);
        }
        if (!StringUtils.isBlank((CharSequence)reqBO.getSkuName())) {
            skuNameTerm = new SeTermsBO();
            skuNameTerm.setName("skuName.keyword");
            skuNameTerm.setIsWildcard(Boolean.valueOf(true));
            skuNameTerm.setValueList(Collections.singletonList(reqBO.getSkuName()));
            mustTermsList.add(skuNameTerm);
        }
        if (!StringUtils.isBlank((CharSequence)reqBO.getBrandName())) {
            skuNameTerm = new SeTermsBO();
            skuNameTerm.setName("brandName.keyword");
            skuNameTerm.setIsWildcard(Boolean.valueOf(true));
            skuNameTerm.setValueList(Collections.singletonList(reqBO.getBrandName()));
            mustTermsList.add(skuNameTerm);
        }
        if (!StringUtils.isBlank((CharSequence)reqBO.getSupplierName())) {
            skuNameTerm = new SeTermsBO();
            skuNameTerm.setName("supplierName.keyword");
            skuNameTerm.setIsWildcard(Boolean.valueOf(true));
            skuNameTerm.setValueList(Collections.singletonList(reqBO.getSupplierName()));
            mustTermsList.add(skuNameTerm);
        }
        if (null != reqBO.getSupplierId()) {
            skuNameTerm = new SeTermsBO();
            skuNameTerm.setName("supplierId");
            skuNameTerm.setIsWildcard(Boolean.valueOf(true));
            skuNameTerm.setValueList(Collections.singletonList(reqBO.getSupplierId().toString()));
            mustTermsList.add(skuNameTerm);
        }
        if (!StringUtils.isBlank((CharSequence)reqBO.getMaterialName())) {
            skuNameTerm = new SeTermsBO();
            skuNameTerm.setName("materialName.keyword");
            skuNameTerm.setIsWildcard(Boolean.valueOf(true));
            skuNameTerm.setValueList(Collections.singletonList(reqBO.getMaterialName()));
            mustTermsList.add(skuNameTerm);
        }
        if (this.purchaseAuthType == 2 && !StringUtils.isEmpty((CharSequence)reqBO.getOrgPath())) {
            DycProCommPurchaseAuthListQryReqBO qryReqBO = new DycProCommPurchaseAuthListQryReqBO();
            qryReqBO.setOrgPath(reqBO.getOrgPath());
            DycProCommPurchaseAuthListQryRspBO rspBO = this.dycProCommPurchaseAuthListQryAllService.qryPurchaseAuthAll(qryReqBO);
            if (null != rspBO.getRow()) {
                SeTermsBO seTermsBO = new SeTermsBO();
                seTermsBO.setName("manageCatalogList.manageCatalogId");
                List values = rspBO.getRow().getCatalogIds().stream().map(Object::toString).collect(Collectors.toList());
                seTermsBO.setValueList(values);
                mustTermsList.add(seTermsBO);
            }
        }
        if (!ObjectUtils.isEmpty((Object)reqBO.getOrgPath())) {
            SeShouldBO viewScopeShouldBO = new SeShouldBO();
            viewScopeShouldBO.setName("viewScopeList.keyword");
            viewScopeShouldBO.setIsWildcard(Boolean.valueOf(false));
            viewScopeShouldBO.setGroupBy("scope");
            viewScopeShouldBO.setIsMerge(Boolean.valueOf(true));
            ArrayList<String> viewScopeList = new ArrayList<String>();
            viewScopeList.add(DmcCommSkuEsScopeType.ALL.getCode());
            String orgPath = reqBO.getOrgPath();
            if (orgPath.endsWith("-")) {
                orgPath = orgPath.substring(0, orgPath.length() - 1);
            }
            String[] orgList = orgPath.split("-");
            StringBuilder currentPath = new StringBuilder();
            for (int i = 0; i < orgList.length; ++i) {
                if (i > 0) {
                    currentPath.append("-");
                }
                currentPath.append(orgList[i]);
                viewScopeList.add(DmcCommSkuEsScopeType.COMPANY_PATH.getCode() + new String(currentPath));
            }
            if (reqBO.getCompanyId() != null) {
                viewScopeList.add(DmcCommSkuEsScopeType.COMPANY_ID.getCode() + reqBO.getCompanyId());
            }
            viewScopeShouldBO.setValueList(viewScopeList);
            shouldList.add(viewScopeShouldBO);
            SeShouldBO ecSkuCource = new SeShouldBO();
            ecSkuCource.setName("skuSource");
            ecSkuCource.setIsWildcard(Boolean.valueOf(false));
            ecSkuCource.setValueList(Arrays.asList(DycProSaasMallConstants.SkuSource.E_SKU.toString()));
            ecSkuCource.setGroupBy("scope");
            ecSkuCource.setIsMerge(Boolean.valueOf(true));
            shouldList.add(ecSkuCource);
        }
        if (null != reqBO.getQryFlag()) {
            SeTermsBO skuIdNotTerm;
            SeTermsBO eanCodeTerm;
            SeTermsBO upcIdTerm;
            if (DycProSaasMallConstants.SearchGoodsQryFlag.SAME.equals(reqBO.getQryFlag())) {
                if (this.upcEnable) {
                    upcIdTerm = new SeTermsBO();
                    upcIdTerm.setName("upcId");
                    upcIdTerm.setIsWildcard(Boolean.valueOf(false));
                    upcIdTerm.setValueList(Collections.singletonList(reqBO.getUpcId().toString()));
                    mustTermsList.add(upcIdTerm);
                } else {
                    eanCodeTerm = new SeTermsBO();
                    eanCodeTerm.setName("eanCode.keyword");
                    eanCodeTerm.setIsWildcard(Boolean.valueOf(false));
                    eanCodeTerm.setValueList(Collections.singletonList(reqBO.getEanCode()));
                    mustTermsList.add(eanCodeTerm);
                }
                skuIdNotTerm = new SeTermsBO();
                skuIdNotTerm.setName("skuId");
                skuIdNotTerm.setIsWildcard(Boolean.valueOf(false));
                skuIdNotTerm.setValueList(Collections.singletonList(reqBO.getSkuId().toString()));
                mustNotTermsList.add(skuIdNotTerm);
            }
            if (DycProSaasMallConstants.SearchGoodsQryFlag.AGR.equals(reqBO.getQryFlag())) {
                SeTermsBO agrIdTerm = new SeTermsBO();
                agrIdTerm.setName("agrId");
                agrIdTerm.setIsWildcard(Boolean.valueOf(false));
                agrIdTerm.setValueList(Collections.singletonList(reqBO.getAgrId().toString()));
                mustTermsList.add(agrIdTerm);
                SeTermsBO skuIdNotTerm2 = new SeTermsBO();
                skuIdNotTerm2.setName("skuId");
                skuIdNotTerm2.setIsWildcard(Boolean.valueOf(false));
                skuIdNotTerm2.setValueList(Collections.singletonList(reqBO.getSkuId().toString()));
                mustNotTermsList.add(skuIdNotTerm2);
            }
            if (DycProSaasMallConstants.SearchGoodsQryFlag.CMP.equals(reqBO.getQryFlag())) {
                if (DycProSaasMallConstants.SearchGoodsQryCondition.UPC.equals(reqBO.getQryCondition())) {
                    if (this.upcEnable) {
                        upcIdTerm = new SeTermsBO();
                        upcIdTerm.setName("upcId");
                        upcIdTerm.setIsWildcard(Boolean.valueOf(false));
                        upcIdTerm.setValueList(Collections.singletonList(reqBO.getUpcId().toString()));
                        mustTermsList.add(upcIdTerm);
                    } else {
                        eanCodeTerm = new SeTermsBO();
                        eanCodeTerm.setName("eanCode.keyword");
                        eanCodeTerm.setIsWildcard(Boolean.valueOf(false));
                        eanCodeTerm.setValueList(Collections.singletonList(reqBO.getEanCode()));
                        mustTermsList.add(eanCodeTerm);
                    }
                }
                if (DycProSaasMallConstants.SearchGoodsQryCondition.SKU.equals(reqBO.getQryCondition())) {
                    SeTermsBO brandName;
                    if (!StringUtils.isBlank((CharSequence)reqBO.getBrandNameCondition())) {
                        brandName = new SeTermsBO();
                        brandName.setName("brandName.keyword");
                        brandName.setIsWildcard(Boolean.valueOf(false));
                        brandName.setValueList(Collections.singletonList(reqBO.getBrandNameCondition()));
                        mustTermsList.add(brandName);
                    }
                    if (!StringUtils.isBlank((CharSequence)reqBO.getSkuNameCondition())) {
                        brandName = new SeTermsBO();
                        brandName.setName("skuName.keyword");
                        brandName.setIsWildcard(Boolean.valueOf(false));
                        brandName.setValueList(Collections.singletonList(reqBO.getSkuNameCondition()));
                        mustTermsList.add(brandName);
                    }
                    if (null != reqBO.getManageCatalogIdCondition()) {
                        brandName = new SeTermsBO();
                        brandName.setName("manageCatalogList.manageCatalogId");
                        brandName.setIsWildcard(Boolean.valueOf(false));
                        brandName.setValueList(Collections.singletonList(reqBO.getManageCatalogIdCondition().toString()));
                        mustTermsList.add(brandName);
                    }
                }
                skuIdNotTerm = new SeTermsBO();
                skuIdNotTerm.setName("skuId");
                skuIdNotTerm.setIsWildcard(Boolean.valueOf(false));
                skuIdNotTerm.setValueList(reqBO.getSkuIdList().stream().map(Object::toString).collect(Collectors.toList()));
                mustNotTermsList.add(skuIdNotTerm);
            }
        }
        seAppSearchReqBO.setShouldList(shouldList);
        seAppSearchReqBO.setMustTermsList(mustTermsList);
        seAppSearchReqBO.setMustNotTermsList(mustNotTermsList);
    }

    private static void setSort(DycProSaasMallSearchReqBO reqBO, SeAppSearchReqBO seAppSearchReqBO) {
        if (null == reqBO.getOrderByColumn()) {
            return;
        }
        ArrayList<SeComSortBO> seComSortBOS = new ArrayList<SeComSortBO>();
        SeComSortBO seComSortBO = new SeComSortBO();
        seComSortBO.setOrderType(reqBO.getOrderType());
        if (DycProSaasMallConstants.SearchOrderByColumn.ON_SHELVE_TIME.equals(reqBO.getOrderByColumn())) {
            seComSortBO.setOrderByColumn("onShelveTime");
        }
        if (DycProSaasMallConstants.SearchOrderByColumn.SALE_PRICE.equals(reqBO.getOrderByColumn())) {
            seComSortBO.setOrderByColumn("salePrice");
        }
        if (DycProSaasMallConstants.SearchOrderByColumn.DISCOUNT_RATE.equals(reqBO.getOrderByColumn())) {
            seComSortBO.setOrderByColumn("discountRate");
        }
        if (DycProSaasMallConstants.SearchOrderByColumn.ORDER_AMOUNT.equals(reqBO.getOrderByColumn())) {
            seComSortBO.setOrderByColumn("orderAmount");
        }
        seComSortBOS.add(seComSortBO);
        seAppSearchReqBO.setComSortList(seComSortBOS);
    }
}

