/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.busicommon.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.base.utils.DycEsbUtil;
import com.tydic.dyc.atom.base.utils.DycPropertiesUtil;
import com.tydic.dyc.atom.busicommon.api.DycUocGetJDOrderFunction;
import com.tydic.dyc.atom.busicommon.bo.DycUocChildSaleOrderBO;
import com.tydic.dyc.atom.busicommon.bo.DycUocGetJDNoSplitOrderBO;
import com.tydic.dyc.atom.busicommon.bo.DycUocGetJDOrderFuncReqBO;
import com.tydic.dyc.atom.busicommon.bo.DycUocGetJDOrderFuncRspBO;
import com.tydic.dyc.atom.busicommon.bo.DycUocGetJDSplitOrderBO;
import com.tydic.dyc.atom.busicommon.bo.DycUocParentSaleOrderBO;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DycUocGetJDOrderFunctionImpl
implements DycUocGetJDOrderFunction {
    private static final Logger log = LoggerFactory.getLogger(DycUocGetJDOrderFunctionImpl.class);
    @Value(value="${queryExts:jdOrderState,orderType}")
    private String queryExts;

    @Override
    public DycUocGetJDOrderFuncRspBO getExtorder(DycUocGetJDOrderFuncReqBO reqBO) {
        DycUocGetJDOrderFuncRspBO rspBO = new DycUocGetJDOrderFuncRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        reqBO.setQueryExts(this.queryExts);
        String hsn = DycPropertiesUtil.getProperty("SUPPLIER_ID_" + reqBO.getSupNo());
        try {
            log.info("\u4eac\u4e1c\u67e5\u8be2\u8ba2\u5355\u8be6\u60c5\u5165\u53c2: {}", (Object)JSON.toJSONString((Object)reqBO));
            String httpRspStr = DycEsbUtil.doPostReuest(DycPropertiesUtil.getProperty("ESB_QRY_JD_ORDER_URL"), JSON.toJSONString((Object)reqBO), hsn);
            log.info("\u4eac\u4e1c\u67e5\u8be2\u8ba2\u5355\u8be6\u60c5\u51fa\u53c2: {}", (Object)httpRspStr);
            rspBO = DycUocGetJDOrderFunctionImpl.resolveRsp(httpRspStr);
        }
        catch (ZTBusinessException e) {
            log.error("e: {}", (Object)e.getMessage());
            throw new ZTBusinessException(e.getMessage());
        }
        return rspBO;
    }

    private static DycUocGetJDOrderFuncRspBO resolveRsp(String returnString) {
        log.debug("\u8c03\u7528\u4eac\u4e1c\u8ba2\u5355\u67e5\u8be2ESB\u63a5\u53e3\u8fd4\u56de\u6570\u636e\uff1a" + returnString);
        DycUocGetJDOrderFuncRspBO rspBO = new DycUocGetJDOrderFuncRspBO();
        JSONObject jsonObject = JSONObject.parseObject((String)returnString);
        if (jsonObject.getBoolean("success").booleanValue()) {
            String jsonStr = JSONObject.toJSONString((Object)jsonObject.get((Object)"result"));
            JSONObject jsonObj = JSONObject.parseObject((String)jsonStr);
            Object object = jsonObj.get((Object)"cOrder");
            if (object == null) {
                DycUocGetJDNoSplitOrderBO parentOrderBO = (DycUocGetJDNoSplitOrderBO)((Object)JSON.parseObject((String)jsonStr, DycUocGetJDNoSplitOrderBO.class));
                rspBO.setUocGetJDNoSplitOrderBO(parentOrderBO);
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u83b7\u53d6\u65e0\u62c6\u5355\u8ba2\u5355\u4fe1\u606f\u6210\u529f!");
                return rspBO;
            }
            String pOrder = JSONObject.toJSONString((Object)jsonObj.get((Object)"pOrder"));
            DycUocParentSaleOrderBO parentSaleOrderRsp = (DycUocParentSaleOrderBO)JSON.parseObject((String)pOrder, DycUocParentSaleOrderBO.class);
            DycUocGetJDSplitOrderBO uocGetJDSplitOrderBO = (DycUocGetJDSplitOrderBO)((Object)JSON.parseObject((String)jsonStr, DycUocGetJDSplitOrderBO.class));
            uocGetJDSplitOrderBO.setPOrder(parentSaleOrderRsp);
            ArrayList<DycUocChildSaleOrderBO> childList = new ArrayList<DycUocChildSaleOrderBO>();
            String cOrder = JSONObject.toJSONString((Object)jsonObj.get((Object)"cOrder"));
            JSONArray array = JSONArray.parseArray((String)cOrder);
            for (Object singleObject : array) {
                String obj = JSONObject.toJSONString(singleObject);
                DycUocChildSaleOrderBO child = (DycUocChildSaleOrderBO)JSON.parseObject((String)obj, DycUocChildSaleOrderBO.class);
                childList.add(child);
            }
            uocGetJDSplitOrderBO.setCOrder(childList);
            rspBO.setUocGetJDSplitOrderBO(uocGetJDSplitOrderBO);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u83b7\u53d6\u62c6\u5355\u540e\u7684\u7236\u5b50\u8ba2\u5355\u4fe1\u606f\u6210\u529f!");
        } else {
            rspBO.setRespCode((String)jsonObject.get((Object)"resultCode"));
            rspBO.setRespDesc((String)jsonObject.get((Object)"resultMessage"));
        }
        return rspBO;
    }
}

