/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.busicommon.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.JsonUtils;
import com.tydic.dyc.atom.base.utils.DycEsbUtil;
import com.tydic.dyc.atom.base.utils.DycPropertiesUtil;
import com.tydic.dyc.atom.busicommon.api.DycUocQueryBiddingFunction;
import com.tydic.dyc.atom.busicommon.bo.DycUocBatchBiddingSkuInfoBO;
import com.tydic.dyc.atom.busicommon.bo.DycUocBiddingExtendInfoBO;
import com.tydic.dyc.atom.busicommon.bo.DycUocQueryBiddingFuncReqBO;
import com.tydic.dyc.atom.busicommon.bo.DycUocQueryBiddingFuncRspBO;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class DycUocQueryBiddingFunctionImpl
implements DycUocQueryBiddingFunction {
    private static final Logger log = LoggerFactory.getLogger(DycUocQueryBiddingFunctionImpl.class);

    @Override
    public DycUocQueryBiddingFuncRspBO queryBatchBidding(DycUocQueryBiddingFuncReqBO reqBO) {
        this.verifyParam(reqBO);
        String callUrl = null;
        String hsn = DycPropertiesUtil.getProperty("SUPPLIER_ID_" + reqBO.getSupplierId());
        callUrl = DycPropertiesUtil.getProperty("ESB_QUERY_BIDDING_URL");
        String jsonString = JSON.toJSONString((Object)reqBO);
        log.info("\u7ade\u4ef7\u5355\u4fe1\u606f\u67e5\u8be2\u5165\u53c2:{}", (Object)jsonString);
        log.info("\u7ade\u4ef7\u5355\u4fe1\u606f\u67e5\u8be2\u8bf7\u6c42\u5730\u5740:{}", (Object)callUrl);
        log.info("\u7ade\u4ef7\u5355\u4fe1\u606f\u67e5\u8be2\u8bf7\u6c42hsn:{}", (Object)hsn);
        String returnString = DycEsbUtil.doPostReuest(callUrl, jsonString, hsn);
        log.info("\u7ade\u4ef7\u5355\u4fe1\u606f\u67e5\u8be2\u51fa\u53c2: " + returnString);
        return this.resolveRsp(returnString);
    }

    private void verifyParam(DycUocQueryBiddingFuncReqBO reqBo) {
        if (StringUtils.isEmpty((Object)reqBo.getThirdApplyId())) {
            throw new ZTBusinessException("\u7b2c\u4e09\u65b9\u7533\u8bf7\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private DycUocQueryBiddingFuncRspBO resolveRsp(String returnString) {
        DycUocQueryBiddingFuncRspBO rspBO = new DycUocQueryBiddingFuncRspBO();
        JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
        if (rspJsonObject.getBoolean("success").booleanValue() && "0000".equals(rspJsonObject.get((Object)"resultCode"))) {
            JSONObject jsonObject = (JSONObject)rspJsonObject.get((Object)"result");
            rspBO.setBiddingCode((String)jsonObject.get((Object)"biddingCode"));
            rspBO.setBiddingStatus((String)jsonObject.get((Object)"biddingStatus"));
            rspBO.setThirdApplyId((String)jsonObject.get((Object)"thirdApplyId"));
            rspBO.setOrderDeadLine(jsonObject.getLong("orderDeadLine").toString());
            log.info("\u67e5\u8be2\u7ade\u4ef7\u89e3\u6790\u7ed3\u679c" + JSON.toJSONString((Object)((Object)rspBO)));
            if (jsonObject.get((Object)"skuInfoList") != null) {
                String skuInfoLists = JSONObject.toJSONString((Object)jsonObject.get((Object)"skuInfoList"));
                DycUocBatchBiddingSkuInfoBO[] jsonStringToJavaBean = (DycUocBatchBiddingSkuInfoBO[])JsonUtils.jsonStringToJavaBean((String)skuInfoLists, DycUocBatchBiddingSkuInfoBO[].class);
                List<DycUocBatchBiddingSkuInfoBO> asList = Arrays.asList(jsonStringToJavaBean);
                rspBO.setSkuInfoList(asList);
            }
            if (jsonObject.get((Object)"extendInfo") == null) {
                rspBO.setExtendInfo((DycUocBiddingExtendInfoBO)JSON.parseObject((String)JSONObject.toJSONString((Object)jsonObject.get((Object)"extendInfo")), DycUocBiddingExtendInfoBO.class));
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        } else {
            rspBO.setRespCode(rspJsonObject.getString("resultCode"));
            rspBO.setRespDesc("\u67e5\u8be2\u7ade\u4ef7\u5355\u4fe1\u606f\u5931\u8d25\uff01");
        }
        return rspBO;
    }
}

