/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.estore.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.atom.base.utils.DycEsbUtil;
import com.tydic.dyc.atom.base.utils.DycPropertiesUtil;
import com.tydic.dyc.atom.estore.api.DycUocEsCheckOrdersFunction;
import com.tydic.dyc.atom.estore.bo.DycUocEsCheckOrderEntity;
import com.tydic.dyc.atom.estore.bo.DycUocEsCheckOrdersFuncReqBO;
import com.tydic.dyc.atom.estore.bo.DycUocEsCheckOrdersFuncRspBO;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DycUocEsCheckOrdersFunctionImpl
implements DycUocEsCheckOrdersFunction {
    private static final Logger log = LoggerFactory.getLogger(DycUocEsCheckOrdersFunctionImpl.class);

    @Override
    public DycUocEsCheckOrdersFuncRspBO checkOrder(DycUocEsCheckOrdersFuncReqBO reqBo) {
        log.info("\u5bf9\u8d26\u539f\u5b50\u63a5\u53e3\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBo));
        String hsn = DycPropertiesUtil.getProperty("SUPPLIER_ID_" + reqBo.getSupNo());
        String url = reqBo.getCallUrl();
        String returnString = DycEsbUtil.doPostReuest(url, JSON.toJSONString((Object)reqBo), hsn);
        log.info("\u7535\u5546\u5bf9\u8d26\u63a5\u53e3\u8fd4\u56de\uff1a{}", (Object)JSON.toJSONString((Object)returnString));
        return this.resolveRsp(returnString, reqBo);
    }

    private DycUocEsCheckOrdersFuncRspBO resolveRsp(String returnString, DycUocEsCheckOrdersFuncReqBO reqBo) {
        DycUocEsCheckOrdersFuncRspBO rspBO = new DycUocEsCheckOrdersFuncRspBO();
        rspBO.setCheckType(reqBo.getCheckType());
        JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
        if (rspJsonObject.getBoolean("success").booleanValue()) {
            JSONObject jsonObject = (JSONObject)rspJsonObject.get((Object)"result");
            JSONArray orders = jsonObject.getJSONArray("orders");
            ArrayList<DycUocEsCheckOrderEntity> list = new ArrayList<DycUocEsCheckOrderEntity>();
            orders.stream().forEach(x -> {
                JSONObject object = (JSONObject)x;
                DycUocEsCheckOrderEntity uocEsCheckOrderEntity = (DycUocEsCheckOrderEntity)JSONObject.parseObject((String)JSON.toJSONString((Object)object), DycUocEsCheckOrderEntity.class);
                uocEsCheckOrderEntity.setOrderTime(object.getString("time"));
                list.add(uocEsCheckOrderEntity);
            });
            rspBO = (DycUocEsCheckOrdersFuncRspBO)((Object)JSON.parseObject((String)jsonObject.toJSONString(), DycUocEsCheckOrdersFuncRspBO.class));
            rspBO.setOrders(list);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        rspBO.setRespCode(rspJsonObject.getString("resultCode"));
        rspBO.setRespDesc(rspJsonObject.getString("resultMessage"));
        return rspBO;
    }
}

