/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.busicommon.commodity.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.common.ability.api.UccSkuListQryAbilityService;
import com.tydic.commodity.common.ability.api.UccSpuListQryAbilityService;
import com.tydic.commodity.common.ability.bo.UccSkuListQryAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSkuListQryAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccSpuListQryAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSpuListQryAbilityRspBO;
import com.tydic.dyc.authority.service.user.AuthUserRoleDataPowerQryService;
import com.tydic.dyc.authority.service.user.bo.AuthUserRoleDataPowerQryReqBo;
import com.tydic.dyc.authority.service.user.bo.AuthUserRoleDataPowerQryRspBo;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.busicommon.commodity.api.DycUccSpuListExportQryService;
import com.tydic.dyc.busicommon.commodity.bo.DycUccSpuListQryAbilityReqBO;
import com.tydic.dyc.busicommon.commodity.bo.DycUccSpuListQryAbilityRspBO;
import com.tydic.dyc.busicommon.commodity.bo.DycUccSpuListQryBO;
import com.tydic.dyc.busicommon.ucc.bo.DycUccSkuListQryBO;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.busicommon.commodity.api.DycUccSpuListExportQryService"})
public class DycUccSpuListExportQryServiceImpl
implements DycUccSpuListExportQryService {
    private static final Logger log = LoggerFactory.getLogger(DycUccSpuListExportQryServiceImpl.class);
    @Autowired
    private UccSpuListQryAbilityService uccSpuListQryAbilityService;
    @Autowired
    private AuthUserRoleDataPowerQryService authUserRoleDataPowerQryService;
    @Autowired
    private UccSkuListQryAbilityService uccSkuListQryAbilityService;
    public static final Integer INCREMENT = 200;

    @Override
    @PostMapping(value={"getSpuListQry"})
    public DycUccSpuListQryAbilityRspBO getSpuListQry(@RequestBody DycUccSpuListQryAbilityReqBO reqBO) {
        String strReq = JSONObject.toJSONString((Object)((Object)reqBO), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        UccSpuListQryAbilityReqBO abilityReqBO = (UccSpuListQryAbilityReqBO)JSONObject.parseObject((String)strReq, UccSpuListQryAbilityReqBO.class);
        this.setReqAuth(reqBO, strReq, abilityReqBO);
        UccSpuListQryAbilityRspBO abilityRspBO = this.uccSpuListQryAbilityService.getSpuListQry(abilityReqBO);
        DycUccSpuListQryAbilityRspBO rspBO = new DycUccSpuListQryAbilityRspBO();
        if ("0000".equals(abilityRspBO.getRespCode())) {
            String rspStr = JSONObject.toJSONString((Object)abilityRspBO);
            rspBO = (DycUccSpuListQryAbilityRspBO)((Object)JSONObject.parseObject((String)rspStr, DycUccSpuListQryAbilityRspBO.class));
            if (CollectionUtils.isNotEmpty(rspBO.getRows())) {
                Map<Long, List<DycUccSkuListQryBO>> skuMap = this.getSkuMap(rspBO);
                int i = 1;
                for (DycUccSpuListQryBO each : rspBO.getRows()) {
                    each.setSkuItemList(skuMap.get(each.getCommodityId()));
                    each.setSerialNumber(i++);
                    if (null == each.getCommodityExpand()) continue;
                    each.setCommodityExpand4(each.getCommodityExpand().getExpand4());
                    each.setCommodityExpand6(each.getCommodityExpand().getExpand6());
                }
            }
        } else {
            throw new ZTBusinessException(abilityRspBO.getRespDesc());
        }
        return rspBO;
    }

    private Map<Long, List<DycUccSkuListQryBO>> getSkuMap(DycUccSpuListQryAbilityRspBO rspBO) {
        List<Long> commodityIds = rspBO.getRows().parallelStream().map(DycUccSpuListQryBO::getCommodityId).collect(Collectors.toList());
        HashMap<Long, List<DycUccSkuListQryBO>> skuMap = new HashMap<Long, List<DycUccSkuListQryBO>>();
        if (commodityIds.size() > INCREMENT) {
            int times = commodityIds.size() % INCREMENT == 0 ? commodityIds.size() / INCREMENT : commodityIds.size() / INCREMENT + 1;
            int startIndex = 0;
            int endIndex = INCREMENT;
            for (int i = 1; i <= times; ++i) {
                List<Long> subCommodityIds = commodityIds.subList(startIndex, i == times ? commodityIds.size() : endIndex);
                skuMap.putAll(this.getSkuInfoMap(subCommodityIds));
                startIndex += INCREMENT.intValue();
                endIndex += INCREMENT.intValue();
            }
        } else {
            skuMap.putAll(this.getSkuInfoMap(commodityIds));
        }
        return skuMap;
    }

    private Map<Long, List<DycUccSkuListQryBO>> getSkuInfoMap(List<Long> commodityIds) {
        UccSkuListQryAbilityReqBO skuListQryAbilityReqBO = new UccSkuListQryAbilityReqBO();
        skuListQryAbilityReqBO.setCommodityIds(commodityIds);
        skuListQryAbilityReqBO.setPageSize(10000);
        UccSkuListQryAbilityRspBO skuListQryAbilityRspBO = this.uccSkuListQryAbilityService.getSkuListQry(skuListQryAbilityReqBO);
        if ("0000".equals(skuListQryAbilityRspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)skuListQryAbilityRspBO.getRows())) {
            List dycUccSkuListQryBOS = JUtil.jsl((List)skuListQryAbilityRspBO.getRows(), DycUccSkuListQryBO.class);
            return dycUccSkuListQryBOS.parallelStream().collect(Collectors.groupingBy(DycUccSkuListQryBO::getCommodityId));
        }
        return new HashMap<Long, List<DycUccSkuListQryBO>>();
    }

    private void setReqAuth(DycUccSpuListQryAbilityReqBO reqBO, String strReq, UccSpuListQryAbilityReqBO abilityReqBO) {
        AuthUserRoleDataPowerQryReqBo authUserRoleDataPowerQryReqBo = (AuthUserRoleDataPowerQryReqBo)JSONObject.parseObject((String)strReq, AuthUserRoleDataPowerQryReqBo.class);
        AuthUserRoleDataPowerQryRspBo authUserRoleDataPowerQryRspBo = this.authUserRoleDataPowerQryService.qryUserRoleDataPower(authUserRoleDataPowerQryReqBo);
        if (!"0000".equals(authUserRoleDataPowerQryRspBo.getRespCode())) {
            log.error(authUserRoleDataPowerQryRspBo.getRespDesc());
        } else {
            if (reqBO.getLoginTagIn().equals("0")) {
                abilityReqBO.setProExtendOrgIds(authUserRoleDataPowerQryRspBo.getProExtendOrgIds());
                abilityReqBO.setProNotExtendOrgIds(authUserRoleDataPowerQryRspBo.getProNotExtendOrgIds());
                abilityReqBO.setPurExtendOrgIds(authUserRoleDataPowerQryRspBo.getPurExtendOrgIds());
                abilityReqBO.setPurNotExtendOrgIds(authUserRoleDataPowerQryRspBo.getPurNotExtendOrgIds());
                abilityReqBO.setSupExtendOrgIds(authUserRoleDataPowerQryRspBo.getSupExtendOrgIds());
                abilityReqBO.setSupNotExtendOrgIds(authUserRoleDataPowerQryRspBo.getSupNotExtendOrgIds());
            }
            if (authUserRoleDataPowerQryRspBo.getSeflFlag().booleanValue()) {
                abilityReqBO.setCreateOperId(reqBO.getUserId() + "");
            }
        }
    }
}

