/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.busicommon.commodity.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.common.ability.api.UccSkuListQryAbilityService;
import com.tydic.commodity.common.ability.api.UccSpuListQryAbilityService;
import com.tydic.commodity.common.ability.bo.UccSkuListQryAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSkuListQryAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccSkuManagementListQryBO;
import com.tydic.commodity.common.ability.bo.UccSpuListQryAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSpuListQryAbilityRspBO;
import com.tydic.commodity.mall.ability.api.UccMallReplacementPriceAbilityService;
import com.tydic.commodity.mall.ability.bo.ReplacePriceInfoBO;
import com.tydic.commodity.mall.ability.bo.UccMallLadderPriceBo;
import com.tydic.commodity.mall.ability.bo.UccMallReplacementPriceReqBo;
import com.tydic.commodity.mall.ability.bo.UccMallReplacementPriceRspBo;
import com.tydic.dyc.agr.service.agr.AgrGetAgrMainListService;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrMainListReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrMainListRspBO;
import com.tydic.dyc.agr.service.agr.bo.AgrMainListBo;
import com.tydic.dyc.authority.service.user.AuthUserRoleDataPowerQryService;
import com.tydic.dyc.authority.service.user.bo.AuthUserRoleDataPowerQryReqBo;
import com.tydic.dyc.authority.service.user.bo.AuthUserRoleDataPowerQryRspBo;
import com.tydic.dyc.base.utils.MoneyUtils;
import com.tydic.dyc.busicommon.commodity.api.DycUccSpuListExportService;
import com.tydic.dyc.busicommon.commodity.bo.DycUccSkuListQryBO;
import com.tydic.dyc.busicommon.commodity.bo.DycUccSpuListExportAbilityReqBO;
import com.tydic.dyc.busicommon.commodity.bo.DycUccSpuListExportAbilityRspBO;
import com.tydic.dyc.busicommon.commodity.bo.DycUccSpuListExportBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.busicommon.commodity.api.DycUccSpuListExportService"})
public class DycUccSpuListExportServiceImpl
implements DycUccSpuListExportService {
    private static final Logger log = LoggerFactory.getLogger(DycUccSpuListExportServiceImpl.class);
    @Autowired
    private UccSpuListQryAbilityService uccSpuListQryAbilityService;
    @Autowired
    private AuthUserRoleDataPowerQryService authUserRoleDataPowerQryService;
    @Autowired
    private UccSkuListQryAbilityService uccSkuListQryAbilityService;
    @Autowired
    private AgrGetAgrMainListService agrGetAgrMainListService;
    @Autowired
    private UccMallReplacementPriceAbilityService uccMallReplacementPriceAbilityService;
    private final Integer PAGE_SIZE = 100000;

    @Override
    @PostMapping(value={"getSpuListExport"})
    public DycUccSpuListExportAbilityRspBO getSpuListExport(@RequestBody DycUccSpuListExportAbilityReqBO reqBO) {
        String strReq = JSONObject.toJSONString((Object)((Object)reqBO), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        UccSpuListQryAbilityReqBO abilityReqBO = (UccSpuListQryAbilityReqBO)JSONObject.parseObject((String)strReq, UccSpuListQryAbilityReqBO.class);
        this.setSpuReqAuth(reqBO, strReq, abilityReqBO);
        UccSpuListQryAbilityRspBO abilityRspBO = this.uccSpuListQryAbilityService.getSpuListQry(abilityReqBO);
        DycUccSpuListExportAbilityRspBO rspBO = new DycUccSpuListExportAbilityRspBO();
        if (!"0000".equals(abilityRspBO.getRespCode())) {
            throw new ZTBusinessException(abilityRspBO.getRespDesc());
        }
        String rspStr = JSONObject.toJSONString((Object)abilityRspBO);
        rspBO = (DycUccSpuListExportAbilityRspBO)((Object)JSONObject.parseObject((String)rspStr, DycUccSpuListExportAbilityRspBO.class));
        if (ObjectUtil.isNotEmpty(rspBO.getRows())) {
            String skuRspStr;
            List skuListQryBOList;
            List commodityIds = rspBO.getRows().stream().map(DycUccSpuListExportBO::getCommodityId).collect(Collectors.toList());
            String spuStrReq = JSONObject.toJSONString((Object)abilityReqBO);
            UccSkuListQryAbilityReqBO skuAbilityReqBO = (UccSkuListQryAbilityReqBO)JSONObject.parseObject((String)spuStrReq, UccSkuListQryAbilityReqBO.class);
            skuAbilityReqBO.setCommodityId(null);
            skuAbilityReqBO.setCommodityIds(commodityIds);
            skuAbilityReqBO.setPageSize(this.PAGE_SIZE.intValue());
            UccSkuListQryAbilityRspBO skuAbilityRspBO = this.uccSkuListQryAbilityService.getSkuListQry(skuAbilityReqBO);
            if ("0000".equals(skuAbilityRspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)(skuListQryBOList = JSONObject.parseArray((String)(skuRspStr = JSONObject.toJSONString((Object)skuAbilityRspBO.getRows())), DycUccSkuListQryBO.class)))) {
                this.replaceStatus(reqBO, skuListQryBOList);
                Map<Long, List<DycUccSkuListQryBO>> spuToSkuMap = skuListQryBOList.stream().collect(Collectors.groupingBy(DycUccSkuListQryBO::getCommodityId));
                for (DycUccSpuListExportBO each : rspBO.getRows()) {
                    if (!spuToSkuMap.containsKey(each.getCommodityId())) continue;
                    each.setSkuListQryBOList(spuToSkuMap.get(each.getCommodityId()));
                }
            }
        }
        return rspBO;
    }

    private void replaceStatus(DycUccSpuListExportAbilityReqBO reqBO, List<DycUccSkuListQryBO> skuListQryBOList) {
        List result = JSONObject.parseArray((String)JSONObject.toJSONString(skuListQryBOList), UccSkuManagementListQryBO.class);
        Map mapList = result.stream().collect(Collectors.toMap(UccSkuManagementListQryBO::getSkuId, Function.identity()));
        Map<Long, ReplacePriceInfoBO> replaceMap = this.getReplaceMap(reqBO, skuListQryBOList);
        ArrayList<Long> agrIds = new ArrayList<Long>();
        for (DycUccSkuListQryBO row : skuListQryBOList) {
            if (null == row.getAgreementId()) continue;
            agrIds.add(row.getAgreementId());
        }
        ConcurrentMap<Object, Object> agrMap = new ConcurrentHashMap();
        if (!CollectionUtils.isEmpty(agrIds)) {
            AgrGetAgrMainListReqBO agrGetAgrMainListReqBO = new AgrGetAgrMainListReqBO();
            agrGetAgrMainListReqBO.setAgrIds(agrIds.stream().distinct().collect(Collectors.toList()));
            AgrGetAgrMainListRspBO agrGetAgrMainListRspBO = this.agrGetAgrMainListService.getAgrMainList(agrGetAgrMainListReqBO);
            if (!CollectionUtils.isEmpty((Collection)agrGetAgrMainListRspBO.getRows())) {
                agrMap = agrGetAgrMainListRspBO.getRows().stream().collect(Collectors.toConcurrentMap(AgrMainListBo::getAgrId, AgrMainListBo::getAgrMode));
            }
        }
        for (DycUccSkuListQryBO each : skuListQryBOList) {
            ReplacePriceInfoBO replacePriceInfoBO;
            if (UccConstants.Source.NOT_AGR.equals(reqBO.getSkuSource()) && null != (replacePriceInfoBO = replaceMap.get(each.getSkuId()))) {
                each.setSalePrice(MoneyUtils.haoToYuan((Long)replacePriceInfoBO.getSalePrice()));
            }
            if (null == each.getAgreementId()) continue;
            each.setAgrMode((Integer)agrMap.get(each.getAgreementId()));
        }
    }

    private void setSpuReqAuth(DycUccSpuListExportAbilityReqBO reqBO, String strReq, UccSpuListQryAbilityReqBO abilityReqBO) {
        AuthUserRoleDataPowerQryReqBo authUserRoleDataPowerQryReqBo = (AuthUserRoleDataPowerQryReqBo)JSONObject.parseObject((String)strReq, AuthUserRoleDataPowerQryReqBo.class);
        AuthUserRoleDataPowerQryRspBo authUserRoleDataPowerQryRspBo = this.authUserRoleDataPowerQryService.qryUserRoleDataPower(authUserRoleDataPowerQryReqBo);
        if (!"0000".equals(authUserRoleDataPowerQryRspBo.getRespCode())) {
            log.error(authUserRoleDataPowerQryRspBo.getRespDesc());
        } else {
            if (reqBO.getLoginTagIn().equals("0")) {
                abilityReqBO.setProExtendOrgIds(authUserRoleDataPowerQryRspBo.getProExtendOrgIds());
                abilityReqBO.setProNotExtendOrgIds(authUserRoleDataPowerQryRspBo.getProNotExtendOrgIds());
                abilityReqBO.setPurExtendOrgIds(authUserRoleDataPowerQryRspBo.getPurExtendOrgIds());
                abilityReqBO.setPurNotExtendOrgIds(authUserRoleDataPowerQryRspBo.getPurNotExtendOrgIds());
                abilityReqBO.setSupExtendOrgIds(authUserRoleDataPowerQryRspBo.getSupExtendOrgIds());
                abilityReqBO.setSupNotExtendOrgIds(authUserRoleDataPowerQryRspBo.getSupNotExtendOrgIds());
            }
            if (authUserRoleDataPowerQryRspBo.getSeflFlag().booleanValue()) {
                abilityReqBO.setCreateOperId(reqBO.getUserId() + "");
            }
        }
    }

    private Map<Long, ReplacePriceInfoBO> getReplaceMap(DycUccSpuListExportAbilityReqBO reqBO, List<DycUccSkuListQryBO> skuListQryBOList) {
        if (UccConstants.Source.NOT_AGR.equals(reqBO.getSkuSource())) {
            List replacePriceInfoBOS = skuListQryBOList.stream().map(dycUccSkuListQryBO -> {
                ReplacePriceInfoBO replacePriceInfoBO = new ReplacePriceInfoBO();
                replacePriceInfoBO.setSalePrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)dycUccSkuListQryBO.getSalePrice())));
                replacePriceInfoBO.setAgreementPrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)dycUccSkuListQryBO.getAgreementPrice())));
                replacePriceInfoBO.setMarketPrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)dycUccSkuListQryBO.getMarketPrice())));
                replacePriceInfoBO.setSkuId(dycUccSkuListQryBO.getSkuId());
                replacePriceInfoBO.setCommodityId(dycUccSkuListQryBO.getCommodityId());
                replacePriceInfoBO.setLadderPrice(JSONObject.parseArray((String)JSON.toJSONString(dycUccSkuListQryBO.getLadderPriceInfo()), UccMallLadderPriceBo.class));
                return replacePriceInfoBO;
            }).collect(Collectors.toList());
            UccMallReplacementPriceReqBo uccMallReplacementPriceReqBo = new UccMallReplacementPriceReqBo();
            uccMallReplacementPriceReqBo.setIsprofess(reqBO.getIsprofess());
            uccMallReplacementPriceReqBo.setCompanyId(reqBO.getCompanyId());
            uccMallReplacementPriceReqBo.setReplacePriceInfo(replacePriceInfoBOS);
            UccMallReplacementPriceRspBo uccMallReplacementPriceRspBo = this.uccMallReplacementPriceAbilityService.replacePrice(uccMallReplacementPriceReqBo);
            if ("0000".equals(uccMallReplacementPriceRspBo.getRespCode())) {
                return uccMallReplacementPriceRspBo.getRows().stream().collect(Collectors.toMap(ReplacePriceInfoBO::getSkuId, Function.identity()));
            }
            return new HashMap<Long, ReplacePriceInfoBO>();
        }
        return new HashMap<Long, ReplacePriceInfoBO>();
    }
}

