/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.busicommon.commodity.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.common.ability.api.UccSpuListQryAbilityService;
import com.tydic.commodity.common.ability.bo.UccSpuListQryAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSpuListQryAbilityRspBO;
import com.tydic.dyc.authority.service.user.AuthUserRoleDataPowerQryService;
import com.tydic.dyc.authority.service.user.bo.AuthUserRoleDataPowerQryReqBo;
import com.tydic.dyc.authority.service.user.bo.AuthUserRoleDataPowerQryRspBo;
import com.tydic.dyc.busicommon.commodity.api.DycUccSpuListQryService;
import com.tydic.dyc.busicommon.commodity.bo.DycUccSpuListQryAbilityReqBO;
import com.tydic.dyc.busicommon.commodity.bo.DycUccSpuListQryAbilityRspBO;
import com.tydic.dyc.busicommon.commodity.bo.DycUccSpuListQryBO;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.busicommon.commodity.api.DycUccSpuListQryService"})
public class DycUccSpuListQryServiceImpl
implements DycUccSpuListQryService {
    private static final Logger log = LoggerFactory.getLogger(DycUccSpuListQryServiceImpl.class);
    @Autowired
    private UccSpuListQryAbilityService uccSpuListQryAbilityService;
    @Autowired
    private AuthUserRoleDataPowerQryService authUserRoleDataPowerQryService;

    @Override
    @PostMapping(value={"getSpuListQry"})
    public DycUccSpuListQryAbilityRspBO getSpuListQry(@RequestBody DycUccSpuListQryAbilityReqBO reqBO) {
        String strReq = JSONObject.toJSONString((Object)((Object)reqBO), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        UccSpuListQryAbilityReqBO abilityReqBO = (UccSpuListQryAbilityReqBO)JSONObject.parseObject((String)strReq, UccSpuListQryAbilityReqBO.class);
        this.setReqAuth(reqBO, strReq, abilityReqBO);
        UccSpuListQryAbilityRspBO abilityRspBO = this.uccSpuListQryAbilityService.getSpuListQry(abilityReqBO);
        DycUccSpuListQryAbilityRspBO rspBO = new DycUccSpuListQryAbilityRspBO();
        if ("0000".equals(abilityRspBO.getRespCode())) {
            String rspStr = JSONObject.toJSONString((Object)abilityRspBO);
            rspBO = (DycUccSpuListQryAbilityRspBO)((Object)JSONObject.parseObject((String)rspStr, DycUccSpuListQryAbilityRspBO.class));
            if (CollectionUtils.isNotEmpty(rspBO.getRows())) {
                int i = 1;
                for (DycUccSpuListQryBO each : rspBO.getRows()) {
                    each.setSerialNumber(i++);
                    if (null == each.getCommodityExpand()) continue;
                    each.setCommodityExpand4(each.getCommodityExpand().getExpand4());
                    each.setCommodityExpand6(each.getCommodityExpand().getExpand6());
                }
            }
        } else {
            throw new ZTBusinessException(abilityRspBO.getRespDesc());
        }
        return rspBO;
    }

    private void setReqSpuStatus(DycUccSpuListQryAbilityReqBO reqBO, UccSpuListQryAbilityReqBO abilityReqBO) {
    }

    private void setReqAuth(DycUccSpuListQryAbilityReqBO reqBO, String strReq, UccSpuListQryAbilityReqBO abilityReqBO) {
        AuthUserRoleDataPowerQryReqBo authUserRoleDataPowerQryReqBo = (AuthUserRoleDataPowerQryReqBo)JSONObject.parseObject((String)strReq, AuthUserRoleDataPowerQryReqBo.class);
        AuthUserRoleDataPowerQryRspBo authUserRoleDataPowerQryRspBo = this.authUserRoleDataPowerQryService.qryUserRoleDataPower(authUserRoleDataPowerQryReqBo);
        if (!"0000".equals(authUserRoleDataPowerQryRspBo.getRespCode())) {
            log.error(authUserRoleDataPowerQryRspBo.getRespDesc());
        } else {
            if (reqBO.getLoginTagIn().equals("0")) {
                abilityReqBO.setProExtendOrgIds(authUserRoleDataPowerQryRspBo.getProExtendOrgIds());
                abilityReqBO.setProNotExtendOrgIds(authUserRoleDataPowerQryRspBo.getProNotExtendOrgIds());
                abilityReqBO.setPurExtendOrgIds(authUserRoleDataPowerQryRspBo.getPurExtendOrgIds());
                abilityReqBO.setPurNotExtendOrgIds(authUserRoleDataPowerQryRspBo.getPurNotExtendOrgIds());
                abilityReqBO.setSupExtendOrgIds(authUserRoleDataPowerQryRspBo.getSupExtendOrgIds());
                abilityReqBO.setSupNotExtendOrgIds(authUserRoleDataPowerQryRspBo.getSupNotExtendOrgIds());
            }
            if (authUserRoleDataPowerQryRspBo.getSeflFlag().booleanValue()) {
                abilityReqBO.setCreateOperId(reqBO.getUserId() + "");
            }
        }
    }
}

