/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.busicommon.order.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.commodity.common.ability.api.UccDicDictionaryAbilityService;
import com.tydic.commodity.common.ability.bo.UccDictionaryAddReqBO;
import com.tydic.commodity.common.ability.bo.UccDictionaryAddRspBO;
import com.tydic.commodity.common.ability.bo.UccDictionaryDeleteReqBO;
import com.tydic.commodity.common.ability.bo.UccDictionaryDeleteRspBO;
import com.tydic.commodity.common.ability.bo.UccDictionaryReqBO;
import com.tydic.commodity.common.ability.bo.UccDictionaryRspBO;
import com.tydic.commodity.common.ability.bo.UccDictionaryUpdateReqBO;
import com.tydic.commodity.common.ability.bo.UccDictionaryUpdateRspBO;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.busicommon.order.api.DycComUocDictionaryOperateService;
import com.tydic.dyc.busicommon.order.bo.ComPesDictionaryCodeBO;
import com.tydic.dyc.busicommon.order.bo.DycComUocDicDataOperateReqBO;
import com.tydic.dyc.busicommon.order.bo.DycComUocDicDataOperateRspBO;
import com.tydic.dyc.busicommon.order.bo.DycComUocDicDataQueryReqBO;
import com.tydic.dyc.busicommon.order.bo.DycComUocDicDataQueryRspBO;
import com.tydic.dyc.busicommon.order.bo.DycComUocDictionaryRspDataBO;
import com.tydic.dyc.busicommon.order.bo.DycComUocRefreshCodeListRspBO;
import com.tydic.dyc.oc.service.domainservice.UocProDictionaryService;
import com.tydic.dyc.oc.service.domainservice.bo.UocProDictionaryCreateReqBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocProDictionaryCreateRspBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocProDictionaryDeleteReqBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocProDictionaryDeleteRspBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocProDictionaryReqBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocProDictionaryRspBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocProDictionaryUpdateReqBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocProDictionaryUpdateRspBO;
import com.tydic.dyc.smc.service.dictionary.api.SmcQryConfigKeysAndDataListService;
import com.tydic.dyc.smc.service.dictionary.bo.SmcQryConfigKeysAndDataListReqBo;
import com.tydic.dyc.smc.service.dictionary.bo.SmcQryConfigKeysAndDataListRspBo;
import com.tydic.dyc.umc.service.sysdictionary.UmcPesDicQryListByConfigKeysService;
import com.tydic.dyc.umc.service.sysdictionary.UmcQueryBypCodeBackPoService;
import com.tydic.dyc.umc.service.sysdictionary.bo.UmcPesDicConfigBo;
import com.tydic.dyc.umc.service.sysdictionary.bo.UmcQueryBypCodeBackPoReqBo;
import com.tydic.dyc.umc.service.sysdictionary.bo.UmcQueryBypCodeBackPoRspBo;
import com.tydic.fsc.base.FscRspPageBaseBO;
import com.tydic.fsc.bo.FscDicDictionaryReqBO;
import com.tydic.fsc.common.ability.api.FscDictionaryAbilityService;
import com.tydic.fsc.common.ability.bo.FscDictionaryAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscQueryDictionaryAbilityReqBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.busicommon.order.api.DycComUocDictionaryOperateService"})
public class DycComUocDictionaryOperateServiceImpl
implements DycComUocDictionaryOperateService {
    private static final Logger log = LoggerFactory.getLogger(DycComUocDictionaryOperateServiceImpl.class);
    public static final int DICTIONARY_KEY_EXPIRE = 3600;
    public static final String DICTIONARY_KEY_PREFIX = "PES_DIC_";
    public static final String RSP_CODE_SUCCESS = "0000";
    public static final String RSP_CODE_FAILURE = "9999";
    public static final String UOC_PRO_CODE = "UOC_PRO";
    public static final String UMC_CODE = "UMC_PLUS";
    public static final String UCC_CODE = "UCC";
    public static final String FSC_CODE = "FSC";
    public static final String AGR_CODE = "AGR";
    public static final String INC_CODE = "INC_PRO";
    public static final Integer QUERY = 0;
    public static final Integer INSERT = 1;
    public static final Integer UPDATE = 2;
    public static final Integer DELETE = 3;
    private static final Logger LOGGER = LoggerFactory.getLogger(DycComUocDictionaryOperateServiceImpl.class);
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    SmcQryConfigKeysAndDataListService smcQryConfigKeysAndDataListService;
    @Autowired
    private UmcPesDicQryListByConfigKeysService umcPesDicQryListByConfigKeysService;
    @Autowired
    private UccDicDictionaryAbilityService uccDicDictionaryAbilityService;
    @Autowired
    private FscDictionaryAbilityService fscDictionaryAbilityService;
    @Autowired
    private UmcQueryBypCodeBackPoService umcQueryBypCodeBackPoService;
    @Autowired
    private UocProDictionaryService uocProDictionaryService;
    private static Map<String, BiFunction<Integer, ComPesDictionaryCodeBO, List<ComPesDictionaryCodeBO>>> dicActionMap = Maps.newHashMapWithExpectedSize((int)4);

    public DycComUocDictionaryOperateServiceImpl() {
        dicActionMap.put(UMC_CODE, this::callUmcDicService);
        dicActionMap.put(UCC_CODE, this::callUccDicService);
        dicActionMap.put(FSC_CODE, this::callFscDicService);
        dicActionMap.put(UOC_PRO_CODE, this::callUocProDicService);
    }

    @Override
    @PostMapping(value={"queryCodeList"})
    public DycComUocDicDataQueryRspBO queryCodeList(@RequestBody DycComUocDicDataQueryReqBO reqBO) {
        DycComUocDicDataQueryRspBO rspBO = new DycComUocDicDataQueryRspBO();
        if (CollectionUtils.isEmpty(reqBO.getConfigKeys())) {
            rspBO.setRespCode(RSP_CODE_FAILURE);
            rspBO.setRespDesc("\u4f20\u5165[configKeys]\u4e3a\u7a7a");
            return rspBO;
        }
        SmcQryConfigKeysAndDataListReqBo smcReqBo = new SmcQryConfigKeysAndDataListReqBo();
        smcReqBo.setConfigKeys(reqBO.getConfigKeys());
        SmcQryConfigKeysAndDataListRspBo smcRspBo = this.smcQryConfigKeysAndDataListService.qryConfigKeysDataList(smcReqBo);
        ArrayList<DycComUocDictionaryRspDataBO> list = new ArrayList<DycComUocDictionaryRspDataBO>();
        smcRspBo.getSmcConfigKeyDictDataListBo().forEach(data -> {
            DycComUocDictionaryRspDataBO dycComUocDictionaryRspDataBO = new DycComUocDictionaryRspDataBO();
            dycComUocDictionaryRspDataBO.setConfigKey(data.getConfigKey());
            ArrayList<ComPesDictionaryCodeBO> rspList = new ArrayList<ComPesDictionaryCodeBO>();
            data.getSmcDictDataBoList().forEach(dict -> {
                ComPesDictionaryCodeBO comPesDictionaryCodeBO = new ComPesDictionaryCodeBO();
                comPesDictionaryCodeBO.setCode(dict.getCode());
                comPesDictionaryCodeBO.setPCode(dict.getPCode());
                comPesDictionaryCodeBO.setOrderId(dict.getSort());
                if (UOC_PRO_CODE.equals(dict.getBusiCenter())) {
                    comPesDictionaryCodeBO.setDescrip(dict.getValue());
                    comPesDictionaryCodeBO.setTitle(dict.getRemark());
                } else {
                    comPesDictionaryCodeBO.setDescrip(dict.getRemark());
                    comPesDictionaryCodeBO.setTitle(dict.getValue());
                }
                comPesDictionaryCodeBO.setDelflag(0);
                rspList.add(comPesDictionaryCodeBO);
            });
            dycComUocDictionaryRspDataBO.setCodeList(rspList);
            list.add(dycComUocDictionaryRspDataBO);
        });
        rspBO.setData(list);
        rspBO.setRespCode(RSP_CODE_SUCCESS);
        rspBO.setRespDesc("\u83b7\u53d6\u6570\u636e\u6210\u529f");
        return rspBO;
    }

    @Override
    @PostMapping(value={"dealCodeOperate"})
    public DycComUocDicDataOperateRspBO dealCodeOperate(@RequestBody DycComUocDicDataOperateReqBO reqBO) {
        if (reqBO.getOperateType() == null) {
            throw new ZTBusinessException("\u4f20\u5165[operateType]\u4e3a\u7a7a");
        }
        if (!(INSERT.equals(reqBO.getOperateType()) || UPDATE.equals(reqBO.getOperateType()) || DELETE.equals(reqBO.getOperateType()))) {
            throw new ZTBusinessException("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7c7b\u578b[operateType]");
        }
        if (StringUtils.isEmpty((Object)reqBO.getCenter())) {
            throw new ZTBusinessException("\u4f20\u5165[center]\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getConfigKey())) {
            throw new ZTBusinessException("\u4f20\u5165[configKey]\u4e3a\u7a7a");
        }
        if (dicActionMap.get(reqBO.getCenter()) == null) {
            throw new ZTBusinessException("\u4e0d\u652f\u6301\u8c03\u7528\u8be5\u4e2d\u5fc3\u5b57\u5178\u670d\u52a1\uff0ccenter=" + reqBO.getCenter());
        }
        ComPesDictionaryCodeBO dictionaryCode = reqBO.getDictionaryCode();
        if (StringUtils.isEmpty((Object)dictionaryCode.getCode()) || dictionaryCode.getCode().trim().length() < 1) {
            throw new ZTBusinessException("\u4f20\u5165\u7f16\u7801\u4e3a\u7a7a" + reqBO.getCenter());
        }
        if (StringUtils.isEmpty((Object)dictionaryCode.getTitle()) || dictionaryCode.getTitle().trim().length() < 1) {
            throw new ZTBusinessException("\u4f20\u5165\u5b57\u5178\u4e3a\u7a7a" + reqBO.getCenter());
        }
        List<ComPesDictionaryCodeBO> rspInfo = dicActionMap.get(reqBO.getCenter()).apply(reqBO.getOperateType(), dictionaryCode);
        DycComUocDicDataOperateRspBO rspBO = new DycComUocDicDataOperateRspBO();
        rspBO.setRespCode(rspInfo.get(0).getRespCode());
        rspBO.setRespDesc(rspInfo.get(0).getRespDesc());
        if (RSP_CODE_SUCCESS.equals(rspBO.getRespCode())) {
            DycComUocDicDataQueryReqBO refreshReqBO = new DycComUocDicDataQueryReqBO();
            refreshReqBO.setConfigKeys(Collections.singletonList(reqBO.getConfigKey()));
            this.refreshCodeList(refreshReqBO);
        }
        return rspBO;
    }

    @Override
    @PostMapping(value={"refreshCodeList"})
    public DycComUocRefreshCodeListRspBO refreshCodeList(@RequestBody DycComUocDicDataQueryReqBO reqBO) {
        DycComUocRefreshCodeListRspBO rspBO = new DycComUocRefreshCodeListRspBO();
        if (CollectionUtils.isEmpty(reqBO.getConfigKeys())) {
            LOGGER.error("\u4f20\u5165[configKeys]\u4e3a\u7a7a");
            rspBO.setRespCode(RSP_CODE_SUCCESS);
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        reqBO.getConfigKeys().forEach(config -> this.cacheClient.delete(DICTIONARY_KEY_PREFIX + config));
        this.queryCodeList(reqBO);
        rspBO.setRespCode(RSP_CODE_SUCCESS);
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private List<String> cacheDataProcess(List<String> configKeys, Map<String, List<ComPesDictionaryCodeBO>> rspData) {
        ArrayList notExistsKeys = Lists.newArrayListWithExpectedSize((int)configKeys.size());
        for (String configKey : configKeys) {
            notExistsKeys.add(configKey);
        }
        return notExistsKeys;
    }

    private void dicDataProcess(List<String> configKeys, Map<String, UmcPesDicConfigBo> dicMap, Map<String, List<ComPesDictionaryCodeBO>> rspData) {
        for (String configKey : configKeys) {
            if (dicMap.get(configKey) == null) {
                rspData.put(configKey, Lists.newArrayList());
                LOGGER.error("\u672a\u83b7\u53d6\u5230\u5b57\u5178\u914d\u7f6e\uff0cconfigKey=" + configKey);
                continue;
            }
            UmcPesDicConfigBo dicInfo = dicMap.get(configKey);
            if (dicActionMap.get(dicInfo.getCenter()) == null) {
                rspData.put(configKey, Lists.newArrayList());
                LOGGER.error("\u4e0d\u652f\u6301\u8c03\u7528\u8be5\u4e2d\u5fc3\u5b57\u5178\u670d\u52a1\uff0ccenter=" + dicInfo.getCenter());
                continue;
            }
            ComPesDictionaryCodeBO param = new ComPesDictionaryCodeBO();
            param.setPCode(dicInfo.getPCode());
            List<ComPesDictionaryCodeBO> dicList = dicActionMap.get(dicInfo.getCenter()).apply(QUERY, param);
            log.info("dicList--------------------->:{}", (Object)JSON.toJSONString(dicList));
            rspData.put(configKey, dicList);
            if (!CollectionUtils.isEmpty(dicList)) continue;
            LOGGER.info("{}\u5b57\u5178\u670d\u52a1\u672a\u8fd4\u56de\u5b57\u5178\u6570\u636e\uff0cpCode={}", (Object)dicInfo.getCenter(), (Object)dicInfo.getPCode());
        }
    }

    public static int getExpireSeconds(int radix, int range) {
        return radix * (new Random().nextInt(range) + 1);
    }

    private List<ComPesDictionaryCodeBO> callUocProDicService(Integer operateType, ComPesDictionaryCodeBO dictionaryCode) {
        ComPesDictionaryCodeBO rspBO = new ComPesDictionaryCodeBO();
        if (QUERY.equals(operateType)) {
            UocProDictionaryReqBO reqBO = new UocProDictionaryReqBO();
            reqBO.setPCode(dictionaryCode.getPCode());
            UocProDictionaryRspBO qryRspBO = this.uocProDictionaryService.qryDic(reqBO);
            List rspList = qryRspBO.getRows();
            return CollectionUtils.isEmpty((Collection)rspList) ? Lists.newArrayList() : JUtil.jsl((List)rspList, ComPesDictionaryCodeBO.class);
        }
        if (INSERT.equals(operateType)) {
            UocProDictionaryCreateReqBO reqBO = new UocProDictionaryCreateReqBO();
            BeanUtils.copyProperties((Object)((Object)dictionaryCode), (Object)reqBO);
            reqBO.setPCode(dictionaryCode.getPCode());
            UocProDictionaryCreateRspBO addRspBO = this.uocProDictionaryService.createDic(reqBO);
            rspBO.setRespCode(addRspBO.getRespCode());
            rspBO.setRespDesc(addRspBO.getRespDesc());
        } else if (UPDATE.equals(operateType)) {
            UocProDictionaryUpdateReqBO reqBO = new UocProDictionaryUpdateReqBO();
            BeanUtils.copyProperties((Object)((Object)dictionaryCode), (Object)reqBO);
            reqBO.setPCode(dictionaryCode.getPCode());
            UocProDictionaryUpdateRspBO updateRspBO = this.uocProDictionaryService.updateDic(reqBO);
            rspBO.setRespCode(updateRspBO.getRespCode());
            rspBO.setRespDesc(updateRspBO.getRespDesc());
        } else {
            UocProDictionaryDeleteReqBO reqBO = new UocProDictionaryDeleteReqBO();
            reqBO.setPCode(dictionaryCode.getPCode());
            reqBO.setCode(dictionaryCode.getCode());
            UocProDictionaryDeleteRspBO delRspBO = this.uocProDictionaryService.deleteDic(reqBO);
            rspBO.setRespCode(delRspBO.getRespCode());
            rspBO.setRespDesc(delRspBO.getRespDesc());
        }
        return Collections.singletonList(rspBO);
    }

    private List<ComPesDictionaryCodeBO> callUmcDicService(Integer operateType, ComPesDictionaryCodeBO dictionaryCode) {
        ComPesDictionaryCodeBO rspBO = new ComPesDictionaryCodeBO();
        if (QUERY.equals(operateType)) {
            UmcQueryBypCodeBackPoReqBo umcQueryBypCodeBackPoReqBo = new UmcQueryBypCodeBackPoReqBo();
            umcQueryBypCodeBackPoReqBo.setPCode(dictionaryCode.getPCode());
            UmcQueryBypCodeBackPoRspBo umcQueryBypCodeBackPoRspBo = this.umcQueryBypCodeBackPoService.queryBypCodeBackPo(umcQueryBypCodeBackPoReqBo);
            return CollectionUtils.isEmpty((Collection)umcQueryBypCodeBackPoRspBo.getData()) ? Lists.newArrayList() : JUtil.jsl((List)umcQueryBypCodeBackPoRspBo.getData(), ComPesDictionaryCodeBO.class);
        }
        return Collections.singletonList(rspBO);
    }

    private List<ComPesDictionaryCodeBO> callUccDicService(Integer operateType, ComPesDictionaryCodeBO dictionaryCode) {
        ComPesDictionaryCodeBO rspBO = new ComPesDictionaryCodeBO();
        if (QUERY.equals(operateType)) {
            UccDictionaryReqBO uccDictionaryReqBO = new UccDictionaryReqBO();
            uccDictionaryReqBO.setPCode(dictionaryCode.getPCode());
            uccDictionaryReqBO.setPtypeCode(dictionaryCode.getPCode());
            UccDictionaryRspBO uccDictionaryRspBO = this.uccDicDictionaryAbilityService.queryDictionary(uccDictionaryReqBO);
            return CollectionUtils.isEmpty((Collection)uccDictionaryRspBO.getRows()) ? Lists.newArrayList() : JUtil.jsl((List)uccDictionaryRspBO.getRows(), ComPesDictionaryCodeBO.class);
        }
        if (INSERT.equals(operateType)) {
            UccDictionaryAddReqBO uccDictionaryAddReqBO = new UccDictionaryAddReqBO();
            BeanUtils.copyProperties((Object)((Object)dictionaryCode), (Object)uccDictionaryAddReqBO);
            uccDictionaryAddReqBO.setPtypeCode(dictionaryCode.getPCode());
            UccDictionaryAddRspBO uccDictionaryAddRspBO = this.uccDicDictionaryAbilityService.insertDictionary(uccDictionaryAddReqBO);
            rspBO.setRespCode(uccDictionaryAddRspBO.getRespCode());
            rspBO.setRespDesc(uccDictionaryAddRspBO.getRespDesc());
        } else if (UPDATE.equals(operateType)) {
            UccDictionaryUpdateReqBO uccDictionaryUpdateReqBO = new UccDictionaryUpdateReqBO();
            BeanUtils.copyProperties((Object)((Object)dictionaryCode), (Object)uccDictionaryUpdateReqBO);
            uccDictionaryUpdateReqBO.setPtypeCode(dictionaryCode.getPCode());
            UccDictionaryUpdateRspBO uccDictionaryUpdateRspBO = this.uccDicDictionaryAbilityService.updateDictionary(uccDictionaryUpdateReqBO);
            rspBO.setRespCode(uccDictionaryUpdateRspBO.getRespCode());
            rspBO.setRespDesc(uccDictionaryUpdateRspBO.getRespDesc());
        } else {
            UccDictionaryDeleteReqBO uccDictionaryDeleteReqBO = new UccDictionaryDeleteReqBO();
            uccDictionaryDeleteReqBO.setPtypeCode(dictionaryCode.getPCode());
            uccDictionaryDeleteReqBO.setCode(dictionaryCode.getCode());
            UccDictionaryDeleteRspBO uccDictionaryDeleteRspBO = this.uccDicDictionaryAbilityService.deleteDictionary(uccDictionaryDeleteReqBO);
            rspBO.setRespCode(uccDictionaryDeleteRspBO.getRespCode());
            rspBO.setRespDesc(uccDictionaryDeleteRspBO.getRespDesc());
        }
        return Collections.singletonList(rspBO);
    }

    private List<ComPesDictionaryCodeBO> callFscDicService(Integer operateType, ComPesDictionaryCodeBO dictionaryCode) {
        ComPesDictionaryCodeBO rspBO = new ComPesDictionaryCodeBO();
        if (QUERY.equals(operateType)) {
            FscQueryDictionaryAbilityReqBO fscQueryDictionaryAbilityReqBO = new FscQueryDictionaryAbilityReqBO();
            fscQueryDictionaryAbilityReqBO.setPcode(dictionaryCode.getPCode());
            FscRspPageBaseBO fscDicDictionaryBOFscRspPageBaseBO = this.fscDictionaryAbilityService.queryBypCodeBackPo(fscQueryDictionaryAbilityReqBO);
            return CollectionUtils.isEmpty((Collection)fscDicDictionaryBOFscRspPageBaseBO.getRows()) ? Lists.newArrayList() : JUtil.jsl((List)fscDicDictionaryBOFscRspPageBaseBO.getRows(), ComPesDictionaryCodeBO.class);
        }
        if (INSERT.equals(operateType)) {
            FscDicDictionaryReqBO fscDicDictionaryReqBO = new FscDicDictionaryReqBO();
            BeanUtils.copyProperties((Object)((Object)dictionaryCode), (Object)fscDicDictionaryReqBO);
            FscDictionaryAbilityRspBO fscDictionaryAbilityRspBO = this.fscDictionaryAbilityService.addDicDictionary(fscDicDictionaryReqBO);
            rspBO.setRespCode(fscDictionaryAbilityRspBO.getRespCode());
            rspBO.setRespDesc(fscDictionaryAbilityRspBO.getRespDesc());
        } else if (UPDATE.equals(operateType)) {
            FscDicDictionaryReqBO fscDicDictionaryReqBO = new FscDicDictionaryReqBO();
            BeanUtils.copyProperties((Object)((Object)dictionaryCode), (Object)fscDicDictionaryReqBO);
            FscDictionaryAbilityRspBO fscDictionaryAbilityRspBO = this.fscDictionaryAbilityService.updateDicDictionary(fscDicDictionaryReqBO);
            rspBO.setRespCode(fscDictionaryAbilityRspBO.getRespCode());
            rspBO.setRespDesc(fscDictionaryAbilityRspBO.getRespDesc());
        } else {
            FscDicDictionaryReqBO fscDicDictionaryReqBO = new FscDicDictionaryReqBO();
            fscDicDictionaryReqBO.setPCode(dictionaryCode.getPCode());
            fscDicDictionaryReqBO.setCode(dictionaryCode.getCode());
            FscDictionaryAbilityRspBO fscDictionaryAbilityRspBO = this.fscDictionaryAbilityService.deleteDicDictionary(fscDicDictionaryReqBO);
            rspBO.setRespCode(fscDictionaryAbilityRspBO.getRespCode());
            rspBO.setRespDesc(fscDictionaryAbilityRspBO.getRespDesc());
        }
        return Collections.singletonList(rspBO);
    }
}

