/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.busicommon.ucc.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.common.ability.api.UccSkuListQryAbilityService;
import com.tydic.commodity.common.ability.bo.UccSkuListQryAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSkuListQryAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccSkuManagementListQryBO;
import com.tydic.commodity.mall.ability.api.UccMallReplacementPriceAbilityService;
import com.tydic.commodity.mall.ability.bo.ReplacePriceInfoBO;
import com.tydic.commodity.mall.ability.bo.UccMallLadderPriceBo;
import com.tydic.commodity.mall.ability.bo.UccMallReplacementPriceReqBo;
import com.tydic.commodity.mall.ability.bo.UccMallReplacementPriceRspBo;
import com.tydic.dyc.agr.service.agr.AgrGetAgrMainListService;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrMainListReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrMainListRspBO;
import com.tydic.dyc.agr.service.agr.bo.AgrMainListBo;
import com.tydic.dyc.authority.service.user.AuthUserRoleDataPowerQryService;
import com.tydic.dyc.authority.service.user.bo.AuthUserRoleDataPowerQryReqBo;
import com.tydic.dyc.authority.service.user.bo.AuthUserRoleDataPowerQryRspBo;
import com.tydic.dyc.base.constants.MoneyUtils;
import com.tydic.dyc.busicommon.ucc.api.DycUccSkuListQryService;
import com.tydic.dyc.busicommon.ucc.bo.DycUccSkuListQryBO;
import com.tydic.dyc.busicommon.ucc.bo.DycUccSkuListQryReqBO;
import com.tydic.dyc.busicommon.ucc.bo.DycUccSkuListQryRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.busicommon.ucc.api.DycUccSkuListQryService"})
public class DycUccSkuListQryServiceImpl
implements DycUccSkuListQryService {
    private static final Logger log = LoggerFactory.getLogger(DycUccSkuListQryServiceImpl.class);
    @Autowired
    private UccSkuListQryAbilityService uccSkuListQryAbilityService;
    @Autowired
    private AuthUserRoleDataPowerQryService authUserRoleDataPowerQryService;
    @Autowired
    private UccMallReplacementPriceAbilityService uccMallReplacementPriceAbilityService;
    @Autowired
    private AgrGetAgrMainListService agrGetAgrMainListService;

    @Override
    @PostMapping(value={"getSkuListQry"})
    public DycUccSkuListQryRspBO getSkuListQry(@RequestBody DycUccSkuListQryReqBO reqBO) {
        String strReq = JSONObject.toJSONString((Object)((Object)reqBO), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        UccSkuListQryAbilityReqBO abilityReqBO = (UccSkuListQryAbilityReqBO)JSONObject.parseObject((String)strReq, UccSkuListQryAbilityReqBO.class);
        this.setReqAuth(reqBO, strReq, abilityReqBO);
        UccSkuListQryAbilityRspBO abilityRspBO = this.uccSkuListQryAbilityService.getSkuListQry(abilityReqBO);
        DycUccSkuListQryRspBO rspBO = new DycUccSkuListQryRspBO();
        if ("0000".equals(abilityRspBO.getRespCode())) {
            String rspStr = JSONObject.toJSONString((Object)abilityRspBO);
            rspBO = (DycUccSkuListQryRspBO)((Object)JSONObject.parseObject((String)rspStr, DycUccSkuListQryRspBO.class));
            if (UccConstants.IsQryNoPicSku.CODE.equals(reqBO.getIsQryNoPicSku()) || UccConstants.IsQryNoPicSku.NO_PIC.equals(reqBO.getIsQryNoPicSku())) {
                return rspBO;
            }
            if (!CollectionUtils.isEmpty((Collection)abilityRspBO.getRows())) {
                List result = JSONObject.parseArray((String)JSONObject.toJSONString((Object)abilityRspBO.getRows()), UccSkuManagementListQryBO.class);
                Map mapList = result.stream().collect(Collectors.toMap(UccSkuManagementListQryBO::getSkuId, Function.identity()));
                Map<Long, ReplacePriceInfoBO> replaceMap = this.getReplaceMap(reqBO, rspBO);
                ArrayList<Long> agrIds = new ArrayList<Long>();
                for (DycUccSkuListQryBO row : rspBO.getRows()) {
                    if (null == row.getAgreementId()) continue;
                    agrIds.add(row.getAgreementId());
                }
                ConcurrentMap<Object, Object> agrMap = new ConcurrentHashMap();
                if (!CollectionUtils.isEmpty(agrIds)) {
                    AgrGetAgrMainListReqBO agrGetAgrMainListReqBO = new AgrGetAgrMainListReqBO();
                    agrGetAgrMainListReqBO.setAgrIds(agrIds.stream().distinct().collect(Collectors.toList()));
                    AgrGetAgrMainListRspBO agrGetAgrMainListRspBO = this.agrGetAgrMainListService.getAgrMainList(agrGetAgrMainListReqBO);
                    if (!CollectionUtils.isEmpty((Collection)agrGetAgrMainListRspBO.getRows())) {
                        agrMap = agrGetAgrMainListRspBO.getRows().stream().collect(Collectors.toConcurrentMap(AgrMainListBo::getAgrId, AgrMainListBo::getAgrMode));
                    }
                }
                for (DycUccSkuListQryBO each : rspBO.getRows()) {
                    ReplacePriceInfoBO replacePriceInfoBO;
                    if (UccConstants.Source.NOT_AGR.equals(reqBO.getSkuSource()) && null != (replacePriceInfoBO = replaceMap.get(each.getSkuId()))) {
                        each.setSalePrice(MoneyUtils.haoToYuan((Long)replacePriceInfoBO.getSalePrice()));
                    }
                    if (null != each.getAgreementId()) {
                        each.setAgrMode((Integer)agrMap.get(each.getAgreementId()));
                    }
                    if (null != each.getSkuExpand()) {
                        each.setSkuExpand4(each.getSkuExpand().getExpand4());
                    }
                    if (null == each.getCommodityExpand()) continue;
                    each.setCommodityExpand4(each.getCommodityExpand().getExpand4());
                    each.setCommodityExpand6(each.getCommodityExpand().getExpand6());
                }
            }
        } else {
            throw new ZTBusinessException(abilityRspBO.getRespDesc());
        }
        return rspBO;
    }

    private Map<Long, ReplacePriceInfoBO> getReplaceMap(DycUccSkuListQryReqBO reqBO, DycUccSkuListQryRspBO rspBO) {
        if (UccConstants.Source.NOT_AGR.equals(reqBO.getSkuSource())) {
            List replacePriceInfoBOS = rspBO.getRows().stream().map(dycUccSkuListQryBO -> {
                ReplacePriceInfoBO replacePriceInfoBO = new ReplacePriceInfoBO();
                replacePriceInfoBO.setSalePrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)dycUccSkuListQryBO.getSalePrice())));
                replacePriceInfoBO.setAgreementPrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)dycUccSkuListQryBO.getAgreementPrice())));
                replacePriceInfoBO.setMarketPrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)dycUccSkuListQryBO.getMarketPrice())));
                replacePriceInfoBO.setSkuId(dycUccSkuListQryBO.getSkuId());
                replacePriceInfoBO.setCommodityId(dycUccSkuListQryBO.getCommodityId());
                replacePriceInfoBO.setLadderPrice(JSONObject.parseArray((String)JSON.toJSONString(dycUccSkuListQryBO.getLadderPriceInfo()), UccMallLadderPriceBo.class));
                return replacePriceInfoBO;
            }).collect(Collectors.toList());
            UccMallReplacementPriceReqBo uccMallReplacementPriceReqBo = new UccMallReplacementPriceReqBo();
            uccMallReplacementPriceReqBo.setIsprofess(reqBO.getIsprofess());
            uccMallReplacementPriceReqBo.setCompanyId(reqBO.getCompanyId());
            uccMallReplacementPriceReqBo.setUserTypeIn(reqBO.getUserTypeIn());
            uccMallReplacementPriceReqBo.setReplacePriceInfo(replacePriceInfoBOS);
            UccMallReplacementPriceRspBo uccMallReplacementPriceRspBo = this.uccMallReplacementPriceAbilityService.replacePrice(uccMallReplacementPriceReqBo);
            if ("0000".equals(uccMallReplacementPriceRspBo.getRespCode())) {
                return uccMallReplacementPriceRspBo.getRows().stream().collect(Collectors.toMap(ReplacePriceInfoBO::getSkuId, Function.identity()));
            }
            return new HashMap<Long, ReplacePriceInfoBO>();
        }
        return new HashMap<Long, ReplacePriceInfoBO>();
    }

    private void setReqAuth(DycUccSkuListQryReqBO reqBO, String strReq, UccSkuListQryAbilityReqBO abilityReqBO) {
        AuthUserRoleDataPowerQryReqBo authUserRoleDataPowerQryReqBo = (AuthUserRoleDataPowerQryReqBo)JSONObject.parseObject((String)strReq, AuthUserRoleDataPowerQryReqBo.class);
        AuthUserRoleDataPowerQryRspBo authUserRoleDataPowerQryRspBo = this.authUserRoleDataPowerQryService.qryUserRoleDataPower(authUserRoleDataPowerQryReqBo);
        if (!"0000".equals(authUserRoleDataPowerQryRspBo.getRespCode())) {
            log.error(authUserRoleDataPowerQryRspBo.getRespDesc());
        } else {
            if (reqBO.getLoginTagIn().equals("0")) {
                abilityReqBO.setProExtendOrgIds(authUserRoleDataPowerQryRspBo.getProExtendOrgIds());
                abilityReqBO.setProNotExtendOrgIds(authUserRoleDataPowerQryRspBo.getProNotExtendOrgIds());
                abilityReqBO.setPurExtendOrgIds(authUserRoleDataPowerQryRspBo.getPurExtendOrgIds());
                abilityReqBO.setPurNotExtendOrgIds(authUserRoleDataPowerQryRspBo.getPurNotExtendOrgIds());
                abilityReqBO.setSupExtendOrgIds(authUserRoleDataPowerQryRspBo.getSupExtendOrgIds());
                abilityReqBO.setSupNotExtendOrgIds(authUserRoleDataPowerQryRspBo.getSupNotExtendOrgIds());
            }
            if (authUserRoleDataPowerQryRspBo.getSeflFlag().booleanValue()) {
                abilityReqBO.setCreateOperId(reqBO.getUserId() + "");
            }
        }
    }
}

