/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.busicommon.user.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.dyc.authority.service.domainservice.bo.AuthDistributeBo;
import com.tydic.dyc.authority.service.role.AuthRoleListQryService;
import com.tydic.dyc.authority.service.role.bo.AuthRoleListQryReqBo;
import com.tydic.dyc.authority.service.role.bo.AuthRoleListQryRspBo;
import com.tydic.dyc.authority.service.user.bo.AuthCustInfoBo;
import com.tydic.dyc.authority.service.user.bo.AuthUserInfoBo;
import com.tydic.dyc.authority.service.user.bo.AuthUserTagRelBo;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.base.utils.PasswordUtils;
import com.tydic.dyc.base.utils.SaltUtils;
import com.tydic.dyc.busicommon.user.api.DycCustInfoSyncTaskService;
import com.tydic.dyc.busicommon.user.bo.DycCustInfoSyncTaskServiceReqBo;
import com.tydic.dyc.busicommon.user.bo.DycCustInfoSyncTaskServiceRspBo;
import com.tydic.dyc.busicommon.user.bo.DycUmcUserSyncRoleBo;
import com.tydic.dyc.umc.constants.UmcStatusConstant;
import com.tydic.dyc.umc.service.user.UmcCustInfoSyncTempDeleteService;
import com.tydic.dyc.umc.service.user.UmcCustInfoSyncTempListQryService;
import com.tydic.dyc.umc.service.user.UmcCustInfoSyncTempUpdateService;
import com.tydic.dyc.umc.service.user.UmcSyncUserInfoService;
import com.tydic.dyc.umc.service.user.bo.UmcCustInfoSynBo;
import com.tydic.dyc.umc.service.user.bo.UmcCustInfoSyncTempDeleteServiceReqBo;
import com.tydic.dyc.umc.service.user.bo.UmcCustInfoSyncTempListQryServiceReqBo;
import com.tydic.dyc.umc.service.user.bo.UmcCustInfoSyncTempListQryServiceRspBo;
import com.tydic.dyc.umc.service.user.bo.UmcCustInfoSyncTempUpdateServiceReqBo;
import com.tydic.dyc.umc.service.user.bo.UmcRoleBo;
import com.tydic.dyc.umc.service.user.bo.UmcSyncUserInfoReqBo;
import com.tydic.dyc.umc.service.user.bo.UmcSyncUserInfoRspBo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.busicommon.user.api.DycCustInfoSyncTaskService"})
public class DycCustInfoSyncTaskServiceImpl
implements DycCustInfoSyncTaskService {
    private static final Logger log = LoggerFactory.getLogger(DycCustInfoSyncTaskServiceImpl.class);
    private final Object $lock = new Object[0];
    @Autowired
    private UmcCustInfoSyncTempListQryService umcCustInfoSyncTempListQryService;
    @Autowired
    private UmcCustInfoSyncTempUpdateService umcCustInfoSyncTempUpdateService;
    @Autowired
    private AuthRoleListQryService authRoleListQryService;
    @Autowired
    private UmcSyncUserInfoService umcSyncUserInfoService;
    @Autowired
    private UmcCustInfoSyncTempDeleteService umcCustInfoSyncTempDeleteService;
    @Value(value="${syncCust.increment:100}")
    private int increment;
    @Value(value="${syncCust.foreach.count:1000}")
    private int total;
    @Autowired
    private PasswordUtils passwordUtils;
    public static final Integer UPDATE_BY_ID = 1;
    public static final Integer UPDATE_BY_STATE = 2;
    @Autowired
    private CacheClient cacheClient;
    private static final String SYNC_CUST_INFO_KEY = "SYNC_CUST_INFO_KEY";
    private static final String SYNC_CUST_INFO_KEY_THREAD_COUNT = "SYNC_CUST_INFO_KEY_THREAD_COUNT";
    private static final String SYNC_CUST_INFO_KEY_SUP = "SYNC_CUST_INFO_KEY_SUP";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PostMapping(value={"syncCustInfoTask"})
    public DycCustInfoSyncTaskServiceRspBo syncCustInfoTask(@RequestBody DycCustInfoSyncTaskServiceReqBo reqBo) {
        int threadCount;
        DycCustInfoSyncTaskServiceRspBo dycCustInfoSyncTaskServiceRspBo = new DycCustInfoSyncTaskServiceRspBo();
        Long setnxThreadCountResult = this.cacheClient.setnx(SYNC_CUST_INFO_KEY_THREAD_COUNT, (Object)reqBo.getSHARDING_SHARDNUM());
        if (setnxThreadCountResult < 1L && (threadCount = Integer.parseInt(this.cacheClient.get(SYNC_CUST_INFO_KEY_THREAD_COUNT).toString())) != reqBo.getSHARDING_SHARDNUM()) {
            dycCustInfoSyncTaskServiceRspBo.setMessage("\u4e0a\u6b21\u53d1\u8d77\u7684\u4efb\u52a1\u672a\u5904\u7406\u5b8c\u6210\uff0c\u8bf7\u7a0d\u540e\u53d1\u8d77");
            return dycCustInfoSyncTaskServiceRspBo;
        }
        Long setnxThreadNumResult = this.cacheClient.setnx(SYNC_CUST_INFO_KEY + reqBo.getSHARDING_PARAMETER(), (Object)reqBo.getSHARDING_PARAMETER());
        if (setnxThreadNumResult < 1L) {
            dycCustInfoSyncTaskServiceRspBo.setMessage("\u5206\u7247" + reqBo.getSHARDING_PARAMETER() + "\u6b63\u5728\u5904\u7406\uff0c\u8bf7\u52ff\u91cd\u590d\u53d1\u8d77");
            return dycCustInfoSyncTaskServiceRspBo;
        }
        try {
            for (int i = 1; i <= this.total; ++i) {
                UmcCustInfoSyncTempListQryServiceRspBo umcCustInfoSyncTempListQryServiceRsp = this.getUmcCustInfoSyncTempListQryServiceRspBo(reqBo, 1);
                if (CollectionUtils.isEmpty((Collection)umcCustInfoSyncTempListQryServiceRsp.getRows())) {
                    log.debug("\u65e0\u5f85\u5904\u7406\u6570\u636e");
                    break;
                }
                this.deal(umcCustInfoSyncTempListQryServiceRsp.getRows());
            }
            this.updateTempDataToNotDeal();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            log.debug("\u7528\u6237\u540c\u6b65\u5b9a\u65f6\u4efb\u52a1\u5206\u7247" + reqBo.getSHARDING_PARAMETER() + "\u5904\u7406\u5b8c\u6210");
            this.dealRedisValue(reqBo);
            log.info("\u7528\u6237\u5b9a\u65f6\u4efb\u52a1\u5206\u7247\u6267\u884c\u5b8c\u6210" + reqBo.getSHARDING_PARAMETER() + "\u7f13\u5b58keys {}", (Object)this.cacheClient.getkeys("SYNC_CUST_INFO_KEY*"));
        }
        return dycCustInfoSyncTaskServiceRspBo;
    }

    private void deal(List<UmcCustInfoSynBo> rows) {
        ArrayList authIdentityList = new ArrayList();
        for (UmcCustInfoSynBo row : rows) {
            List umcUserSyncRoleBos;
            if (StringUtils.isBlank((CharSequence)row.getRoleJson()) || CollectionUtils.isEmpty((Collection)(umcUserSyncRoleBos = JSON.parseArray((String)row.getRoleJson(), DycUmcUserSyncRoleBo.class)))) continue;
            authIdentityList.addAll(umcUserSyncRoleBos.stream().map(DycUmcUserSyncRoleBo::getRoleCode).collect(Collectors.toList()));
        }
        List umcRoleBos = null;
        if (!CollectionUtils.isEmpty(authIdentityList)) {
            AuthRoleListQryReqBo authRoleListQryReqBo = new AuthRoleListQryReqBo();
            authRoleListQryReqBo.setAuthIdentityList(authIdentityList);
            AuthRoleListQryRspBo authRoleListQryRspBo = this.authRoleListQryService.getRoleList(authRoleListQryReqBo);
            if (!CollectionUtils.isEmpty((Collection)authRoleListQryRspBo.getAuthRoleInfoBoList())) {
                umcRoleBos = JUtil.jsl((List)authRoleListQryRspBo.getAuthRoleInfoBoList(), UmcRoleBo.class);
            }
        }
        this.updateTempDataState(rows, UmcStatusConstant.SyncDealResult.DEALING);
        UmcSyncUserInfoReqBo umcSyncUserInfoReqBo = new UmcSyncUserInfoReqBo();
        umcSyncUserInfoReqBo.setUmcRoleBos(umcRoleBos);
        umcSyncUserInfoReqBo.setUmcCustInfoSynBos(rows);
        UmcSyncUserInfoRspBo umcSyncUserInfoRspBo = this.umcSyncUserInfoService.syncUserInfo(umcSyncUserInfoReqBo);
        if (!"0000".equals(umcSyncUserInfoRspBo.getRespCode())) {
            this.updateTempDataState(rows, UmcStatusConstant.SyncDealResult.FILER);
        } else if (!(CollectionUtils.isEmpty((Collection)umcSyncUserInfoRspBo.getDeleteUserInfo()) && CollectionUtils.isEmpty((Collection)umcSyncUserInfoRspBo.getAddUserInfoBos()) && CollectionUtils.isEmpty((Collection)umcSyncUserInfoRspBo.getUpdateUserInfoBos()) || CollectionUtils.isEmpty((Collection)umcSyncUserInfoRspBo.getSuccessSynBos()))) {
            log.debug("umcSyncUserInfoRspBo:{}", (Object)JSON.toJSONString((Object)umcSyncUserInfoRspBo));
            UmcCustInfoSyncTempDeleteServiceReqBo umcCustInfoSyncTempDeleteServiceReqBo = new UmcCustInfoSyncTempDeleteServiceReqBo();
            umcCustInfoSyncTempDeleteServiceReqBo.setTempIds(umcSyncUserInfoRspBo.getSuccessSynBos().stream().map(UmcCustInfoSynBo::getId).collect(Collectors.toList()));
            this.umcCustInfoSyncTempDeleteService.deleteCustInfoTemp(umcCustInfoSyncTempDeleteServiceReqBo);
        }
    }

    private void setAuthUserRole(UmcSyncUserInfoRspBo umcSyncUserInfoRspBo, List<AuthDistributeBo> authDistributeBos) {
        if (!CollectionUtils.isEmpty((Collection)umcSyncUserInfoRspBo.getAddAuthDistributeBos())) {
            umcSyncUserInfoRspBo.getAddAuthDistributeBos().forEach(umcUserRoleRelBo -> {
                AuthDistributeBo authUserTagRelBo = (AuthDistributeBo)JUtil.js((Object)umcUserRoleRelBo, AuthDistributeBo.class);
                authUserTagRelBo.setDealType(Integer.valueOf(1));
                authDistributeBos.add(authUserTagRelBo);
            });
        }
    }

    private void setAuthUserTag(UmcSyncUserInfoRspBo umcSyncUserInfoRspBo, List<AuthUserTagRelBo> authUserTagRelBos) {
        if (!CollectionUtils.isEmpty((Collection)umcSyncUserInfoRspBo.getAddUserTagRelBos())) {
            umcSyncUserInfoRspBo.getAddUserTagRelBos().forEach(umcUserTagRelBo -> {
                AuthUserTagRelBo authUserTagRelBo = (AuthUserTagRelBo)JUtil.js((Object)umcUserTagRelBo, AuthUserTagRelBo.class);
                authUserTagRelBo.setDealType(Integer.valueOf(1));
                authUserTagRelBos.add(authUserTagRelBo);
            });
        }
    }

    private void setAuthUserInfo(UmcSyncUserInfoRspBo umcSyncUserInfoRspBo, List<AuthUserInfoBo> authUserInfoBos) {
        if (!CollectionUtils.isEmpty((Collection)umcSyncUserInfoRspBo.getAddUserInfoBos())) {
            umcSyncUserInfoRspBo.getAddUserInfoBos().forEach(umcUserInfoBo -> {
                AuthUserInfoBo authUserInfoBo = new AuthUserInfoBo();
                authUserInfoBo.setDealType(Integer.valueOf(1));
                authUserInfoBo.setCustId(umcUserInfoBo.getCustId());
                authUserInfoBo.setUserId(umcUserInfoBo.getUserId());
                authUserInfoBo.setMainCustId(umcUserInfoBo.getMainCustId());
                authUserInfoBo.setUserStatus(umcUserInfoBo.getStopStatus());
                authUserInfoBo.setCreateOperId(umcUserInfoBo.getCreateOperId());
                authUserInfoBo.setCreateOperName(umcUserInfoBo.getCreateOperName());
                authUserInfoBo.setCreateTime(umcUserInfoBo.getCreateTime());
                authUserInfoBo.setOrgId(umcUserInfoBo.getOrgId());
                authUserInfoBo.setOrgTreePath(umcUserInfoBo.getOrgTreePath());
                authUserInfoBo.setAuthorityType(umcUserInfoBo.getAuthorityType());
                authUserInfoBo.setTenantId(umcUserInfoBo.getTenantId());
                authUserInfoBo.setIsMain(umcUserInfoBo.getIsMain());
                if ("00".equals(umcUserInfoBo.getStopStatus())) {
                    authUserInfoBo.setUserStatus("0");
                } else {
                    authUserInfoBo.setUserStatus("1");
                }
                authUserInfoBos.add(authUserInfoBo);
            });
        }
        if (!CollectionUtils.isEmpty((Collection)umcSyncUserInfoRspBo.getUpdateUserInfoBos())) {
            umcSyncUserInfoRspBo.getUpdateUserInfoBos().forEach(umcUserInfoBo -> {
                AuthUserInfoBo authUserInfoBo = new AuthUserInfoBo();
                authUserInfoBo.setDealType(Integer.valueOf(2));
                authUserInfoBo.setCustId(umcUserInfoBo.getCustId());
                authUserInfoBo.setUserId(umcUserInfoBo.getUserId());
                authUserInfoBo.setMainCustId(umcUserInfoBo.getMainCustId());
                authUserInfoBo.setUserStatus(umcUserInfoBo.getStopStatus());
                authUserInfoBo.setCreateOperId(umcUserInfoBo.getCreateOperId());
                authUserInfoBo.setCreateOperName(umcUserInfoBo.getCreateOperName());
                authUserInfoBo.setCreateTime(umcUserInfoBo.getCreateTime());
                authUserInfoBo.setUpdateOperId(umcUserInfoBo.getUpdateOperId());
                authUserInfoBo.setUpdateOperName(umcUserInfoBo.getUpdateOperName());
                authUserInfoBo.setUpdateTime(umcUserInfoBo.getUpdateTime());
                authUserInfoBo.setUpdateTime(umcUserInfoBo.getUpdateTime());
                authUserInfoBo.setOrgId(umcUserInfoBo.getOrgId());
                authUserInfoBo.setOrgTreePath(umcUserInfoBo.getOrgTreePath());
                authUserInfoBo.setAuthorityType(umcUserInfoBo.getAuthorityType());
                authUserInfoBo.setTenantId(umcUserInfoBo.getTenantId());
                authUserInfoBo.setIsMain(umcUserInfoBo.getIsMain());
                if ("00".equals(umcUserInfoBo.getStopStatus())) {
                    authUserInfoBo.setUserStatus("0");
                } else {
                    authUserInfoBo.setUserStatus("1");
                }
                authUserInfoBos.add(authUserInfoBo);
            });
        }
        if (!CollectionUtils.isEmpty((Collection)umcSyncUserInfoRspBo.getDeleteUserInfo())) {
            umcSyncUserInfoRspBo.getDeleteUserInfo().forEach(umcUserInfoBo -> {
                AuthUserInfoBo authUserInfoBo = new AuthUserInfoBo();
                authUserInfoBo.setDealType(Integer.valueOf(3));
                authUserInfoBo.setCustId(umcUserInfoBo.getCustId());
                authUserInfoBo.setUserId(umcUserInfoBo.getUserId());
                authUserInfoBos.add(authUserInfoBo);
            });
        }
    }

    private void setAuthCustInfo(UmcSyncUserInfoRspBo umcSyncUserInfoRspBo, List<AuthCustInfoBo> authCustInfoBos) {
        if (!CollectionUtils.isEmpty((Collection)umcSyncUserInfoRspBo.getAddCustInfoBos())) {
            umcSyncUserInfoRspBo.getAddCustInfoBos().forEach(umcCustInfoBo -> {
                AuthCustInfoBo authCustInfoBo = new AuthCustInfoBo();
                authCustInfoBo.setDealType(Integer.valueOf(1));
                authCustInfoBo.setCustId(umcCustInfoBo.getCustId());
                authCustInfoBo.setCustEmail(umcCustInfoBo.getRegEmail());
                authCustInfoBo.setCustName(umcCustInfoBo.getCustName());
                authCustInfoBo.setCellPhone(umcCustInfoBo.getRegMobile());
                authCustInfoBo.setCreateOperId(umcCustInfoBo.getCreateOperId());
                authCustInfoBo.setCreateOperName(umcCustInfoBo.getCreateOperName());
                authCustInfoBo.setCreateTime(umcCustInfoBo.getCreateTime());
                authCustInfoBo.setTenantId(Long.valueOf(10000L));
                authCustInfoBo.setLoginName(umcCustInfoBo.getRegAccount());
                authCustInfoBo.setDelFlag(umcCustInfoBo.getDelFlag());
                authCustInfoBo.setCustStatus(umcCustInfoBo.getCustStatus());
                if (!StringUtils.isBlank((CharSequence)umcCustInfoBo.getPasswd())) {
                    String salt = SaltUtils.getSerialNo((int)8);
                    String pwd = this.passwordUtils.buildPassword(umcCustInfoBo.getPasswd(), salt);
                    authCustInfoBo.setCustPassword(pwd);
                    authCustInfoBo.setPasswordSalt(salt);
                }
                authCustInfoBos.add(authCustInfoBo);
            });
        }
        if (!CollectionUtils.isEmpty((Collection)umcSyncUserInfoRspBo.getUpdateCustInfoBos())) {
            umcSyncUserInfoRspBo.getUpdateCustInfoBos().forEach(umcCustInfoBo -> {
                AuthCustInfoBo authCustInfoBo = new AuthCustInfoBo();
                authCustInfoBo.setDealType(Integer.valueOf(2));
                authCustInfoBo.setCustId(umcCustInfoBo.getCustId());
                authCustInfoBo.setCustEmail(umcCustInfoBo.getRegEmail());
                authCustInfoBo.setCustName(umcCustInfoBo.getCustName());
                authCustInfoBo.setCellPhone(umcCustInfoBo.getRegMobile());
                authCustInfoBo.setCreateOperId(umcCustInfoBo.getCreateOperId());
                authCustInfoBo.setCreateOperName(umcCustInfoBo.getCreateOperName());
                authCustInfoBo.setCreateTime(umcCustInfoBo.getCreateTime());
                authCustInfoBo.setUpdateOperId(umcCustInfoBo.getUpdateOperId());
                authCustInfoBo.setUpdateOperName(umcCustInfoBo.getUpdateOperName());
                authCustInfoBo.setUpdateTime(umcCustInfoBo.getUpdateTime());
                authCustInfoBo.setLoginName(umcCustInfoBo.getRegAccount());
                authCustInfoBo.setCustStatus(umcCustInfoBo.getCustStatus());
                authCustInfoBos.add(authCustInfoBo);
            });
        }
    }

    private UmcCustInfoSyncTempListQryServiceRspBo getUmcCustInfoSyncTempListQryServiceRspBo(DycCustInfoSyncTaskServiceReqBo reqBo, Integer pageNo) {
        UmcCustInfoSyncTempListQryServiceReqBo umcCustInfoSyncTempListQryServiceReqBo = new UmcCustInfoSyncTempListQryServiceReqBo();
        umcCustInfoSyncTempListQryServiceReqBo.setPageNo(pageNo);
        umcCustInfoSyncTempListQryServiceReqBo.setPageSize(Integer.valueOf(this.increment));
        umcCustInfoSyncTempListQryServiceReqBo.setDealResultList(Collections.singletonList(UmcStatusConstant.SyncDealResult.TO_DEAL));
        umcCustInfoSyncTempListQryServiceReqBo.setOrderBy("sync_time asc");
        umcCustInfoSyncTempListQryServiceReqBo.setSHARDING_SHARDNUM(reqBo.getSHARDING_SHARDNUM());
        umcCustInfoSyncTempListQryServiceReqBo.setSHARDING_PARAMETER(reqBo.getSHARDING_PARAMETER());
        UmcCustInfoSyncTempListQryServiceRspBo umcCustInfoSyncTempListQryServiceRspBo = this.umcCustInfoSyncTempListQryService.qryCustInfoTempList(umcCustInfoSyncTempListQryServiceReqBo);
        if (!"0000".equals(umcCustInfoSyncTempListQryServiceRspBo.getRespCode())) {
            throw new ZTBusinessException(umcCustInfoSyncTempListQryServiceRspBo.getRespDesc());
        }
        return umcCustInfoSyncTempListQryServiceRspBo;
    }

    private void updateTempDataState(List<UmcCustInfoSynBo> rows, Integer dealResult) {
        UmcCustInfoSyncTempUpdateServiceReqBo umcCustInfoSyncTempUpdateServiceReqBo = new UmcCustInfoSyncTempUpdateServiceReqBo();
        umcCustInfoSyncTempUpdateServiceReqBo.setTempIds(rows.stream().map(UmcCustInfoSynBo::getId).collect(Collectors.toList()));
        umcCustInfoSyncTempUpdateServiceReqBo.setDealResult(dealResult);
        umcCustInfoSyncTempUpdateServiceReqBo.setUpdateType(UPDATE_BY_ID);
        this.umcCustInfoSyncTempUpdateService.updateCustSyncInfoTempState(umcCustInfoSyncTempUpdateServiceReqBo);
    }

    private void updateTempDataToNotDeal() {
        UmcCustInfoSyncTempUpdateServiceReqBo umcCustInfoSyncTempUpdateServiceReqBo = new UmcCustInfoSyncTempUpdateServiceReqBo();
        umcCustInfoSyncTempUpdateServiceReqBo.setDealResult(UmcStatusConstant.SyncDealResult.NEXT_PROCESSING);
        umcCustInfoSyncTempUpdateServiceReqBo.setUpdateType(UPDATE_BY_STATE);
        this.umcCustInfoSyncTempUpdateService.updateCustSyncInfoTempState(umcCustInfoSyncTempUpdateServiceReqBo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dealRedisValue(DycCustInfoSyncTaskServiceReqBo reqBo) {
        Object object = this.$lock;
        synchronized (object) {
            this.cacheClient.setnx(SYNC_CUST_INFO_KEY_SUP, (Object)reqBo.getSHARDING_SHARDNUM());
            int surplus = Integer.parseInt(this.cacheClient.get(SYNC_CUST_INFO_KEY_SUP).toString());
            if (surplus == 1) {
                this.cacheClient.delete(SYNC_CUST_INFO_KEY_SUP);
                this.cacheClient.delete(SYNC_CUST_INFO_KEY_THREAD_COUNT);
                Set threadNumSet = this.cacheClient.getkeys("SYNC_CUST_INFO_KEY*");
                if (!CollectionUtils.isEmpty((Collection)threadNumSet)) {
                    threadNumSet.forEach(key -> this.cacheClient.delete(key));
                } else {
                    log.error("redis\u7f13\u5b58\u6e05\u695a\u5931\u8d25\uff0c\u83b7\u53d6\u4e0d\u5230\u5bf9\u5e94key");
                }
            } else {
                this.cacheClient.set(SYNC_CUST_INFO_KEY_SUP, (Object)(surplus - 1));
            }
        }
    }
}

