/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.config.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.cfc.ability.api.CfcUniteParamQryListPageAbilityService;
import com.tydic.cfc.ability.bo.CfcUniteParamQryListPageAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcUniteParamQryListPageAbilityRspBO;
import com.tydic.dyc.config.api.CfcCommonUniteParamDealBreachQryListPageService;
import com.tydic.dyc.config.bo.CfcCommonUniteParamBO;
import com.tydic.dyc.config.bo.CfcCommonUniteParamDealBreachQryListPageReqBO;
import com.tydic.dyc.config.bo.CfcCommonUniteParamDealBreachQryListPageRspBO;
import com.tydic.dyc.config.bo.DealBreachBO;
import com.tydic.fsc.base.FscRspPageBaseBO;
import com.tydic.fsc.bo.FscDicDictionaryBO;
import com.tydic.fsc.common.ability.api.FscDictionaryAbilityService;
import com.tydic.fsc.common.ability.bo.FscQueryDictionaryAbilityReqBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.config.api.CfcCommonUniteParamDealBreachQryListPageService"})
public class CfcCommonUniteParamDealBreachQryListPageServiceImpl
implements CfcCommonUniteParamDealBreachQryListPageService {
    @Autowired
    private CfcUniteParamQryListPageAbilityService cfcUniteParamQryListPageAbilityService;
    @Autowired
    private FscDictionaryAbilityService fscDictionaryAbilityService;

    @Override
    @PostMapping(value={"qryDealBreachListPage"})
    public CfcCommonUniteParamDealBreachQryListPageRspBO qryDealBreachListPage(@RequestBody CfcCommonUniteParamDealBreachQryListPageReqBO reqBO) {
        CfcUniteParamQryListPageAbilityReqBO abilityReqBO = new CfcUniteParamQryListPageAbilityReqBO();
        abilityReqBO.setCenter("FSC");
        abilityReqBO.setGroupCode("DEAL_BREACH");
        abilityReqBO.setPageNo(reqBO.getPageNo());
        abilityReqBO.setPageSize(reqBO.getPageSize());
        CfcUniteParamQryListPageAbilityRspBO abilityRspBO = this.cfcUniteParamQryListPageAbilityService.qryUniteParamListPage(abilityReqBO);
        if (!"0000".equals(abilityRspBO.getRespCode())) {
            throw new ZTBusinessException(abilityRspBO.getRespDesc());
        }
        CfcCommonUniteParamDealBreachQryListPageRspBO rspBO = new CfcCommonUniteParamDealBreachQryListPageRspBO();
        Map<String, List<FscDicDictionaryBO>> dealNotPayCreditMap = this.getDicMap("FSC_SERVICE_DEAL_NOT_PAY_CREDIT");
        Map<String, List<FscDicDictionaryBO>> dealRuleCreditMap = this.getDicMap("FSC_SERVICE_DEAL_RULE_CREDIT");
        rspBO.setPageNo(abilityRspBO.getPageNo());
        rspBO.setRecordsTotal(abilityRspBO.getRecordsTotal());
        rspBO.setTotal(abilityRspBO.getTotal());
        ArrayList<DealBreachBO> dealBreachBOS = new ArrayList<DealBreachBO>();
        if (abilityRspBO.getRows() != null && abilityRspBO.getRows().size() > 0) {
            for (JSONObject json : abilityRspBO.getRows()) {
                DealBreachBO dealBreachBO = (DealBreachBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)json), DealBreachBO.class);
                if (!CollectionUtils.isEmpty((Collection)dealNotPayCreditMap.get(dealBreachBO.getBreachCondition()))) {
                    dealBreachBO.setBreachConditionStr(dealNotPayCreditMap.get(dealBreachBO.getBreachCondition()).get(0).getTitle());
                }
                for (String breachLimit : dealBreachBO.getBreachLimit()) {
                    if (CollectionUtils.isEmpty((Collection)dealRuleCreditMap.get(breachLimit))) continue;
                    if (dealBreachBO.getBreachLimitStr() == null || dealBreachBO.getBreachLimitStr().isEmpty()) {
                        dealBreachBO.setBreachLimitStr(dealRuleCreditMap.get(breachLimit).get(0).getTitle());
                        continue;
                    }
                    dealBreachBO.setBreachLimitStr(dealBreachBO.getBreachLimitStr() + "," + dealRuleCreditMap.get(breachLimit).get(0).getTitle());
                }
                dealBreachBOS.add(dealBreachBO);
            }
        }
        dealBreachBOS.stream().sorted(Comparator.comparing(CfcCommonUniteParamBO::getExceptionMainId));
        rspBO.setRows(dealBreachBOS);
        return rspBO;
    }

    private Map<String, List<FscDicDictionaryBO>> getDicMap(String pCode) {
        Map<String, List<FscDicDictionaryBO>> extSysMap = new HashMap<String, List<FscDicDictionaryBO>>();
        FscQueryDictionaryAbilityReqBO fscQueryDictionaryAbilityReqBO = new FscQueryDictionaryAbilityReqBO();
        fscQueryDictionaryAbilityReqBO.setPcode(pCode);
        FscRspPageBaseBO qryRspBO = this.fscDictionaryAbilityService.queryBypCodeBackPo(fscQueryDictionaryAbilityReqBO);
        if (!CollectionUtils.isEmpty((Collection)qryRspBO.getRows())) {
            extSysMap = qryRspBO.getRows().stream().collect(Collectors.groupingBy(FscDicDictionaryBO::getCode));
        }
        return extSysMap;
    }
}

