/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.config.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FindSameJavaUtil {
    private static Map<String, List<String>> fileMap = new HashMap<String, List<String>>();

    public static void main(String[] args) {
        String dirPath = "D:\\\u4ee3\u7801\\dyc-2024\\dyc-saas";
        String outputPath = "C:\\Users\\mli\\Desktop\\1.txt";
        FindSameJavaUtil.traverse(dirPath);
        FindSameJavaUtil.outputToFile(outputPath);
    }

    public static void traverse(String path) {
        File[] files = new File(path).listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    FindSameJavaUtil.traverse(file.getAbsolutePath());
                    continue;
                }
                String name = file.getName();
                int index = name.lastIndexOf(".java");
                if (index <= 0 || name.length() - index != 5 || !name.endsWith("Service.java")) continue;
                String fileName = name.substring(0, index);
                String filePath = file.getAbsolutePath();
                if (!fileMap.containsKey(fileName)) {
                    fileMap.put(fileName, new ArrayList());
                }
                fileMap.get(fileName).add(filePath);
            }
        }
    }

    public static void outputToFile(String path) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(path));
            for (Map.Entry<String, List<String>> entry : fileMap.entrySet()) {
                String fileName = entry.getKey();
                List<String> filePaths = entry.getValue();
                if (filePaths.size() < 2) continue;
                writer.write(fileName + ":\r\n");
                for (String filePath : filePaths) {
                    writer.write(filePath + "\r\n");
                }
                writer.write("\r\n");
            }
            writer.close();
            System.out.println("Output finished.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

