/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.fsc.pay.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.ValueFilter;
import com.tydic.commodity.mall.ability.api.UccMallAreaAvailableQryAbilityService;
import com.tydic.commodity.mall.ability.api.UccMallCurrentStockQryAbilityService;
import com.tydic.commodity.mall.ability.api.UccMallQrySkuStateAbilityService;
import com.tydic.commodity.mall.ability.bo.UccMallAreaAvailableCommdBO_busi;
import com.tydic.commodity.mall.ability.bo.UccMallAreaAvailableQryAbilityReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallAreaAvailableQryAbilityRspBO;
import com.tydic.commodity.mall.ability.bo.UccMallAreaAvailableQryBo;
import com.tydic.commodity.mall.ability.bo.UccMallCommdStockBO_busi;
import com.tydic.commodity.mall.ability.bo.UccMallCurrentStockQryReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallCurrentStockQryRspBO;
import com.tydic.commodity.mall.ability.bo.UccMallQrySkuStateBO;
import com.tydic.commodity.mall.ability.bo.UccMallQrySkuStateReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallQrySkuStateRspBO;
import com.tydic.commodity.mall.ability.bo.UccMallSkuNumBO_busi;
import com.tydic.dyc.fsc.pay.api.DycFscQryOrderSkuInfoListService;
import com.tydic.dyc.fsc.pay.api.DycPebExtOrderListQryForFscAbilityService;
import com.tydic.dyc.fsc.pay.bo.DycFscInspectionItemListBO;
import com.tydic.dyc.fsc.pay.bo.DycFscOrderSkuInfoRspBo;
import com.tydic.dyc.fsc.pay.bo.DycFscQryOrderSkuInfoListServiceReqBo;
import com.tydic.dyc.fsc.pay.bo.DycFscQryOrderSkuInfoListServiceRspBo;
import com.tydic.dyc.fsc.pay.bo.DycFscUocAcceptOrderCommodityInfoBO;
import com.tydic.dyc.fsc.pay.bo.DycFscUocAcceptOrderInfoBO;
import com.tydic.dyc.fsc.pay.bo.DycFscUocQryAcceptOrderListReqBO;
import com.tydic.dyc.fsc.pay.bo.DycFscUocQryAcceptOrderListRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.fsc.pay.api.DycFscQryOrderSkuInfoListService"})
public class DycFscQryOrderSkuInfoListServiceImpl
implements DycFscQryOrderSkuInfoListService {
    private static final Logger log = LoggerFactory.getLogger(DycFscQryOrderSkuInfoListServiceImpl.class);
    @Value(value="${qry.url:http://39.105.66.173:10220/query}")
    private String generalQueryUrl;
    @Autowired
    private DycPebExtOrderListQryForFscAbilityService dycPebExtOrderListQryForFscAbilityService;
    @Autowired
    private UccMallCurrentStockQryAbilityService uccMallCurrentStockQryAbilityService;
    @Autowired
    private UccMallAreaAvailableQryAbilityService uccMallAreaAvailableQryAbilityService;
    @Autowired
    private UccMallQrySkuStateAbilityService uccMallQrySkuStateAbilityService;
    ValueFilter propertyFilter = (object, name, value) -> {
        if (value != null && value.getClass().equals(String.class) && "".equals(value)) {
            value = null;
        }
        return value;
    };

    @Override
    @PostMapping(value={"qryOrderSkuInfoList"})
    public DycFscQryOrderSkuInfoListServiceRspBo qryOrderSkuInfoList(@RequestBody DycFscQryOrderSkuInfoListServiceReqBo reqBo) {
        DycFscUocQryAcceptOrderListReqBO uocInspectionDetailsListPageQueryReqBO = (DycFscUocQryAcceptOrderListReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBo), (SerializeFilter)this.propertyFilter, (SerializerFeature[])new SerializerFeature[0]), DycFscUocQryAcceptOrderListReqBO.class));
        uocInspectionDetailsListPageQueryReqBO.setInspOrderId(reqBo.getInspectionVoucherId());
        uocInspectionDetailsListPageQueryReqBO.setSaleOrderId(Convert.toStr((Object)reqBo.getSaleVoucherId()));
        DycFscUocQryAcceptOrderListRspBO inspectionList = this.getInspectionList(uocInspectionDetailsListPageQueryReqBO);
        DycFscQryOrderSkuInfoListServiceRspBo rspBo = new DycFscQryOrderSkuInfoListServiceRspBo();
        if (!CollectionUtils.isEmpty(inspectionList.getRows())) {
            Map<String, UccMallCommdStockBO_busi> commdStockBOBusiMap = this.getStockInfo(reqBo, inspectionList);
            Map<String, UccMallAreaAvailableCommdBO_busi> availableCommdBOBusiMap = this.getAreaAvailableInfo(reqBo, inspectionList);
            Map<Long, UccMallQrySkuStateBO> skuStateBOMap = this.getSkuState(inspectionList);
            rspBo.setRows(this.getDycPebExtOrderListQryForFscRspBO(inspectionList, commdStockBOBusiMap, availableCommdBOBusiMap, skuStateBOMap));
        }
        return rspBo;
    }

    private Map<Long, UccMallQrySkuStateBO> getSkuState(DycFscUocQryAcceptOrderListRspBO inspectionList) {
        UccMallQrySkuStateReqBO uccMallQrySkuStateReqBO = new UccMallQrySkuStateReqBO();
        DycFscUocAcceptOrderInfoBO dycFscUocAcceptOrderInfoBO = inspectionList.getRows().get(0);
        List<DycFscUocAcceptOrderCommodityInfoBO> acceptOrderCommodityInfo = dycFscUocAcceptOrderInfoBO.getAcceptOrderCommodityInfo();
        List skuIds = acceptOrderCommodityInfo.stream().map(c -> Convert.toLong((Object)c.getSkuId())).collect(Collectors.toList());
        uccMallQrySkuStateReqBO.setSkuIds(skuIds);
        uccMallQrySkuStateReqBO.setSupplierShopId(Convert.toLong((Object)acceptOrderCommodityInfo.get(0).getSupplierShopId()));
        UccMallQrySkuStateRspBO uccQrySkuStateRspBO = this.uccMallQrySkuStateAbilityService.qrySkuState(uccMallQrySkuStateReqBO);
        if (!"0000".equals(uccQrySkuStateRspBO.getRespCode())) {
            log.error("\u67e5\u8be2\u5546\u54c1\u4e2d\u5fc3\u5f02\u5e38\uff1a{}", (Object)JSON.toJSONString((Object)uccQrySkuStateRspBO));
        }
        if (CollectionUtils.isEmpty((Collection)uccQrySkuStateRspBO.getRows())) {
            return new HashMap<Long, UccMallQrySkuStateBO>(0);
        }
        return uccQrySkuStateRspBO.getRows().stream().collect(Collectors.toMap(UccMallQrySkuStateBO::getSkuId, o -> o));
    }

    private Map<String, UccMallAreaAvailableCommdBO_busi> getAreaAvailableInfo(DycFscQryOrderSkuInfoListServiceReqBo reqBo, DycFscUocQryAcceptOrderListRspBO inspectionList) {
        UccMallAreaAvailableQryAbilityReqBO uccAreaAvailableQryAbilityReqBO = new UccMallAreaAvailableQryAbilityReqBO();
        DycFscUocAcceptOrderInfoBO dycFscUocAcceptOrderInfoBO = inspectionList.getRows().get(0);
        List<DycFscUocAcceptOrderCommodityInfoBO> acceptOrderCommodityInfo = dycFscUocAcceptOrderInfoBO.getAcceptOrderCommodityInfo();
        List areaAvailableSkuInfo = acceptOrderCommodityInfo.stream().map(commodityInfo -> {
            UccMallAreaAvailableQryBo uccMallAreaAvailableQryBo = new UccMallAreaAvailableQryBo();
            uccMallAreaAvailableQryBo.setProvince(reqBo.getProvince());
            uccMallAreaAvailableQryBo.setCity(reqBo.getCity());
            uccMallAreaAvailableQryBo.setCounty(reqBo.getCounty());
            uccMallAreaAvailableQryBo.setTown(reqBo.getTown());
            uccMallAreaAvailableQryBo.setSkuId(Convert.toLong((Object)commodityInfo.getSkuId()));
            uccMallAreaAvailableQryBo.setSupplierShopId(Convert.toLong((Object)commodityInfo.getSupplierShopId()));
            return uccMallAreaAvailableQryBo;
        }).collect(Collectors.toList());
        uccAreaAvailableQryAbilityReqBO.setAreaAvailableSkuInfo(areaAvailableSkuInfo);
        UccMallAreaAvailableQryAbilityRspBO uccAreaAvailableQryAbilityRspBO = this.uccMallAreaAvailableQryAbilityService.qryAreaAvailable(uccAreaAvailableQryAbilityReqBO);
        if (!"0000".equals(uccAreaAvailableQryAbilityRspBO.getRespCode())) {
            log.error("\u67e5\u8be2\u5546\u54c1\u4e2d\u5fc3\u5f02\u5e38\uff1a{}", (Object)JSON.toJSONString((Object)uccAreaAvailableQryAbilityRspBO));
        }
        if (CollectionUtils.isEmpty((Collection)uccAreaAvailableQryAbilityRspBO.getAreaAvailableCommdInfos())) {
            return new HashMap<String, UccMallAreaAvailableCommdBO_busi>(0);
        }
        return uccAreaAvailableQryAbilityRspBO.getAreaAvailableCommdInfos().stream().collect(Collectors.toMap(UccMallAreaAvailableCommdBO_busi::getSkuId, o -> o));
    }

    private Map<String, UccMallCommdStockBO_busi> getStockInfo(DycFscQryOrderSkuInfoListServiceReqBo reqBo, DycFscUocQryAcceptOrderListRspBO inspectionList) {
        UccMallCurrentStockQryReqBO uccCurrentStockQryReqBO = new UccMallCurrentStockQryReqBO();
        uccCurrentStockQryReqBO.setCity(reqBo.getCity());
        uccCurrentStockQryReqBO.setCounty(reqBo.getCounty());
        uccCurrentStockQryReqBO.setProvince(reqBo.getProvince());
        uccCurrentStockQryReqBO.setTown(reqBo.getTown());
        DycFscUocAcceptOrderInfoBO dycFscUocAcceptOrderInfoBO = inspectionList.getRows().get(0);
        DycFscUocAcceptOrderCommodityInfoBO commodityInfoBO = dycFscUocAcceptOrderInfoBO.getAcceptOrderCommodityInfo().get(0);
        uccCurrentStockQryReqBO.setSupplierShopId(Convert.toLong((Object)commodityInfoBO.getSupplierShopId()));
        ArrayList<UccMallSkuNumBO_busi> skuNum = new ArrayList<UccMallSkuNumBO_busi>();
        for (DycFscUocAcceptOrderCommodityInfoBO pesappMallQueryGoodsStockInfo : dycFscUocAcceptOrderInfoBO.getAcceptOrderCommodityInfo()) {
            UccMallSkuNumBO_busi skuNumBO_busi = new UccMallSkuNumBO_busi();
            skuNumBO_busi.setNum(BigDecimal.ONE);
            skuNumBO_busi.setSkuId(Convert.toLong((Object)commodityInfoBO.getSkuId()));
            skuNum.add(skuNumBO_busi);
        }
        uccCurrentStockQryReqBO.setSkuNum(skuNum);
        UccMallCurrentStockQryRspBO uccCurrentStockQryRspBO = this.uccMallCurrentStockQryAbilityService.qryStock(uccCurrentStockQryReqBO);
        if (!"0000".equals(uccCurrentStockQryRspBO.getRespCode())) {
            log.error("\u67e5\u8be2\u5546\u54c1\u4e2d\u5fc3\u5f02\u5e38\uff1a{}", (Object)JSON.toJSONString((Object)uccCurrentStockQryRspBO));
        }
        if (CollectionUtils.isEmpty((Collection)uccCurrentStockQryRspBO.getCommdStockInfo())) {
            return new HashMap<String, UccMallCommdStockBO_busi>(0);
        }
        return uccCurrentStockQryRspBO.getCommdStockInfo().stream().collect(Collectors.toMap(UccMallCommdStockBO_busi::getSkuId, o -> o));
    }

    private List<DycFscInspectionItemListBO> getDycPebExtOrderListQryForFscRspBO(DycFscUocQryAcceptOrderListRspBO uocInspectionDetailsListPageQueryRspBO, Map<String, UccMallCommdStockBO_busi> commdStockBOBusiMap, Map<String, UccMallAreaAvailableCommdBO_busi> availableCommdBOBusiMap, Map<Long, UccMallQrySkuStateBO> skuStateBOMap) {
        DycFscUocAcceptOrderInfoBO dycFscUocAcceptOrderInfoBO = uocInspectionDetailsListPageQueryRspBO.getRows().get(0);
        return uocInspectionDetailsListPageQueryRspBO.getRows().get(0).getAcceptOrderCommodityInfo().stream().map(dycFscUocAcceptOrderCommodityInfoBO -> {
            UccMallQrySkuStateBO uccMallQrySkuStateBO;
            UccMallAreaAvailableCommdBO_busi uccMallAreaAvailableCommdBO_busi;
            DycFscInspectionItemListBO dycFscInspectionItemListBO = (DycFscInspectionItemListBO)JSON.parseObject((String)JSON.toJSONString((Object)dycFscUocAcceptOrderCommodityInfoBO), DycFscInspectionItemListBO.class);
            dycFscInspectionItemListBO.setInspectionItemId(Convert.toStr((Object)dycFscUocAcceptOrderCommodityInfoBO.getInspOrderItemId()));
            dycFscInspectionItemListBO.setInspectionVoucherId(Convert.toStr((Object)dycFscUocAcceptOrderInfoBO.getInspOrderId()));
            dycFscInspectionItemListBO.setInspectionCount(dycFscUocAcceptOrderCommodityInfoBO.getAcceptCount());
            dycFscInspectionItemListBO.setPurchasingPrice(Convert.toStr((Object)dycFscUocAcceptOrderCommodityInfoBO.getPurchasePrice()));
            dycFscInspectionItemListBO.setSellingPrice(Convert.toStr((Object)dycFscUocAcceptOrderCommodityInfoBO.getSalePrice()));
            dycFscInspectionItemListBO.setSkuMaterialId(dycFscUocAcceptOrderCommodityInfoBO.getMaterialCode());
            dycFscInspectionItemListBO.setSkuMaterialName(dycFscUocAcceptOrderCommodityInfoBO.getMaterialName());
            dycFscInspectionItemListBO.setSkuMaterialTypeId(dycFscUocAcceptOrderCommodityInfoBO.getMaterialClassifyId());
            dycFscInspectionItemListBO.setSkuMaterialTypeName(dycFscUocAcceptOrderCommodityInfoBO.getMaterialClassifyName());
            dycFscInspectionItemListBO.setExtSkuId(dycFscUocAcceptOrderCommodityInfoBO.getSkuExtSkuId());
            dycFscInspectionItemListBO.setPicUrl(dycFscUocAcceptOrderCommodityInfoBO.getSkuMainPic());
            dycFscInspectionItemListBO.setSendCount(Convert.toStr((Object)dycFscUocAcceptOrderCommodityInfoBO.getDeliveryCount()));
            dycFscInspectionItemListBO.setOrderId(Convert.toStr((Object)dycFscUocAcceptOrderInfoBO.getSaleOrderId()));
            dycFscInspectionItemListBO.setOrdItemId(Convert.toStr((Object)dycFscUocAcceptOrderCommodityInfoBO.getSaleOrderItemId()));
            dycFscInspectionItemListBO.setSupplierId(dycFscUocAcceptOrderInfoBO.getSupplierId());
            dycFscInspectionItemListBO.setSupplierShopId(dycFscUocAcceptOrderCommodityInfoBO.getSupplierShopId());
            dycFscInspectionItemListBO.setSkuMainPic(dycFscUocAcceptOrderCommodityInfoBO.getSkuMainPic());
            DycFscOrderSkuInfoRspBo fscOrderSkuInfoRspBo = new DycFscOrderSkuInfoRspBo();
            UccMallCommdStockBO_busi uccMallCommdStockBO_busi = (UccMallCommdStockBO_busi)commdStockBOBusiMap.get(dycFscUocAcceptOrderCommodityInfoBO.getSkuId());
            if (null != uccMallCommdStockBO_busi) {
                fscOrderSkuInfoRspBo.setAreaId(uccMallCommdStockBO_busi.getAreaId());
                fscOrderSkuInfoRspBo.setStockStateId(uccMallCommdStockBO_busi.getStockStateId());
                fscOrderSkuInfoRspBo.setStockStateDesc(uccMallCommdStockBO_busi.getStockStateDesc());
                fscOrderSkuInfoRspBo.setRemainNum(Convert.toInt((Object)uccMallCommdStockBO_busi.getRemainNum()));
            }
            if (null != (uccMallAreaAvailableCommdBO_busi = (UccMallAreaAvailableCommdBO_busi)availableCommdBOBusiMap.get(dycFscUocAcceptOrderCommodityInfoBO.getSkuId()))) {
                fscOrderSkuInfoRspBo.setAreaRestrict(uccMallAreaAvailableCommdBO_busi.isAreaRestrict());
            }
            if (null != (uccMallQrySkuStateBO = (UccMallQrySkuStateBO)skuStateBOMap.get(Convert.toLong((Object)dycFscUocAcceptOrderCommodityInfoBO.getSkuId())))) {
                fscOrderSkuInfoRspBo.setStatus(uccMallQrySkuStateBO.getStatus());
            }
            dycFscInspectionItemListBO.setSkuInfoRspBo(fscOrderSkuInfoRspBo);
            return dycFscInspectionItemListBO;
        }).collect(Collectors.toList());
    }

    private DycFscUocQryAcceptOrderListRspBO getInspectionList(DycFscUocQryAcceptOrderListReqBO qryAcceptOrderListReqBO) {
        String rspJsonStr = this.commonQry(JSON.toJSONString((Object)((Object)qryAcceptOrderListReqBO)));
        log.info("\u9a8c\u6536\u5355\u67e5\u8be2\u51fa\u53c2\uff1a{}", (Object)rspJsonStr);
        return (DycFscUocQryAcceptOrderListRspBO)((Object)JSON.parseObject((String)rspJsonStr, DycFscUocQryAcceptOrderListRspBO.class));
    }

    private String commonQry(String reqJsonStr) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("queryCountFlag", (Object)false);
        jsonObject.put("reqParams", (Object)reqJsonStr);
        log.info("\u9a8c\u6536\u5355\u67e5\u8be2\u5165\u53c2\uff1a{}", (Object)jsonObject.toJSONString());
        return HttpUtil.post((String)this.generalQueryUrl, (String)jsonObject.toJSONString(), (int)6000);
    }
}

