/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.mall.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.commodity.mall.ability.api.UccMallSearchBarEsAbilityService;
import com.tydic.commodity.mall.ability.bo.UccMallSearchBarEsReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallSearchBarEsRspBO;
import com.tydic.dyc.atom.common.api.DycGeneralQueryFunction;
import com.tydic.dyc.atom.common.bo.DycGeneralQueryFuncReqBO;
import com.tydic.dyc.mall.ability.DycMallStatisticsQueryService;
import com.tydic.dyc.mall.ability.bo.DycMallStatisticsQueryReqBO;
import com.tydic.dyc.mall.ability.bo.DycMallStatisticsQueryRspBO;
import com.tydic.dyc.oc.service.saleorder.UocQryLastMonthSaleOrdersCountService;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.mall.ability.DycMallStatisticsQueryService"})
public class DycMallStatisticsQueryServiceImpl
implements DycMallStatisticsQueryService {
    @Autowired
    private UccMallSearchBarEsAbilityService uccMallSearchBarEsAbilityService;
    @Autowired
    private UocQryLastMonthSaleOrdersCountService uocQryLastMonthSaleOrdersCountService;
    @Autowired
    private DycGeneralQueryFunction dycGeneralQueryFunction;

    @Override
    @PostMapping(value={"statisticsQuery"})
    public DycMallStatisticsQueryRspBO statisticsQuery(@RequestBody DycMallStatisticsQueryReqBO reqBO) {
        DycMallStatisticsQueryRspBO rspBO = new DycMallStatisticsQueryRspBO();
        try {
            UccMallSearchBarEsReqBO searchBarEsReqBO = new UccMallSearchBarEsReqBO();
            searchBarEsReqBO.setNeedKeyWorld(false);
            UccMallSearchBarEsRspBO searchBarEsRspBO = this.uccMallSearchBarEsAbilityService.qryBySearchBar(searchBarEsReqBO);
            if ("0000".equals(searchBarEsRspBO.getRespCode())) {
                rspBO.setOnlineProductsCount(searchBarEsRspBO.getRecordsTotal());
            } else {
                rspBO.setOnlineProductsCount(0);
            }
        }
        catch (Exception e) {
            rspBO.setOnlineProductsCount(0);
        }
        try {
            DycGeneralQueryFuncReqBO dycGeneralQueryFuncReqBO = new DycGeneralQueryFuncReqBO();
            dycGeneralQueryFuncReqBO.setQueryCountFlag(Boolean.TRUE);
            JSONObject reqCountObj = new JSONObject();
            reqCountObj.put("code", (Object)"951184533233897472");
            ArrayList<String> saleOrderList = new ArrayList<String>();
            saleOrderList.add(0, "XS_YS_YS");
            saleOrderList.add(1, "XS_YS_BFYS");
            reqCountObj.put("saleOrderStates", saleOrderList);
            LocalDate firstDayOfMonth = LocalDate.now().minusMonths(1L).with(TemporalAdjusters.firstDayOfMonth());
            LocalDate lastDayOfMonth = LocalDate.now().minusMonths(1L).with(TemporalAdjusters.lastDayOfMonth());
            String defaultEndDate = lastDayOfMonth.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            defaultEndDate = defaultEndDate + " 23:59:59";
            reqCountObj.put("createTimeStart", (Object)Date.from(firstDayOfMonth.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()));
            reqCountObj.put("createTimeEnd", (Object)DateUtils.strToDate((String)defaultEndDate, (String)"yyyy-MM-dd HH:mm:ss"));
            dycGeneralQueryFuncReqBO.setReqParams(reqCountObj.toJSONString());
            String rspJsonStr = this.dycGeneralQueryFunction.generalQuery(dycGeneralQueryFuncReqBO).getRspJsonStr();
            if (ObjectUtil.isNotEmpty((Object)rspJsonStr)) {
                JSONObject jsonObject = JSON.parseObject((String)rspJsonStr);
                rspBO.setOrderCount(ObjectUtil.isNotNull((Object)jsonObject.get((Object)"recordsTotal")) ? jsonObject.getInteger("recordsTotal") : 0);
            }
        }
        catch (Exception e) {
            rspBO.setOrderCount(0);
        }
        return rspBO;
    }
}

