/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.mall.order.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.mall.ability.api.UccMallAreaAvailableQryAbilityService;
import com.tydic.commodity.mall.ability.bo.UccMallAreaAvailableQryAbilityReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallAreaAvailableQryAbilityRspBO;
import com.tydic.dyc.base.utils.ComHttpUtil;
import com.tydic.dyc.mall.order.api.PesappMallQueryAreaAvailableService;
import com.tydic.dyc.mall.order.bo.PesappMallAreaAvailableQryBO;
import com.tydic.dyc.mall.order.bo.PesappMallQueryAreaAvailableReqBO;
import com.tydic.dyc.mall.order.bo.PesappMallQueryAreaAvailableRspBO;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.mall.order.api.PesappMallQueryAreaAvailableService"})
public class PesappMallQueryAreaAvailableServiceImpl
implements PesappMallQueryAreaAvailableService {
    private static final Logger log = LoggerFactory.getLogger(PesappMallQueryAreaAvailableServiceImpl.class);
    private static final String JD_CHECK_ADDRESS_SUCCESS = "success";
    private static final String ESB_RESULT_CODE = "resultCode";
    private static final String ESB_RESULT_MESSAGE = "resultMessage";
    private static final String HSN = "jd";
    private static final String JD_SUPNO = "100055";
    private static final String JD_SUPNO_VOP = "100054";
    @Autowired
    private UccMallAreaAvailableQryAbilityService uccMallAreaAvailableQryAbilityService;
    @Value(value="${JD_CHECK_ADDRESS_URL:${ESB_ACCESS_IP}/OSN/api/checkArea/v1}")
    private String JD_CHECK_ADDRESS_URL = "JD_CHECK_ADDRESS_URL";

    @Override
    @PostMapping(value={"queryAreaAvailable"})
    public PesappMallQueryAreaAvailableRspBO queryAreaAvailable(@RequestBody PesappMallQueryAreaAvailableReqBO reqBO) {
        for (PesappMallAreaAvailableQryBO pesappMallQueryGoodsStockInfo : reqBO.getAreaAvailableSkuInfo()) {
            if (!JD_SUPNO.equals(pesappMallQueryGoodsStockInfo.getSupplierShopId()) && !JD_SUPNO_VOP.equals(pesappMallQueryGoodsStockInfo.getSupplierShopId())) continue;
            this.extracted(pesappMallQueryGoodsStockInfo);
        }
        String inputJsonStr = JSONObject.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue});
        UccMallAreaAvailableQryAbilityReqBO uccAreaAvailableQryAbilityReqBO = (UccMallAreaAvailableQryAbilityReqBO)JSON.parseObject((String)inputJsonStr, UccMallAreaAvailableQryAbilityReqBO.class);
        UccMallAreaAvailableQryAbilityRspBO uccAreaAvailableQryAbilityRspBO = this.uccMallAreaAvailableQryAbilityService.qryAreaAvailable(uccAreaAvailableQryAbilityReqBO);
        if ("0000".equals(uccAreaAvailableQryAbilityRspBO.getRespCode())) {
            String resultStr = JSONObject.toJSONString((Object)uccAreaAvailableQryAbilityRspBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue});
            return (PesappMallQueryAreaAvailableRspBO)((Object)JSONObject.parseObject((String)resultStr, PesappMallQueryAreaAvailableRspBO.class));
        }
        throw new ZTBusinessException(uccAreaAvailableQryAbilityRspBO.getRespDesc());
    }

    private void extracted(PesappMallAreaAvailableQryBO pesappMallQueryGoodsStockInfo) {
        String callUrl = this.JD_CHECK_ADDRESS_URL;
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("provinceId", (Object)pesappMallQueryGoodsStockInfo.getProvince());
        jsonObject.put("cityId", (Object)pesappMallQueryGoodsStockInfo.getCity());
        jsonObject.put("countyId", (Object)pesappMallQueryGoodsStockInfo.getCounty());
        jsonObject.put("townId", (Object)(StringUtils.isEmpty((Object)pesappMallQueryGoodsStockInfo.getTown()) ? 0L : pesappMallQueryGoodsStockInfo.getTown()));
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)pesappMallQueryGoodsStockInfo.getHsn())) {
            jsonObject.put("hsn", (Object)HSN);
        } else {
            jsonObject.put("hsn", (Object)pesappMallQueryGoodsStockInfo.getHsn());
        }
        String jsonString = JSON.toJSONString((Object)jsonObject);
        log.info("\u4eac\u4e1c\u5730\u5740\u6821\u9a8c\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)callUrl, (Object)jsonString);
        String result = null;
        try {
            result = ComHttpUtil.sendPost((String)callUrl, (String)jsonObject.toJSONString());
            log.info("\u4eac\u4e1c\u5730\u5740\u6821\u9a8c\u51fa\u53c2: " + result);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ZTBusinessException("\u4eac\u4e1c\u5730\u5740\u6821\u9a8c\u5f02\u5e38" + e);
        }
        JSONObject rspJsonObject = JSONObject.parseObject((String)result);
        if (!rspJsonObject.getBoolean(JD_CHECK_ADDRESS_SUCCESS).booleanValue() || !"0000".equals(rspJsonObject.getString(ESB_RESULT_CODE))) {
            throw new ZTBusinessException("\u63d0\u4ea4\u5931\u8d25\uff01\u7531\u4e8e\u4eac\u4e1c\u5730\u5740\u4fe1\u606f\u5339\u914d\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u5904\u7406\uff08\u5f02\u5e38\u4ee3\u7801:" + rspJsonObject.getString(ESB_RESULT_CODE) + " :" + rspJsonObject.getString(ESB_RESULT_MESSAGE) + "\uff09");
        }
    }
}

