/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.mall.order.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.DelFormatHelper;
import com.tydic.commodity.mall.ability.api.UccMallCurrentStockQryAbilityService;
import com.tydic.commodity.mall.ability.bo.UccMallCurrentStockQryReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallCurrentStockQryRspBO;
import com.tydic.commodity.mall.ability.bo.UccMallSkuNumBO_busi;
import com.tydic.dyc.base.utils.ComHttpUtil;
import com.tydic.dyc.mall.order.api.PesappMallQueryGoodsStockService;
import com.tydic.dyc.mall.order.bo.PesappMallCommdStockBO;
import com.tydic.dyc.mall.order.bo.PesappMallQueryGoodsStockInfo;
import com.tydic.dyc.mall.order.bo.PesappMallQueryGoodsStockReqBO;
import com.tydic.dyc.mall.order.bo.PesappMallQueryGoodsStockRspBO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.mall.order.api.PesappMallQueryGoodsStockService"})
public class PesappMallQueryGoodsStockServiceImpl
implements PesappMallQueryGoodsStockService {
    private static final Logger log = LoggerFactory.getLogger(PesappMallQueryGoodsStockServiceImpl.class);
    private static final String JD_CHECK_ADDRESS_SUCCESS = "success";
    private static final String ESB_RESULT_CODE = "resultCode";
    private static final String ESB_RESULT_MESSAGE = "resultMessage";
    private static final String HSN = "jd";
    private static final Long JD_SUPNO = 100055L;
    private static final Long JD_SUPNO_VOP = 100054L;
    @Autowired
    private UccMallCurrentStockQryAbilityService uccMallCurrentStockQryAbilityService;
    @Value(value="${JD_CHECK_ADDRESS_URL:${ESB_ACCESS_IP}/OSN/api/checkArea/v1}")
    private String JD_CHECK_ADDRESS_URL = "JD_CHECK_ADDRESS_URL";

    @Override
    @PostMapping(value={"queryGoodsStock"})
    public PesappMallQueryGoodsStockRspBO queryGoodsStock(@RequestBody PesappMallQueryGoodsStockReqBO reqBO) {
        PesappMallQueryGoodsStockRspBO rspBO = new PesappMallQueryGoodsStockRspBO();
        if (reqBO.getQueryGoodsStockInfo() != null && reqBO.getQueryGoodsStockInfo().size() > 0) {
            List queryGoodsStockInfoList;
            ArrayList<PesappMallCommdStockBO> commdStockInfo = new ArrayList<PesappMallCommdStockBO>();
            for (PesappMallQueryGoodsStockInfo pesappMallQueryGoodsStockInfo : reqBO.getQueryGoodsStockInfo()) {
                if (!JD_SUPNO.equals(pesappMallQueryGoodsStockInfo.getSupplierShopId()) && !JD_SUPNO_VOP.equals(pesappMallQueryGoodsStockInfo.getSupplierShopId())) continue;
                this.extracted(pesappMallQueryGoodsStockInfo);
            }
            HashMap queryGoodsStockInfoGroup = new HashMap();
            for (PesappMallQueryGoodsStockInfo pesappMallQueryGoodsStockInfo : reqBO.getQueryGoodsStockInfo()) {
                if (queryGoodsStockInfoGroup.containsKey(pesappMallQueryGoodsStockInfo.getSupplierShopId())) {
                    queryGoodsStockInfoList = (List)queryGoodsStockInfoGroup.get(pesappMallQueryGoodsStockInfo.getSupplierShopId());
                    queryGoodsStockInfoList.add(pesappMallQueryGoodsStockInfo);
                    queryGoodsStockInfoGroup.put(pesappMallQueryGoodsStockInfo.getSupplierShopId(), queryGoodsStockInfoList);
                    continue;
                }
                queryGoodsStockInfoList = new ArrayList<PesappMallQueryGoodsStockInfo>();
                queryGoodsStockInfoList.add(pesappMallQueryGoodsStockInfo);
                queryGoodsStockInfoGroup.put(pesappMallQueryGoodsStockInfo.getSupplierShopId(), queryGoodsStockInfoList);
            }
            for (Long supplierShopId : queryGoodsStockInfoGroup.keySet()) {
                queryGoodsStockInfoList = (List)queryGoodsStockInfoGroup.get(supplierShopId);
                if (queryGoodsStockInfoList == null || queryGoodsStockInfoList.size() <= 0) continue;
                UccMallCurrentStockQryReqBO uccCurrentStockQryReqBO = new UccMallCurrentStockQryReqBO();
                uccCurrentStockQryReqBO.setCity(((PesappMallQueryGoodsStockInfo)queryGoodsStockInfoList.get(0)).getCity());
                uccCurrentStockQryReqBO.setCounty(((PesappMallQueryGoodsStockInfo)queryGoodsStockInfoList.get(0)).getCounty());
                uccCurrentStockQryReqBO.setProvince(((PesappMallQueryGoodsStockInfo)queryGoodsStockInfoList.get(0)).getProvince());
                uccCurrentStockQryReqBO.setTown(((PesappMallQueryGoodsStockInfo)queryGoodsStockInfoList.get(0)).getTown());
                uccCurrentStockQryReqBO.setSupplierShopId(supplierShopId);
                ArrayList<UccMallSkuNumBO_busi> skuNum = new ArrayList<UccMallSkuNumBO_busi>();
                for (PesappMallQueryGoodsStockInfo pesappMallQueryGoodsStockInfo : queryGoodsStockInfoList) {
                    UccMallSkuNumBO_busi skuNumBO_busi = new UccMallSkuNumBO_busi();
                    skuNumBO_busi.setNum(pesappMallQueryGoodsStockInfo.getNum());
                    skuNumBO_busi.setSkuId(pesappMallQueryGoodsStockInfo.getSkuId());
                    skuNum.add(skuNumBO_busi);
                }
                uccCurrentStockQryReqBO.setSkuNum(skuNum);
                UccMallCurrentStockQryRspBO uccCurrentStockQryRspBO = this.uccMallCurrentStockQryAbilityService.qryStock(uccCurrentStockQryReqBO);
                if ("0000".equals(uccCurrentStockQryRspBO.getRespCode())) {
                    String resultJsonStr = JSONObject.toJSONString((Object)uccCurrentStockQryRspBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue});
                    PesappMallQueryGoodsStockRspBO pesappMallQueryGoodsStockRspBO = (PesappMallQueryGoodsStockRspBO)((Object)JSONObject.parseObject((String)resultJsonStr, PesappMallQueryGoodsStockRspBO.class));
                    commdStockInfo.addAll(pesappMallQueryGoodsStockRspBO.getCommdStockInfo());
                    continue;
                }
                throw new ZTBusinessException(uccCurrentStockQryRspBO.getRespDesc());
            }
            rspBO.setCommdStockInfo(commdStockInfo);
        }
        return rspBO;
    }

    private void extracted(PesappMallQueryGoodsStockInfo pesappMallQueryGoodsStockInfo) {
        String callUrl = this.JD_CHECK_ADDRESS_URL;
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("provinceId", (Object)pesappMallQueryGoodsStockInfo.getProvince());
        jsonObject.put("cityId", (Object)pesappMallQueryGoodsStockInfo.getCity());
        jsonObject.put("countyId", (Object)pesappMallQueryGoodsStockInfo.getCounty());
        jsonObject.put("townId", (Object)(StringUtils.isEmpty((Object)pesappMallQueryGoodsStockInfo.getTown()) ? 0L : pesappMallQueryGoodsStockInfo.getTown()));
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)pesappMallQueryGoodsStockInfo.getHsn())) {
            jsonObject.put("hsn", (Object)HSN);
        } else {
            jsonObject.put("hsn", (Object)pesappMallQueryGoodsStockInfo.getHsn());
        }
        String timeStamp = DelFormatHelper.getNowTimeForString();
        jsonObject.put("timeStamp", (Object)timeStamp);
        jsonObject.put("serialNumber", (Object)("BUSINESS_COMMODITY" + timeStamp + PesappMallQueryGoodsStockServiceImpl.get4Random()));
        String jsonString = JSON.toJSONString((Object)jsonObject);
        log.info("\u4eac\u4e1c\u5730\u5740\u6821\u9a8c\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)callUrl, (Object)jsonString);
        String result = null;
        try {
            result = ComHttpUtil.sendPost((String)callUrl, (String)jsonObject.toJSONString());
            log.info("\u4eac\u4e1c\u5730\u5740\u6821\u9a8c\u51fa\u53c2: " + result);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ZTBusinessException("\u4eac\u4e1c\u5730\u5740\u6821\u9a8c\u5f02\u5e38" + e);
        }
        JSONObject rspJsonObject = JSONObject.parseObject((String)result);
        if (!rspJsonObject.getBoolean(JD_CHECK_ADDRESS_SUCCESS).booleanValue() || !"0000".equals(rspJsonObject.getString(ESB_RESULT_CODE))) {
            throw new ZTBusinessException("\u63d0\u4ea4\u5931\u8d25\uff01\u7531\u4e8e\u4eac\u4e1c\u5730\u5740\u4fe1\u606f\u5339\u914d\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u5904\u7406\uff08\u5f02\u5e38\u4ee3\u7801:" + rspJsonObject.getString(ESB_RESULT_CODE) + " :" + rspJsonObject.getString(ESB_RESULT_MESSAGE) + "\uff09");
        }
    }

    private static String get4Random() {
        int min = 1000;
        int max = 9999;
        Random random = new Random();
        int resultInt = random.nextInt(max) % (max - min + 1) + min;
        return String.valueOf(resultInt);
    }
}

