/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.selfrun.order.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.busicommon.api.DycBuriedPointCallFunction;
import com.tydic.dyc.atom.busicommon.bo.DycBuriedPointCallFuncBo;
import com.tydic.dyc.atom.busicommon.bo.DycBuriedPointCallFuncReqBo;
import com.tydic.dyc.atom.busicommon.bo.DycBuriedPointCallFuncRspBo;
import com.tydic.dyc.atom.busicommon.order.api.DycUocRefundPayFunction;
import com.tydic.dyc.atom.busicommon.order.bo.DycUocRefundPayFunctionReqBO;
import com.tydic.dyc.atom.busicommon.order.bo.DycUocRefundPayFunctionRspBO;
import com.tydic.dyc.atom.common.api.DycBusiProcessFlowFunction;
import com.tydic.dyc.atom.common.bo.DycBusiProcessFlowFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycBusiProcessFlowFuncRspBO;
import com.tydic.dyc.atom.pay.api.DycFscPayShouldPayCreateFunction;
import com.tydic.dyc.atom.pay.bo.DycFscPayShouldPayCreateFuncReqBO;
import com.tydic.dyc.atom.pay.bo.DycFscPayShouldPayCreateFuncRspBO;
import com.tydic.dyc.atom.pay.bo.DycFscShouldPayBO;
import com.tydic.dyc.base.constants.UocConstant;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.service.domainservice.UocShipOrderArrivaConfirmOrRefuseService;
import com.tydic.dyc.oc.service.domainservice.UocShouldPayCalculateService;
import com.tydic.dyc.oc.service.domainservice.UocShouldPayCreateService;
import com.tydic.dyc.oc.service.domainservice.bo.UocShipOrderArrivaConfirmOrRefuseReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocShipOrderArrivaConfirmOrRefuseRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocShouldPayCalculateReqBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocShouldPayCalculateRspBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocShouldPayCalculateShouldBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocShouldPayCreateBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocShouldPayCreateReqBO;
import com.tydic.dyc.selfrun.order.api.DycUocArrivalCommodityConfirmService;
import com.tydic.dyc.selfrun.order.bo.DycUocArrivalCommodityConfirmReqBO;
import com.tydic.dyc.selfrun.order.bo.DycUocArrivalCommodityConfirmRspBO;
import com.tydic.dyc.selfrun.order.bo.DycUocShipOrderTaskBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.selfrun.order.api.DycUocArrivalCommodityConfirmService"})
public class DycUocArrivalCommodityConfirmServiceImpl
implements DycUocArrivalCommodityConfirmService {
    private static final Logger log = LoggerFactory.getLogger(DycUocArrivalCommodityConfirmServiceImpl.class);
    private static final Integer OP_FLAG_REFUSE = 2;
    @Autowired
    private UocShipOrderArrivaConfirmOrRefuseService uocShipOrderArrivaConfirmOrRefuseService;
    @Autowired
    private DycBusiProcessFlowFunction dycBusiProcessFlowFunction;
    @Autowired
    private DycUocRefundPayFunction dycUocRefundPayFunction;
    @Autowired
    private UocShouldPayCalculateService uocShouldPayCalculateService;
    @Autowired
    private DycFscPayShouldPayCreateFunction dycFscPayShouldPayCreateFunction;
    @Autowired
    private UocShouldPayCreateService uocShouldPayCreateService;
    @Autowired
    private DycBuriedPointCallFunction dycBuriedPointCallFunction;
    @Lazy
    @Autowired
    private DycUocArrivalCommodityConfirmService dycUocArrivalCommodityConfirmService;
    @Value(value="${uoc.buriedpoint.enable:false}")
    private boolean buryPointEnable;
    @Value(value="${uoc.buriedpoint.url:http://192.168.0.15/ability}")
    private String buriedpointUrl;

    @Override
    @PostMapping(value={"arrivalCommodityConfirm"})
    public DycUocArrivalCommodityConfirmRspBO arrivalCommodityConfirm(@RequestBody DycUocArrivalCommodityConfirmReqBO reqBO) {
        this.verifyParam(reqBO);
        this.dealShipOrder(reqBO);
        if (OP_FLAG_REFUSE.equals(reqBO.getOpFlag())) {
            this.doRetrun(reqBO);
        } else {
            this.doPushShouldPay(reqBO);
        }
        this.flowBusiProcess(reqBO);
        this.buryPoint(reqBO);
        if (!CollectionUtils.isEmpty(reqBO.getShipOrderTaskBos())) {
            for (DycUocShipOrderTaskBO each : reqBO.getShipOrderTaskBos()) {
                JSONObject ShipOrderInfo = new JSONObject();
                ShipOrderInfo.put("orderId", (Object)reqBO.getOrderId());
                ShipOrderInfo.put("shipOrderId", (Object)each.getShipOrderId());
                ShipOrderInfo.put("userId", (Object)reqBO.getUserId());
                this.dycUocArrivalCommodityConfirmService.arrivalCommodityConfirmForTodo(ShipOrderInfo);
            }
        }
        return new DycUocArrivalCommodityConfirmRspBO();
    }

    @Override
    @PostMapping(value={"arrivalCommodityConfirmForTodo"})
    public DycUocArrivalCommodityConfirmRspBO arrivalCommodityConfirmForTodo(@RequestBody JSONObject shipOrderInfo) {
        return new DycUocArrivalCommodityConfirmRspBO();
    }

    private void doPushShouldPay(DycUocArrivalCommodityConfirmReqBO reqBO) {
        for (DycUocShipOrderTaskBO bo : reqBO.getShipOrderTaskBos()) {
            UocShouldPayCalculateReqBO uocShouldPayCalculateReqBO = new UocShouldPayCalculateReqBO();
            uocShouldPayCalculateReqBO.setObjId(bo.getShipOrderId());
            uocShouldPayCalculateReqBO.setOrderId(reqBO.getOrderId());
            uocShouldPayCalculateReqBO.setShouldPayType(UocConstant.SHOULD_PAY_TYPE.ACOUNT_DAY);
            uocShouldPayCalculateReqBO.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
            uocShouldPayCalculateReqBO.setPayNodeRule(UocConstant.PAY_NODE_RULE.ARRIVAL_COMMODITY);
            UocShouldPayCalculateRspBO dycUocCreateOrderShouldPayFuncRspBO = this.uocShouldPayCalculateService.calculate(uocShouldPayCalculateReqBO);
            if (!CollectionUtils.isEmpty((Collection)dycUocCreateOrderShouldPayFuncRspBO.getShouldPayList())) {
                DycFscPayShouldPayCreateFuncReqBO dycFscPayShouldPayCreateFuncReqBO = this.fillFscShouldPayCreateAttr(dycUocCreateOrderShouldPayFuncRspBO);
                DycFscPayShouldPayCreateFuncRspBO dycFscPayShouldPayCreateFuncRspBO = this.dycFscPayShouldPayCreateFunction.dealShouldPayCreate(dycFscPayShouldPayCreateFuncReqBO);
                UocShouldPayCreateReqBO dycUocShouldPayCreateFuncReqBO = this.fillUocShouldPayAttr(dycUocCreateOrderShouldPayFuncRspBO, dycFscPayShouldPayCreateFuncRspBO);
                dycUocShouldPayCreateFuncReqBO.setObjectType(UocDicConstant.OBJ_TYPE.SHIP);
                this.uocShouldPayCreateService.create(dycUocShouldPayCreateFuncReqBO);
            }
            UocShouldPayCalculateReqBO uocShouldPayCalculateForConstraintReqBO = new UocShouldPayCalculateReqBO();
            uocShouldPayCalculateForConstraintReqBO.setObjId(bo.getShipOrderId());
            uocShouldPayCalculateForConstraintReqBO.setOrderId(reqBO.getOrderId());
            uocShouldPayCalculateForConstraintReqBO.setShouldPayType(UocConstant.SHOULD_PAY_TYPE.SHIP);
            uocShouldPayCalculateForConstraintReqBO.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
            UocShouldPayCalculateRspBO dycUocCreateOrderShouldPayFuncForConstraintRspBO = this.uocShouldPayCalculateService.calculate(uocShouldPayCalculateForConstraintReqBO);
            if (CollectionUtils.isEmpty((Collection)dycUocCreateOrderShouldPayFuncForConstraintRspBO.getShouldPayList())) continue;
            DycFscPayShouldPayCreateFuncReqBO dycFscPayShouldPayCreateFuncReqBO = this.fillFscShouldPayCreateAttr(dycUocCreateOrderShouldPayFuncForConstraintRspBO);
            DycFscPayShouldPayCreateFuncRspBO dycFscPayShouldPayCreateFuncRspBO = this.dycFscPayShouldPayCreateFunction.dealShouldPayCreate(dycFscPayShouldPayCreateFuncReqBO);
            UocShouldPayCreateReqBO dycUocShouldPayCreateFuncReqBO = this.fillUocShouldPayAttr(dycUocCreateOrderShouldPayFuncForConstraintRspBO, dycFscPayShouldPayCreateFuncRspBO);
            dycUocShouldPayCreateFuncReqBO.setObjectType(UocDicConstant.OBJ_TYPE.SHIP);
            this.uocShouldPayCreateService.create(dycUocShouldPayCreateFuncReqBO);
        }
    }

    private DycFscPayShouldPayCreateFuncReqBO fillFscShouldPayCreateAttr(UocShouldPayCalculateRspBO dycUocCreateOrderShouldPayFuncRspBO) {
        ArrayList<DycFscShouldPayBO> fscShouldPayBOS = new ArrayList<DycFscShouldPayBO>();
        for (UocShouldPayCalculateShouldBO item : dycUocCreateOrderShouldPayFuncRspBO.getShouldPayList()) {
            DycFscShouldPayBO dycFscShouldPayBO = new DycFscShouldPayBO();
            dycFscShouldPayBO.setPayType(item.getPayType());
            dycFscShouldPayBO.setShouldPayType(item.getShouldPayType());
            dycFscShouldPayBO.setObjectId(item.getObjectId());
            dycFscShouldPayBO.setOrderId(item.getOrderId());
            dycFscShouldPayBO.setSaleVoucherId(item.getSaleOrderId());
            dycFscShouldPayBO.setObjectType(item.getObjectTypeReturn());
            dycFscShouldPayBO.setObjectNo(item.getObjectNo());
            dycFscShouldPayBO.setShouldPayAmount(item.getShouldPayAmount());
            dycFscShouldPayBO.setShouldPayDate(item.getShouldPayDate());
            dycFscShouldPayBO.setPayerId(item.getPayerId());
            dycFscShouldPayBO.setPayerName(item.getPayerName());
            dycFscShouldPayBO.setPayeeId(item.getPayeeId());
            dycFscShouldPayBO.setPayeeName(item.getPayeeName());
            dycFscShouldPayBO.setContractId(item.getContractId());
            dycFscShouldPayBO.setContractNo(item.getContractNo());
            dycFscShouldPayBO.setPenaltyRatio(item.getPenaltyRatio());
            fscShouldPayBOS.add(dycFscShouldPayBO);
        }
        DycFscPayShouldPayCreateFuncReqBO dycFscPayShouldPayCreateFuncReqBO = new DycFscPayShouldPayCreateFuncReqBO();
        dycFscPayShouldPayCreateFuncReqBO.setFscShouldPayBOS(fscShouldPayBOS);
        return dycFscPayShouldPayCreateFuncReqBO;
    }

    private UocShouldPayCreateReqBO fillUocShouldPayAttr(UocShouldPayCalculateRspBO dycUocCreateOrderShouldPayFuncRspBO, DycFscPayShouldPayCreateFuncRspBO dycFscPayShouldPayCreateFuncRspBO) {
        HashMap map = new HashMap();
        dycFscPayShouldPayCreateFuncRspBO.getFscShouldPayRspBOs().forEach(item -> map.put(item.getPayerId().toString() + item.getPayeeId().toString(), item.getShouldPayId()));
        ArrayList<UocShouldPayCreateBo> uocShouldPayCreateBoList = new ArrayList<UocShouldPayCreateBo>();
        for (UocShouldPayCalculateShouldBO item2 : dycUocCreateOrderShouldPayFuncRspBO.getShouldPayList()) {
            UocShouldPayCreateBo dycUocShouldPayCreateFuncBO = (UocShouldPayCreateBo)JUtil.js((Object)item2, UocShouldPayCreateBo.class);
            dycUocShouldPayCreateFuncBO.setFscShouldPayId((Long)map.get(item2.getPayerId().toString() + item2.getPayeeId().toString()));
            uocShouldPayCreateBoList.add(dycUocShouldPayCreateFuncBO);
        }
        UocShouldPayCreateReqBO dycUocShouldPayCreateFuncReqBO = new UocShouldPayCreateReqBO();
        dycUocShouldPayCreateFuncReqBO.setUocShouldPayCreateBoList(uocShouldPayCreateBoList);
        return dycUocShouldPayCreateFuncReqBO;
    }

    private void doRetrun(DycUocArrivalCommodityConfirmReqBO reqBO) {
        List shipOrderIds = reqBO.getShipOrderTaskBos().stream().map(DycUocShipOrderTaskBO::getShipOrderId).collect(Collectors.toList());
        DycUocRefundPayFunctionReqBO dycUocRefundPayFunctionReqBO = (DycUocRefundPayFunctionReqBO)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), DycUocRefundPayFunctionReqBO.class);
        dycUocRefundPayFunctionReqBO.setShipOrderIds(shipOrderIds);
        dycUocRefundPayFunctionReqBO.setReturnNode("3");
        DycUocRefundPayFunctionRspBO dycUocRefundPayFunctionRspBO = this.dycUocRefundPayFunction.refundPay(dycUocRefundPayFunctionReqBO);
        if (!"0000".equals(dycUocRefundPayFunctionRspBO.getRespCode())) {
            throw new ZTBusinessException("\u652f\u4ed8\u9000\u6b3e\u5931\u8d25");
        }
    }

    private void dealShipOrder(DycUocArrivalCommodityConfirmReqBO reqBo) {
        UocShipOrderArrivaConfirmOrRefuseReqBo uocShipOrderArrivaConfirmOrRefuseReqBo = (UocShipOrderArrivaConfirmOrRefuseReqBo)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBo)), UocShipOrderArrivaConfirmOrRefuseReqBo.class);
        List shipOrderIds = reqBo.getShipOrderTaskBos().stream().map(DycUocShipOrderTaskBO::getShipOrderId).distinct().collect(Collectors.toList());
        uocShipOrderArrivaConfirmOrRefuseReqBo.setShipOrderIdList(shipOrderIds);
        List taskIds = reqBo.getShipOrderTaskBos().stream().map(DycUocShipOrderTaskBO::getTaskId).distinct().collect(Collectors.toList());
        uocShipOrderArrivaConfirmOrRefuseReqBo.setTaskIds(taskIds);
        UocShipOrderArrivaConfirmOrRefuseRspBo uocShipOrderArrivaConfirmOrRefuseRspBo = this.uocShipOrderArrivaConfirmOrRefuseService.dealArriva(uocShipOrderArrivaConfirmOrRefuseReqBo);
        if (!"0000".equals(uocShipOrderArrivaConfirmOrRefuseRspBo.getRespCode())) {
            throw new ZTBusinessException("\u5230\u8d27\u786e\u8ba4/\u62d2\u6536\u5931\u8d25" + uocShipOrderArrivaConfirmOrRefuseRspBo.getRespDesc());
        }
    }

    private void flowBusiProcess(DycUocArrivalCommodityConfirmReqBO reqBo) {
        for (DycUocShipOrderTaskBO dycUocShipOrderTaskBO : reqBo.getShipOrderTaskBos()) {
            DycBusiProcessFlowFuncReqBO dycBusiProcessFlowFuncReqBO = new DycBusiProcessFlowFuncReqBO();
            dycBusiProcessFlowFuncReqBO.setTaskId(dycUocShipOrderTaskBO.getTaskId());
            HashMap<String, Object> variables = new HashMap<String, Object>();
            if (reqBo.getOpFlag() == 1) {
                variables.put("properCastFlag", 1);
            } else {
                variables.put("properCastFlag", 0);
            }
            variables.put("userId", reqBo.getUserId());
            variables.put("userName", reqBo.getName());
            dycBusiProcessFlowFuncReqBO.setVariables(variables);
            DycBusiProcessFlowFuncRspBO dycBusiProcessFlowFuncRspBO = this.dycBusiProcessFlowFunction.flowBusiProcess(dycBusiProcessFlowFuncReqBO);
            if ("0000".equals(dycBusiProcessFlowFuncRspBO.getRespCode())) continue;
            throw new ZTBusinessException("\u6d41\u7a0b\u6d41\u8f6c\u5931\u8d25\uff1a" + dycBusiProcessFlowFuncRspBO.getRespDesc());
        }
    }

    private void buryPoint(DycUocArrivalCommodityConfirmReqBO contextBO) {
        DycBuriedPointCallFuncReqBo funcReqBo = new DycBuriedPointCallFuncReqBo();
        funcReqBo.setEnable(Boolean.valueOf(this.buryPointEnable));
        JSONObject jsonObject = new JSONObject();
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        List<DycUocShipOrderTaskBO> shipOrderTaskBos = contextBO.getShipOrderTaskBos();
        for (DycUocShipOrderTaskBO dycUocShipOrderTaskBO : shipOrderTaskBos) {
            jsonObject.put("orderId", (Object)contextBO.getOrderId());
            jsonObject.put("shipOrderId", (Object)dycUocShipOrderTaskBO.getShipOrderId());
            list.add(jsonObject);
        }
        ArrayList<DycBuriedPointCallFuncBo> buildsList = new ArrayList<DycBuriedPointCallFuncBo>();
        for (JSONObject j : list) {
            DycBuriedPointCallFuncBo bo = new DycBuriedPointCallFuncBo();
            bo.setIdent("UPDATA");
            bo.setDycBusiCode("sendOrderSync");
            bo.setDycCenterCode("UOC");
            bo.setData((Object)j);
            buildsList.add(bo);
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("saleOrderId", (Object)contextBO.getSaleOrderId());
        jSONObject.put("orderId", (Object)contextBO.getOrderId());
        DycBuriedPointCallFuncBo bo1 = new DycBuriedPointCallFuncBo();
        bo1.setIdent("UPDATA");
        bo1.setDycBusiCode("saleOrderSync");
        bo1.setDycCenterCode("UOC");
        bo1.setData((Object)jSONObject);
        buildsList.add(bo1);
        funcReqBo.setBusiList(buildsList);
        DycBuriedPointCallFuncRspBo funcRspBo = this.dycBuriedPointCallFunction.callAbility(funcReqBo);
        if (!"0000".equals(funcRspBo.getRespCode())) {
            log.error("\u5230\u8d27\u786e\u8ba4\u53d8\u66f4\u53d1\u8d27\u5355,\u53d8\u66f4\u9500\u552e\u5355\u540e\u8fdb\u884c\u57cb\u70b9\uff08\u53d8\u66f4\uff09\u540e\u8fdb\u884c\u57cb\u70b9\u5931\u8d25\uff1a" + funcRspBo.getRespDesc());
        }
    }

    private void verifyParam(DycUocArrivalCommodityConfirmReqBO reqBo) {
        if (null == reqBo) {
            throw new ZTBusinessException("\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderId()) {
            throw new ZTBusinessException("\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new ZTBusinessException("\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(reqBo.getShipOrderTaskBos())) {
            throw new ZTBusinessException("\u53d1\u8d27\u5355\u4fe1\u606f\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOpFlag()) {
            throw new ZTBusinessException("\u64cd\u4f5c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getUserId()) {
            throw new ZTBusinessException("\u5f53\u524d\u767b\u5f55\u4ebaID\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getName())) {
            throw new ZTBusinessException("\u5f53\u524d\u767b\u5f55\u4eba\u540d\u79f0\u4e3a\u7a7a");
        }
    }
}

