/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.selfrun.order.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.busicommon.api.DycBuriedPointCallFunction;
import com.tydic.dyc.atom.busicommon.bo.DycBuriedPointCallFuncBo;
import com.tydic.dyc.atom.busicommon.bo.DycBuriedPointCallFuncReqBo;
import com.tydic.dyc.atom.busicommon.bo.DycBuriedPointCallFuncRspBo;
import com.tydic.dyc.atom.common.api.DycBusiProcessFlowFunction;
import com.tydic.dyc.atom.common.bo.DycBusiProcessFlowFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycBusiProcessFlowFuncRspBO;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryAddBo;
import com.tydic.dyc.oc.service.shiporder.UocShipOrderArrivaRegistService;
import com.tydic.dyc.oc.service.shiporder.bo.UocShipOrderArrivaRegistReqBo;
import com.tydic.dyc.oc.service.shiporder.bo.UocShipOrderArrivaRegistRspBo;
import com.tydic.dyc.selfrun.order.api.DycUocArrivalCommodityRegisterService;
import com.tydic.dyc.selfrun.order.bo.DycUocArrivalCommodityRegisterReqBO;
import com.tydic.dyc.selfrun.order.bo.DycUocArrivalCommodityRegisterRspBO;
import com.tydic.dyc.selfrun.order.bo.DycUocShipOrderTaskBO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.selfrun.order.api.DycUocArrivalCommodityRegisterService"})
public class DycUocArrivalCommodityRegisterServiceImpl
implements DycUocArrivalCommodityRegisterService {
    private static final Logger log = LoggerFactory.getLogger(DycUocArrivalCommodityRegisterServiceImpl.class);
    @Autowired
    private UocShipOrderArrivaRegistService uocShipOrderArrivaRegistService;
    @Autowired
    private DycBusiProcessFlowFunction dycBusiProcessFlowFunction;
    @Autowired
    private DycBuriedPointCallFunction dycBuriedPointCallFunction;
    @Value(value="${uoc.buriedpoint.enable:false}")
    private boolean buryPointEnable;
    @Value(value="${uoc.buriedpoint.url:http://192.168.0.15/ability}")
    private String buriedpointUrl;
    @Lazy
    @Autowired
    private DycUocArrivalCommodityRegisterService dycUocArrivalCommodityRegisterService;

    @Override
    @PostMapping(value={"arrivalCommodityRegister"})
    public DycUocArrivalCommodityRegisterRspBO arrivalCommodityRegister(@RequestBody DycUocArrivalCommodityRegisterReqBO registerReqBO) {
        this.verifyParam(registerReqBO);
        this.arrivalRegister(registerReqBO);
        this.flowBusiProcess(registerReqBO);
        this.buryPoint(registerReqBO);
        if (ObjectUtil.isNotEmpty(registerReqBO.getShipOrderTaskBos())) {
            registerReqBO.getShipOrderTaskBos().forEach(shipOrder -> {
                JSONObject shipOrderInfo = new JSONObject();
                shipOrderInfo.put("orderId", (Object)registerReqBO.getOrderId());
                shipOrderInfo.put("shipOrderId", (Object)shipOrder.getShipOrderId());
                shipOrderInfo.put("userId", (Object)registerReqBO.getUserId());
                this.dycUocArrivalCommodityRegisterService.arrivalCommodityRegisterForTodo(shipOrderInfo);
            });
        }
        return new DycUocArrivalCommodityRegisterRspBO();
    }

    @Override
    @PostMapping(value={"arrivalCommodityRegisterForTodo"})
    public DycUocArrivalCommodityRegisterRspBO arrivalCommodityRegisterForTodo(@RequestBody JSONObject shipOrderInfo) {
        return new DycUocArrivalCommodityRegisterRspBO();
    }

    private void flowBusiProcess(DycUocArrivalCommodityRegisterReqBO reqBo) {
        for (DycUocShipOrderTaskBO dycUocShipOrderTaskBO : reqBo.getShipOrderTaskBos()) {
            DycBusiProcessFlowFuncReqBO flowFuncReqBO = new DycBusiProcessFlowFuncReqBO();
            flowFuncReqBO.setTaskId(dycUocShipOrderTaskBO.getTaskId());
            HashMap<String, Object> variables = new HashMap<String, Object>();
            variables.put("userId", reqBo.getUserId());
            variables.put("userName", reqBo.getName());
            flowFuncReqBO.setVariables(variables);
            DycBusiProcessFlowFuncRspBO dycBusiProcessFlowFuncRspBO = this.dycBusiProcessFlowFunction.flowBusiProcess(flowFuncReqBO);
            if ("0000".equals(dycBusiProcessFlowFuncRspBO.getRespCode())) continue;
            throw new ZTBusinessException("\u53d1\u8d27\u5355\u6d41\u7a0b\u6d41\u8f6c\u5931\u8d25\uff1a" + dycBusiProcessFlowFuncRspBO.getRespDesc());
        }
    }

    private void arrivalRegister(DycUocArrivalCommodityRegisterReqBO reqBo) {
        UocShipOrderArrivaRegistReqBo uocShipOrderArrivaRegistReqBo = (UocShipOrderArrivaRegistReqBo)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBo)), UocShipOrderArrivaRegistReqBo.class);
        List shipOrderIds = reqBo.getShipOrderTaskBos().stream().map(DycUocShipOrderTaskBO::getShipOrderId).distinct().collect(Collectors.toList());
        uocShipOrderArrivaRegistReqBo.setShipOrderIdList(shipOrderIds);
        List taskIds = reqBo.getShipOrderTaskBos().stream().map(DycUocShipOrderTaskBO::getTaskId).distinct().collect(Collectors.toList());
        uocShipOrderArrivaRegistReqBo.setTaskIds(taskIds);
        uocShipOrderArrivaRegistReqBo.setArriveRemark(reqBo.getRemark());
        uocShipOrderArrivaRegistReqBo.setOrderAccessoryList(JSONArray.parseArray((String)JSON.toJSONString(reqBo.getOrderAccessoryBoList()), UocBaseOrderAccessoryAddBo.class));
        UocShipOrderArrivaRegistRspBo uocShipOrderArrivaRegistRspBo = this.uocShipOrderArrivaRegistService.dealShipOrderArrivaRegist(uocShipOrderArrivaRegistReqBo);
        if (!"0000".equals(uocShipOrderArrivaRegistRspBo.getRespCode())) {
            throw new ZTBusinessException("\u53d1\u8d27\u5355\u5230\u8d27\u767b\u8bb0\u5931\u8d25\uff1a" + uocShipOrderArrivaRegistRspBo.getRespDesc());
        }
    }

    private void buryPoint(DycUocArrivalCommodityRegisterReqBO contextBO) {
        DycBuriedPointCallFuncReqBo funcReqBo = new DycBuriedPointCallFuncReqBo();
        funcReqBo.setEnable(Boolean.valueOf(this.buryPointEnable));
        JSONObject jsonObject = new JSONObject();
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        List<DycUocShipOrderTaskBO> shipOrderTaskBos = contextBO.getShipOrderTaskBos();
        for (DycUocShipOrderTaskBO dycUocShipOrderTaskBO : shipOrderTaskBos) {
            jsonObject.put("orderId", (Object)contextBO.getOrderId());
            jsonObject.put("shipOrderId", (Object)dycUocShipOrderTaskBO.getShipOrderId());
            list.add(jsonObject);
        }
        ArrayList<DycBuriedPointCallFuncBo> buildsList = new ArrayList<DycBuriedPointCallFuncBo>();
        for (JSONObject j : list) {
            DycBuriedPointCallFuncBo bo = new DycBuriedPointCallFuncBo();
            bo.setIdent("UPDATA");
            bo.setDycBusiCode("sendOrderSync");
            bo.setDycCenterCode("UOC");
            bo.setData((Object)j);
            buildsList.add(bo);
        }
        funcReqBo.setBusiList(buildsList);
        DycBuriedPointCallFuncRspBo dycBuriedPointCallFuncRspBo = this.dycBuriedPointCallFunction.callAbility(funcReqBo);
        if (!"0000".equals(dycBuriedPointCallFuncRspBo.getRespCode())) {
            log.error("\u5230\u8d27\u767b\u8bb0\u53d1\u8d27\u5355\u540e\u8fdb\u884c\u57cb\u70b9\uff08\u53d8\u66f4\uff09\u540e\u8fdb\u884c\u57cb\u70b9\u5931\u8d25\uff1a" + dycBuriedPointCallFuncRspBo.getRespDesc());
        }
    }

    private void verifyParam(DycUocArrivalCommodityRegisterReqBO reqBo) {
        if (null == reqBo) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderId()) {
            throw new ZTBusinessException("\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new ZTBusinessException("\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(reqBo.getShipOrderTaskBos())) {
            throw new ZTBusinessException("\u53d1\u8d27\u5355\u4fe1\u606f\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getUserId()) {
            throw new ZTBusinessException("\u5f53\u524d\u767b\u5f55\u4ebaID\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getName())) {
            throw new ZTBusinessException("\u5f53\u524d\u767b\u5f55\u4eba\u540d\u79f0\u4e3a\u7a7a");
        }
    }
}

