/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.selfrun.order.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.busicommon.api.DycBuriedPointCallFunction;
import com.tydic.dyc.atom.common.api.DycBusiProcessFlowFunction;
import com.tydic.dyc.atom.common.bo.DycBusiProcessFlowFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycBusiProcessFlowFuncRspBO;
import com.tydic.dyc.oc.service.domainservice.UocCalculateSaleOrderFeeService;
import com.tydic.dyc.oc.service.domainservice.UocChngOrderConfirmOrRefuseForInspService;
import com.tydic.dyc.oc.service.domainservice.UocChngOrderModifyStateService;
import com.tydic.dyc.oc.service.domainservice.UocInspOrderModifyRemainInspCountService;
import com.tydic.dyc.oc.service.domainservice.bo.UocChngOrderConfirmOrRefuseForInspReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocChngOrderConfirmOrRefuseForInspRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocInspOrderBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocInspOrderItemBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleOrderBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleOrderItemBO;
import com.tydic.dyc.oc.service.order.UocAddOrderInterLogService;
import com.tydic.dyc.oc.service.saleorder.UocGetSaleOrderDetailService;
import com.tydic.dyc.selfrun.order.api.DycUocExceptionChangeConfimForInspService;
import com.tydic.dyc.selfrun.order.bo.DycUocExceptionChangeConfimForInspReqBO;
import com.tydic.dyc.selfrun.order.bo.DycUocExceptionChangeConfimForInspRspBO;
import com.tydic.fsc.bill.ability.api.FscBillChangeInfoAbilityService;
import com.tydic.fsc.bill.ability.api.FscExceptionChangeCheckStateUpdateAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillChangeInfoAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillChangeInfoAbilityRspBO;
import com.tydic.fsc.bo.FscOrderItemBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.selfrun.order.api.DycUocExceptionChangeConfimForInspService"})
public class DycUocExceptionChangeConfimForInspServiceImpl
implements DycUocExceptionChangeConfimForInspService {
    private static final Logger log = LoggerFactory.getLogger(DycUocExceptionChangeConfimForInspServiceImpl.class);
    @Autowired
    private UocChngOrderConfirmOrRefuseForInspService uocChngOrderConfirmOrRefuseForInspService;
    @Autowired
    private FscExceptionChangeCheckStateUpdateAbilityService fscExceptionChangeCheckStateUpdateAbilityService;
    @Autowired
    private DycBusiProcessFlowFunction dycBusiProcessFlowFunction;
    @Autowired
    private DycBuriedPointCallFunction dycBuriedPointCallFunction;
    @Autowired
    private FscBillChangeInfoAbilityService fscBillChangeInfoAbilityService;
    @Value(value="${uoc.buriedpoint.enable:false}")
    private boolean buryPointEnable;
    @Value(value="${uoc.adjustBudgetExt:true}")
    private boolean adjustBudgetExt;
    @Autowired
    private UocCalculateSaleOrderFeeService uocCalculateSaleOrderFeeService;
    @Autowired
    private UocGetSaleOrderDetailService uocGetSaleOrderDetailService;
    @Autowired
    private UocAddOrderInterLogService uocAddOrderInterLogService;
    @Autowired
    private UocChngOrderModifyStateService uocChngOrderModifyStateService;
    private static final Integer OP_FLAG_CONFIRM = 1;
    public static final String CHNG_CHNG_YSZ = "CHNG_CHNG_YSZ";
    public static final String CHNG_CHNG_QX = "CHNG_CHNG_QX";
    @Autowired
    private UocInspOrderModifyRemainInspCountService uocInspOrderModifyRemainInspCountService;
    @Lazy
    @Autowired
    private DycUocExceptionChangeConfimForInspService dycUocExceptionChangeConfimForInspService;

    @Override
    @PostMapping(value={"dealExceptionChangeConfimForInsp"})
    public DycUocExceptionChangeConfimForInspRspBO dealExceptionChangeConfimForInsp(@RequestBody DycUocExceptionChangeConfimForInspReqBO reqBO) {
        this.checkParam(reqBO);
        UocChngOrderConfirmOrRefuseForInspReqBo uocChngOrderConfirmOrRefuseForInspReqBo = (UocChngOrderConfirmOrRefuseForInspReqBo)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), UocChngOrderConfirmOrRefuseForInspReqBo.class);
        UocChngOrderConfirmOrRefuseForInspRspBo uocChngOrderConfirmOrRefuseForInspRspBo = this.uocChngOrderConfirmOrRefuseForInspService.dealConfirmOrRefuse(uocChngOrderConfirmOrRefuseForInspReqBo);
        if (!"0000".equals(uocChngOrderConfirmOrRefuseForInspRspBo.getRespCode())) {
            throw new ZTBusinessException(uocChngOrderConfirmOrRefuseForInspRspBo.getRespDesc());
        }
        List saleOrderBOList = uocChngOrderConfirmOrRefuseForInspRspBo.getSaleOrderBOList();
        if (reqBO.getOpFlag().equals(OP_FLAG_CONFIRM)) {
            this.syncFscInspChange(uocChngOrderConfirmOrRefuseForInspRspBo, saleOrderBOList);
        }
        reqBO.getChngOrderList().forEach(dycUocChngOrderListBO -> {
            DycBusiProcessFlowFuncReqBO flowFuncReqBO = new DycBusiProcessFlowFuncReqBO();
            HashMap<String, Object> variables = new HashMap<String, Object>();
            variables.put("userId", reqBO.getUserId());
            variables.put("userName", reqBO.getUsername());
            variables.put("opFlag", reqBO.getOpFlag());
            variables.put("saleOrderNo", dycUocChngOrderListBO.getSaleOrderNo());
            flowFuncReqBO.setVariables(variables);
            flowFuncReqBO.setTaskId(dycUocChngOrderListBO.getTaskId());
            this.dycBusiProcessFlowFunction.flowBusiProcess(flowFuncReqBO);
            JSONObject chngOrderInfo = new JSONObject();
            chngOrderInfo.put("orderId", (Object)dycUocChngOrderListBO.getOrderId());
            chngOrderInfo.put("chngOrderId", (Object)dycUocChngOrderListBO.getChngOrderId());
            chngOrderInfo.put("opFlag", (Object)reqBO.getOpFlag());
            chngOrderInfo.put("userId", (Object)reqBO.getUserId());
            this.dycUocExceptionChangeConfimForInspService.dealExceptionChangeConfimForInspForTodo(chngOrderInfo);
        });
        if (!CollectionUtils.isEmpty((Collection)uocChngOrderConfirmOrRefuseForInspRspBo.getSaleOrderTaskInstList())) {
            uocChngOrderConfirmOrRefuseForInspRspBo.getSaleOrderTaskInstList().forEach(taskInstBo -> {
                if ("E0011".equals(taskInstBo.getStepId())) {
                    DycBusiProcessFlowFuncReqBO flowFuncReqBO = new DycBusiProcessFlowFuncReqBO();
                    flowFuncReqBO.setTaskId(taskInstBo.getTaskId());
                    HashMap<String, Object> variables = new HashMap<String, Object>();
                    variables.put("exceptionChangeFlag", "1");
                    variables.put("userId", reqBO.getUserId());
                    variables.put("userName", reqBO.getName());
                    flowFuncReqBO.setVariables(variables);
                    log.info("\u201c\u7b49\u5f85\u62d2\u6536\u201d\u73af\u8282\u6d41\u8f6c\u6210\u201c\u8ba2\u5355\u9a8c\u6536\u201d\u73af\u8282\uff0c\u6d41\u7a0b\u6d41\u8f6c\u5165\u53c2:" + JSON.toJSONString((Object)flowFuncReqBO));
                    DycBusiProcessFlowFuncRspBO flowFuncRspBO = this.dycBusiProcessFlowFunction.flowBusiProcess(flowFuncReqBO);
                    if (!"0000".equals(flowFuncRspBO.getRespCode())) {
                        throw new ZTBusinessException("\u8c03\u7528\u6d41\u7a0b\u4e2d\u5fc3\u5931\u8d25\uff1a" + flowFuncRspBO.getRespDesc());
                    }
                }
            });
        }
        return new DycUocExceptionChangeConfimForInspRspBO();
    }

    @Override
    @PostMapping(value={"dealExceptionChangeConfimForInspForTodo"})
    public DycUocExceptionChangeConfimForInspRspBO dealExceptionChangeConfimForInspForTodo(@RequestBody JSONObject chngOrderInfo) {
        return new DycUocExceptionChangeConfimForInspRspBO();
    }

    private void syncFscInspChange(UocChngOrderConfirmOrRefuseForInspRspBo uocChngOrderConfirmOrRefuseForInspRspBo, List<UocSaleOrderBO> saleOrderBOList) {
        List inspOrderBoList = uocChngOrderConfirmOrRefuseForInspRspBo.getInspOrderBoList();
        List saleOrderItemList = uocChngOrderConfirmOrRefuseForInspRspBo.getSaleOrderItemList();
        Map<Long, UocSaleOrderBO> saleOrderBOMap = saleOrderBOList.stream().collect(Collectors.toMap(UocSaleOrderBO::getSaleOrderId, e -> e));
        Map<Long, UocSaleOrderItemBO> saleOrderItemBOMap = saleOrderItemList.stream().collect(Collectors.toMap(UocSaleOrderItemBO::getSaleOrderItemId, e -> e));
        for (UocInspOrderBo each : inspOrderBoList) {
            FscBillChangeInfoAbilityReqBO fscBillChangeInfoAbilityReqBO = new FscBillChangeInfoAbilityReqBO();
            fscBillChangeInfoAbilityReqBO.setOrderId(each.getOrderId());
            fscBillChangeInfoAbilityReqBO.setOrderSource(String.valueOf(saleOrderBOMap.get(each.getSaleOrderId()).getOrderSource()));
            fscBillChangeInfoAbilityReqBO.setSupplierId(Long.valueOf(saleOrderBOMap.get(each.getSaleOrderId()).getStakeholder().getSupId()));
            fscBillChangeInfoAbilityReqBO.setAcceptOrderId(each.getInspOrderId());
            fscBillChangeInfoAbilityReqBO.setOtherNo(saleOrderBOMap.get(each.getSaleOrderId()).getSaleOrderNo());
            fscBillChangeInfoAbilityReqBO.setMyAmount(each.getTotalPurchaseFee());
            fscBillChangeInfoAbilityReqBO.setSaleAmount(each.getTotalSaleFee());
            List inspOrderItemBos = each.getUocInspOrderItemList();
            ArrayList<FscOrderItemBO> fscOrderItemBOList = new ArrayList<FscOrderItemBO>();
            for (UocInspOrderItemBo itemBo : inspOrderItemBos) {
                FscOrderItemBO fscOrderItemBO = new FscOrderItemBO();
                fscOrderItemBO.setOrderItemId(itemBo.getInspOrderItemId());
                fscOrderItemBO.setPrice(saleOrderItemBOMap.get(itemBo.getSaleOrderItemId()).getSalePrice());
                fscOrderItemBO.setPurchasePrice(saleOrderItemBOMap.get(itemBo.getSaleOrderItemId()).getPurchasePrice());
                fscOrderItemBO.setAmt(itemBo.getInspCount().multiply(fscOrderItemBO.getPrice()));
                fscOrderItemBO.setPurchaseAmt(itemBo.getInspCount().multiply(fscOrderItemBO.getPurchasePrice()));
                fscOrderItemBO.setUntaxAmt(itemBo.getInspCount().multiply(fscOrderItemBO.getPrice()));
                fscOrderItemBO.setNum(itemBo.getInspCount());
                fscOrderItemBOList.add(fscOrderItemBO);
            }
            fscBillChangeInfoAbilityReqBO.setFscOrderItemBOList(fscOrderItemBOList);
            log.info("\u8c03\u7528\u7ed3\u7b97\u66f4\u65b0\u72b6\u6001\u5165\u53c2 \uff1a{}", (Object)JSON.toJSONString((Object)fscBillChangeInfoAbilityReqBO));
            FscBillChangeInfoAbilityRspBO fscBillChangeInfoAbilityRspBO = this.fscBillChangeInfoAbilityService.dealBillChange(fscBillChangeInfoAbilityReqBO);
            log.info("\u8c03\u7528\u7ed3\u7b97\u66f4\u65b0\u72b6\u6001\u51fa\u53c2 \uff1a{}", (Object)JSON.toJSONString((Object)fscBillChangeInfoAbilityRspBO));
        }
    }

    private void checkParam(DycUocExceptionChangeConfimForInspReqBO reqBO) {
        if (reqBO.getOpFlag() == null) {
            throw new ZTBusinessException("\u786e\u8ba4\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getOpFlag() == 0 && reqBO.getRejectRemark() == null) {
            throw new ZTBusinessException("\u62d2\u7edd\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(reqBO.getChngOrderList())) {
            throw new ZTBusinessException("\u53d8\u66f4\u5355\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqBO.getChngOrderList().forEach(obj -> {
            if (obj.getOrderId() == null) {
                throw new ZTBusinessException("\u53d8\u66f4\u5355\u660e\u7ec6-\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (obj.getChngOrderId() == null) {
                throw new ZTBusinessException("\u53d8\u66f4\u5355\u660e\u7ec6-\u53d8\u66f4\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (obj.getTaskId() == null) {
                throw new ZTBusinessException("\u53d8\u66f4\u5355\u660e\u7ec6-\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
        });
    }
}

