/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.selfrun.order.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.atom.common.api.DycGeneralQueryFunction;
import com.tydic.dyc.atom.common.bo.DycGeneralQueryFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycGeneralQueryFuncRspBO;
import com.tydic.dyc.selfrun.order.api.DycUocOvertimeApprovalService;
import com.tydic.dyc.selfrun.order.bo.DycUocOvertimeOrderReqBO;
import com.tydic.dyc.selfrun.order.bo.DycUocOvertimeOrderRspBO;
import com.tydic.dyc.selfrun.order.bo.DycUocSalOrderListQryReqBO;
import com.tydic.dyc.selfrun.order.bo.DycUocSalOrderListQryRspBO;
import com.tydic.dyc.selfrun.order.bo.DycUocSaleOrderInfoBO;
import com.tydic.dyc.selfrun.order.bo.DycUocTaskInstInfoBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.selfrun.order.api.DycUocOvertimeApprovalService"})
public class DycUocOvertimeApprovalServiceImpl
implements DycUocOvertimeApprovalService {
    private static final Logger log = LoggerFactory.getLogger(DycUocOvertimeApprovalServiceImpl.class);
    @Autowired
    private DycGeneralQueryFunction dycGeneralQueryFunction;
    @Lazy
    @Autowired
    private DycUocOvertimeApprovalService dycUocOvertimeApprovalService;

    @Override
    @PostMapping(value={"overtimeApproval"})
    public DycUocOvertimeOrderRspBO overtimeApproval(@RequestBody DycUocOvertimeOrderReqBO reqBO) {
        log.info("\u672a\u5ba1\u6279\u5165\u53c2" + reqBO.getShardingParameter());
        List<DycUocSaleOrderInfoBO> dycUocSaleOrderInfoBOS = this.qrySaleOrderList(reqBO.getShardingParameter());
        dycUocSaleOrderInfoBOS.forEach(obj -> {
            JSONObject saleOrderInfo = new JSONObject();
            saleOrderInfo.put("orderId", (Object)obj.getOrderId());
            saleOrderInfo.put("saleOrderId", (Object)obj.getSaleOrderId());
            saleOrderInfo.put("warnTime", (Object)reqBO.getShardingParameter());
            saleOrderInfo.put("userId", (Object)1L);
            saleOrderInfo.put("dealIds", obj.getAuditTaskInstBos().stream().map(DycUocTaskInstInfoBO::getDealId).collect(Collectors.toList()));
            this.dycUocOvertimeApprovalService.overtimeApprovalForTodo(saleOrderInfo);
        });
        return new DycUocOvertimeOrderRspBO();
    }

    @Override
    @PostMapping(value={"overtimeApprovalForTodo"})
    public DycUocOvertimeOrderRspBO overtimeApprovalForTodo(@RequestBody JSONObject saleOrderInfo) {
        return new DycUocOvertimeOrderRspBO();
    }

    private List<DycUocSaleOrderInfoBO> qrySaleOrderList(String time) {
        DycUocSalOrderListQryReqBO salOrderListQryReqBO = new DycUocSalOrderListQryReqBO();
        DycGeneralQueryFuncReqBO queryFuncReqBO = new DycGeneralQueryFuncReqBO();
        DycGeneralQueryFuncRspBO dycGeneralQueryFuncRspBO = new DycGeneralQueryFuncRspBO();
        DycUocSalOrderListQryRspBO qryRspBO = new DycUocSalOrderListQryRspBO();
        salOrderListQryReqBO.setSaleOrderStates(Arrays.asList("XS_SP_SPZ"));
        queryFuncReqBO.setReqParams(JSON.toJSONString((Object)((Object)salOrderListQryReqBO)));
        queryFuncReqBO.setQueryCountFlag(Boolean.valueOf(true));
        dycGeneralQueryFuncRspBO = this.dycGeneralQueryFunction.generalQuery(queryFuncReqBO);
        qryRspBO = (DycUocSalOrderListQryRspBO)((Object)JSONObject.parseObject((String)dycGeneralQueryFuncRspBO.getRspJsonStr(), DycUocSalOrderListQryRspBO.class));
        Integer total = qryRspBO.getRecordsTotal() % 10 == 0 ? qryRspBO.getRecordsTotal() / 10 : qryRspBO.getRecordsTotal() / 10 + 1;
        ArrayList<DycUocSaleOrderInfoBO> uocSaleOrderInfoBOList = new ArrayList<DycUocSaleOrderInfoBO>();
        for (int i = 1; i <= total; ++i) {
            salOrderListQryReqBO.setPageNo(i);
            queryFuncReqBO.setQueryCountFlag(Boolean.valueOf(false));
            queryFuncReqBO.setReqParams(JSON.toJSONString((Object)((Object)salOrderListQryReqBO)));
            dycGeneralQueryFuncRspBO = this.dycGeneralQueryFunction.generalQuery(queryFuncReqBO);
            qryRspBO = (DycUocSalOrderListQryRspBO)((Object)JSONObject.parseObject((String)dycGeneralQueryFuncRspBO.getRspJsonStr(), DycUocSalOrderListQryRspBO.class));
            List<DycUocSaleOrderInfoBO> saleOrderInfoBOList = qryRspBO.getRows();
            saleOrderInfoBOList = saleOrderInfoBOList.stream().filter(obj -> {
                Long startTime = Long.parseLong(time) * 24L * 60L * 60L * 1000L;
                Long endTime = (Long.parseLong(time) + 1L) * 24L * 60L * 60L * 1000L;
                Long nowMills = System.currentTimeMillis();
                if (!CollectionUtils.isEmpty(obj.getAuditTaskInstBos())) {
                    List<DycUocTaskInstInfoBO> auditTaskList = obj.getAuditTaskInstBos().stream().filter(e -> e.getFinishTag() == 0).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(auditTaskList)) {
                        if (!CollectionUtils.isEmpty(auditTaskList = auditTaskList.stream().filter(each -> {
                            if (each.getCreateTime() != null) {
                                Long createTime = each.getCreateTime().getTime();
                                Long presentTime = nowMills - createTime;
                                if (startTime <= presentTime && presentTime < endTime) {
                                    log.info("\u8ba2\u5355\uff1a{} + \u5ba1\u6279\u4eba\uff1a{} + \u8d85\u65f6: + {} + \u5929\u672a\u5ba1\u6279", new Object[]{obj.getSaleOrderNo(), each.getDealName(), time});
                                    return true;
                                }
                                return false;
                            }
                            return false;
                        }).collect(Collectors.toList()))) {
                            obj.setAuditTaskInstBos(auditTaskList);
                            return true;
                        }
                        return false;
                    }
                    return false;
                }
                return false;
            }).collect(Collectors.toList());
            uocSaleOrderInfoBOList.addAll(saleOrderInfoBOList);
        }
        return uocSaleOrderInfoBOList;
    }
}

