/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.selfrun.order.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.busicommon.api.DycBuriedPointCallFunction;
import com.tydic.dyc.atom.busicommon.bo.DycBuriedPointCallFuncBo;
import com.tydic.dyc.atom.busicommon.bo.DycBuriedPointCallFuncReqBo;
import com.tydic.dyc.atom.busicommon.bo.DycBuriedPointCallFuncRspBo;
import com.tydic.dyc.atom.common.api.DycBusiProcessDeleteFunction;
import com.tydic.dyc.atom.common.api.DycGeneralQueryFunction;
import com.tydic.dyc.atom.common.bo.DycBusiProcessDeleteFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycGeneralQueryFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycGeneralQueryFuncRspBO;
import com.tydic.dyc.atom.estore.api.DycUocEstoreCancelSaleOrderFunction;
import com.tydic.dyc.atom.estore.bo.DycUocEstoreCancelSaleOrderFuncReqBO;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.service.domainservice.UocCancelSaleOrderAndStopProcessService;
import com.tydic.dyc.oc.service.domainservice.UocProcInsTerminateDomainService;
import com.tydic.dyc.oc.service.domainservice.bo.UocCancelSaleOrderAndStopProcessServiceReqBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocCancelSaleOrderAndStopProcessServiceRspBO;
import com.tydic.dyc.oc.service.order.UocProOrderEffectivePageQueryService;
import com.tydic.dyc.oc.service.order.bo.UocProOrderEffectiveInfoBo;
import com.tydic.dyc.oc.service.order.bo.UocProOrderEffectiveListPageQueryReqBo;
import com.tydic.dyc.oc.service.order.bo.UocProOrderEffectiveListPageQueryRspBo;
import com.tydic.dyc.selfrun.order.api.DycUocStockExpireCancelOrderService;
import com.tydic.dyc.selfrun.order.bo.DycUocSalOrderListQryReqBO;
import com.tydic.dyc.selfrun.order.bo.DycUocSalOrderListQryRspBO;
import com.tydic.dyc.selfrun.order.bo.DycUocSaleOrderInfoBO;
import com.tydic.dyc.selfrun.order.bo.DycUocStockExpireCancelOrderReqBO;
import com.tydic.dyc.selfrun.order.bo.DycUocStockExpireCancelOrderRspBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.selfrun.order.api.DycUocStockExpireCancelOrderService"})
public class DycUocStockExpireCancelOrderServiceImpl
implements DycUocStockExpireCancelOrderService {
    private static final Logger log = LoggerFactory.getLogger(DycUocStockExpireCancelOrderServiceImpl.class);
    @Autowired
    private UocProOrderEffectivePageQueryService uocProOrderEffectivePageQueryService;
    @Autowired
    private DycGeneralQueryFunction dycGeneralQueryFunction;
    @Autowired
    private DycUocEstoreCancelSaleOrderFunction dycUocEstoreCancelSaleOrderFunction;
    @Autowired
    private UocCancelSaleOrderAndStopProcessService uocCancelSaleOrderAndStopProcessService;
    @Autowired
    private UocProcInsTerminateDomainService uocProcInsTerminateDomainService;
    @Autowired
    private DycBusiProcessDeleteFunction dycBusiProcessDeleteFunction;
    @Autowired
    private DycBuriedPointCallFunction dycBuriedPointCallFunction;
    @Value(value="${uoc.buriedpoint.enable:false}")
    private boolean buryPointEnable;
    @Value(value="${uoc.buriedpoint.url:http://192.168.0.15/ability}")
    private String buriedpointUrl;

    @Override
    @PostMapping(value={"dealStockExpireCancelOrder"})
    public DycUocStockExpireCancelOrderRspBO dealStockExpireCancelOrder(@RequestBody DycUocStockExpireCancelOrderReqBO reqBO) {
        log.info("\u5e93\u5b58\u65f6\u9650\u5230\u671f\u540e\u81ea\u52a8\u53d6\u6d88\u8ba2\u5355\u5165\u53c2\uff1a", (Object)reqBO.toString());
        DycUocStockExpireCancelOrderRspBO rspBO = new DycUocStockExpireCancelOrderRspBO();
        UocProOrderEffectiveListPageQueryReqBo pageQueryReqBo = new UocProOrderEffectiveListPageQueryReqBo();
        pageQueryReqBo.setEffectiveCode("1");
        UocProOrderEffectiveListPageQueryRspBo uocProOrderEffectiveListPageQueryRspBo = this.uocProOrderEffectivePageQueryService.queryOrderEffectiveListPage(pageQueryReqBo);
        Map<String, Long> effectiveMap = uocProOrderEffectiveListPageQueryRspBo.getRows().stream().collect(Collectors.toMap(UocProOrderEffectiveInfoBo::getSupplierNo, UocProOrderEffectiveInfoBo::getAging));
        DycUocSalOrderListQryReqBO salOrderListQryReqBO = new DycUocSalOrderListQryReqBO();
        DycUocSalOrderListQryRspBO qryRspBO = new DycUocSalOrderListQryRspBO();
        DycGeneralQueryFuncRspBO dycGeneralQueryFuncRspBO = new DycGeneralQueryFuncRspBO();
        DycGeneralQueryFuncReqBO queryFuncReqBO = new DycGeneralQueryFuncReqBO();
        salOrderListQryReqBO.setOrderSourceList(Arrays.asList(UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.toString()));
        salOrderListQryReqBO.setTacheCodes(Arrays.asList("E0002"));
        queryFuncReqBO.setReqParams(JSON.parseObject((String)JSON.toJSONString((Object)((Object)salOrderListQryReqBO))).toJSONString());
        queryFuncReqBO.setQueryCountFlag(Boolean.valueOf(true));
        dycGeneralQueryFuncRspBO = this.dycGeneralQueryFunction.generalQuery(queryFuncReqBO);
        qryRspBO = (DycUocSalOrderListQryRspBO)((Object)JSONObject.parseObject((String)dycGeneralQueryFuncRspBO.getRspJsonStr(), DycUocSalOrderListQryRspBO.class));
        Integer total = qryRspBO.getRecordsTotal() % 10 == 0 ? qryRspBO.getRecordsTotal() / 10 : qryRspBO.getRecordsTotal() / 10 + 1;
        HashMap<Long, String> map = new HashMap<Long, String>();
        for (int i = 1; i <= total; ++i) {
            queryFuncReqBO.setQueryCountFlag(Boolean.valueOf(false));
            salOrderListQryReqBO.setPageNo(i);
            queryFuncReqBO.setReqParams(JSON.toJSONString((Object)((Object)salOrderListQryReqBO)));
            dycGeneralQueryFuncRspBO = this.dycGeneralQueryFunction.generalQuery(queryFuncReqBO);
            qryRspBO = (DycUocSalOrderListQryRspBO)((Object)JSONObject.parseObject((String)dycGeneralQueryFuncRspBO.getRspJsonStr(), DycUocSalOrderListQryRspBO.class));
            List<DycUocSaleOrderInfoBO> saleOrderInfoBOList = qryRspBO.getRows();
            saleOrderInfoBOList = saleOrderInfoBOList.stream().filter(item -> {
                Long aging = (Long)effectiveMap.get(item.getSupId());
                if (ObjectUtil.isEmpty((Object)aging)) {
                    aging = (Long)effectiveMap.get("0");
                }
                Long nowMills = System.currentTimeMillis();
                Long createOrderTime = item.getCreateTime().getTime();
                if (aging + createOrderTime - nowMills >= 0L) {
                    log.info("\u8ba2\u5355\uff1a{} +  \u4e0b\u5355\u65f6\u95f4: + {} + \u672a\u8d85\u65f6", (Object)item.getSaleOrderNo(), (Object)item.getCreateTime());
                    return false;
                }
                log.info("\u8ba2\u5355\uff1a{} +  \u4e0b\u5355\u65f6\u95f4: + {} + \u8d85\u65f6", (Object)item.getSaleOrderNo(), (Object)item.getCreateTime());
                Long overMill = nowMills - (aging + createOrderTime);
                log.debug("overMill" + overMill);
                item.setCancelReason("\u8d85\u8fc7" + this.formatTime(overMill) + "\u672a\u5ba1\u6279\uff0c\u8ba2\u5355\u81ea\u52a8\u53d6\u6d88");
                return true;
            }).collect(Collectors.toList());
            for (DycUocSaleOrderInfoBO uocSaleOrderInfoBO : saleOrderInfoBOList) {
                try {
                    UocCancelSaleOrderAndStopProcessServiceReqBO cancelSaleReqBO = new UocCancelSaleOrderAndStopProcessServiceReqBO();
                    cancelSaleReqBO.setOrderId(uocSaleOrderInfoBO.getOrderId());
                    cancelSaleReqBO.setCancelReason(uocSaleOrderInfoBO.getCancelReason());
                    cancelSaleReqBO.setCancelReasonFlag(UocConstant.CancelReasonFlag.AUTO_CANCEL);
                    cancelSaleReqBO.setSaleOrderId(uocSaleOrderInfoBO.getSaleOrderId());
                    cancelSaleReqBO.setUserId(Long.valueOf(1L));
                    cancelSaleReqBO.setName("\u7cfb\u7edf\u81ea\u52a8");
                    cancelSaleReqBO.setTraceId(reqBO.getTraceId());
                    UocCancelSaleOrderAndStopProcessServiceRspBO serviceRspBO = this.uocCancelSaleOrderAndStopProcessService.cancelSaleOrderAndStopProcess(cancelSaleReqBO);
                    if (!"0000".equals(serviceRspBO.getRespCode())) {
                        throw new ZTBusinessException(serviceRspBO.getRespDesc());
                    }
                    DycUocEstoreCancelSaleOrderFuncReqBO funcReqBO = new DycUocEstoreCancelSaleOrderFuncReqBO();
                    funcReqBO.setOutOrderId(uocSaleOrderInfoBO.getOutOrderId());
                    funcReqBO.setSupplierNo(uocSaleOrderInfoBO.getSupId());
                    this.dycUocEstoreCancelSaleOrderFunction.cancelSaleOrder(funcReqBO);
                    DycBusiProcessDeleteFuncReqBO dycBusiProcessDeleteFuncReqBO = new DycBusiProcessDeleteFuncReqBO();
                    dycBusiProcessDeleteFuncReqBO.setProcInstId(uocSaleOrderInfoBO.getBusiProcId());
                    this.dycBusiProcessDeleteFunction.deleteBusiProcess(dycBusiProcessDeleteFuncReqBO);
                    this.buryPoint(uocSaleOrderInfoBO);
                }
                catch (ZTBusinessException e) {
                    map.put(uocSaleOrderInfoBO.getOrderId(), e.getMessage());
                }
            }
        }
        log.info("\u5931\u8d25\u8ba2\u5355\uff1a" + JSON.toJSONString(map));
        return rspBO;
    }

    private void buryPoint(DycUocSaleOrderInfoBO bo) {
        DycBuriedPointCallFuncReqBo funcReqBo = new DycBuriedPointCallFuncReqBo();
        funcReqBo.setEnable(Boolean.valueOf(this.buryPointEnable));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("saleOrderId", (Object)bo.getSaleOrderId());
        jsonObject.put("orderId", (Object)bo.getOrderId());
        ArrayList<DycBuriedPointCallFuncBo> buildsList = new ArrayList<DycBuriedPointCallFuncBo>();
        DycBuriedPointCallFuncBo bo1 = new DycBuriedPointCallFuncBo();
        bo1.setIdent("UPDATA");
        bo1.setDycBusiCode("saleOrderSync");
        bo1.setDycCenterCode("UOC");
        bo1.setData((Object)jsonObject);
        buildsList.add(bo1);
        funcReqBo.setBusiList(buildsList);
        DycBuriedPointCallFuncRspBo funcRspBo = this.dycBuriedPointCallFunction.callAbility(funcReqBo);
        if (!"0000".equals(funcRspBo.getRespCode())) {
            log.error("\u5e93\u5b58\u65f6\u9650\u5230\u671f\u540e\u81ea\u52a8\u53d6\u6d88\u8ba2\u5355\u66f4\u6539\u9500\u552e\u5355\u540e\u8fdb\u884c\u57cb\u70b9\u5931\u8d25\uff1a" + funcRspBo.getRespDesc());
        }
    }

    public String formatTime(Long ms) {
        log.debug("ms" + ms);
        Integer ss = 1000;
        log.debug("ss" + ss);
        Integer mi = ss * 60;
        log.debug("mi" + mi);
        Integer hh = mi * 60;
        log.debug("hh" + hh);
        Integer dd = hh * 24;
        log.debug("dd" + dd);
        Long day = ms / (long)dd.intValue();
        log.debug("day" + day);
        Long hour = (ms - day * (long)dd.intValue()) / (long)hh.intValue();
        log.debug("hour" + hour);
        Long minute = (ms - day * (long)dd.intValue() - hour * (long)hh.intValue()) / (long)mi.intValue();
        log.debug("minute" + minute);
        Long second = (ms - day * (long)dd.intValue() - hour * (long)hh.intValue() - minute * (long)mi.intValue()) / (long)ss.intValue();
        log.debug("second" + second);
        Long milliSecond = ms - day * (long)dd.intValue() - hour * (long)hh.intValue() - minute * (long)mi.intValue() - second * (long)ss.intValue();
        StringBuffer sb = new StringBuffer();
        if (day > 0L) {
            sb.append(day + "\u5929");
            log.debug("sb" + sb);
        }
        if (hour > 0L) {
            sb.append(hour + "\u5c0f\u65f6");
            log.debug("sb" + sb);
        }
        if (minute > 0L) {
            sb.append(minute + "\u5206");
            log.debug("sb" + sb);
        }
        if (second > 0L) {
            sb.append(second + "\u79d2");
            log.debug("sb" + sb);
        }
        System.out.println("\u8d85\u65f6\u65f6\u95f4" + sb);
        return sb.toString();
    }
}

