/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.zone.agr.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.agr.service.agr.AgrAgrItemSaveCheckService;
import com.tydic.dyc.agr.service.agr.bo.AgrAgrItemSaveCheckReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrAgrItemSaveCheckRspBO;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.procinst.AgrGetTaskInstService;
import com.tydic.dyc.agr.service.procinst.AgrTaskDealService;
import com.tydic.dyc.agr.service.procinst.bo.AgrGetTaskInstReqBo;
import com.tydic.dyc.agr.service.procinst.bo.AgrGetTaskInstRspBo;
import com.tydic.dyc.agr.service.procinst.bo.AgrTaskDealReqBO;
import com.tydic.dyc.agr.service.procinst.bo.AgrTaskInfoBO;
import com.tydic.dyc.agr.service.procinst.bo.AgrUocOrderTaskInstBo;
import com.tydic.dyc.atom.common.api.DycBusiProcessFlowFunction;
import com.tydic.dyc.atom.common.api.DycBusiProcessStartFunction;
import com.tydic.dyc.atom.common.bo.DycBusiProcessFlowFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycBusiProcessFlowFuncRspBO;
import com.tydic.dyc.atom.common.bo.DycBusiProcessStartFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycBusiProcessStartFuncRspBO;
import com.tydic.dyc.atom.zone.agr.api.DycAgrAgrSaveAndSubmitFunction;
import com.tydic.dyc.atom.zone.agr.bo.DycAgrAgrSaveAndSubmitFuncReqBO;
import com.tydic.dyc.atom.zone.agr.bo.DycAgrAgrSaveAndSubmitFuncRspBO;
import com.tydic.dyc.zone.agr.api.DycAgrAgrSaveAndSubmitService;
import com.tydic.dyc.zone.agr.api.DycAgrSetScopeOrgPathService;
import com.tydic.dyc.zone.agr.bo.DycAgrAccessoryBO;
import com.tydic.dyc.zone.agr.bo.DycAgrAgrSaveAndSubmitReqBO;
import com.tydic.dyc.zone.agr.bo.DycAgrAgrSaveAndSubmitRspBO;
import com.tydic.dyc.zone.agr.bo.DycAgrAppScopeBO;
import com.tydic.dyc.zone.agr.bo.DycAgrCataScopeBO;
import com.tydic.dyc.zone.agr.bo.DycAgrMainSaveBO;
import com.tydic.dyc.zone.agr.bo.DycAgrPayConfigBO;
import com.tydic.dyc.zone.agr.bo.DycAgrSetScopeOrgPathReqBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.zone.agr.api.DycAgrAgrSaveAndSubmitService"})
public class DycAgrAgrSaveAndSubmitServiceImpl
implements DycAgrAgrSaveAndSubmitService {
    private static final Logger log = LoggerFactory.getLogger(DycAgrAgrSaveAndSubmitServiceImpl.class);
    @Autowired
    private DycAgrAgrSaveAndSubmitFunction dycAgrAgrSaveAndSubmitFunction;
    @Autowired
    private DycBusiProcessStartFunction dycBusiProcessStartFunction;
    @Autowired
    private DycBusiProcessFlowFunction dycBusiProcessFlowFunction;
    @Autowired
    private AgrGetTaskInstService agrGetTaskInstService;
    @Value(value="${process.sysCode:DYC}")
    private String SYS_CODE;
    private final Integer submitFlag = 1;
    @Autowired
    private AgrTaskDealService agrTaskDealService;
    @Autowired
    private AgrAgrItemSaveCheckService agrAgrItemSaveCheckService;
    @Value(value="${agr.app.topOrgId:1}")
    private String topOrgId;
    @Autowired
    private DycAgrSetScopeOrgPathService dycAgrSetScopeOrgPathService;

    @Override
    @PostMapping(value={"dealAgrSaveAndSubmit"})
    public DycAgrAgrSaveAndSubmitRspBO dealAgrSaveAndSubmit(@RequestBody DycAgrAgrSaveAndSubmitReqBO reqBO) {
        DycAgrAgrSaveAndSubmitRspBO rspBO = new DycAgrAgrSaveAndSubmitRspBO();
        this.validateParams(reqBO);
        this.setScopeOrgPath(reqBO);
        DycAgrAgrSaveAndSubmitFuncReqBO saveAndSubmitFuncReqBO = (DycAgrAgrSaveAndSubmitFuncReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), DycAgrAgrSaveAndSubmitFuncReqBO.class);
        saveAndSubmitFuncReqBO.setAgrId(reqBO.getAgrMainSaveBO().getAgrId());
        DycAgrAgrSaveAndSubmitFuncRspBO dycAgrAgrSaveAndSubmitFuncRspBO = this.dycAgrAgrSaveAndSubmitFunction.dealAgrSaveAndSubmit(saveAndSubmitFuncReqBO);
        if (!"0000".equals(dycAgrAgrSaveAndSubmitFuncRspBO.getRespCode())) {
            throw new ZTBusinessException("\u534f\u8bae\u4fdd\u5b58\u63d0\u4ea4\u5931\u8d25\uff1a" + dycAgrAgrSaveAndSubmitFuncRspBO.getRespDesc());
        }
        rspBO.setAgrId(dycAgrAgrSaveAndSubmitFuncRspBO.getAgrId());
        reqBO.getAgrMainSaveBO().setAgrId(dycAgrAgrSaveAndSubmitFuncRspBO.getAgrId());
        this.checkAgrItem(reqBO);
        AgrUocOrderTaskInstBo agrUocOrderTaskInstBo = this.getTaskInst(reqBO);
        if (agrUocOrderTaskInstBo == null || StringUtils.isEmpty((Object)agrUocOrderTaskInstBo.getTaskInstId())) {
            this.startBusiProcess(reqBO);
        } else {
            this.flowBusiProcess(reqBO, agrUocOrderTaskInstBo.getTaskInstId());
            this.submitCenterTask(agrUocOrderTaskInstBo, reqBO);
        }
        return rspBO;
    }

    private void setScopeOrgPath(DycAgrAgrSaveAndSubmitReqBO reqBO) {
        List<DycAgrAppScopeBO> agrAppScopeBOs;
        if (AgrCommConstant.ScopeType.ALL.equals(reqBO.getAgrMainSaveBO().getScopeType())) {
            List<DycAgrAppScopeBO> dycAgrAppScopeBOS = Arrays.stream(this.topOrgId.split(",")).map(e -> {
                DycAgrAppScopeBO dycAgrAppScopeBO = new DycAgrAppScopeBO();
                if (e.contains("->")) {
                    String[] temp = e.split("->");
                    dycAgrAppScopeBO.setScopeCode(Long.valueOf(temp[0]));
                    dycAgrAppScopeBO.setScopeName(temp[1]);
                } else {
                    dycAgrAppScopeBO.setScopeCode(Long.valueOf(e));
                }
                dycAgrAppScopeBO.setScopeType(reqBO.getAgrMainSaveBO().getScopeType());
                return dycAgrAppScopeBO;
            }).collect(Collectors.toList());
            reqBO.setAgrAppScopeBOs(dycAgrAppScopeBOS);
        }
        if (CollectionUtil.isNotEmpty(agrAppScopeBOs = reqBO.getAgrAppScopeBOs())) {
            DycAgrSetScopeOrgPathReqBO dycAgrSetScopeOrgPathReqBO = new DycAgrSetScopeOrgPathReqBO();
            dycAgrSetScopeOrgPathReqBO.setAgrAppScopeBOs(agrAppScopeBOs);
            this.dycAgrSetScopeOrgPathService.setScopeOrgPath(dycAgrSetScopeOrgPathReqBO);
        }
    }

    private void checkAgrItem(DycAgrAgrSaveAndSubmitReqBO reqBO) {
        if (1 == reqBO.getAgrMainSaveBO().getWhetherHaveItem()) {
            AgrAgrItemSaveCheckReqBO agrAgrItemSaveCheckReqBO = new AgrAgrItemSaveCheckReqBO();
            agrAgrItemSaveCheckReqBO.setAgrId(reqBO.getAgrMainSaveBO().getAgrId());
            AgrAgrItemSaveCheckRspBO agrAgrItemSaveCheckRspBO = this.agrAgrItemSaveCheckService.checkAgrItemSave(agrAgrItemSaveCheckReqBO);
            if (!"0000".equals(agrAgrItemSaveCheckRspBO.getRespCode())) {
                throw new ZTBusinessException("\u5f53\u524d\u7269\u6599\u660e\u7ec6\u6709\u5fc5\u586b\u9879\u672a\u586b\u5199\uff0c\u8bf7\u6838\u5b9e\u5b8c\u5584\u540e\u518d\u63d0\u4ea4\uff01");
            }
        }
    }

    private void submitCenterTask(AgrUocOrderTaskInstBo agrUocOrderTaskInstBo, DycAgrAgrSaveAndSubmitReqBO reqBO) {
        AgrTaskDealReqBO agrTaskDealReqBO = new AgrTaskDealReqBO();
        agrTaskDealReqBO.setOrderId(agrUocOrderTaskInstBo.getOrderId());
        agrTaskDealReqBO.setUserId(reqBO.getUserId());
        agrTaskDealReqBO.setUsername(reqBO.getUsername());
        ArrayList<AgrTaskInfoBO> agrTaskInfoBOS = new ArrayList<AgrTaskInfoBO>();
        AgrTaskInfoBO agrTaskInfoBO = new AgrTaskInfoBO();
        agrTaskInfoBO.setBusiObjId(agrUocOrderTaskInstBo.getObjId());
        agrTaskInfoBO.setBusiObjType(agrUocOrderTaskInstBo.getObjType());
        agrTaskInfoBO.setDealResult(this.submitFlag);
        agrTaskInfoBO.setTaskId(agrUocOrderTaskInstBo.getTaskInstId());
        agrTaskInfoBOS.add(agrTaskInfoBO);
        agrTaskDealReqBO.setCompleteTaskInfos(agrTaskInfoBOS);
        this.agrTaskDealService.dealTask(agrTaskDealReqBO);
    }

    private void flowBusiProcess(DycAgrAgrSaveAndSubmitReqBO reqBO, String taskInstId) {
        DycBusiProcessFlowFuncReqBO dycBusiProcessFlowFuncReqBO = new DycBusiProcessFlowFuncReqBO();
        dycBusiProcessFlowFuncReqBO.setTaskId(taskInstId);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("userId", reqBO.getUserId());
        variables.put("userName", reqBO.getName());
        variables.put("submitFlag", this.submitFlag);
        dycBusiProcessFlowFuncReqBO.setVariables(variables);
        DycBusiProcessFlowFuncRspBO dycBusiProcessFlowFuncRspBO = this.dycBusiProcessFlowFunction.flowBusiProcess(dycBusiProcessFlowFuncReqBO);
        if (!"0000".equals(dycBusiProcessFlowFuncRspBO.getRespCode())) {
            throw new ZTBusinessException("\u534f\u8bae\u63d0\u4ea4\u6d41\u7a0b\u6d41\u8f6c\u5931\u8d25\uff1a" + dycBusiProcessFlowFuncRspBO.getRespDesc());
        }
    }

    private AgrUocOrderTaskInstBo getTaskInst(DycAgrAgrSaveAndSubmitReqBO reqBO) {
        AgrGetTaskInstReqBo agrGetTaskInstReqBo = new AgrGetTaskInstReqBo();
        agrGetTaskInstReqBo.setOrderId(reqBO.getAgrMainSaveBO().getAgrId());
        agrGetTaskInstReqBo.setObjId(reqBO.getAgrMainSaveBO().getAgrId());
        agrGetTaskInstReqBo.setFinishTag(Integer.valueOf(0));
        AgrGetTaskInstRspBo agrGetTaskInstRspBo = this.agrGetTaskInstService.getTaskInstList(agrGetTaskInstReqBo);
        if (!"0000".equals(agrGetTaskInstRspBo.getRespCode())) {
            throw new ZTBusinessException("\u8c03\u7528\u534f\u8bae\u4efb\u52a1\u67e5\u8be2\u5931\u8d25\uff01\u5f02\u5e38\u7f16\u7801\u3010" + agrGetTaskInstRspBo.getRespCode() + "\u3011," + agrGetTaskInstRspBo.getRespDesc());
        }
        if (!CollectionUtils.isEmpty((Collection)agrGetTaskInstRspBo.getRows())) {
            return (AgrUocOrderTaskInstBo)agrGetTaskInstRspBo.getRows().get(0);
        }
        return null;
    }

    private void startBusiProcess(DycAgrAgrSaveAndSubmitReqBO reqBO) {
        DycBusiProcessStartFuncReqBO dycBusiProcessStartFuncReqBO = new DycBusiProcessStartFuncReqBO();
        if (reqBO.getAgrMainSaveBO().getTradeMode().equals(1)) {
            dycBusiProcessStartFuncReqBO.setProcDefKey("agr_plat_agr_busi_process");
        } else {
            dycBusiProcessStartFuncReqBO.setProcDefKey("agr_danwei_agr_busi_process");
        }
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("agrId", reqBO.getAgrMainSaveBO().getAgrId());
        variables.put("orderId", reqBO.getAgrMainSaveBO().getAgrId());
        variables.put("auditObjId", reqBO.getAgrMainSaveBO().getAgrId());
        variables.put("auditObjType", AgrCommConstant.ObjType.AGREEMENT);
        variables.put("auditObjCode", reqBO.getAgrMainSaveBO().getAgrCode());
        variables.put("auditStartFlag", "1");
        variables.put("auditFinishFlag", "1");
        variables.put("orgId", reqBO.getOrgId());
        variables.put("orgName", reqBO.getOrgName());
        variables.put("userId", reqBO.getUserId());
        variables.put("userName", reqBO.getName());
        variables.put("todoOrderNo", reqBO.getAgrMainSaveBO().getAgrCode());
        variables.put("createOperId", reqBO.getUserId());
        variables.put("loginTagIn", reqBO.getLoginTagIn());
        variables.put("agrCode", reqBO.getAgrMainSaveBO().getAgrCode());
        variables.put("agrType", reqBO.getAgrMainSaveBO().getAgrType());
        variables.put("agrTypeStr", reqBO.getAgrMainSaveBO().getAgrTypeStr());
        variables.put("supplierId", reqBO.getAgrMainSaveBO().getSupplierId());
        dycBusiProcessStartFuncReqBO.setVariables(variables);
        dycBusiProcessStartFuncReqBO.setSysCode(this.SYS_CODE);
        dycBusiProcessStartFuncReqBO.setPartitonKey(String.valueOf(reqBO.getAgrMainSaveBO().getAgrId()));
        DycBusiProcessStartFuncRspBO dycBusiProcessStartFuncRspBO = this.dycBusiProcessStartFunction.startBusiProcess(dycBusiProcessStartFuncReqBO);
        if (!"0000".equals(dycBusiProcessStartFuncRspBO.getRespCode())) {
            throw new ZTBusinessException("\u534f\u8bae\u63d0\u4ea4\u6d41\u7a0b\u542f\u52a8\u5931\u8d25\uff1a" + dycBusiProcessStartFuncRspBO.getRespDesc());
        }
    }

    private void validateParams(DycAgrAgrSaveAndSubmitReqBO reqBO) {
        List<DycAgrCataScopeBO> list;
        List<DycAgrAccessoryBO> agrAccessoryBOs;
        List<DycAgrAppScopeBO> agrAppScopeBOs;
        DycAgrMainSaveBO agrMainSaveBO = reqBO.getAgrMainSaveBO();
        if (null == agrMainSaveBO) {
            throw new ZTBusinessException("\u534f\u8bae\u4e3b\u4f53\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)agrMainSaveBO.getSupplierName())) {
            throw new ZTBusinessException("\u534f\u8bae\u4e3b\u4f53\u4fe1\u606f[\u4f9b\u8d27\u5546\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)agrMainSaveBO.getEffDate())) {
            // empty if block
        }
        if (ObjectUtil.isEmpty((Object)agrMainSaveBO.getTradeMode())) {
            agrMainSaveBO.setTradeMode(AgrCommConstant.TradeMode.MATCH_UP);
        }
        if (AgrCommConstant.TradeMode.PURCHASE_AND_SALE.equals(agrMainSaveBO.getTradeMode())) {
            if (ObjectUtil.isNotEmpty((Object)agrMainSaveBO.getPayTypePur())) {
                DycAgrPayConfigBO payTypePur1 = agrMainSaveBO.getPayTypePur();
                if (ObjectUtil.isEmpty((Object)payTypePur1.getPayType())) {
                    throw new ZTBusinessException("\u6536\u6b3e\u65b9\u5f0f\uff08\u5bf9\u91c7\u8d2d\u5355\u4f4d\uff09[\u652f\u4ed8\u65b9\u5f0f]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (payTypePur1.getPayType().equals(AgrCommConstant.PayTypeEnum.PAY_TYPE_PAYMENT_DAYS.getValue())) {
                    if (ObjectUtil.isEmpty((Object)payTypePur1.getAssign())) {
                        throw new ZTBusinessException("\u6536\u6b3e\u65b9\u5f0f\uff08\u5bf9\u91c7\u8d2d\u5355\u4f4d\uff09[\u671f\u671b\u7ed3\u7b97\u65b9\u5f0f]\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (ObjectUtil.isEmpty((Object)payTypePur1.getBusiNode())) {
                        if (payTypePur1.getAssign().equals(AgrCommConstant.AssignEnum.no.getValue())) {
                            throw new ZTBusinessException("\u6536\u6b3e\u65b9\u5f0f\uff08\u5bf9\u91c7\u8d2d\u5355\u4f4d\uff09[\u8d26\u671f\u8d77\u7b97\u7279\u5b9a\u4e1a\u52a1\u8282\u70b9]\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        throw new ZTBusinessException("\u6536\u6b3e\u65b9\u5f0f\uff08\u5bf9\u91c7\u8d2d\u5355\u4f4d\uff09[\u8d26\u671f\u65e5\u7ed3\u7b97\u8ba2\u5355\u89c4\u5219]\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (ObjectUtil.isEmpty((Object)payTypePur1.getSettlementDate())) {
                        if (payTypePur1.getAssign().equals(AgrCommConstant.AssignEnum.no.getValue())) {
                            throw new ZTBusinessException("\u6536\u6b3e\u65b9\u5f0f\uff08\u5bf9\u91c7\u8d2d\u5355\u4f4d\uff09[\u53ef\u9009\u8d26\u671f\u5929\u6570]\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        throw new ZTBusinessException("\u6536\u6b3e\u65b9\u5f0f\uff08\u5bf9\u91c7\u8d2d\u5355\u4f4d\uff09[\u6bcf\u6708\u7ed3\u7b97\u65e5]\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                }
            }
        } else {
            agrMainSaveBO.setPayTypePur(null);
        }
        if (ObjectUtil.isNotEmpty((Object)agrMainSaveBO.getPayTypeSup())) {
            DycAgrPayConfigBO payTypeSup1 = agrMainSaveBO.getPayTypeSup();
            if (ObjectUtil.isEmpty((Object)payTypeSup1.getPayType())) {
                throw new ZTBusinessException("\u4ed8\u6b3e\u65b9\u5f0f\uff08\u5bf9\u4f9b\u5e94\u5546\uff09[\u652f\u4ed8\u65b9\u5f0f]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (payTypeSup1.getPayType().equals(AgrCommConstant.PayTypeEnum.PAY_TYPE_PAYMENT_DAYS.getValue())) {
                if (ObjectUtil.isEmpty((Object)payTypeSup1.getAssign())) {
                    throw new ZTBusinessException("\u4ed8\u6b3e\u65b9\u5f0f\uff08\u5bf9\u4f9b\u5e94\u5546\uff09[\u671f\u671b\u7ed3\u7b97\u65b9\u5f0f]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (ObjectUtil.isEmpty((Object)payTypeSup1.getBusiNode())) {
                    if (payTypeSup1.getAssign().equals(AgrCommConstant.AssignEnum.no.getValue())) {
                        throw new ZTBusinessException("\u4ed8\u6b3e\u65b9\u5f0f\uff08\u5bf9\u4f9b\u5e94\u5546\uff09[\u8d26\u671f\u8d77\u7b97\u7279\u5b9a\u4e1a\u52a1\u8282\u70b9]\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    throw new ZTBusinessException("\u4ed8\u6b3e\u65b9\u5f0f\uff08\u5bf9\u4f9b\u5e94\u5546\uff09[\u8d26\u671f\u65e5\u7ed3\u7b97\u8ba2\u5355\u89c4\u5219]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (ObjectUtil.isEmpty((Object)payTypeSup1.getSettlementDate())) {
                    if (payTypeSup1.getAssign().equals(AgrCommConstant.AssignEnum.no.getValue())) {
                        throw new ZTBusinessException("\u4ed8\u6b3e\u65b9\u5f0f\uff08\u5bf9\u4f9b\u5e94\u5546\uff09[\u53ef\u9009\u8d26\u671f\u5929\u6570]\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    throw new ZTBusinessException("\u4ed8\u6b3e\u65b9\u5f0f\uff08\u5bf9\u4f9b\u5e94\u5546\uff09[\u6bcf\u6708\u7ed3\u7b97\u65e5]\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
        }
        if (ObjectUtil.isEmpty((Object)agrMainSaveBO.getCreateTime())) {
            agrMainSaveBO.setCreateTime(new Date());
        }
        if (ObjectUtil.isEmpty((Object)agrMainSaveBO.getAgrOperatorId())) {
            agrMainSaveBO.setAgrOperatorId(reqBO.getUserId());
        }
        if (ObjectUtil.isEmpty((Object)agrMainSaveBO.getAgrOperatorName())) {
            agrMainSaveBO.setAgrOperatorName(reqBO.getName());
        }
        if (ObjectUtil.isEmpty((Object)agrMainSaveBO.getAgrOperatorUsername())) {
            agrMainSaveBO.setAgrOperatorUsername(reqBO.getUsername());
        }
        if (ObjectUtil.isEmpty((Object)agrMainSaveBO.getAgrCode())) {
            throw new ZTBusinessException("\u534f\u8bae\u4e3b\u4f53\u4fe1\u606f[\u534f\u8bae\u7f16\u53f7]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)agrMainSaveBO.getAgrName())) {
            throw new ZTBusinessException("\u534f\u8bae\u4e3b\u4f53\u4fe1\u606f[\u534f\u8bae\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)agrMainSaveBO.getAgrMode())) {
            agrMainSaveBO.setAgrMode(AgrCommConstant.agreementMode.UNIT_AGREEMENT);
        }
        if (Integer.valueOf(1).equals(agrMainSaveBO.getWhetherStorePlan())) {
            if (ObjectUtil.isEmpty((Object)agrMainSaveBO.getSupplierMode())) {
                throw new ZTBusinessException("\u534f\u8bae\u4e3b\u4f53\u4fe1\u606f[\u94fa\u8d27\u65b9\u5f0f]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)agrMainSaveBO.getManagementOrgId())) {
                throw new ZTBusinessException("\u534f\u8bae\u4e3b\u4f53\u4fe1\u606f[\u94fa\u8d27\u5355\u4f4dID]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)agrMainSaveBO.getManagementOrgName())) {
                throw new ZTBusinessException("\u534f\u8bae\u4e3b\u4f53\u4fe1\u606f[\u94fa\u8d27\u5355\u4f4d\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (ObjectUtil.isEmpty((Object)agrMainSaveBO.getSupplierId())) {
            throw new ZTBusinessException("\u534f\u8bae\u4e3b\u4f53\u4fe1\u606f[\u4f9b\u8d27\u5546ID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (agrMainSaveBO.getSupplierMode() != null) {
            if (agrMainSaveBO.getSupplierMode().equals(AgrCommConstant.SupplierMode.SUPPLIER_DELIVERY)) {
                agrMainSaveBO.setManagementOrgId(agrMainSaveBO.getSupplierId().toString());
                agrMainSaveBO.setManagementOrgName(agrMainSaveBO.getSupplierName());
            } else if (agrMainSaveBO.getSupplierMode().equals(AgrCommConstant.SupplierMode.CREATE_AND_SUP)) {
                agrMainSaveBO.setManagementOrgId(agrMainSaveBO.getSupplierId() + "," + reqBO.getCompanyId());
                agrMainSaveBO.setManagementOrgName(agrMainSaveBO.getSupplierName() + "," + reqBO.getCompanyName());
            } else {
                agrMainSaveBO.setManagementOrgId(reqBO.getCompanyId().toString());
                agrMainSaveBO.setManagementOrgName(reqBO.getCompanyName());
            }
        }
        if (ObjectUtil.isNotEmpty(agrAppScopeBOs = reqBO.getAgrAppScopeBOs())) {
            for (DycAgrAppScopeBO dycAgrAppScopeBO : agrAppScopeBOs) {
                if (ObjectUtil.isEmpty((Object)dycAgrAppScopeBO.getScopeCode())) {
                    throw new ZTBusinessException("\u5e94\u7528\u8303\u56f4\u4fe1\u606f[\u5e94\u7528\u8303\u56f4\u7f16\u7801]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (Long.valueOf(AgrCommConstant.ScopeTypeEnum.SCOPE_TYPE_ALL.getValue().intValue()).equals(dycAgrAppScopeBO.getScopeCode())) {
                    dycAgrAppScopeBO.setScopeName(AgrCommConstant.ScopeTypeEnum.SCOPE_TYPE_ALL.getName());
                }
                if (!ObjectUtil.isEmpty((Object)dycAgrAppScopeBO.getScopeName())) continue;
                throw new ZTBusinessException("\u5e94\u7528\u8303\u56f4\u4fe1\u606f[\u5e94\u7528\u8303\u56f4\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (!ObjectUtil.isEmpty(agrAccessoryBOs = reqBO.getAgrAccessoryBOs())) {
            for (DycAgrAccessoryBO item : agrAccessoryBOs) {
                if (ObjectUtil.isEmpty((Object)item.getAttachmentType())) {
                    throw new ZTBusinessException("\u9644\u4ef6\u4fe1\u606f[\u9644\u4ef6\u7c7b\u578b]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (ObjectUtil.isEmpty((Object)item.getAccessoryName())) {
                    throw new ZTBusinessException("\u9644\u4ef6\u4fe1\u606f[\u9644\u4ef6\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!ObjectUtil.isEmpty((Object)item.getAccessoryUrl())) continue;
                throw new ZTBusinessException("\u9644\u4ef6\u4fe1\u606f[\u9644\u4ef6url]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (!ObjectUtil.isEmpty(list = reqBO.getAgrCataScopeBOs())) {
            for (DycAgrCataScopeBO item : list) {
                if (ObjectUtil.isEmpty((Object)item.getCatalogCode())) {
                    throw new ZTBusinessException("\u534f\u8bae\u7c7b\u76ee\u4fe1\u606f[\u7c7b\u76ee\u7f16\u7801]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (ObjectUtil.isEmpty((Object)item.getCatalogName())) {
                    throw new ZTBusinessException("\u534f\u8bae\u7c7b\u76ee\u4fe1\u606f[\u7c7b\u76ee\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!ObjectUtil.isEmpty((Object)item.getCatalogLevel())) continue;
                throw new ZTBusinessException("\u534f\u8bae\u7c7b\u76ee\u4fe1\u606f[\u7c7b\u76ee\u5c42\u7ea7]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

