/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.zone.agr.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.cfc.ability.api.CfcParamConfigAbilityService;
import com.tydic.cfc.ability.bo.CfcParamConfigItemBO;
import com.tydic.cfc.ability.bo.CfcQryParamConfigListAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcQryParamConfigListAbilityRspBO;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.zone.agr.api.DycAgrGetAgrShopCodeService;
import com.tydic.dyc.zone.agr.bo.DycAgrGetAgrShopCodeReqBO;
import com.tydic.dyc.zone.agr.bo.DycAgrGetAgrShopCodeRspBO;
import com.tydic.dyc.zone.agr.bo.DycAgrShopCodeBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.zone.agr.api.DycAgrGetAgrShopCodeService"})
public class DycAgrGetAgrShopCodeServiceImpl
implements DycAgrGetAgrShopCodeService {
    private static final Logger log = LoggerFactory.getLogger(DycAgrGetAgrShopCodeServiceImpl.class);
    @Autowired
    private CfcParamConfigAbilityService cfcParamConfigAbilityService;

    @Override
    @PostMapping(value={"queryShopCode"})
    public DycAgrGetAgrShopCodeRspBO queryShopCode(@RequestBody DycAgrGetAgrShopCodeReqBO reqBO) {
        DycAgrGetAgrShopCodeRspBO rspBO = new DycAgrGetAgrShopCodeRspBO();
        ArrayList<DycAgrShopCodeBO> boList = new ArrayList<DycAgrShopCodeBO>();
        String agrType = this.agrTypeTran(reqBO.getAgrMode());
        CfcQryParamConfigListAbilityRspBO cfcQryParamConfigListAbilityRspBO = this.getCfcQryParamConfigListAbilityRspBO();
        log.info("\u914d\u7f6e\u4e2d\u5fc3\u914d\u7f6e\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)cfcQryParamConfigListAbilityRspBO));
        if (ObjectUtils.isEmpty((Object)cfcQryParamConfigListAbilityRspBO) || CollectionUtils.isEmpty((Collection)cfcQryParamConfigListAbilityRspBO.getParamConfigItemList())) {
            throw new ZTBusinessException("\u914d\u7f6e\u4e2d\u5fc3\u914d\u7f6e\u51fa\u53c2\u4e3a\u7a7a\uff01");
        }
        String shopUnitType = "";
        CfcParamConfigItemBO agrTypeItem = null;
        for (CfcParamConfigItemBO item2 : cfcQryParamConfigListAbilityRspBO.getParamConfigItemList()) {
            if ("agr_shop_goods".equals(item2.getItemCode())) {
                shopUnitType = item2.getItemValue();
                continue;
            }
            if (!agrType.equals(item2.getItemName())) continue;
            agrTypeItem = item2;
        }
        if ("1".equals(shopUnitType)) {
            boList.addAll(agrTypeItem.getDicList().stream().map(item -> new DycAgrShopCodeBO(item.getDicCode(), item.getDicName())).collect(Collectors.toList()));
        } else if ("2".equals(shopUnitType) && !ObjectUtils.isEmpty(agrTypeItem)) {
            String[] split = agrTypeItem.getItemValue().split(",");
            CfcParamConfigItemBO finalAgrShopGoodsItem = agrTypeItem;
            boList.addAll(Arrays.stream(split).flatMap(code -> finalAgrShopGoodsItem.getDicList().stream().filter(item -> code.equals(item.getDicCode())).map(item -> new DycAgrShopCodeBO(item.getDicCode(), item.getDicName()))).collect(Collectors.toList()));
        }
        rspBO.setData(boList);
        return rspBO;
    }

    private CfcQryParamConfigListAbilityRspBO getCfcQryParamConfigListAbilityRspBO() {
        CfcQryParamConfigListAbilityReqBO cfcQryParamConfigListAbilityReqBO = new CfcQryParamConfigListAbilityReqBO();
        cfcQryParamConfigListAbilityReqBO.setParamConfigCode("agr_base_param");
        return this.cfcParamConfigAbilityService.qryParamConfigList(cfcQryParamConfigListAbilityReqBO);
    }

    private String agrTypeTran(String reqBO) {
        return AgrCommConstant.AgreementModeEnum.getValueByCode((Integer)Integer.valueOf(reqBO));
    }
}

