/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.menu;

import com.tydic.dyc.authority.model.menu.ISysMenuModel;
import com.tydic.dyc.authority.model.menu.SysMenuDo;
import com.tydic.dyc.authority.model.menu.qrybo.SysMenuQryBo;
import com.tydic.dyc.authority.service.menu.AuthShiftDownMenuService;
import com.tydic.dyc.authority.service.menu.bo.AuthMenuInfoBo;
import com.tydic.dyc.authority.service.menu.bo.AuthShiftDownMenuReqBo;
import com.tydic.dyc.authority.service.menu.bo.AuthShiftDownMenuRspBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/3.3.0/com.tydic.dyc.authority.service.menu.AuthShiftDownMenuService"})
public class AuthShiftDownMenuServiceImpl
implements AuthShiftDownMenuService {
    @Autowired
    private ISysMenuModel iSysMenuModel;

    @PostMapping(value={"dealShiftDownMenu"})
    public AuthShiftDownMenuRspBo dealShiftDownMenu(@RequestBody AuthShiftDownMenuReqBo reqBo) {
        AuthShiftDownMenuRspBo rspBo = AuthRu.success(AuthShiftDownMenuRspBo.class);
        this.validateArg(reqBo);
        SysMenuQryBo downQryBo = new SysMenuQryBo();
        downQryBo.setMenuId(reqBo.getMenuId());
        SysMenuDo downDo = this.iSysMenuModel.getMenuInfoDetails(downQryBo);
        if (downDo == null || downDo.getMenuId() == null) {
            throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u83dc\u5355\u4fe1\u606f");
        }
        SysMenuQryBo upQryBo = new SysMenuQryBo();
        if (downDo != null && downDo.getMenuId() != null) {
            if (downDo.getParentId() != null) {
                upQryBo.setParentId(downDo.getParentId());
            } else {
                upQryBo.setParentIdNull(0L);
            }
            upQryBo.setSort(downDo.getSort() + 1);
            SysMenuDo upDo = this.iSysMenuModel.getMenuInfoDetails(upQryBo);
            SysMenuDo up = new SysMenuDo();
            up.setSort(downDo.getSort());
            up.setMenuId(upDo.getMenuId());
            SysMenuDo sysMenuDo = this.iSysMenuModel.modifyMenuInfo(up);
        }
        SysMenuDo down = new SysMenuDo();
        down.setSort(downDo.getSort() + 1);
        down.setMenuId(reqBo.getMenuId());
        SysMenuDo rspDo = this.iSysMenuModel.modifyMenuInfo(down);
        AuthMenuInfoBo menuInfoBo = AuthRu.js(rspDo, AuthMenuInfoBo.class);
        if (downDo == null || downDo.getMenuId() == null) {
            throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u5e94\u7528\u4fe1\u606f");
        }
        rspBo.setMenuInfoBo(menuInfoBo);
        return rspBo;
    }

    private SysMenuDo buildDoByBO(AuthShiftDownMenuReqBo reqBo) {
        reqBo.setUpdateTime(new Date());
        SysMenuDo reqDo = AuthRu.js(reqBo, SysMenuDo.class);
        return reqDo;
    }

    private void validateArg(AuthShiftDownMenuReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthCreateMenuReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getMenuId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[MenuId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

