/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.role;

import com.tydic.dyc.authority.model.common.sub.SysAuthRoleMenuDataOrgSubDo;
import com.tydic.dyc.authority.model.common.sub.SysRoleMenuBtnSubDo;
import com.tydic.dyc.authority.model.role.ISysRoleInfoModel;
import com.tydic.dyc.authority.model.role.SysRoleInfoDo;
import com.tydic.dyc.authority.model.role.qrybo.SysRoleInfoQryBo;
import com.tydic.dyc.authority.model.role.sub.SysMenuSubDo;
import com.tydic.dyc.authority.model.role.sub.SysRoleMenuDataAuthSubDo;
import com.tydic.dyc.authority.model.role.sub.SysRoleMenuRelSubDo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthRoleInfoBo;
import com.tydic.dyc.authority.service.role.AuthCopyRoleInfoService;
import com.tydic.dyc.authority.service.role.bo.AuthCopyRoleInfoReqBo;
import com.tydic.dyc.authority.service.role.bo.AuthCopyRoleInfoRspBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.authority.utils.IdUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.UmcEnterpriseInfoDo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseInfoQryBo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/3.3.0/com.tydic.dyc.authority.service.role.AuthCopyRoleInfoService"})
public class AuthCopyRoleInfoServiceImpl
implements AuthCopyRoleInfoService {
    @Autowired
    private ISysRoleInfoModel iSysRoleInfoModel;
    @Autowired
    private IUmcEnterpriseInfoModel iSysOrgInfoModel;
    private static final long ROOT_ORG_ID = 1L;

    @PostMapping(value={"copyRoleInfo"})
    public AuthCopyRoleInfoRspBo copyRoleInfo(@RequestBody AuthCopyRoleInfoReqBo reqBo) {
        List<SysMenuSubDo> menuList;
        AuthCopyRoleInfoRspBo rspBo = AuthRu.success(AuthCopyRoleInfoRspBo.class);
        this.validateArg(reqBo);
        this.getManageLevel(reqBo);
        if (reqBo.getOrgIdIn() != 1L && !CollectionUtils.isEmpty((Collection)reqBo.getOrgIdList()) && !reqBo.getOrgIdList().contains(reqBo.getOrgIdIn())) {
            reqBo.getOrgIdList().add(reqBo.getOrgIdIn());
        }
        SysRoleInfoDo reqDo = this.buildDoByBO(reqBo);
        reqDo.setRoleId(IdUtil.nextId());
        SysRoleInfoDo rspDo = this.iSysRoleInfoModel.createRoleInfo(reqDo);
        AuthRoleInfoBo DoToBo = AuthRu.js(rspDo, AuthRoleInfoBo.class);
        Long roleId = DoToBo.getRoleId();
        rspBo.setRoleInfoBo(DoToBo);
        SysRoleInfoQryBo qryBo = new SysRoleInfoQryBo();
        qryBo.setRoleIds(Collections.singletonList(reqBo.getCopyRoleId()));
        List<SysRoleMenuBtnSubDo> roleMenuBtnList = this.iSysRoleInfoModel.getAuthRoleMenuBtnList(qryBo).getRoleMenuBtnList();
        if (!CollectionUtils.isEmpty(roleMenuBtnList)) {
            SysRoleInfoDo roleMenuBtnAdd = new SysRoleInfoDo();
            ArrayList<SysRoleMenuBtnSubDo> roleMenuBtnSubDos = new ArrayList<SysRoleMenuBtnSubDo>();
            for (SysRoleMenuBtnSubDo menuBtn : roleMenuBtnList) {
                SysRoleMenuBtnSubDo btnSubDo = AuthRu.js(menuBtn, SysRoleMenuBtnSubDo.class);
                btnSubDo.setId(IdUtil.nextId());
                btnSubDo.setRoleId(roleId);
                btnSubDo.setCreateOperId(reqBo.getCreateOperId());
                btnSubDo.setCreateOperName(reqBo.getCreateOperName());
                btnSubDo.setCreateTime(reqBo.getCreateTime());
                btnSubDo.setDelFlag("0");
                roleMenuBtnSubDos.add(btnSubDo);
            }
            roleMenuBtnAdd.setRoleMenuBtnList(roleMenuBtnSubDos);
            this.iSysRoleInfoModel.addRoleMenuBtn(roleMenuBtnAdd);
        }
        List roleMenuDataAuthList = this.iSysRoleInfoModel.getRoleMenuDataAuthList(qryBo).getRows();
        HashMap<Long, Long> oldToNewMap = new HashMap<Long, Long>(roleMenuDataAuthList.size());
        if (!CollectionUtils.isEmpty((Collection)roleMenuDataAuthList)) {
            SysRoleInfoDo roleMenuDataAuthAdd = new SysRoleInfoDo();
            ArrayList<SysRoleMenuDataAuthSubDo> roleMenuBtnSubDos = new ArrayList<SysRoleMenuDataAuthSubDo>();
            for (SysRoleMenuDataAuthSubDo menuDataAuth : roleMenuDataAuthList) {
                SysRoleMenuDataAuthSubDo menuDataAuthSubDo = AuthRu.js(menuDataAuth, SysRoleMenuDataAuthSubDo.class);
                long newDataAuthId = IdUtil.nextId();
                menuDataAuthSubDo.setDataAuthId(newDataAuthId);
                menuDataAuthSubDo.setCreateOperId(reqBo.getCreateOperId());
                menuDataAuthSubDo.setCreateOperName(reqBo.getCreateOperName());
                menuDataAuthSubDo.setCreateTime(reqBo.getCreateTime());
                menuDataAuthSubDo.setRoleId(roleId);
                menuDataAuthSubDo.setDelFlag("0");
                oldToNewMap.put(menuDataAuth.getDataAuthId(), newDataAuthId);
                roleMenuBtnSubDos.add(menuDataAuthSubDo);
            }
            roleMenuDataAuthAdd.setRoleMenuDataAuths(roleMenuBtnSubDos);
            this.iSysRoleInfoModel.addRoleMenuDataAuth(roleMenuDataAuthAdd);
        }
        qryBo.setRoleId(reqBo.getCopyRoleId());
        List<SysAuthRoleMenuDataOrgSubDo> roleMenuDataOrgList = this.iSysRoleInfoModel.getAuthRoleMenuDataOrgList(qryBo).getAuthRoleMenuDataOrgList();
        if (!CollectionUtils.isEmpty(roleMenuDataOrgList)) {
            Map<Long, Long> idToOldAuthMap = roleMenuDataOrgList.stream().collect(Collectors.toMap(SysAuthRoleMenuDataOrgSubDo::getId, SysAuthRoleMenuDataOrgSubDo::getDataAuthId));
            SysRoleInfoDo roleMenuDataOrgAdd = new SysRoleInfoDo();
            ArrayList<SysAuthRoleMenuDataOrgSubDo> roleMenuBtnSubDos = new ArrayList<SysAuthRoleMenuDataOrgSubDo>();
            for (SysAuthRoleMenuDataOrgSubDo menuDataOrg : roleMenuDataOrgList) {
                SysAuthRoleMenuDataOrgSubDo menuDataOrgSubDo = AuthRu.js(menuDataOrg, SysAuthRoleMenuDataOrgSubDo.class);
                menuDataOrgSubDo.setId(IdUtil.nextId());
                Long oldDataAuthId = idToOldAuthMap.get(menuDataOrg.getId());
                if (oldToNewMap.containsKey(oldDataAuthId)) {
                    menuDataOrgSubDo.setDataAuthId((Long)oldToNewMap.get(oldDataAuthId));
                }
                menuDataOrgSubDo.setCreateOperId(reqBo.getCreateOperId());
                menuDataOrgSubDo.setCreateOperName(reqBo.getCreateOperName());
                menuDataOrgSubDo.setCreateTime(reqBo.getCreateTime());
                menuDataOrgSubDo.setRoleId(roleId);
                menuDataOrgSubDo.setDelFlag("0");
                roleMenuBtnSubDos.add(menuDataOrgSubDo);
            }
            roleMenuDataOrgAdd.setAuthRoleMenuDataOrgList(roleMenuBtnSubDos);
            this.iSysRoleInfoModel.addRoleMenuDataOrg(roleMenuDataOrgAdd);
        }
        if (!CollectionUtils.isEmpty(menuList = this.iSysRoleInfoModel.getRoleMenuRelList(qryBo).getMenuList())) {
            SysRoleInfoDo menuAdd = new SysRoleInfoDo();
            ArrayList<SysRoleMenuRelSubDo> menuRelSubDos = new ArrayList<SysRoleMenuRelSubDo>();
            for (SysMenuSubDo menu : menuList) {
                SysRoleMenuRelSubDo menuSubDo = AuthRu.js(menu, SysRoleMenuRelSubDo.class);
                menuSubDo.setRelId(IdUtil.nextId());
                menuSubDo.setCreateOperId(reqBo.getCreateOperId());
                menuSubDo.setCreateOperName(reqBo.getCreateOperName());
                menuSubDo.setCreateTime(reqBo.getCreateTime());
                menuSubDo.setRoleId(roleId);
                menuSubDo.setDelFlag("0");
                menuRelSubDos.add(menuSubDo);
            }
            menuAdd.setMenuRelList(menuRelSubDos);
            this.iSysRoleInfoModel.addRoleMenuRel(menuAdd);
        }
        return rspBo;
    }

    private SysRoleInfoDo buildDoByBO(AuthCopyRoleInfoReqBo reqBo) {
        reqBo.setCreateTime(new Date());
        reqBo.setUpdateTime(reqBo.getCreateTime());
        SysRoleInfoDo reqDo = AuthRu.js(reqBo, SysRoleInfoDo.class);
        reqDo.setManageLevel(reqBo.getManagerLevelIn());
        return reqDo;
    }

    private void validateArg(AuthCopyRoleInfoReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthCreateRoleInfoReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getCopyRoleId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u590d\u5236\u89d2\u8272id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void getManageLevel(AuthCopyRoleInfoReqBo reqBo) {
        if (reqBo.getManagerLevelIn() == null && reqBo.getOrgIdIn() != null) {
            UmcEnterpriseInfoQryBo orgInfoQryBo = new UmcEnterpriseInfoQryBo();
            orgInfoQryBo.setOrgId(reqBo.getOrgIdIn());
            UmcEnterpriseInfoDo orgInfoDetails = this.iSysOrgInfoModel.getOrgInfoDetails(orgInfoQryBo);
            reqBo.setManagerLevelIn(orgInfoDetails.getManageLevel());
        }
    }
}

