/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.role;

import com.tydic.dyc.authority.model.role.ISysRoleInfoModel;
import com.tydic.dyc.authority.model.role.SysRoleInfoDo;
import com.tydic.dyc.authority.model.role.qrybo.SysRoleInfoQryBo;
import com.tydic.dyc.authority.model.role.sub.SysRoleMenuRelSubDo;
import com.tydic.dyc.authority.service.role.AuthDealRoleMenuRelService;
import com.tydic.dyc.authority.service.role.bo.AuthDealRoleMenuRelReqBo;
import com.tydic.dyc.authority.service.role.bo.AuthDealRoleMenuRelRspBo;
import com.tydic.dyc.authority.service.role.bo.AuthRoleMenuRelBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.authority.utils.IdUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/3.3.0/com.tydic.dyc.authority.service.role.AuthDealRoleMenuRelService"})
public class AuthDealRoleMenuRelServiceImpl
implements AuthDealRoleMenuRelService {
    @Autowired
    private ISysRoleInfoModel iSysRoleInfoModel;

    @PostMapping(value={"dealRoleMenuRel"})
    public AuthDealRoleMenuRelRspBo dealRoleMenuRel(@RequestBody AuthDealRoleMenuRelReqBo reqBo) {
        AuthDealRoleMenuRelRspBo rspBo = AuthRu.success(AuthDealRoleMenuRelRspBo.class);
        this.validateArg(reqBo);
        SysRoleInfoQryBo qryListBo = new SysRoleInfoQryBo();
        qryListBo.setRoleId(reqBo.getRoleId());
        qryListBo.setApplicationCode(reqBo.getApplicationCode());
        SysRoleInfoDo oldRoleDo = this.iSysRoleInfoModel.getRoleMenuRelList(qryListBo);
        List<SysRoleMenuRelSubDo> oldDoList = AuthRu.jsl(oldRoleDo.getMenuList(), SysRoleMenuRelSubDo.class);
        SysRoleInfoDo reqDo = AuthRu.js(reqBo, SysRoleInfoDo.class);
        List<SysRoleMenuRelSubDo> newDoList = reqDo.getMenuRelList();
        ArrayList<SysRoleMenuRelSubDo> eqaulsOld = new ArrayList<SysRoleMenuRelSubDo>();
        ArrayList<SysRoleMenuRelSubDo> eqaulsNew = new ArrayList<SysRoleMenuRelSubDo>();
        if (!CollectionUtils.isEmpty(oldDoList)) {
            block0: for (SysRoleMenuRelSubDo oldDo : oldDoList) {
                for (SysRoleMenuRelSubDo newDo : newDoList) {
                    if (!oldDo.getMenuId().equals(newDo.getMenuId())) continue;
                    eqaulsNew.add(newDo);
                    eqaulsOld.add(oldDo);
                    continue block0;
                }
            }
            oldDoList.removeAll(eqaulsOld);
            newDoList.removeAll(eqaulsNew);
            this.addRolePower(reqDo, newDoList);
            this.deleteRolePower(reqDo, oldDoList);
        } else {
            this.addRolePower(reqDo, newDoList);
        }
        return rspBo;
    }

    private void addRolePower(SysRoleInfoDo reqDo, List<SysRoleMenuRelSubDo> newDoList) {
        SysRoleInfoDo addReqBo = new SysRoleInfoDo();
        for (SysRoleMenuRelSubDo subDo : newDoList) {
            subDo.setRelId(IdUtil.nextId());
            subDo.setRoleId(reqDo.getRoleId());
            subDo.setCreateOperId(reqDo.getUpdateOperId());
            subDo.setCreateOperName(reqDo.getUpdateOperName());
            subDo.setCreateTime(reqDo.getUpdateTime());
            subDo.setUpdateOperId(reqDo.getUpdateOperId());
            subDo.setUpdateOperName(reqDo.getUpdateOperName());
            subDo.setUpdateTime(reqDo.getUpdateTime());
        }
        addReqBo.setMenuRelList(newDoList);
        this.iSysRoleInfoModel.addRoleMenuRel(addReqBo);
    }

    private void deleteRolePower(SysRoleInfoDo reqDo, List<SysRoleMenuRelSubDo> oldDoList) {
        SysRoleInfoDo deleteDo = new SysRoleInfoDo();
        for (SysRoleMenuRelSubDo subDo : oldDoList) {
            subDo.setMenuId(subDo.getMenuId());
            subDo.setRoleId(reqDo.getRoleId());
            subDo.setUpdateOperId(reqDo.getUpdateOperId());
            subDo.setUpdateOperName(reqDo.getCreateOperName());
            subDo.setUpdateTime(reqDo.getCreateTime());
            subDo.setDelFlag("1");
        }
        deleteDo.setMenuRelList(oldDoList);
        this.iSysRoleInfoModel.updateRoleMenuRel(deleteDo);
    }

    private void validateArg(AuthDealRoleMenuRelReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthDealOrgRoleReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getRoleId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[RoleId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getApplicationCode() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[ApplicationCode]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getMenuRelList())) {
            for (AuthRoleMenuRelBo bo : reqBo.getMenuRelList()) {
                if (bo.getMenuId() != null) continue;
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[MenuId]\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
            }
        }
    }
}

