/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.subpage;

import com.tydic.dyc.authority.model.subpage.ISysSubpageModel;
import com.tydic.dyc.authority.model.subpage.SysSubpageDo;
import com.tydic.dyc.authority.service.subpage.AuthEnableSubpageService;
import com.tydic.dyc.authority.service.subpage.bo.AuthEnableSubpageReqBo;
import com.tydic.dyc.authority.service.subpage.bo.AuthEnableSubpageRspBo;
import com.tydic.dyc.authority.service.subpage.bo.AuthSubpageInfoBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/3.3.0/com.tydic.dyc.authority.service.subpage.AuthEnableSubpageService"})
public class AuthEnableSubpageServiceImpl
implements AuthEnableSubpageService {
    @Autowired
    private ISysSubpageModel iSysSubpageModel;

    @PostMapping(value={"enableSubpage"})
    public AuthEnableSubpageRspBo enableSubpage(@RequestBody AuthEnableSubpageReqBo reqBo) {
        AuthEnableSubpageRspBo rspBo = AuthRu.success(AuthEnableSubpageRspBo.class);
        this.validateArg(reqBo);
        ArrayList<Long> menuIds = new ArrayList<Long>();
        if (reqBo.getPageId() != null) {
            menuIds.add(reqBo.getPageId());
        } else {
            menuIds.addAll(reqBo.getPageIds());
        }
        SysSubpageDo reqDo = this.buildDoByBO(reqBo);
        reqDo.setPageIds(menuIds);
        SysSubpageDo rspDo = this.iSysSubpageModel.modifySubpageInfo(reqDo);
        AuthSubpageInfoBo DoToBo = AuthRu.js(rspDo, AuthSubpageInfoBo.class);
        rspBo.setSubpageInfoBo(DoToBo);
        return rspBo;
    }

    private SysSubpageDo buildDoByBO(AuthEnableSubpageReqBo reqBo) {
        reqBo.setUpdateTime(new Date());
        SysSubpageDo reqDo = AuthRu.js(reqBo, SysSubpageDo.class);
        reqDo.setPageStatus("1");
        return reqDo;
    }

    private void validateArg(AuthEnableSubpageReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthCreateMenuReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getPageId() == null && CollectionUtils.isEmpty((Collection)reqBo.getPageIds())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[PageId\u6216PageIds]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

