/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.tenant;

import com.tydic.dyc.authority.model.tenant.ISysTenantModel;
import com.tydic.dyc.authority.model.tenant.SysTenantInfoDo;
import com.tydic.dyc.authority.model.tenant.qrybo.SysTenantApplicationRelQryBo;
import com.tydic.dyc.authority.model.tenant.sub.SysApplicationSubDo;
import com.tydic.dyc.authority.model.tenant.sub.SysTenantApplicationRelSubDo;
import com.tydic.dyc.authority.service.tenant.AuthDealTenantApplicationService;
import com.tydic.dyc.authority.service.tenant.bo.AuthDealTenantApplicationReqBo;
import com.tydic.dyc.authority.service.tenant.bo.AuthDealTenantApplicationRspBo;
import com.tydic.dyc.authority.service.tenant.bo.AuthTenantApplicationRelBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.authority.utils.IdUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/3.3.0/com.tydic.dyc.authority.service.tenant.AuthDealTenantApplicationService"})
public class AuthDealTenantApplicationServiceImpl
implements AuthDealTenantApplicationService {
    @Autowired
    private ISysTenantModel iSysTenantModel;

    @PostMapping(value={"dealTenantApplication"})
    public AuthDealTenantApplicationRspBo dealTenantApplication(@RequestBody AuthDealTenantApplicationReqBo reqBo) {
        AuthDealTenantApplicationRspBo rspBo = AuthRu.success(AuthDealTenantApplicationRspBo.class);
        this.validateArg(reqBo);
        SysTenantApplicationRelQryBo qryListBo = new SysTenantApplicationRelQryBo();
        qryListBo.setTenantId(reqBo.getTenantId());
        SysTenantInfoDo sysTenantInfoDo = this.iSysTenantModel.getTenantApplicationRelList(qryListBo);
        List<SysApplicationSubDo> oldDoList = sysTenantInfoDo.getSysApplicationSubDos();
        SysTenantInfoDo reqDo = AuthRu.js(reqBo, SysTenantInfoDo.class);
        List<SysTenantApplicationRelSubDo> newDoList = reqDo.getTenantApplicationRelList();
        ArrayList<SysApplicationSubDo> eqaulsOld = new ArrayList<SysApplicationSubDo>();
        ArrayList<SysTenantApplicationRelSubDo> eqaulsNew = new ArrayList<SysTenantApplicationRelSubDo>();
        block0: for (SysApplicationSubDo oldDo : oldDoList) {
            for (SysTenantApplicationRelSubDo newDo : newDoList) {
                if (!oldDo.getApplicationId().equals(newDo.getApplicationId())) continue;
                eqaulsNew.add(newDo);
                eqaulsOld.add(oldDo);
                continue block0;
            }
        }
        oldDoList.removeAll(eqaulsOld);
        newDoList.removeAll(eqaulsNew);
        this.addTenantApp(reqDo, newDoList);
        this.deleteTenantApp(reqDo, oldDoList);
        return rspBo;
    }

    private void addTenantApp(SysTenantInfoDo reqDo, List<SysTenantApplicationRelSubDo> newDoList) {
        SysTenantInfoDo addReqBo = new SysTenantInfoDo();
        for (SysTenantApplicationRelSubDo subDo : newDoList) {
            subDo.setRelId(IdUtil.nextId());
            subDo.setTenantId(reqDo.getTenantId());
            subDo.setCreateOperId(reqDo.getUpdateOperId());
            subDo.setCreateOperName(reqDo.getUpdateOperName());
            subDo.setCreateTime(reqDo.getUpdateTime());
            subDo.setUpdateOperId(reqDo.getUpdateOperId());
            subDo.setUpdateOperName(reqDo.getUpdateOperName());
            subDo.setUpdateTime(reqDo.getUpdateTime());
        }
        addReqBo.setTenantApplicationRelList(newDoList);
        this.iSysTenantModel.addTenantApplicationRel(addReqBo);
    }

    private void deleteTenantApp(SysTenantInfoDo reqDo, List<SysApplicationSubDo> oldDoList) {
        SysTenantInfoDo addReqBo = new SysTenantInfoDo();
        ArrayList<SysTenantApplicationRelSubDo> delDoList = new ArrayList<SysTenantApplicationRelSubDo>();
        for (SysApplicationSubDo appDo : oldDoList) {
            SysTenantApplicationRelSubDo subDo = new SysTenantApplicationRelSubDo();
            subDo.setApplicationId(appDo.getApplicationId());
            subDo.setTenantId(reqDo.getTenantId());
            subDo.setUpdateOperId(reqDo.getUpdateOperId());
            subDo.setUpdateOperName(reqDo.getCreateOperName());
            subDo.setUpdateTime(reqDo.getCreateTime());
            subDo.setDelFlag("1");
            delDoList.add(subDo);
        }
        addReqBo.setTenantApplicationRelList(delDoList);
        this.iSysTenantModel.updateTenantApplicationRel(addReqBo);
    }

    private void validateArg(AuthDealTenantApplicationReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthDealTenantApplicationReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getTenantId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[TenantId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getApplicationList())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u53d8\u66f4\u5217\u8868]\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getApplicationList())) {
            for (AuthTenantApplicationRelBo bo : reqBo.getApplicationList()) {
                if (bo.getApplicationId() != null) continue;
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[ApplicationId]\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
            }
        }
    }
}

