/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.user;

import com.tydic.dyc.authority.service.user.AuthGetThirdBindListBatchService;
import com.tydic.dyc.authority.service.user.bo.AuthGetThirdBindListBatchReqBo;
import com.tydic.dyc.authority.service.user.bo.AuthGetThirdBindListBatchRspBo;
import com.tydic.dyc.authority.service.user.bo.AuthGetThirdBindListBo;
import com.tydic.dyc.authority.service.user.bo.AuthThirdBindBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.user.IUmcUserInfoModel;
import com.tydic.dyc.umc.model.user.UmcUserInfoDo;
import com.tydic.dyc.umc.model.user.qrybo.SysThirdBindQryBo;
import com.tydic.dyc.umc.model.user.sub.SysThirdBindSubDo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/3.3.0/com.tydic.dyc.authority.service.user.AuthGetThirdBindListBatchService"})
public class AuthGetThirdBindListBatchServiceImpl
implements AuthGetThirdBindListBatchService {
    @Autowired
    private IUmcUserInfoModel iSysUserInfoModel;

    @PostMapping(value={"getThirdBindList"})
    public AuthGetThirdBindListBatchRspBo getThirdBindList(@RequestBody AuthGetThirdBindListBatchReqBo reqBo) {
        AuthGetThirdBindListBatchRspBo rspBo = AuthRu.success(AuthGetThirdBindListBatchRspBo.class);
        this.validateArg(reqBo);
        SysThirdBindQryBo qryBo = new SysThirdBindQryBo();
        qryBo.setCustIds(reqBo.getCustIds());
        UmcUserInfoDo sysUserInfoDo = this.iSysUserInfoModel.getThirdBindList(qryBo);
        List<SysThirdBindSubDo> rspDoList = sysUserInfoDo.getSysThirdBindSubDos();
        if (!CollectionUtils.isEmpty(rspDoList)) {
            Map<Long, List<SysThirdBindSubDo>> custMap = rspDoList.stream().collect(Collectors.groupingBy(SysThirdBindSubDo::getCustId));
            ArrayList authGetThirdBindListBos = new ArrayList(custMap.size());
            custMap.forEach((custId, custDoList) -> {
                AuthGetThirdBindListBo authGetThirdBindListBo = new AuthGetThirdBindListBo();
                authGetThirdBindListBo.setCustId(custId);
                authGetThirdBindListBo.setThirdBindList(AuthRu.jsl(custDoList, AuthThirdBindBo.class));
                authGetThirdBindListBos.add(authGetThirdBindListBo);
            });
            rspBo.setRows(authGetThirdBindListBos);
        }
        return rspBo;
    }

    private void validateArg(AuthGetThirdBindListBatchReqBo reqBo) {
        if (CollectionUtils.isEmpty((Collection)reqBo.getCustIds())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[custIds]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

