/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.user;

import com.tydic.dyc.authority.service.user.AuthGetUserInfoDetailService;
import com.tydic.dyc.authority.service.user.bo.AuthGetUserInfoDetailReqBo;
import com.tydic.dyc.authority.service.user.bo.AuthGetUserInfoDetailRspBo;
import com.tydic.dyc.authority.service.user.bo.AuthUserInfoBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.authority.utils.StrUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.user.IUmcUserInfoModel;
import com.tydic.dyc.umc.model.user.UmcUserInfoDo;
import com.tydic.dyc.umc.model.user.qrybo.UmcUserInfoQryBo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/3.3.0/com.tydic.dyc.authority.service.user.AuthGetUserInfoDetailService"})
public class AuthGetUserInfoDetailServiceImpl
implements AuthGetUserInfoDetailService {
    @Autowired
    private IUmcUserInfoModel iSysUserInfoModel;

    @PostMapping(value={"getUserInfoDetail"})
    public AuthGetUserInfoDetailRspBo getUserInfoDetail(@RequestBody AuthGetUserInfoDetailReqBo reqBo) {
        AuthGetUserInfoDetailRspBo rspBo = AuthRu.success(AuthGetUserInfoDetailRspBo.class);
        this.validateArg(reqBo);
        UmcUserInfoQryBo qryBo = StrUtil.noNullStringAttr(AuthRu.js(reqBo, UmcUserInfoQryBo.class));
        UmcUserInfoDo rspDo = this.iSysUserInfoModel.getUserInfoDetails(qryBo);
        if (rspDo == null || rspDo.getUserId() == null) {
            throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f");
        }
        AuthUserInfoBo DoToBo = AuthRu.js(rspDo, AuthUserInfoBo.class);
        DoToBo.getCustInfo().setLoginName(rspDo.getCustInfo().getRegAccount());
        DoToBo.getCustInfo().setCellPhone(rspDo.getCustInfo().getRegMobile());
        rspBo.setUserInfoBo(DoToBo);
        return rspBo;
    }

    private void validateArg(AuthGetUserInfoDetailReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthGetThirdBindListReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getUserId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[userId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

