/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.config.IUmcConfigModel;
import com.tydic.dyc.umc.model.config.qrybo.UmcConfTabOrdStateQryBo;
import com.tydic.dyc.umc.model.config.qrybo.UmcConfTabOrdStateQryRspBo;
import com.tydic.dyc.umc.model.config.qrybo.UmcTacheButtonQryBo;
import com.tydic.dyc.umc.model.config.qrybo.UmcTacheButtonQryRspBo;
import com.tydic.dyc.umc.model.config.sub.UmcConfTabOrdState;
import com.tydic.dyc.umc.model.config.sub.UmcTacheButton;
import com.tydic.dyc.umc.service.config.UmcTabBtnConfSaveCacheService;
import com.tydic.dyc.umc.service.config.bo.UmcTabBtnConfSaveCacheReqBo;
import com.tydic.dyc.umc.service.config.bo.UmcTabBtnConfSaveCacheRspBo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/3.3.0/com.tydic.dyc.umc.service.config.UmcTabBtnConfSaveCacheService"})
public class UmcTabBtnConfSaveCacheServiceImpl
implements UmcTabBtnConfSaveCacheService {
    private static final Logger log = LoggerFactory.getLogger(UmcTabBtnConfSaveCacheServiceImpl.class);
    @Autowired
    private IUmcConfigModel iUmcConfigModel;
    private static final String TAB_ORDER_BY = "center, menu_code, sort";
    private static final String BTN_ORDER_BY = "center, tab_id, sort";
    @Autowired
    private CacheClient cacheClient;

    @PostMapping(value={"saveCacheTabBtnConf"})
    public UmcTabBtnConfSaveCacheRspBo saveCacheTabBtnConf(@RequestBody UmcTabBtnConfSaveCacheReqBo reqBo) {
        this.val(reqBo);
        List<String> centerList = reqBo.getCenterList().stream().distinct().collect(Collectors.toList());
        UmcConfTabOrdStateQryBo umcConfTabOrdStateQryBo = new UmcConfTabOrdStateQryBo();
        umcConfTabOrdStateQryBo.setCenterList(centerList);
        umcConfTabOrdStateQryBo.setOrderBy(TAB_ORDER_BY);
        UmcConfTabOrdStateQryRspBo umcConfTabOrdStateQryRspBo = this.iUmcConfigModel.qryConfTabOrdStateList(umcConfTabOrdStateQryBo);
        if (!CollectionUtils.isEmpty(umcConfTabOrdStateQryRspBo.getUmcConfTabOrdStates())) {
            UmcTacheButtonQryBo umcTacheButtonQryBo = new UmcTacheButtonQryBo();
            umcTacheButtonQryBo.setCenterList(reqBo.getCenterList());
            umcTacheButtonQryBo.setOrderBy(BTN_ORDER_BY);
            UmcTacheButtonQryRspBo umcTacheButtonQryRspBo = this.iUmcConfigModel.qryTacheButtonList(umcTacheButtonQryBo);
            if (!CollectionUtils.isEmpty(umcTacheButtonQryRspBo.getUmcTacheButtonList())) {
                HashMap umcTacheButtonMap = new HashMap();
                umcTacheButtonQryRspBo.getUmcTacheButtonList().forEach(umcTacheButton -> {
                    String key = umcTacheButton.getCenter() + umcTacheButton.getTabId();
                    ArrayList<UmcTacheButton> umcTacheButtonList = (ArrayList<UmcTacheButton>)umcTacheButtonMap.get(key);
                    if (CollectionUtils.isEmpty((Collection)umcTacheButtonList)) {
                        umcTacheButtonList = new ArrayList<UmcTacheButton>();
                        umcTacheButtonMap.put(key, umcTacheButtonList);
                    }
                    umcTacheButtonList.add((UmcTacheButton)umcTacheButton);
                });
                umcConfTabOrdStateQryRspBo.getUmcConfTabOrdStates().forEach(umcConfTabOrdState -> umcConfTabOrdState.setUmcTacheButtonList((List)umcTacheButtonMap.get(umcConfTabOrdState.getCenter() + umcConfTabOrdState.getTabId())));
            }
            HashMap<String, List> umcConfTabMap = new HashMap<String, List>();
            umcConfTabOrdStateQryRspBo.getUmcConfTabOrdStates().forEach(umcConfTabOrdState -> {
                ArrayList<UmcConfTabOrdState> umcConfTabOrdStates = (ArrayList<UmcConfTabOrdState>)umcConfTabMap.get(umcConfTabOrdState.getCenter());
                if (CollectionUtils.isEmpty((Collection)umcConfTabOrdStates)) {
                    umcConfTabOrdStates = new ArrayList<UmcConfTabOrdState>();
                    umcConfTabMap.put(umcConfTabOrdState.getCenter(), umcConfTabOrdStates);
                }
                umcConfTabOrdStates.add((UmcConfTabOrdState)umcConfTabOrdState);
            });
            HashMap btnMap = new HashMap();
            Object btnObj = this.cacheClient.get("TAB_BTN_CONF_");
            if (null != btnObj) {
                JSONObject json = JSON.parseObject((String)btnObj.toString());
                json.forEach((key, obj) -> btnMap.put(key, (Map)obj));
            }
            umcConfTabMap.forEach((center, umcConfTabOrdStates) -> {
                HashMap menuCodeTabConfMap = new HashMap();
                umcConfTabOrdStates.forEach(umcConfTabOrdState -> {
                    ArrayList<UmcConfTabOrdState> menuTabConf = (ArrayList<UmcConfTabOrdState>)menuCodeTabConfMap.get(umcConfTabOrdState.getMenuCode());
                    if (CollectionUtils.isEmpty((Collection)menuTabConf)) {
                        menuTabConf = new ArrayList<UmcConfTabOrdState>();
                        menuCodeTabConfMap.put(umcConfTabOrdState.getMenuCode(), menuTabConf);
                    }
                    menuTabConf.add((UmcConfTabOrdState)umcConfTabOrdState);
                });
                btnMap.put(center, menuCodeTabConfMap);
            });
            String btnJson = ((JSONObject)JSON.toJSON(btnMap)).toJSONString();
            if (log.isDebugEnabled()) {
                log.debug("\u4e2d\u5fc3KEY:{},\u53c2\u6570:{}", (Object)"TAB_BTN_CONF_", (Object)btnJson);
            }
            this.cacheClient.set("TAB_BTN_CONF_", (Object)btnJson);
        }
        return UmcRu.success(UmcTabBtnConfSaveCacheRspBo.class);
    }

    private void val(UmcTabBtnConfSaveCacheReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getCenterList())) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u6240\u5c5e\u4e2d\u5fc3\u4e3a\u7a7a");
        }
        reqBo.getCenterList().forEach(center -> {
            if (StringUtils.isBlank((CharSequence)center)) {
                throw new BaseBusinessException("200001", "\u5165\u53c2\u6240\u5c5e\u4e2d\u5fc3\u4e3a\u7a7a");
            }
        });
    }
}

