/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.gx.libs.tapclient.proxy;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.tydic.gx.libs.tapclient.annotation.TapMethod;
import com.tydic.gx.libs.tapclient.config.TapProperties;
import com.tydic.gx.libs.tapclient.config.TapTokenStore;
import com.tydic.gx.libs.tapclient.dto.TapResp;
import com.tydic.gx.libs.tapclient.dto.UniBssBody;
import com.tydic.gx.libs.tapclient.dto.ZBTapResp;
import com.tydic.gx.libs.tapclient.exception.TapCallEx;
import com.tydic.gx.libs.tapclient.utils.DateUtils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class TapCaller {
    private static Logger logger = Logger.getLogger(TapCaller.class.getName());
    private static final String DEF_VAL_URL = "appKey={appKey}&timestamp={timestamp}&transactionID={transactionID}&v={v}&format={format}&token={token}&sign={sign}";
    public static final String DATA_LABEL = "data";
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private TapTokenStore tapTokenStore;
    @Autowired
    private TapProperties props;

    public TapCaller() {
    }

    public TapCaller(TapProperties tapProperties, TapTokenStore tapTokenStore) {
        this.props = tapProperties;
        this.tapTokenStore = tapTokenStore;
    }

    private JSONObject callTransInner(TapMethod tapMethod, Object[] args) {
        UniBssBody body = new UniBssBody();
        body.setData((tapMethod.serviceCode() + "_REQ").toUpperCase(), args[0]);
        HttpHeaders headers = new HttpHeaders();
        headers.set("Accept-Encoding", "");
        JSONObject reqData = new JSONObject();
        reqData.put(DATA_LABEL, (Object)JSON.toJSONString((Object)body));
        HttpEntity request = new HttpEntity((Object)reqData, (MultiValueMap)headers);
        JSONObject resp = (JSONObject)this.restTemplate.postForObject(this.buildUrl(tapMethod.path()), (Object)request, JSONObject.class, this.getParamMap((String)this.tapTokenStore.get(tapMethod.path()), reqData.getString(DATA_LABEL)));
        return resp;
    }

    private JSONObject callTrans(TapMethod tapMethod, Object[] args) {
        TapResp tapResp;
        String dataJsonStr;
        if (args.length != 1) {
            throw new IllegalArgumentException("\u8bf7\u6c42\u53c2\u6570\u4e0d\u6b63\u786e");
        }
        Assert.isTrue((boolean)this.tapTokenStore.containsKey(tapMethod.path()), (String)("\u7f3a\u5c11 Token \u914d\u7f6e :" + tapMethod.path()));
        HttpHeaders headers = new HttpHeaders();
        headers.set("Accept-Encoding", "");
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap reqData = new LinkedMultiValueMap();
        if (!tapMethod.serviceCode().isEmpty()) {
            JSONObject tmpReqData = new JSONObject();
            tmpReqData.put(tapMethod.serviceCode() + "_REQ", args[0]);
            dataJsonStr = JSONObject.toJSONString((Object)tmpReqData);
        } else {
            dataJsonStr = JSON.toJSONString((Object)args[0]);
        }
        reqData.add((Object)DATA_LABEL, (Object)dataJsonStr);
        if (logger.isLoggable(Level.FINE)) {
            logger.info(dataJsonStr);
        }
        HttpEntity request = new HttpEntity((Object)reqData, (MultiValueMap)headers);
        String respJson = (String)this.restTemplate.postForObject(this.buildUrl(tapMethod.path()), (Object)request, String.class, this.getParamMap((String)this.tapTokenStore.get(tapMethod.path()), dataJsonStr));
        if (logger.isLoggable(Level.FINE)) {
            logger.info(respJson);
        }
        if (!(tapResp = (TapResp)JSON.parseObject((String)respJson, TapResp.class)).isSuccess()) {
            throw new TapCallEx(tapResp);
        }
        if (!tapMethod.serviceCode().isEmpty()) {
            ZBTapResp zbTapResp = (ZBTapResp)JSON.parseObject((String)respJson, ZBTapResp.class);
            if (!zbTapResp.isSuccess()) {
                throw new TapCallEx(zbTapResp.getHead().getRespCode(), zbTapResp.getHead().getRespDesc());
            }
            return zbTapResp.getBody().getJSONObject(tapMethod.serviceCode() + "_RSP");
        }
        return tapResp.getData();
    }

    public <T> T call(TapMethod tapMethod, Object[] args, Class<T> rspType) {
        JSONObject respData = this.callTrans(tapMethod, args);
        if (rspType == JSONObject.class) {
            return (T)respData;
        }
        return (T)JSONObject.parseObject((String)respData.toJSONString(), rspType);
    }

    public <T> List<T> callList(TapMethod tapMethod, Object[] args, Class<T> rspType) {
        JSONObject respData = this.callTrans(tapMethod, args);
        return (List)JSON.parseObject((String)respData.toJSONString(), (TypeReference)new TypeReference<List<T>>(new Type[]{rspType}){}, (Feature[])new Feature[0]);
    }

    private Map<String, String> getParamMap(String token, String dataJsonStr) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        TreeMap<String, String> signMap = new TreeMap<String, String>();
        signMap.put("appKey", this.props.getAppId());
        signMap.put("v", this.props.getVersion());
        signMap.put("format", this.props.getFormat());
        signMap.put("transactionID", UUID.randomUUID().toString());
        signMap.put("timestamp", DateUtils.timestamp.format(new Date()));
        signMap.put("token", token);
        paramMap.putAll(signMap);
        signMap.put(DATA_LABEL, dataJsonStr);
        ArrayList<String> params = new ArrayList<String>();
        params.add(this.props.getAppSecret());
        for (Map.Entry entry : signMap.entrySet()) {
            params.add((String)entry.getKey());
            params.add((String)entry.getValue());
        }
        params.add(this.props.getAppSecret());
        String sign = DigestUtils.sha1Hex((String)StringUtils.join((Object[])params.toArray())).toUpperCase();
        paramMap.put("sign", sign);
        return paramMap;
    }

    private String buildUrl(String path) {
        return this.getProps().getBaseUrl() + path + "?" + DEF_VAL_URL;
    }

    @PostConstruct
    public void afterPropertiesSet() {
        Assert.notNull((Object)this.tapTokenStore, (String)"\u672a\u521d\u59cb\u5316 Token \u5217\u8868");
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public void setTapTokenStore(TapTokenStore tapTokenStore) {
        this.tapTokenStore = tapTokenStore;
    }

    public TapTokenStore getTapTokenStore() {
        return this.tapTokenStore;
    }

    public void setProps(TapProperties props) {
        this.props = props;
    }

    public TapProperties getProps() {
        return this.props;
    }
}

