/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.gx.libs.tapclient.proxy;

import com.tydic.gx.libs.tapclient.annotation.TapMethod;
import com.tydic.gx.libs.tapclient.exception.TapCallEx;
import com.tydic.gx.libs.tapclient.proxy.TapCaller;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Collection;
import org.springframework.core.annotation.AnnotationUtils;

public class TapClientInvocationHandler
implements InvocationHandler {
    private TapCaller tapCaller;
    private Class<?> interfaceClass;

    public void setTapCaller(TapCaller tapCaller) {
        this.tapCaller = tapCaller;
    }

    public Object bind(Class<?> cls) {
        this.interfaceClass = cls;
        return Proxy.newProxyInstance(cls.getClassLoader(), new Class[]{this.interfaceClass}, (InvocationHandler)this);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        if (method.isAnnotationPresent(TapMethod.class)) {
            TapMethod tapMethod = (TapMethod)AnnotationUtils.getAnnotation((Method)method, TapMethod.class);
            try {
                ParameterizedType type;
                Type returnType = method.getGenericReturnType();
                if (returnType instanceof ParameterizedType && Collection.class.isAssignableFrom((Class)(type = (ParameterizedType)returnType).getRawType())) {
                    return this.tapCaller.callList(tapMethod, args, (Class)type.getActualTypeArguments()[0]);
                }
                return this.tapCaller.call(tapMethod, args, method.getReturnType());
            }
            catch (TapCallEx ex) {
                throw ex;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new TapCallEx("9999", "\u8c03\u7528\u5f02\u5e38\uff1a" + e.getMessage());
            }
        }
        return null;
    }
}

