/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.plugin.encoded.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.cfc.ability.api.CfcEncodedRuleQryDetailAbilityService;
import com.tydic.cfc.ability.api.CfcEncodedRuleSelectCodeAbilityService;
import com.tydic.cfc.ability.bo.CfcEncodedRuleBO;
import com.tydic.cfc.ability.bo.CfcEncodedRuleSelectCodeAbilityReqBo;
import com.tydic.cfc.ability.bo.CfcEncodedRuleSelectCodeAbilityRspBo;
import com.tydic.plugin.encoded.dao.CfcEncodedSerialGenerateMapper;
import com.tydic.plugin.encoded.dao.CfcEncodedSerialMapper;
import com.tydic.plugin.encoded.dao.po.CfcEncodedSerialGeneratePO;
import com.tydic.plugin.encoded.dao.po.CfcEncodedSerialPO;
import com.tydic.plugin.encoded.exception.CfcEncodedPluginBusinessException;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialServiceRspBO;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service(value="cfcEncodedSerialGetService")
public class CfcEncodedSerialGetServiceImpl
implements CfcEncodedSerialGetService {
    private static final Logger log = LoggerFactory.getLogger(CfcEncodedSerialGetServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(CfcEncodedSerialGetServiceImpl.class);
    @Autowired
    private CfcEncodedRuleSelectCodeAbilityService cfcEncodedRuleSelectCodeAbilityService;
    @Autowired
    private CfcEncodedRuleQryDetailAbilityService cfcEncodedRuleQryDetailAbilityService;
    @Autowired
    private CfcEncodedSerialMapper cfcEncodedSerialMapper;
    @Autowired
    private CfcEncodedSerialGenerateMapper cfcEncodedSerialGenerateMapper;
    @Resource
    private CacheClient cacheService;
    private static final String CHANGE_ENCODED = "change_encoded";
    @Autowired
    private DataSourceTransactionManager dataSourceTransactionManager;

    @Override
    public CfcEncodedSerialGetServiceRspBO getEncodedSerial(CfcEncodedSerialGetServiceReqBO reqBO) {
        CfcEncodedSerialServiceRspBO cfcEncodedSerialServiceRspBO;
        CfcEncodedSerialGetServiceRspBO rspBO = new CfcEncodedSerialGetServiceRspBO();
        try {
            cfcEncodedSerialServiceRspBO = this.transaction(reqBO);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            cfcEncodedSerialServiceRspBO = this.transaction(reqBO);
        }
        rspBO.setSerialNoList(cfcEncodedSerialServiceRspBO.getSerialNoList());
        return rspBO;
    }

    private CfcEncodedSerialServiceRspBO transaction(CfcEncodedSerialGetServiceReqBO reqBO) {
        CfcEncodedSerialServiceRspBO cfcEncodedSerialServiceRspBO;
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.dataSourceTransactionManager.getTransaction((TransactionDefinition)def);
        try {
            cfcEncodedSerialServiceRspBO = this.getSerial(reqBO);
            this.dataSourceTransactionManager.commit(status);
        }
        catch (Exception e) {
            this.dataSourceTransactionManager.rollback(status);
            throw new CfcEncodedPluginBusinessException("8888", "\u66f4\u65b0\u7f16\u7801\u5e8f\u5217\u5931\u8d25");
        }
        return cfcEncodedSerialServiceRspBO;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public CfcEncodedSerialServiceRspBO getSerial(CfcEncodedSerialGetServiceReqBO reqBO) {
        int i;
        int result;
        log.info("\u83b7\u53d6\u7f16\u7801\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBO));
        CfcEncodedSerialServiceRspBO rspBO = new CfcEncodedSerialServiceRspBO();
        this.validParam(reqBO);
        Map<Long, Integer> restartMap = this.changeValid(reqBO);
        CfcEncodedSerialPO esParam = new CfcEncodedSerialPO();
        esParam.setCenter(reqBO.getCenter());
        esParam.setEncodedRuleCode(reqBO.getEncodedRuleCode());
        esParam.setEffFlag("1");
        List<CfcEncodedSerialPO> cfcEncodedSerialPOS = this.cfcEncodedSerialMapper.getList(esParam);
        List<CfcEncodedSerialPO> validList = new ArrayList<CfcEncodedSerialPO>();
        ArrayList<Long> invalidIds = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty(cfcEncodedSerialPOS)) {
            for (CfcEncodedSerialPO itemPO : cfcEncodedSerialPOS) {
                String effDate = this.composeEffDate(itemPO);
                if (StringUtils.isEmpty((CharSequence)effDate)) continue;
                if ("none".equals(effDate) || effDate.equals(itemPO.getEffDate())) {
                    validList.add(itemPO);
                    continue;
                }
                invalidIds.add(itemPO.getId());
            }
        }
        log.info("\u67e5\u8be2\u672c\u4e2d\u5fc3\u5e93\uff0c\u6839\u636e\u751f\u6548\u7c7b\u578b\u8fc7\u6ee4\u5f97\u5230\u7684\u6709\u6548\u5217\u8868\uff1a{}", (Object)JSON.toJSONString(validList));
        if (!CollectionUtils.isEmpty(invalidIds) && (result = this.cfcEncodedSerialMapper.updateInvalidBatch(invalidIds)) < 1) {
            throw new CfcEncodedPluginBusinessException("8888", "\u66f4\u65b0\u5931\u6548\u7f16\u7801\u5e8f\u5217\u72b6\u6001\u5931\u8d25");
        }
        Boolean hasQueriedCfc = false;
        if (CollectionUtils.isEmpty(validList)) {
            log.info("=== \u6839\u636e\u751f\u6548\u7c7b\u578b\u8fc7\u6ee4\u540e\uff0c\u6709\u6548\u5217\u8868\u4e3a\u7a7a\uff0c\u51c6\u5907\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3");
            hasQueriedCfc = true;
            validList.addAll(this.getAllEncodedSerialPO(esParam));
            int insertFlag = this.cfcEncodedSerialMapper.insertBatch(validList);
            if (insertFlag < 1) {
                throw new CfcEncodedPluginBusinessException("8888", "\u66f4\u65b0\u7f16\u7801\u5e8f\u5217\u5931\u8d25");
            }
        }
        CfcEncodedSerialPO cfcEncodedSerialPO = this.filterByRelId(reqBO, validList);
        if (hasQueriedCfc.booleanValue() && ObjectUtils.isEmpty((Object)cfcEncodedSerialPO)) {
            log.info("=== \u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3\u5f97\u5230\u7684\u5217\u8868\u6839\u636e\u5173\u7cfbID\u8fc7\u6ee4\u540e\u5f97\u5230\u7684\u5bf9\u8c61\u4e3a\u7a7a");
            throw new CfcEncodedPluginBusinessException("8888", "\u672a\u83b7\u53d6\u5230\u5173\u8054\u7684\u7f16\u7801\u89c4\u5219");
        }
        if (ObjectUtils.isEmpty((Object)cfcEncodedSerialPO)) {
            log.info("=== \u672c\u4e2d\u5fc3\u6709\u6548\u5217\u8868\u4e0d\u4e3a\u7a7a\uff0c\u4f46\u6839\u636e\u5173\u7cfbID\u8fc7\u6765\u540e\u5f97\u5230\u7684\u5e8f\u5217\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u51c6\u5907\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3");
            validList = this.getAllEncodedSerialPO(esParam);
            cfcEncodedSerialPO = this.filterByRelId(reqBO, validList);
            if (ObjectUtils.isEmpty((Object)cfcEncodedSerialPO)) {
                throw new CfcEncodedPluginBusinessException("8888", "\u672a\u83b7\u53d6\u5230\u5173\u8054\u7684\u7f16\u7801\u89c4\u5219");
            }
            int insertFlag = this.cfcEncodedSerialMapper.insert(cfcEncodedSerialPO);
            if (insertFlag < 1) {
                throw new CfcEncodedPluginBusinessException("8888", "\u66f4\u65b0\u5173\u8054\u7684\u7f16\u7801\u5e8f\u5217\u5931\u8d25");
            }
        }
        ArrayList<String> serialNoList = new ArrayList<String>();
        CfcEncodedSerialGeneratePO esgParam = new CfcEncodedSerialGeneratePO();
        String generatePrefix = cfcEncodedSerialPO.getEncodedSerialPrefix();
        if (reqBO.getReplaceJson() != null && reqBO.getReplaceJson().size() > 0) {
            for (Map.Entry itemJson : reqBO.getReplaceJson().entrySet()) {
                String itemJsonKey = "\\$\\{" + (String)itemJson.getKey() + "\\}";
                generatePrefix = generatePrefix.replaceAll(itemJsonKey, itemJson.getValue().toString());
            }
        } else if (!CollectionUtils.isEmpty(reqBO.getReplaceValue())) {
            String sp = "\\$\\{\\w+\\}";
            Pattern p = Pattern.compile(sp);
            Matcher m = p.matcher(generatePrefix);
            StringBuffer sb = new StringBuffer();
            i = 0;
            while (m.find()) {
                if (i >= reqBO.getReplaceValue().size()) continue;
                String key = m.group(0);
                m.appendReplacement(sb, reqBO.getReplaceValue().get(i++));
            }
            m.appendTail(sb);
            generatePrefix = sb.toString();
        }
        esgParam.setSerialId(cfcEncodedSerialPO.getId());
        esgParam.setGeneratePrefix(generatePrefix);
        List<CfcEncodedSerialGeneratePO> esgList = this.cfcEncodedSerialGenerateMapper.getList(esgParam);
        Integer num = reqBO.getNum() != null ? reqBO.getNum() : 1;
        Long esgId = null;
        if (esgList != null && esgList.size() > 0) {
            esgId = esgList.get(0).getId();
            int updateFlag = this.cfcEncodedSerialGenerateMapper.updateGenerateValue(esgId, num);
            if (updateFlag < 1) {
                throw new CfcEncodedPluginBusinessException("8888", "\u66f4\u65b0\u6d41\u6c34\u53f7\u5931\u8d25");
            }
        } else {
            esgId = Sequence.getInstance().nextId();
            esgParam.setId(esgId);
            int genValue = num;
            if (reqBO.getInitNum() != null) {
                genValue += reqBO.getInitNum().intValue();
            }
            if (restartMap.get(cfcEncodedSerialPO.getId()) != null) {
                esgParam.setGenerateValue(genValue + restartMap.get(cfcEncodedSerialPO.getId()));
            } else {
                esgParam.setGenerateValue(genValue);
            }
            int insertFlag = this.cfcEncodedSerialGenerateMapper.insert(esgParam);
            if (insertFlag < 1) {
                throw new CfcEncodedPluginBusinessException("8888", "\u66f4\u65b0\u6d41\u6c34\u53f7\u5931\u8d25");
            }
        }
        CfcEncodedSerialGeneratePO esgPO = this.cfcEncodedSerialGenerateMapper.selectByPrimaryKey(esgId);
        for (i = num - 1; i >= 0; --i) {
            String serialNo = esgPO.getGeneratePrefix() + String.format("%0" + cfcEncodedSerialPO.getEncodedSerialDigit() + "d", esgPO.getGenerateValue() - i);
            serialNoList.add(serialNo);
        }
        rspBO.setSerialNoList(serialNoList);
        rspBO.setCfcEncodedSerialPO(cfcEncodedSerialPO);
        rspBO.setCfcEncodedSerialGeneratePO(esgPO);
        return rspBO;
    }

    private CfcEncodedSerialPO filterByRelId(CfcEncodedSerialGetServiceReqBO reqBO, List<CfcEncodedSerialPO> validList) {
        CfcEncodedSerialPO cfcEncodedSerialPO = null;
        int extendLength = -1;
        for (CfcEncodedSerialPO itemPO : validList) {
            if (StringUtils.isBlank((CharSequence)reqBO.getRelId())) {
                if (!StringUtils.isBlank((CharSequence)itemPO.getRelId())) continue;
                cfcEncodedSerialPO = itemPO;
                break;
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getRelType())) {
                reqBO.setRelType("org");
            }
            if (StringUtils.isBlank((CharSequence)itemPO.getRelId())) {
                if (cfcEncodedSerialPO != null) continue;
                cfcEncodedSerialPO = itemPO;
                continue;
            }
            if ("1".equals(reqBO.getExtendFlag())) {
                if (!reqBO.getRelId().contains(itemPO.getRelId()) || !reqBO.getRelType().equals(itemPO.getRelType())) continue;
                String[] ids = reqBO.getRelId().split("-");
                for (int i = 0; i < ids.length; ++i) {
                    if (!ids[i].equals(itemPO.getRelId()) || i <= extendLength) continue;
                    extendLength = i;
                    cfcEncodedSerialPO = itemPO;
                }
                continue;
            }
            if (!reqBO.getRelId().equals(itemPO.getRelId()) || !reqBO.getRelType().equals(itemPO.getRelType())) continue;
            cfcEncodedSerialPO = itemPO;
            break;
        }
        return cfcEncodedSerialPO;
    }

    private Map<Long, Integer> changeValid(CfcEncodedSerialGetServiceReqBO reqBO) {
        LOGGER.info("=============\u7f16\u7801\u53d8\u66f4\u6821\u9a8c\u5f00\u59cb==============");
        HashMap<Long, Integer> restartMap = new HashMap<Long, Integer>();
        String changeRedisKey = "change_encoded_" + reqBO.getCenter();
        LOGGER.info("\u7f16\u7801\u53d8\u66f4     changeRedisKey : {}", (Object)changeRedisKey);
        HashMap<String, List<CfcEncodedSerialPO>> map = new HashMap<String, List<CfcEncodedSerialPO>>();
        Object changeRedisObject = this.cacheService.get(changeRedisKey);
        JSONArray jsonArray = null;
        if (changeRedisObject != null) {
            jsonArray = JSONArray.parseArray((String)changeRedisObject.toString());
            this.cacheService.delete(changeRedisKey);
        } else {
            jsonArray = new JSONArray();
        }
        if (jsonArray != null && jsonArray.size() > 0) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                CfcEncodedRuleSelectCodeAbilityReqBo cfcEncodedRuleQryDetailAbilityReqBO = new CfcEncodedRuleSelectCodeAbilityReqBo();
                cfcEncodedRuleQryDetailAbilityReqBO.setId(jsonObject.getLong("id"));
                CfcEncodedRuleSelectCodeAbilityRspBo cfcEncodedRuleSelectCodeAbilityRspBo = this.cfcEncodedRuleSelectCodeAbilityService.selectEncodedRuleDetail(cfcEncodedRuleQryDetailAbilityReqBO);
                if (!"0000".equals(cfcEncodedRuleSelectCodeAbilityRspBo.getRespCode())) {
                    throw new CfcEncodedPluginBusinessException(cfcEncodedRuleSelectCodeAbilityRspBo.getRespCode(), cfcEncodedRuleSelectCodeAbilityRspBo.getRespDesc());
                }
                CfcEncodedRuleBO cfcEncodedRuleBO = null;
                if (!CollectionUtils.isEmpty((Collection)cfcEncodedRuleSelectCodeAbilityRspBo.getEncodedRuleList())) {
                    cfcEncodedRuleBO = (CfcEncodedRuleBO)cfcEncodedRuleSelectCodeAbilityRspBo.getEncodedRuleList().get(0);
                }
                LOGGER.info("\u7f16\u7801\u53d8\u66f4     cfcEncodedRuleBO : {}", (Object)JSONObject.toJSONString(cfcEncodedRuleBO));
                List<CfcEncodedSerialPO> cfcEncodedSerialPOS = (List<CfcEncodedSerialPO>)map.get(cfcEncodedRuleBO.getEncodedRuleCode());
                if (CollectionUtils.isEmpty((Collection)cfcEncodedSerialPOS)) {
                    CfcEncodedSerialPO esParam = new CfcEncodedSerialPO();
                    esParam.setCenter(cfcEncodedRuleBO.getCenter());
                    esParam.setEncodedRuleCode(cfcEncodedRuleBO.getEncodedRuleCode());
                    esParam.setEffFlag("1");
                    cfcEncodedSerialPOS = this.cfcEncodedSerialMapper.getList(esParam);
                }
                if (CollectionUtils.isEmpty((Collection)cfcEncodedSerialPOS)) continue;
                LOGGER.info("\u7f16\u7801\u53d8\u66f4     encodedSerialPOMap : {}", (Object)JSONObject.toJSONString((Object)cfcEncodedSerialPOS));
                CfcEncodedSerialPO insertPO = new CfcEncodedSerialPO();
                BeanUtils.copyProperties((Object)cfcEncodedRuleBO, (Object)insertPO);
                insertPO.setId(Sequence.getInstance().nextId());
                insertPO.setEncodedSerialPrefix(cfcEncodedRuleBO.getEncodedSerialPrefix());
                insertPO.setEncodedSerialDigit(cfcEncodedRuleBO.getEncodedSerialDigit());
                insertPO.setEffFlag("1");
                insertPO.setEffType(cfcEncodedRuleBO.getEffType());
                insertPO.setEffDate(this.composeEffDate(insertPO));
                insertPO.setRelType(cfcEncodedRuleBO.getRelType());
                insertPO.setRelId(cfcEncodedRuleBO.getRelId());
                CfcEncodedSerialPO restartPO = null;
                int currentValidNum = 0;
                if (!CollectionUtils.isEmpty(cfcEncodedSerialPOS)) {
                    for (CfcEncodedSerialPO itemPO : cfcEncodedSerialPOS) {
                        String effDate;
                        int operateFlag = 0;
                        if (StringUtils.isBlank((CharSequence)itemPO.getRelId()) && StringUtils.isBlank((CharSequence)insertPO.getRelId())) {
                            operateFlag = this.cfcEncodedSerialMapper.updateInvalid(itemPO.getId());
                        }
                        if (!StringUtils.isBlank((CharSequence)itemPO.getRelId()) && itemPO.getRelId().equals(insertPO.getRelId())) {
                            operateFlag = this.cfcEncodedSerialMapper.updateInvalid(itemPO.getId());
                        }
                        if ((effDate = this.composeEffDate(itemPO)) != null && ("".equals(effDate) || effDate.equals(itemPO.getEffDate()))) {
                            if ("1".equals(jsonObject.getString("restartFlag")) && operateFlag > 0) {
                                restartPO = itemPO;
                            }
                            ++currentValidNum;
                        }
                        LOGGER.info("\u7f16\u7801\u53d8\u66f4     updateInvalid : {}", (Object)operateFlag);
                    }
                }
                if (currentValidNum <= 0) continue;
                int operateFlag = this.cfcEncodedSerialMapper.insert(insertPO);
                LOGGER.info("\u7f16\u7801\u53d8\u66f4     insert : {}", (Object)operateFlag);
                cfcEncodedSerialPOS.add(insertPO);
                map.put(cfcEncodedRuleBO.getEncodedRuleCode(), cfcEncodedSerialPOS);
                if (restartPO == null) continue;
                CfcEncodedSerialGeneratePO esgParam = new CfcEncodedSerialGeneratePO();
                esgParam.setSerialId(restartPO.getId());
                List<CfcEncodedSerialGeneratePO> esgList = this.cfcEncodedSerialGenerateMapper.getList(esgParam);
                if (CollectionUtils.isEmpty(esgList) || esgList.size() != 1) continue;
                restartMap.put(insertPO.getId(), esgList.get(0).getGenerateValue());
            }
        }
        return restartMap;
    }

    private String composeEffDate(CfcEncodedSerialPO cfcEncodedSerialPO) {
        if ("none".equals(cfcEncodedSerialPO.getEffType())) {
            return "none";
        }
        if ("date".equals(cfcEncodedSerialPO.getEffType())) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            return df.format(LocalDateTime.now());
        }
        if ("year".equals(cfcEncodedSerialPO.getEffType())) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy");
            return df.format(LocalDateTime.now());
        }
        if ("mouth".equals(cfcEncodedSerialPO.getEffType())) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("MM");
            return df.format(LocalDateTime.now());
        }
        if ("day".equals(cfcEncodedSerialPO.getEffType())) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("dd");
            return df.format(LocalDateTime.now());
        }
        return null;
    }

    private List<CfcEncodedSerialPO> getAllEncodedSerialPO(CfcEncodedSerialPO esPO) {
        CfcEncodedRuleSelectCodeAbilityReqBo cfcEncodedRuleSelectCodeAbilityReqBo = new CfcEncodedRuleSelectCodeAbilityReqBo();
        cfcEncodedRuleSelectCodeAbilityReqBo.setCenter(esPO.getCenter());
        cfcEncodedRuleSelectCodeAbilityReqBo.setEncodedRuleCode(esPO.getEncodedRuleCode());
        CfcEncodedRuleSelectCodeAbilityRspBo cfcEncodedRuleSelectCodeAbilityRspBo = this.cfcEncodedRuleSelectCodeAbilityService.selectEncodedRuleDetail(cfcEncodedRuleSelectCodeAbilityReqBo);
        if (!"0000".equals(cfcEncodedRuleSelectCodeAbilityRspBo.getRespCode())) {
            throw new CfcEncodedPluginBusinessException(cfcEncodedRuleSelectCodeAbilityRspBo.getRespCode(), cfcEncodedRuleSelectCodeAbilityRspBo.getRespDesc());
        }
        List encodedRuleList = cfcEncodedRuleSelectCodeAbilityRspBo.getEncodedRuleList();
        ArrayList<CfcEncodedSerialPO> addList = new ArrayList<CfcEncodedSerialPO>();
        for (CfcEncodedRuleBO encodedRuleBO : encodedRuleList) {
            CfcEncodedSerialPO insertPO = new CfcEncodedSerialPO();
            BeanUtils.copyProperties((Object)esPO, (Object)insertPO);
            insertPO.setId(Sequence.getInstance().nextId());
            insertPO.setEncodedSerialPrefix(encodedRuleBO.getEncodedSerialPrefix());
            insertPO.setEncodedSerialDigit(encodedRuleBO.getEncodedSerialDigit());
            insertPO.setEffFlag("1");
            insertPO.setEffType(encodedRuleBO.getEffType());
            insertPO.setEffDate(this.composeEffDate(insertPO));
            insertPO.setRelType(encodedRuleBO.getRelType());
            insertPO.setRelId(encodedRuleBO.getRelId());
            addList.add(insertPO);
        }
        log.info("===\u8c03\u7528\u914d\u7f6e\u4e2d\u5fc3\uff0c\u7f16\u7801\uff1a{}\uff0c \u7f16\u7801\u89c4\u5219\u96c6\u5408\uff1a{}", (Object)esPO.getEncodedRuleCode(), addList);
        return addList;
    }

    private void validParam(CfcEncodedSerialGetServiceReqBO reqBO) {
        if (reqBO == null) {
            throw new CfcEncodedPluginBusinessException("8888", "\u7f16\u7801\u89c4\u5219\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getCenter())) {
            throw new CfcEncodedPluginBusinessException("8888", "\u7f16\u7801\u89c4\u5219\u6240\u5c5e\u4e2d\u5fc3\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getEncodedRuleCode())) {
            throw new CfcEncodedPluginBusinessException("8888", "\u7f16\u7801\u89c4\u5219\u7f16\u7801\u4e3a\u7a7a");
        }
    }
}

