/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.base.constant;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.base.constant.SslUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelNewUtils {
    private static final Logger log = LoggerFactory.getLogger(ExcelNewUtils.class);
    private static final String EXCEL_XLS = "xls";
    private static final String EXCEL_XLSX = "xlsx";

    public static void getExcelDate(String path, List<List<String>> data, Integer readLine, Integer sheetAt) throws Exception {
        int count = 1;
        try {
            URL url = new URL(path);
            File file = new File(url.getFile());
            InputStream inputStream = url.openStream();
            ExcelNewUtils.checkExcelVaild(path);
            Workbook workbook = ExcelNewUtils.getWorkbok(path, inputStream);
            Sheet sheet = workbook.getSheetAt(sheetAt.intValue());
            for (Row row : sheet) {
                ArrayList<String> c = new ArrayList<String>();
                int end = row.getLastCellNum();
                if (row.getCell(0) == null || "".equals(row.getCell(0).toString())) continue;
                for (int i = 0; i < end; ++i) {
                    Cell cell = row.getCell(i, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
                    if (count < readLine) continue;
                    if (cell == null) {
                        c.add("");
                        continue;
                    }
                    Object obj = ExcelNewUtils.getValue(cell);
                    c.add(String.valueOf(obj).trim());
                }
                ++count;
                if (c.size() <= 0) continue;
                data.add(c);
            }
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u7b2c" + count + "\u6570\u636e\u5904\u7406\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    private static void checkExcelVaild(String filePath) throws Exception {
        if (filePath == null) {
            return;
        }
        String extString = filePath.substring(filePath.lastIndexOf(".") + 1);
        if (!EXCEL_XLS.equals(extString) && !EXCEL_XLSX.equals(extString)) {
            throw new Exception("\u6587\u4ef6\u4e0d\u662fExcel");
        }
    }

    private static Workbook getWorkbok(String filePath, InputStream inputStream) throws IOException {
        if (filePath == null) {
            return null;
        }
        String extString = filePath.substring(filePath.lastIndexOf(".") + 1);
        if (!EXCEL_XLS.equals(extString) && !EXCEL_XLSX.equals(extString)) {
            throw new IOException("\u6587\u4ef6\u4e0d\u662fExcel");
        }
        HSSFWorkbook wb = null;
        if (EXCEL_XLS.equals(extString)) {
            wb = new HSSFWorkbook(inputStream);
        } else if (EXCEL_XLSX.equals(extString)) {
            wb = new XSSFWorkbook(inputStream);
        }
        return wb;
    }

    private static Object getValue(Cell cell) {
        Object obj = null;
        cell.setCellType(CellType.STRING);
        switch (cell.getCellTypeEnum()) {
            case BOOLEAN: {
                obj = cell.getBooleanCellValue();
                break;
            }
            case ERROR: {
                obj = cell.getErrorCellValue();
                break;
            }
            case NUMERIC: {
                obj = cell.getNumericCellValue();
                break;
            }
            case STRING: {
                obj = cell.getStringCellValue();
                break;
            }
        }
        return obj;
    }

    public static void getExcelDateNoTrim(String path, List<List<String>> data, Integer readLine, Integer sheetAt) throws Exception {
        int count = 1;
        try (InputStream inputStream = null;){
            URL urlReq;
            log.debug("[\u5546\u54c1\u4e2d\u5fc3-\u6807\u51c6\u5546\u54c1\u5bfc\u5165\u6587\u4ef6\u65b9\u6cd5]-\u65e5\u5fd7|\u5165\u53c2url:" + path);
            String urlH = path;
            URL url = new URL(urlH);
            String urlHead = url.getProtocol();
            if ("http".equals(urlHead)) {
                urlH = urlH.replace("http", "https");
            }
            if ("https".equalsIgnoreCase((urlReq = new URL(urlH)).getProtocol())) {
                SslUtils.ignoreSsl();
            }
            log.debug("[\u5546\u54c1\u4e2d\u5fc3-\u6807\u51c6\u5546\u54c1\u5bfc\u5165\u6587\u4ef6\u65b9\u6cd5]-\u65e5\u5fd7|urlUtils:" + urlH);
            inputStream = urlReq.openStream();
            ExcelNewUtils.checkExcelVaild(urlH);
            Workbook workbook = ExcelNewUtils.getWorkbok(urlH, inputStream);
            Sheet sheet = workbook.getSheetAt(sheetAt.intValue());
            for (Row row : sheet) {
                ArrayList<String> c = new ArrayList<String>();
                int end = row.getLastCellNum();
                if (row.getCell(0) == null || "".equals(row.getCell(0).toString())) continue;
                for (int i = 0; i < end; ++i) {
                    Cell cell = row.getCell(i, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
                    if (count < readLine) continue;
                    if (cell == null) {
                        c.add("");
                        continue;
                    }
                    Object obj = ExcelNewUtils.getValue(cell);
                    c.add(String.valueOf(obj));
                }
                ++count;
                if (c.size() <= 0) continue;
                data.add(c);
            }
        }
    }
}

