/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.atom.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.base.constant.CommonConstant;
import com.tydic.commodity.busibase.atom.api.PebSendMessageAtomService;
import com.tydic.commodity.busibase.atom.bo.PebSendMessageAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.PebSendMessageAtomRspBO;
import com.tydic.commodity.utils.CommodityPropertiesUtil;
import com.tydic.commodity.utils.HSHttpHelper;
import com.tydic.commodity.utils.HSNHttpHeader;
import com.tydic.commodity.utils.HttpRetBean;
import com.tydic.commodity.utils.SSLClient;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PebSendMessageAtomServiceImpl
implements PebSendMessageAtomService {
    private static final Logger log = LoggerFactory.getLogger(PebSendMessageAtomServiceImpl.class);

    @Override
    public PebSendMessageAtomRspBO dealPebSendMessage(PebSendMessageAtomReqBO reqBO) {
        PebSendMessageAtomRspBO rspBO;
        String token = reqBO.getToken();
        if (reqBO.getSendType().equals(CommonConstant.ORDER_SEND_MESSAGE)) {
            String requestJsonStr = this.initRequestMessageJsonStr(reqBO);
            log.debug("[\u5546\u54c1\u4e2d\u5fc3-\u534f\u8bae\u63d0\u9192\u539f\u5b50\u670d\u52a1]-\u53d1\u9001\u7ad9\u5185\u4fe1\u901a\u77e5\u4e2d\u5fc3-\u5165\u53c2|requestJsonStr:{}", (Object)requestJsonStr);
            rspBO = null == reqBO.getTemplateId() ? this.sendFrom(requestJsonStr, CommodityPropertiesUtil.getProperty("SEND_INNER_MESSAGE_URL"), token) : this.sendFrom(requestJsonStr, CommodityPropertiesUtil.getProperty("SEND_INNER_SYSMESSAGE_URL"), token);
        } else if (reqBO.getSendType().equals(CommonConstant.ORDER_SEND_EMIL)) {
            String requestJsonStr = this.initRequestEmailJsonStr(reqBO);
            log.debug("[\u5546\u54c1\u4e2d\u5fc3-\u534f\u8bae\u63d0\u9192\u539f\u5b50\u670d\u52a1]-\u53d1\u9001\u90ae\u4ef6\u901a\u77e5\u4e2d\u5fc3-\u5165\u53c2|requestJsonStr:{}", (Object)requestJsonStr);
            rspBO = this.doUrlPostRequest(requestJsonStr, "NOTIFY_SEND_MAIL_URL", token);
        } else if (reqBO.getSendType().equals(CommonConstant.ORDER_SEND_MOBILE)) {
            String requestJsonStr = this.initRequestMobileJsonStr(reqBO);
            log.debug("[\u5546\u54c1\u4e2d\u5fc3-\u534f\u8bae\u63d0\u9192\u539f\u5b50\u670d\u52a1]-\u53d1\u9001\u77ed\u4fe1\u901a\u77e5\u4e2d\u5fc3-\u5165\u53c2|requestJsonStr:{}", (Object)requestJsonStr);
            rspBO = this.doUrlPostRequest(requestJsonStr, "SEND_ONLY_SMS_MESSAGE_URL", "");
        } else if (reqBO.getSendType().equals(CommonConstant.ORDER_SEND_WX)) {
            String requestJsonStr = this.initRequestWXJsonStr(reqBO);
            log.debug("[\u5546\u54c1\u4e2d\u5fc3-\u534f\u8bae\u63d0\u9192\u539f\u5b50\u670d\u52a1]-\u53d1\u9001\u5fae\u4fe1\u901a\u77e5\u4e2d\u5fc3-\u5165\u53c2|requestJsonStr:{}", (Object)requestJsonStr);
            rspBO = this.doUrlPostRequest(requestJsonStr, "SEND_WX_MESSAGE_URL", "");
        } else if (reqBO.getSendType().equals(CommonConstant.ORDER_SEND_QYWX)) {
            String requestJsonStr = this.initRequestQywxJsonStr(reqBO);
            log.debug("[\u5546\u54c1\u4e2d\u5fc3-\u534f\u8bae\u63d0\u9192\u539f\u5b50\u670d\u52a1]-\u53d1\u9001\u4f01\u4e1a\u5fae\u4fe1\u901a\u77e5\u4e2d\u5fc3-\u5165\u53c2|requestJsonStr:{}", (Object)requestJsonStr);
            rspBO = this.doQywxUrlPostRequest(requestJsonStr, "send_qywx_message", "");
        } else {
            rspBO = new PebSendMessageAtomRspBO();
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u672a\u77e5\u901a\u77e5\u7c7b\u578b");
        }
        return rspBO;
    }

    private PebSendMessageAtomRspBO sendFrom(String requestJsonStr, String url, String token) {
        PebSendMessageAtomRspBO rspBO = new PebSendMessageAtomRspBO();
        Map map = (Map)JSONObject.parseObject((String)requestJsonStr, Map.class);
        HashMap<String, String> param = new HashMap<String, String>(map.size());
        for (Map.Entry elem : map.entrySet()) {
            if (elem.getValue() == null) continue;
            param.put((String)elem.getKey(), elem.getValue().toString());
        }
        try {
            HashMap<String, String> header = null;
            if (token != null) {
                header = new HashMap<String, String>(1);
                header.put("auth-token", token);
            }
            String rsp = SSLClient.doPost(url, param, header);
            log.debug("[\u5546\u54c1\u4e2d\u5fc3-\u534f\u8bae\u63d0\u9192\u539f\u5b50\u670d\u52a1]-\u53d1\u9001\u90ae\u4ef6-\u51fa\u53c2|rsp:{}", (Object)rsp);
            rspBO = this.resolveRsp(rsp);
        }
        catch (Exception e) {
            log.error("[\u5546\u54c1\u4e2d\u5fc3-\u534f\u8bae\u63d0\u9192\u539f\u5b50\u670d\u52a1]-\u53d1\u9001\u90ae\u4ef6-\u5f02\u5e38|", (Throwable)e);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u5f02\u5e38");
        }
        return rspBO;
    }

    private PebSendMessageAtomRspBO doUrlPostRequest(String requestJsonStr, String url, String token) {
        PebSendMessageAtomRspBO rspBO = new PebSendMessageAtomRspBO();
        try {
            HttpRetBean httpRetBean;
            Header[] headers = HSNHttpHeader.getRequestHeaders("json");
            if (StringUtils.isNotBlank((CharSequence)token)) {
                Header[] header = new Header[headers.length + 1];
                System.arraycopy(headers, 0, header, 0, headers.length);
                header[headers.length] = new BasicHeader("auth-token", token);
                httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(CommodityPropertiesUtil.getProperty(url)), header, requestJsonStr.getBytes(StandardCharsets.UTF_8), "UTF-8", false);
            } else {
                httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(CommodityPropertiesUtil.getProperty(url)), headers, requestJsonStr.getBytes(StandardCharsets.UTF_8), "UTF-8", false);
            }
            if (httpRetBean.getStatus() != 200) {
                throw new RuntimeException("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + CommodityPropertiesUtil.getProperty(url) + "]");
            }
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((CharSequence)returnString)) {
                throw new ZTBusinessException("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            rspBO = this.resolveRsp(returnString);
        }
        catch (Exception e) {
            log.error("[\u5546\u54c1\u4e2d\u5fc3-\u534f\u8bae\u63d0\u9192\u539f\u5b50\u670d\u52a1]-\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3-\u5f02\u5e38|", (Throwable)e);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u5f02\u5e38");
            return rspBO;
        }
        return rspBO;
    }

    private PebSendMessageAtomRspBO doQywxUrlPostRequest(String requestJsonStr, String url, String token) {
        PebSendMessageAtomRspBO rspBO = new PebSendMessageAtomRspBO();
        log.debug("[\u5546\u54c1\u4e2d\u5fc3-\u534f\u8bae\u63d0\u9192\u539f\u5b50\u670d\u52a1]-\u53d1\u9001\u4f01\u4e1a\u5fae\u4fe1\u63d0\u9192-\u5165\u53c2|requestJsonStr:{}", (Object)requestJsonStr);
        try {
            HttpRetBean httpRetBean;
            Header[] headers = HSNHttpHeader.getRequestHeaders("json");
            if (StringUtils.isNotBlank((CharSequence)token)) {
                Header[] header = new Header[headers.length + 1];
                System.arraycopy(headers, 0, header, 0, headers.length);
                header[headers.length] = new BasicHeader("auth-token", token);
                httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(CommodityPropertiesUtil.getProperty(url)), header, requestJsonStr.getBytes(StandardCharsets.UTF_8), "UTF-8", false);
            } else {
                httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(CommodityPropertiesUtil.getProperty(url)), headers, requestJsonStr.getBytes(StandardCharsets.UTF_8), "UTF-8", false);
            }
            if (httpRetBean.getStatus() != 200) {
                throw new RuntimeException("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + CommodityPropertiesUtil.getProperty(url) + "]");
            }
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((CharSequence)returnString)) {
                throw new ZTBusinessException("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
        }
        catch (Exception e) {
            log.error("[\u5546\u54c1\u4e2d\u5fc3-\u534f\u8bae\u63d0\u9192\u539f\u5b50\u670d\u52a1]-\u53d1\u9001\u4f01\u4e1a\u5fae\u4fe1\u63d0\u9192-\u5f02\u5e38|", (Throwable)e);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u5f02\u5e38");
            return rspBO;
        }
        return rspBO;
    }

    public static void main(String[] args) throws Exception {
        PebSendMessageAtomServiceImpl pebSendMessageAtomService = new PebSendMessageAtomServiceImpl();
        PebSendMessageAtomRspBO rspBO = pebSendMessageAtomService.sendFrom("{\n\t\"to\": \"liaoxj @tydic.com \",\n\t\"content \": \"\u8ba2\u5355\u6210\u4ea4\u901a\u77e5 \",\n\n\t\"subject \": \"\u5c0a\u656c\u7684\u7528\u6237\u60a8\u597d\uff01 \u60a8\u5728\u9996\u94a2\u5728\u7ebf\u4ea4\u6613\u5e73\u53f0\u8d2d\u4e70\u7684\u5546\u54c1\u5df2\u7ecf\u4e0b\u5355\u6210\u529f\uff0c \u8ba2\u5355\u7f16\u53f7 { < a href = 'http://www.xxxx.com.cn' > YGZK20200526954546 < /a>}\uff0c\u8bf7\u53ca\u65f6\u5173\u6ce8\u3002\"\n}", "http://10.105.29.22:31032/notifyApi/sendEMail", null);
        log.debug("[\u5546\u54c1\u4e2d\u5fc3-\u901a\u77e5\u6d88\u606f\u53d1\u9001\u670d\u52a1-\u6d4b\u8bd5\u7528\u4e3b\u65b9\u6cd5]-\u51fa\u53c2|{}", (Object)JSON.toJSONString((Object)((Object)rspBO)));
    }

    private String initRequestEmailJsonStr(PebSendMessageAtomReqBO reqBO) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("to", (Object)reqBO.getEmail());
        jsonObject.put("content", (Object)reqBO.getText());
        jsonObject.put("subject", (Object)reqBO.getSubject());
        return jsonObject.toJSONString();
    }

    private String initRequestMobileJsonStr(PebSendMessageAtomReqBO reqBO) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("mobile", (Object)reqBO.getMobile());
        jsonObject.put("tempid", (Object)reqBO.getTemplateId());
        jsonObject.put("msgtype", (Object)"2");
        jsonObject.put("content", (Object)reqBO.getText());
        return jsonObject.toJSONString();
    }

    private String initRequestMessageJsonStr(PebSendMessageAtomReqBO reqBO) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("sendid", (Object)(ObjectUtil.isEmpty((Object)reqBO.getUserId()) ? reqBO.getReceiveId() : reqBO.getUserId()));
        jsonObject.put("recid", (Object)reqBO.getReceiveId());
        jsonObject.put("appid", (Object)CommodityPropertiesUtil.getProperty("APP_ID"));
        jsonObject.put("titel", (Object)reqBO.getTitel());
        jsonObject.put("text", (Object)reqBO.getText());
        jsonObject.put("token", (Object)reqBO.getToken());
        if (null != reqBO.getTemplateId()) {
            jsonObject.put("templateId", (Object)reqBO.getTemplateId());
            jsonObject.put("templateParam", (Object)JSON.toJSONString(reqBO.getTemplateParam()));
        }
        return jsonObject.toJSONString();
    }

    private String initRequestWXJsonStr(PebSendMessageAtomReqBO reqBO) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("touser", (Object)reqBO.getOpenId());
        jsonObject.put("template_id", (Object)reqBO.getTemplateIdWX());
        LinkedHashMap<String, JSONObject> data = new LinkedHashMap<String, JSONObject>();
        JSONObject title = new JSONObject();
        title.put("value", (Object)reqBO.getTitel());
        data.put("first", title);
        JSONObject content = new JSONObject();
        content.put("value", (Object)reqBO.getText());
        data.put("keyword1", content);
        JSONObject time = new JSONObject();
        time.put("value", (Object)DateUtil.formatDateTime((Date)new Date()));
        data.put("keyword2", time);
        jsonObject.put("data", data);
        return jsonObject.toJSONString();
    }

    private String initRequestQywxJsonStr(PebSendMessageAtomReqBO reqBO) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("touser", (Object)reqBO.getMobile());
        jsonObject.put("title", (Object)reqBO.getTitel());
        jsonObject.put("description", (Object)reqBO.getText());
        jsonObject.put("msgtype", (Object)reqBO.getQywxMsgType());
        jsonObject.put("phoneNo", (Object)reqBO.getMobile());
        jsonObject.put("loginName", (Object)reqBO.getRegAccount());
        return jsonObject.toJSONString();
    }

    private PebSendMessageAtomRspBO resolveRsp(String returnString) {
        log.debug("[\u5546\u54c1\u4e2d\u5fc3-\u534f\u8bae\u63d0\u9192\u539f\u5b50\u670d\u52a1]-\u62a5\u6587\u89e3\u6790-\u5165\u53c2|returnString:{}", (Object)returnString);
        PebSendMessageAtomRspBO rspBO = new PebSendMessageAtomRspBO();
        JSONObject jsonObjectReturn = JSONObject.parseObject((String)returnString);
        if (!"0".equals(jsonObjectReturn.getString("code"))) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u5931\u8d25!" + jsonObjectReturn.getString("message"));
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u8ba2\u5355\u63d0\u9192\u6210\u529f!");
        return rspBO;
    }
}

