/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.atom.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccRealPriceQryAtomService;
import com.tydic.commodity.busibase.atom.bo.UccRealCommdPriceBO;
import com.tydic.commodity.busibase.atom.bo.UccRealJdPriceBO;
import com.tydic.commodity.busibase.atom.bo.UccRealNotJdPriceBO;
import com.tydic.commodity.busibase.atom.bo.UccRealPriceQryReqBO;
import com.tydic.commodity.busibase.atom.bo.UccRealPriceQryRspBO;
import com.tydic.commodity.utils.ESBParamUtil;
import com.tydic.commodity.utils.HSHttpHelper;
import com.tydic.commodity.utils.HSNHttpHeader;
import com.tydic.commodity.utils.HttpRetBean;
import com.tydic.commodity.utils.PropertiesUtil;
import java.net.URI;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class UccRealPriceQryAtomServiceImpl
implements UccRealPriceQryAtomService {
    private static final Logger log = LoggerFactory.getLogger(UccRealPriceQryAtomServiceImpl.class);

    @Override
    public UccRealPriceQryRspBO qryCommdRealPrice(UccRealPriceQryReqBO reqBO) {
        try {
            String reqStr = this.initReqStr(reqBO);
            String hsn = reqBO.getSupplierCode();
            String reqEsbStr = ESBParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_COMMODITY");
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(PropertiesUtil.getProperty("ESB_QRY_SKU_PRICE_URL")), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.getBytes("UTF-8"), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                log.error("[\u5546\u54c1\u4e2d\u5fc3-\u5546\u54c1\u4e2d\u5fc3\u4ef7\u683c\u5b9e\u65f6\u67e5\u8be2\u670d\u52a1]-\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u65e5\u5fd7|\u63a5\u53e3\u8fd4\u56de\u5931\u8d25[http_status={}], [http_url={}]", (Object)httpRetBean.getStatus(), (Object)PropertiesUtil.getProperty("ESB_QRY_SKU_PRICE_URL"));
                throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u5931\u8d25");
            }
            log.info("[\u5546\u54c1\u4e2d\u5fc3-\u5546\u54c1\u4e2d\u5fc3\u4ef7\u683c\u5b9e\u65f6\u67e5\u8be2\u670d\u52a1]-\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u65e5\u5fd7|\u63a5\u53e3\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)httpRetBean.getStr());
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            UccRealPriceQryRspBO resolveRsp = this.resolveRsp(reqBO, returnString);
            if (resolveRsp != null) {
                log.info("[\u5546\u54c1\u4e2d\u5fc3-\u5546\u54c1\u4e2d\u5fc3\u4ef7\u683c\u5b9e\u65f6\u67e5\u8be2\u670d\u52a1]-\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u65e5\u5fd7|\u89e3\u6790\u54cd\u5e94\u6570\u636e\uff1a{}", (Object)resolveRsp.toString());
            }
            return resolveRsp;
        }
        catch (Exception e) {
            log.error("[\u5546\u54c1\u4e2d\u5fc3-\u5546\u54c1\u4e2d\u5fc3\u4ef7\u683c\u5b9e\u65f6\u67e5\u8be2\u670d\u52a1]-\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u5f02\u5e38|", (Throwable)e);
            throw new BusinessException("8888", "\u5931\u8d25");
        }
    }

    private String initReqStr(UccRealPriceQryReqBO reqBO) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("sku", reqBO.getSkuIds());
        jsonObject.put("hsn", (Object)reqBO.getSupplierCode());
        if ("jd".equals(reqBO.getSupplierCode())) {
            jsonObject.put("queryExts ", (Object)"containsTax,marketPrice");
        }
        return jsonObject.toString();
    }

    private UccRealPriceQryRspBO resolveRsp(UccRealPriceQryReqBO reqBO, String returnString) {
        UccRealPriceQryRspBO rspBO = new UccRealPriceQryRspBO();
        ArrayList<UccRealJdPriceBO> list = new ArrayList<UccRealJdPriceBO>();
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            rspBO.setSuccess((Boolean)rspJsonObject.get((Object)"success"));
            rspBO.setResultCode((String)rspJsonObject.get((Object)"resultCode"));
            rspBO.setResultMessage((String)rspJsonObject.get((Object)"resultMessage"));
            String respCode = (String)rspJsonObject.get((Object)"resultCode");
            if (!"0000".equals(respCode)) {
                if ("2007".equals(respCode)) {
                    rspBO.setResultMessage("token\u5df2\u8fc7\u671f,\u8bf7\u91cd\u65b0\u5237\u65b0\u6216\u8005\u83b7\u53d6token");
                } else {
                    rspBO.setResultMessage("\u8c03\u7528\u5916\u90e8\u5e73\u53f0 \u4ef7\u683c\u5b9e\u65f6\u67e5\u8be2\u63a5\u53e3 \u9519\u8bef");
                }
                rspBO.setResultCode("8888");
                return rspBO;
            }
            JSONArray object = rspJsonObject.getJSONArray("result");
            if (null != object) {
                UccRealCommdPriceBO commdPriceBO = new UccRealCommdPriceBO();
                if ("jd".equals(reqBO.getSupplierCode())) {
                    for (int i = 0; i < object.size(); ++i) {
                        JSONObject obj = (JSONObject)object.get(i);
                        String jsonStr = JSONObject.toJSONString((Object)obj);
                        if (StringUtils.isEmpty((Object)jsonStr)) continue;
                        UccRealJdPriceBO jsonStringToJavaBean = (UccRealJdPriceBO)JSON.parseObject((String)jsonStr, UccRealJdPriceBO.class);
                        list.add(jsonStringToJavaBean);
                    }
                    commdPriceBO.setJdPriceInfos(list);
                    rspBO.setResult(commdPriceBO);
                } else {
                    for (int i = 0; i < object.size(); ++i) {
                        JSONObject jsonObject = (JSONObject)object.get(i);
                        UccRealNotJdPriceBO notJdPriceBO = (UccRealNotJdPriceBO)JSONObject.toJavaObject((JSON)jsonObject, UccRealNotJdPriceBO.class);
                        list.add((UccRealJdPriceBO)((Object)notJdPriceBO));
                    }
                    commdPriceBO.setNotJdPriceInfo(list);
                }
                rspBO.setResult(commdPriceBO);
            }
            return rspBO;
        }
        catch (Exception var10) {
            log.error("[\u5546\u54c1\u4e2d\u5fc3-\u5546\u54c1\u4e2d\u5fc3\u4ef7\u683c\u5b9e\u65f6\u67e5\u8be2\u670d\u52a1]-\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587-\u5f02\u5e38|", (Throwable)var10);
            throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
        }
    }
}

