/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.tydic.commodity.busibase.busi.api.SearchEsManageExecuteSqlService;
import com.tydic.commodity.busibase.busi.bo.SearchEsManageRspBo;
import com.tydic.commodity.busibase.comb.bo.CommodityRspBo;
import com.tydic.commodity.busibase.comb.bo.CommoditySingileRspBo;
import com.tydic.commodity.busibase.comb.bo.SearchEsRspBo;
import com.tydic.commodity.config.ElasticsearchUtil;
import com.tydic.commodity.config.EsConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SearchEsManageExecuteSqlServiceImpl
implements SearchEsManageExecuteSqlService {
    private static final Logger log = LoggerFactory.getLogger(SearchEsManageExecuteSqlServiceImpl.class);
    @Autowired
    private EsConfig esConfig;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;

    @Override
    public SearchEsRspBo excuteSql(SearchEsManageRspBo reqBo) {
        String endPoint = "/" + this.esConfig.getIndexName() + "/" + this.esConfig.getEsType() + "/_search";
        String queryString = this.getQueryString(reqBo);
        if (log.isDebugEnabled()) {
            log.debug("[\u5546\u54c1\u4e2d\u5fc3-ES\u641c\u7d22\u67e5\u8be2\u6267\u884c\u670d\u52a1]-\u53c2\u6570|source---->{}", (Object)queryString);
        }
        log.info("[\u5546\u54c1\u4e2d\u5fc3-ES\u641c\u7d22\u67e5\u8be2\u6267\u884c\u670d\u52a1]-\u53c2\u6570|source---->{}", (Object)queryString);
        NStringEntity entity = new NStringEntity(queryString, ContentType.APPLICATION_JSON);
        try {
            Response response = this.elasticsearchUtil.getLowLevelClient().performRequest("POST", endPoint, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            if (log.isDebugEnabled()) {
                log.debug("[\u5546\u54c1\u4e2d\u5fc3-ES\u641c\u7d22\u67e5\u8be2\u6267\u884c\u670d\u52a1]-\u53c2\u6570|result---->{}", (Object)result);
            }
            SearchEsRspBo searchEsRspBo = this.dealSearchData(result, reqBo.isNeedKeyWorld());
            if (reqBo.getIsFieldSpu().booleanValue() || reqBo.getIsFieldSku().booleanValue()) {
                String agss = JSONObject.parseObject((String)result).get((Object)"aggregations").toString();
                int total = Integer.valueOf(JSONObject.parseObject((String)JSONObject.parseObject((String)agss).get((Object)"books_count").toString()).get((Object)"value").toString());
                searchEsRspBo.setTotal(total);
            }
            return searchEsRspBo;
        }
        catch (IOException e) {
            log.error("[\u5546\u54c1\u4e2d\u5fc3-ES\u641c\u7d22\u67e5\u8be2\u6267\u884c\u670d\u52a1]-excuteSql-\u5f02\u5e38|", (Throwable)e);
            return null;
        }
    }

    private String getQueryString(SearchEsManageRspBo searchEsSQLRspBO) {
        JSONObject queryJson = new JSONObject();
        queryJson.put("size", (Object)searchEsSQLRspBO.getPageSize());
        queryJson.put("from", (Object)(searchEsSQLRspBO.getPageSize() * (searchEsSQLRspBO.getPageNo() - 1)));
        String queryString = null;
        queryString = searchEsSQLRspBO.getBoolQueryBuilder().toString();
        queryJson.put("query", (Object)JSON.parseObject((String)queryString));
        queryJson.put("sort", (Object)JSONObject.parseArray((String)searchEsSQLRspBO.getSortQuery().toString()));
        if (searchEsSQLRspBO.getIsFieldSpu().booleanValue() || searchEsSQLRspBO.getIsFieldSku().booleanValue()) {
            JSONObject collapse = new JSONObject();
            if (searchEsSQLRspBO.getIsFieldSku().booleanValue()) {
                collapse.put("field", (Object)"sku_id");
            } else {
                collapse.put("field", (Object)"commodity_id");
            }
            queryJson.put("collapse", (Object)collapse);
        }
        JSONObject aggs = new JSONObject();
        if (searchEsSQLRspBO.getIsFieldSpu().booleanValue() || searchEsSQLRspBO.getIsFieldSku().booleanValue()) {
            JSONObject total = new JSONObject();
            if (searchEsSQLRspBO.getIsFieldSku().booleanValue()) {
                total.put("field", (Object)"sku_id");
            } else {
                total.put("field", (Object)"commodity_id");
            }
            JSONObject cardinality = new JSONObject();
            total.put("precision_threshold", (Object)40000);
            cardinality.put("cardinality", (Object)total);
            aggs.put("books_count", (Object)cardinality);
        }
        queryJson.put("aggs", (Object)aggs);
        return queryJson.toString();
    }

    private SearchEsRspBo dealSearchData(String result, boolean isNeedKeyWorld) {
        SearchEsRspBo rspBo = new SearchEsRspBo();
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = hitsObj.getInteger("total");
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (log.isDebugEnabled()) {
            log.debug("[\u5546\u54c1\u4e2d\u5fc3-ES\u641c\u7d22\u67e5\u8be2\u6267\u884c\u670d\u52a1]-\u53c2\u6570|\u603b\u8bb0\u5f55\u6570:{} \u8fd4\u56de\u8bb0\u5f55\u6570\u636e{}", (Object)total, (Object)listObject.size());
        }
        ArrayList<CommodityRspBo> commodityModels = new ArrayList<CommodityRspBo>();
        HashSet<Long> skuIdSet = new HashSet<Long>();
        ArrayList<String> propertyList = new ArrayList<String>();
        ArrayList<CommodityRspBo> otherProperty = new ArrayList<CommodityRspBo>();
        if (listObject.size() > 0) {
            for (int i = 0; i < listObject.size(); ++i) {
                CommodityRspBo commodity;
                block16: {
                    JSONObject hitObj = listObject.getJSONObject(i);
                    JSONObject data = (JSONObject)hitObj.get((Object)"_source");
                    commodity = new CommodityRspBo();
                    try {
                        commodity = (CommodityRspBo)JSON.toJavaObject((JSON)data, CommodityRspBo.class);
                    }
                    catch (Exception e) {
                        log.error("[\u5546\u54c1\u4e2d\u5fc3-ES\u641c\u7d22\u67e5\u8be2\u6267\u884c\u670d\u52a1]-\u641c\u7d22es\u6570\u636e\u662f\u5355\u4e2a\u7684\u60c5\u51b5-\u5f02\u5e38|", (Throwable)e);
                        CommoditySingileRspBo single = new CommoditySingileRspBo();
                        try {
                            single = (CommoditySingileRspBo)JSON.toJavaObject((JSON)data, CommoditySingileRspBo.class);
                        }
                        catch (Exception e1) {
                            log.error("[\u5546\u54c1\u4e2d\u5fc3-ES\u641c\u7d22\u67e5\u8be2\u6267\u884c\u670d\u52a1]-\u6570\u636e\u8f6c\u6362-\u5f02\u5e38|", (Throwable)e);
                            return rspBo;
                        }
                        BeanUtils.copyProperties((Object)single, (Object)commodity);
                        if (single.getL1_category_id() != null) {
                            commodity.setL1_category_id(new ArrayList<Long>(Arrays.asList(single.getL1_category_id())));
                        }
                        if (single.getL2_category_id() != null) {
                            commodity.setL2_category_id(new ArrayList<Long>(Arrays.asList(single.getL2_category_id())));
                        }
                        if (single.getL3_category_id() != null) {
                            commodity.setL3_category_id(new ArrayList<Long>(Arrays.asList(single.getL3_category_id())));
                        }
                        if (!StringUtils.isEmpty((Object)single.getL1_category_name())) {
                            commodity.setL1_category_name(new ArrayList<String>(Arrays.asList(single.getL1_category_name())));
                        }
                        if (!StringUtils.isEmpty((Object)single.getL2_category_name())) {
                            commodity.setL2_category_name(new ArrayList<String>(Arrays.asList(single.getL2_category_name())));
                        }
                        if (!StringUtils.isEmpty((Object)single.getL3_category_name())) {
                            commodity.setL3_category_name(new ArrayList<String>(Arrays.asList(single.getL3_category_name())));
                        }
                        if (single.getChannel_id() != null) {
                            commodity.setChannel_id(new ArrayList<Long>(Arrays.asList(single.getChannel_id())));
                        }
                        if (!StringUtils.isEmpty((Object)single.getChannel_Name())) break block16;
                        commodity.setChannel_Name(Lists.newArrayList((Object[])new String[]{single.getChannel_Name()}));
                    }
                }
                if (!skuIdSet.contains(commodity.getSku_id())) {
                    String properties = commodity.getProperties();
                    if (!StringUtils.isEmpty((Object)properties)) {
                        propertyList.add(properties);
                        otherProperty.add(commodity);
                    }
                    commodityModels.add(commodity);
                }
                skuIdSet.add(commodity.getSku_id());
            }
        }
        rspBo.setTotal(total);
        rspBo.setCommodityRspBos(commodityModels);
        return rspBo;
    }

    private List<String> getNameList(JSONObject object) {
        ArrayList<String> nameList = new ArrayList<String>();
        JSONArray bucketObject = object.getJSONArray("buckets");
        for (int i = 0; i < bucketObject.size(); ++i) {
            JSONObject jsonObject = bucketObject.getJSONObject(i);
            String name = jsonObject.getString("key");
            nameList.add(name);
        }
        return nameList;
    }
}

