/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.busi.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.bo.UccBrandAddReqBO;
import com.tydic.commodity.base.bo.UccBrandAddRspBO;
import com.tydic.commodity.base.bo.UccBrandAliasInfoBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.enumType.Brand;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccApproveCreationAtomService;
import com.tydic.commodity.busibase.atom.api.UccBaseDictionaryAtomService;
import com.tydic.commodity.busibase.atom.bo.UccApproveCreationAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccApproveCreationAtomRspBO;
import com.tydic.commodity.busibase.busi.api.UccBrandAddBusiService;
import com.tydic.commodity.dao.UccBrandDealMapper;
import com.tydic.commodity.dao.UccBrandExtMapper;
import com.tydic.commodity.po.UccBrandDealPO;
import com.tydic.commodity.po.UccMallBrandDetaillListPO;
import com.tydic.commodity.utils.SSLClient;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccBrandAddBusiServiceImpl
implements UccBrandAddBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccBrandAddBusiServiceImpl.class);
    @Autowired
    private UccBrandDealMapper mapper;
    @Autowired
    private UccBrandExtMapper uccBrandExtMapper;
    private Sequence uccBrandSequence = Sequence.getInstance();
    @Autowired
    private UccBaseDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private UccApproveCreationAtomService uccApproveCreationAtomService;
    @Value(value="${OPER_BRAND_ALIAS_LIST}")
    private String addAliasBrandUrl;
    @Value(value="${BRAND_AUTH_ONE_PROCESS}")
    private String process;

    @Override
    public UccBrandAddRspBO addBrand(UccBrandAddReqBO reqBO) {
        UccBrandAddRspBO rspBO = new UccBrandAddRspBO();
        if (!this.judge(reqBO, rspBO)) {
            rspBO.setRespCode("8888");
            return rspBO;
        }
        UccBrandDealPO brandDealPO = new UccBrandDealPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)brandDealPO);
        brandDealPO.setCreateOperId(String.valueOf(reqBO.getUserId()));
        brandDealPO.setCreateOperName(reqBO.getName());
        brandDealPO.setUpdateOperId(String.valueOf(reqBO.getUserId()));
        brandDealPO.setUpdateOperName(reqBO.getName());
        if ("2".equals(reqBO.getIsProfessionalOrgExt())) {
            if (UccConstants.BranContant.SUP_ADD_BRAND_SAVE == reqBO.getSubmitFlag()) {
                brandDealPO.setBrandStatus(UccConstants.BranContant.STATUS_DRAFT);
            }
            if (UccConstants.BranContant.SUP_ADD_BRAND_SUBMIT == reqBO.getSubmitFlag()) {
                brandDealPO.setBrandStatus(UccConstants.BranContant.STATUS_APPROVING);
            }
            if (reqBO.getSupId() == null) {
                throw new BusinessException("8888", "\u5f53\u524d\u7528\u6237\u4f9b\u5e94\u5546\u4fe1\u606f\u5b58\u5728\u95ee\u9898\uff0c\u4e0d\u80fd\u65b0\u589e\u54c1\u724c\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            brandDealPO.setCreateOperId(String.valueOf(reqBO.getSupId()));
            brandDealPO.setCreateOperName(reqBO.getSupName());
        }
        Long brandId = this.uccBrandSequence.nextId();
        brandDealPO.setBrandId(brandId);
        brandDealPO.setBrandType(1);
        String time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        brandDealPO.setCreateTime(time);
        if (StringUtils.isEmpty((Object)brandDealPO.getBrandCode())) {
            brandDealPO.setBrandCode(brandDealPO.getBrandId().toString());
        }
        int result = this.mapper.addBrand(brandDealPO);
        if (!CollectionUtils.isEmpty((Collection)reqBO.getBrandAliasList())) {
            if (log.isDebugEnabled()) {
                log.debug("[\u5546\u54c1\u4e2d\u5fc3-\u54c1\u724c\u6dfb\u52a0]-\u8c03\u7528\u54c1\u724c\u522b\u540d\u6570\u636e1.0\u5b58\u50a8,\u6570\u636e:{}", (Object)reqBO);
            }
            this.sendPostBrandAlias(brandId, reqBO.getBrandName(), reqBO.getBrandAliasList(), reqBO.getUserId(), reqBO.getUsername());
        }
        if ("2".equals(reqBO.getIsProfessionalOrgExt()) && UccConstants.BranContant.SUP_ADD_BRAND_SUBMIT == reqBO.getSubmitFlag()) {
            this.supAddBrandApprove(reqBO, brandId);
        }
        if (result > 0) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u63d2\u5165\u54c1\u724c\u6210\u529f");
            rspBO.setBrandId(brandId);
        } else {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u63d2\u5165\u54c1\u724c\u5931\u8d25");
        }
        return rspBO;
    }

    private UccApproveCreationAtomRspBO supAddBrandApprove(UccBrandAddReqBO reqBO, Long brandId) {
        UccApproveCreationAtomReqBO approveCreationAtomReqBO = new UccApproveCreationAtomReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)approveCreationAtomReqBO));
        List<Long> objIds = Arrays.asList(brandId);
        approveCreationAtomReqBO.setObjId(objIds);
        approveCreationAtomReqBO.setProcDefKey(this.process);
        approveCreationAtomReqBO.setMenuId("default");
        approveCreationAtomReqBO.setObjType(ModelRuleConstant.UAC_APPROVAL_TYPE_BRAND);
        approveCreationAtomReqBO.setOrderId(brandId);
        if (StringUtils.hasText((String)reqBO.getCompanyName())) {
            approveCreationAtomReqBO.setOrgName(reqBO.getCompanyName());
        }
        UccApproveCreationAtomRspBO uccApproveCreationAtomRspBO = new UccApproveCreationAtomRspBO();
        try {
            uccApproveCreationAtomRspBO = this.uccApproveCreationAtomService.createApprove(approveCreationAtomReqBO);
        }
        catch (Exception e) {
            log.error("[\u5546\u54c1\u4e2d\u5fc3-\u4f9b\u5e94\u5546\u65b0\u589e\u54c1\u724c\u7533\u8bf7\u63d0\u4ea4\u4e1a\u52a1]-\u542f\u52a8\u5ba1\u6279\u6d41\u5f02\u5e38|", (Throwable)e);
            throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), e.getMessage());
        }
        if (!"0000".equals(uccApproveCreationAtomRspBO.getRespCode())) {
            throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), uccApproveCreationAtomRspBO.getRespDesc());
        }
        if (uccApproveCreationAtomRspBO.getNotFindFlag().booleanValue() || uccApproveCreationAtomRspBO.getFinish().booleanValue()) {
            throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), "\u5931\u8d25:\u6d41\u7a0bkey[" + approveCreationAtomReqBO.getMenuId() + "]\u7684\u6d41\u7a0b\u56fe\u672a\u627e\u5230,\u8bf7\u68c0\u67e5\u914d\u7f6e");
        }
        if (!StringUtils.isEmpty((Object)uccApproveCreationAtomRspBO.getStepId())) {
            this.mapper.batchUpdateStepById(objIds, uccApproveCreationAtomRspBO.getStepId());
        }
        return uccApproveCreationAtomRspBO;
    }

    private void sendPostBrandAlias(Long brandId, String brandName, List<UccBrandAliasInfoBO> brandAliasList, long userId, String username) {
        try {
            for (UccBrandAliasInfoBO alias : brandAliasList) {
                alias.setOperType(Integer.valueOf(1));
            }
            JSONObject json = new JSONObject();
            json.put("mallBrandId", (Object)brandId);
            json.put("mallBrandName", (Object)brandName);
            json.put("sourceType", (Object)2);
            JSONArray jsonArray = new JSONArray();
            jsonArray.addAll(brandAliasList);
            json.put("brandAliasList", (Object)jsonArray);
            json.put("userId", (Object)userId);
            json.put("userName", (Object)username);
            String result = SSLClient.doPost(this.addAliasBrandUrl, json.toJSONString());
            if (log.isDebugEnabled()) {
                log.debug("[\u5546\u54c1\u4e2d\u5fc3-\u54c1\u724c\u6dfb\u52a0]-\u54c1\u724c\u522b\u540d\u6570\u636e:{}\u54c1\u724c\u522b\u540d\u8c03\u75281.0API\u7ed3\u679c\uff1a{}", (Object)json, (Object)result);
            }
        }
        catch (Exception e) {
            log.error("[\u5546\u54c1\u4e2d\u5fc3-\u54c1\u724c\u6dfb\u52a0]-\u54c1\u724c\u522b\u540d\u8c03\u7528\u8fdc\u7a0b\u9519\u8bef|", (Throwable)e);
        }
    }

    public boolean judge(UccBrandAddReqBO reqBO, UccBrandAddRspBO rspBO) {
        Map<String, String> map = null;
        if (reqBO.getBrandName() == null || reqBO.getBrandName().equals("")) {
            rspBO.setRespDesc("\u63d2\u5165\u54c1\u724c\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (reqBO.getBrandStatus() != null) {
            map = this.uccDictionaryAtomService.queryBypCodeBackMap(Brand.BRAND_STATUS.toString());
            if (!map.containsKey(reqBO.getBrandStatus().toString())) {
                rspBO.setRespDesc("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u72b6\u6001");
                return false;
            }
        } else {
            rspBO.setRespDesc("\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        List<UccMallBrandDetaillListPO> uccMallBrandDetaillListPOS = this.uccBrandExtMapper.getMallBrandListNoLike(reqBO.getBrandName());
        if (!CollectionUtils.isEmpty(uccMallBrandDetaillListPOS)) {
            rspBO.setRespDesc("\u54c1\u724c\u540d\u79f0\u91cd\u590d\uff01\u8bf7\u4fee\u6539\u540e\u518d\u4fdd\u5b58\uff01");
            return false;
        }
        return true;
    }
}

