/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.busi.impl;

import com.tydic.commodity.base.bo.UccBrandDeleteReqBO;
import com.tydic.commodity.base.bo.UccBrandDeleteRspBO;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.enumType.BrandAuthAuditStatusEnum;
import com.tydic.commodity.base.enumType.BrandAuthStatusEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.busi.api.UccBrandDeleteBusiService;
import com.tydic.commodity.dao.UccBrandAuthorizeMapper;
import com.tydic.commodity.dao.UccBrandDealMapper;
import com.tydic.commodity.po.UccBrandAuthorizePO;
import com.tydic.commodity.po.UccBrandDealPO;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccBrandDeleteBusiServiceImpl
implements UccBrandDeleteBusiService {
    @Autowired
    private UccBrandDealMapper mapper;
    UccBrandDeleteRspBO rspBO = new UccBrandDeleteRspBO();
    @Autowired
    private UccBrandAuthorizeMapper authorizeMapper;

    @Override
    public UccBrandDeleteRspBO deleteBrand(UccBrandDeleteReqBO reqBO) {
        if (!this.judge(reqBO)) {
            this.rspBO.setRespCode("8888");
            return this.rspBO;
        }
        UccBrandDealPO brandDealPO = new UccBrandDealPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)brandDealPO);
        int result = 0;
        try {
            result = this.mapper.deleteBrand(brandDealPO);
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u6570\u636e\u5e93\u5220\u9664\u6570\u636e\u5f02\u5e38");
        }
        if (result > 0) {
            this.rspBO.setRespCode("0000");
            this.rspBO.setRespDesc("\u5220\u9664\u54c1\u724c\u6210\u529f");
        } else {
            this.rspBO.setRespCode("8888");
            this.rspBO.setRespDesc("\u5220\u9664\u54c1\u724c\u5931\u8d25");
        }
        return this.rspBO;
    }

    public boolean judge(UccBrandDeleteReqBO reqBO) {
        if (reqBO.getBrandId() == null) {
            this.rspBO.setRespCode("8888");
            this.rspBO.setRespDesc("\u54c1\u724cID\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            UccBrandDealPO bo = new UccBrandDealPO();
            BeanUtils.copyProperties((Object)reqBO, (Object)bo);
            Integer i = this.mapper.checkBrandRCommodity(bo);
            UccBrandDealPO result1 = this.mapper.selectById(bo);
            if (result1 != null) {
                if (i > 0 || result1.getBrandStatus() == 1) {
                    this.rspBO.setRespDesc("\u54c1\u724c\u4e0e\u5546\u54c1\u5173\u8054\u6216\u54c1\u724c\u72b6\u6001\u6b63\u5728\u542f\u7528");
                    return false;
                }
            } else {
                this.rspBO.setRespDesc("\u54c1\u724cID\u4e0d\u5b58\u5728");
                return false;
            }
            UccBrandAuthorizePO qryPO = new UccBrandAuthorizePO();
            qryPO.setDelFlag(UccConstants.Status.INVALID);
            qryPO.setBrandId(reqBO.getBrandId());
            List<Integer> authStatusList = Arrays.asList(BrandAuthStatusEnum.NO_AUTH_STATUS.getStatus(), BrandAuthStatusEnum.HAD_AUTH_STATUS.getStatus(), BrandAuthStatusEnum.WILL_END_AUTH_STATUS.getStatus());
            qryPO.setAuthStatusList(authStatusList);
            List<Integer> auditStatusList = Arrays.asList(BrandAuthAuditStatusEnum.APPROVAL_STATUS.getStatus(), BrandAuthAuditStatusEnum.PASS_STATUS.getStatus());
            qryPO.setAuditStatusList(auditStatusList);
            List<UccBrandAuthorizePO> authorizePOS = this.authorizeMapper.getList(qryPO);
            if (!CollectionUtils.isEmpty(authorizePOS)) {
                this.rspBO.setRespDesc("\u8be5\u54c1\u724c\u5b58\u5728\u7533\u8bf7\u4e2d\u6216\u751f\u6548\u7684\u54c1\u724c\u6388\u6743");
                return false;
            }
        }
        return true;
    }
}

