/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.bo.AttrValueBO;
import com.tydic.commodity.base.bo.CommodityPropDefIdBo;
import com.tydic.commodity.base.bo.PropertyBo;
import com.tydic.commodity.base.enumType.CommodityPropGrpEnum;
import com.tydic.commodity.busibase.atom.api.UccBaseDictionaryAtomService;
import com.tydic.commodity.busibase.busi.api.UccQueryPropertyBusiService;
import com.tydic.commodity.busibase.busi.bo.UccQryPropReqBo;
import com.tydic.commodity.busibase.busi.bo.UccQryPropRspBo;
import com.tydic.commodity.dao.UccCommodityPropDefMapper;
import com.tydic.commodity.dao.UccCommodityPropGrpMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccPropValueListMapper;
import com.tydic.commodity.dao.UccRelPropGrpPropMapper;
import com.tydic.commodity.po.DicDictionaryPo;
import com.tydic.commodity.po.UccCommdPropDefPo;
import com.tydic.commodity.po.UccCommodityPropGrpPo;
import com.tydic.commodity.po.UccCommodityTypePo;
import com.tydic.commodity.po.UccPropValueListPo;
import com.tydic.commodity.po.UccRelPropGrpPropPo;
import com.tydic.commodity.utils.ListCloneUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccQueryPropertyBusiServiceImpl
implements UccQueryPropertyBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccQueryPropertyBusiServiceImpl.class);
    @Autowired
    private UccCommodityPropDefMapper uccCommodityPropDefMapper;
    @Autowired
    private UccCommodityPropGrpMapper uccCommodityPropGrpMapper;
    @Autowired
    private UccRelPropGrpPropMapper uccRelPropGrpPropMapper;
    @Autowired
    private UccPropValueListMapper uccPropValueListMapper;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private UccBaseDictionaryAtomService uccDictionaryAtomService;

    @Override
    public UccQryPropRspBo queryProp(UccQryPropReqBo reqBo) {
        UccQryPropRspBo rspBo = new UccQryPropRspBo();
        String errMsg = this.verify(reqBo);
        if (!"".equals(errMsg)) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc(errMsg);
            return rspBo;
        }
        ArrayList<PropertyBo> bo = new ArrayList<PropertyBo>();
        UccCommodityPropGrpPo grpPo = new UccCommodityPropGrpPo();
        grpPo.setCommodityTypeId(reqBo.getCommodityTypeId());
        grpPo.setCommodityPropGrpType(reqBo.getCommodityPropGrpType());
        grpPo.setPropGrpStatus(1);
        List<UccCommodityPropGrpPo> grpPoList = this.uccCommodityPropGrpMapper.queryGroup((Page<UccCommodityPropGrpPo>)new Page(-1, 10), grpPo);
        if (grpPoList == null || grpPoList.size() == 0) {
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u5546\u54c1\u7c7b\u578b\u6682\u65e0\u5c5e\u6027\u4fe1\u606f");
            return rspBo;
        }
        PropertyBo propertyBo = null;
        CommodityPropDefIdBo commodityPropDefIdBo = null;
        UccRelPropGrpPropPo relPropGrpPropPo = new UccRelPropGrpPropPo();
        List<Object> relList = new ArrayList();
        ArrayList<CommodityPropDefIdBo> listDefs = null;
        for (UccCommodityPropGrpPo each : grpPoList) {
            listDefs = new ArrayList<CommodityPropDefIdBo>();
            propertyBo = new PropertyBo();
            try {
                BeanUtils.copyProperties((Object)each, (Object)propertyBo);
            }
            catch (Exception e) {
                LOGGER.error("[\u5546\u54c1\u4e2d\u5fc3-\u5c5e\u6027\u67e5\u8be2]-\u5f02\u5e38|", (Throwable)e);
                throw new ZTBusinessException("spring copy value Exception:" + e.getMessage());
            }
            relPropGrpPropPo.setCommodityPropGrpId(each.getCommodityPropGrpId());
            relList = this.uccRelPropGrpPropMapper.queryRelToPage((Page<UccRelPropGrpPropPo>)new Page(-1, 10), relPropGrpPropPo);
            for (UccRelPropGrpPropPo uccRelPropGrpPropPo : relList) {
                commodityPropDefIdBo = this.getPropDef(uccRelPropGrpPropPo.getCommodityPropDefId());
                listDefs.add(commodityPropDefIdBo);
            }
            propertyBo.setCommodityPropDefIds(listDefs);
            DicDictionaryPo dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(each.getCommodityPropGrpType().toString(), CommodityPropGrpEnum.COMMODITY_PROP_GRP_TYPE.toString());
            if (dicDictionaryPo != null) {
                propertyBo.setPropGrpTypeDesc(dicDictionaryPo.getTitle());
            }
            bo.add(propertyBo);
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u5c5e\u6027\u67e5\u8be2\u6210\u529f");
        rspBo.setProperty(bo);
        return rspBo;
    }

    private CommodityPropDefIdBo getPropDef(Long commodityPropDefId) {
        CommodityPropDefIdBo commodityPropDefIdBo = new CommodityPropDefIdBo();
        UccCommdPropDefPo po = new UccCommdPropDefPo();
        po.setCommodityPropDefId(commodityPropDefId);
        po = this.uccCommodityPropDefMapper.queryBycommodityPropDefId(po);
        if (po == null) {
            throw new ZTBusinessException("\u5c5e\u6027\u67e5\u8be2\u5931\u8d25\uff1a\u5c5e\u6027ID" + commodityPropDefId + "\u4e0d\u5b58\u5728");
        }
        try {
            BeanUtils.copyProperties((Object)po, (Object)commodityPropDefIdBo);
        }
        catch (Exception e) {
            LOGGER.error("[\u5546\u54c1\u4e2d\u5fc3-\u5c5e\u6027\u67e5\u8be2]-\u83b7\u53d6\u5c5e\u6027\u76f8\u5173\u4fe1\u606f-\u5f02\u5e38|", (Throwable)e);
            throw new ZTBusinessException("spring copy value Exception:" + e.getMessage());
        }
        List<UccPropValueListPo> listValue = this.uccPropValueListMapper.queryAttrValueBycommodityPropDefId(commodityPropDefId);
        try {
            List<AttrValueBO> attrValueBos = ListCloneUtils.clonePOListToBOList(listValue, AttrValueBO.class);
            commodityPropDefIdBo.setAttrValues(attrValueBos);
        }
        catch (Exception e) {
            LOGGER.error("[\u5546\u54c1\u4e2d\u5fc3-\u5c5e\u6027\u67e5\u8be2]-\u83b7\u53d6\u5c5e\u6027\u76f8\u5173\u4fe1\u606f-\u5f02\u5e38|", (Throwable)e);
            throw new ZTBusinessException("ListCloneUtils copy value Exception:" + e.getMessage());
        }
        return commodityPropDefIdBo;
    }

    private String verify(UccQryPropReqBo reqBo) {
        if (reqBo.getCommodityTypeId() == null || reqBo.getCommodityTypeId() == 0L) {
            return "\u8bf7\u4f20\u5165\u5546\u54c1\u7c7b\u578b";
        }
        return this.dataVerify(reqBo);
    }

    private String dataVerify(UccQryPropReqBo reqBo) {
        UccCommodityTypePo po = this.uccCommodityTypeMapper.queryPoByCommodityTypeId(reqBo.getCommodityTypeId());
        if (po == null) {
            return "\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u5546\u54c1\u7c7b\u578b";
        }
        return this.enumVerify(reqBo);
    }

    private String enumVerify(UccQryPropReqBo reqBo) {
        Map<String, String> map;
        if (reqBo.getCommodityPropGrpType() != null && !(map = this.uccDictionaryAtomService.queryBypCodeBackMap(CommodityPropGrpEnum.COMMODITY_PROP_GRP_TYPE.toString())).containsKey(reqBo.getCommodityPropGrpType().toString())) {
            return "\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u5c5e\u6027\u7ec4\u7c7b\u578b";
        }
        return "";
    }
}

