/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.comb.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.agreement.ability.api.AgrQryAgreementItemSkuIdListAbilityService;
import com.tydic.agreement.ability.bo.AgrQryAgreementItemSkuIdListAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrQryAgreementItemSkuIdListAbilityRspBO;
import com.tydic.commodity.base.bo.UccEstoreLadderPriceBO;
import com.tydic.commodity.base.enumType.SkuEnum;
import com.tydic.commodity.base.enumType.SkuStatusEnum;
import com.tydic.commodity.busibase.atom.api.UccBaseDictionaryAtomService;
import com.tydic.commodity.busibase.comb.api.UccSkuManagementListQryCombService;
import com.tydic.commodity.busibase.comb.bo.UccCombEsCommodityBo;
import com.tydic.commodity.busibase.comb.bo.UccSkuManagementListCombQryBO;
import com.tydic.commodity.busibase.comb.bo.UccSkuManagementListQryCombReqBO;
import com.tydic.commodity.busibase.comb.bo.UccSkuManagementListQryCombRspBO;
import com.tydic.commodity.config.ElasticsearchUtil;
import com.tydic.commodity.config.EsConfig;
import com.tydic.commodity.dao.UccLadderPriceMapper;
import com.tydic.commodity.dao.UccOrgSkuMapper;
import com.tydic.commodity.dao.UccSkuChangeMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.dao.UocApprovalObjMapper;
import com.tydic.commodity.po.DicDictionaryPo;
import com.tydic.commodity.po.UccLadderPricePO;
import com.tydic.commodity.po.UccOrgSkuPO;
import com.tydic.commodity.po.UccSkuPricePo;
import com.tydic.commodity.po.UocApprovalObjPO;
import com.tydic.commodity.po.UocSpuApproverLogPO;
import com.tydic.commodity.utils.MoneyUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Response;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccSkuManagementListQryCombServiceImpl
implements UccSkuManagementListQryCombService {
    private static final Logger log = LoggerFactory.getLogger(UccSkuManagementListQryCombServiceImpl.class);
    private static final long serialVersionUID = 1956659951572577168L;
    @Autowired
    private EsConfig esConfig;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    @Autowired
    private UccBaseDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccLadderPriceMapper uccLadderPriceMapper;
    @Autowired
    private UocApprovalObjMapper uocApprovalObjMapper;
    @Autowired
    private UccOrgSkuMapper uccOrgSkuMapper;
    @Autowired
    private UccSkuChangeMapper uccSkuChangeMapper;
    @Autowired
    private AgrQryAgreementItemSkuIdListAbilityService agrQryAgreementItemSkuIdListAbilityService;

    @Override
    public UccSkuManagementListQryCombRspBO getSkuManagementListQry(UccSkuManagementListQryCombReqBO reqBO) {
        BoolQueryBuilder extBoolQueryBuilder;
        String queryString;
        String result;
        log.info("[\u5546\u54c1\u4e2d\u5fc3-\u5546\u54c1\u4fe1\u606f\u67e5\u8be2]-\u5546\u54c1\u5217\u8868\u67e5\u8be2-\u5165\u53c2|reqBO:{}", (Object)JSON.toJSONString((Object)((Object)reqBO)));
        UccSkuManagementListQryCombRspBO rspBo = new UccSkuManagementListQryCombRspBO();
        log.info("[\u5546\u54c1\u4e2d\u5fc3-\u5546\u54c1\u4fe1\u606f\u67e5\u8be2]-\u5546\u54c1\u5217\u8868\u67e5\u8be2-\u5165\u53c2|reqBO.getIsProfessionalOrgExt():{},reqBO.getApprovalStatus():{}", (Object)reqBO.getIsProfessionalOrgExt(), (Object)reqBO.getApprovalStatus());
        if (reqBO.getApprovalStatus() != null && 31 == reqBO.getApprovalStatus() && "1".equals(reqBO.getIsProfessionalOrgExt())) {
            AgrQryAgreementItemSkuIdListAbilityReqBO skuIdListAbilityReqBO = new AgrQryAgreementItemSkuIdListAbilityReqBO();
            skuIdListAbilityReqBO.setServiceOrgId(reqBO.getOrgId());
            log.info("[\u5546\u54c1\u4e2d\u5fc3-\u5546\u54c1\u4fe1\u606f\u67e5\u8be2]-\u5546\u54c1\u5217\u8868\u67e5\u8be2-\u5165\u53c2|reqBO.getOrgId():{}", (Object)reqBO.getOrgId());
            AgrQryAgreementItemSkuIdListAbilityRspBO skuIdListAbilityRspBO = this.agrQryAgreementItemSkuIdListAbilityService.qryAgreementItemSkuIdList(skuIdListAbilityReqBO);
            if (skuIdListAbilityRspBO != null && !CollectionUtils.isEmpty((Collection)skuIdListAbilityRspBO.getSkuIds())) {
                log.info("[\u5546\u54c1\u4e2d\u5fc3-\u5546\u54c1\u4fe1\u606f\u67e5\u8be2]-\u534f\u8bae\u4fe1\u606f\u67e5\u8be2-\u5165\u53c2|skuIdListAbilityRspBO.getSkuIds():{}", (Object)JSON.toJSONString((Object)skuIdListAbilityRspBO.getSkuIds()));
                reqBO.setSkuIds(skuIdListAbilityRspBO.getSkuIds());
            }
        }
        if (reqBO.getFindgoodsOrgId() != null) {
            UccOrgSkuPO findOrgSkuPO = new UccOrgSkuPO();
            findOrgSkuPO.setServiceOrgId(reqBO.getFindgoodsOrgId());
            findOrgSkuPO.setSkuStatusList(reqBO.getSkuStatus());
            if (reqBO.getVendorId() != null) {
                findOrgSkuPO.setOrgId(String.valueOf(reqBO.getVendorId()));
            }
            List<Long> virtualSkuIds = this.uccOrgSkuMapper.qryVirSkuIdsByAgrDetailList(findOrgSkuPO);
            reqBO.setVirtualSkuIds(virtualSkuIds);
            log.info("[\u5546\u54c1\u4e2d\u5fc3-\u5546\u54c1\u4fe1\u606f\u67e5\u8be2]-\u534f\u8bae\u5546\u54c1\u67e5\u8be2-\u5165\u53c2|virtualSkuIds:{}", (Object)JSON.toJSONString(virtualSkuIds));
        }
        if (StringUtils.isEmpty((Object)(result = this.searchInfo(queryString = this.excuteEsSql(reqBO, extBoolQueryBuilder = this.buildEsSql(reqBO)))))) {
            rspBo.setTotal(0);
            rspBo.setRespCode("0000");
            rspBo.setRecordsTotal(0);
            rspBo.setRows(new ArrayList());
            return rspBo;
        }
        rspBo = this.dealSearchData(result, reqBO);
        if (!CollectionUtils.isEmpty((Collection)rspBo.getRows())) {
            List<UccSkuPricePo> pricePos;
            List<UccLadderPricePO> ladderPricePOS;
            Map<Integer, List<UccSkuPricePo>> groupBySwitch;
            List<Long> skus = rspBo.getRows().stream().map(UccSkuManagementListCombQryBO::getSkuId).collect(Collectors.toList());
            List<UccSkuPricePo> bathPrice = this.uccSkuPriceMapper.batchQryPriBySkuIds(skus, null);
            if (!CollectionUtils.isEmpty((Collection)rspBo.getRows()) && (groupBySwitch = bathPrice.stream().collect(Collectors.groupingBy(UccSkuPricePo::getSwitchOn))).containsKey(1) && !CollectionUtils.isEmpty(ladderPricePOS = this.uccLadderPriceMapper.selectListBySku(skus = (pricePos = groupBySwitch.get(1)).stream().map(UccSkuPricePo::getSkuId).collect(Collectors.toList())))) {
                Map<Long, List<UccLadderPricePO>> ladderMap = ladderPricePOS.stream().collect(Collectors.groupingBy(UccLadderPricePO::getSkuId));
                Iterator<Long> iterator = ladderMap.keySet().iterator();
                HashMap<Long, List> longListMap = new HashMap<Long, List>();
                while (iterator.hasNext()) {
                    Long key = iterator.next();
                    List<UccLadderPricePO> mapPos = ladderMap.get(key);
                    List eachBo = JSONObject.parseArray((String)JSONObject.toJSONString(mapPos), UccEstoreLadderPriceBO.class);
                    eachBo.sort(new Comparator<UccEstoreLadderPriceBO>(){

                        @Override
                        public int compare(UccEstoreLadderPriceBO o1, UccEstoreLadderPriceBO o2) {
                            return o2.getStart().compareTo(o1.getStart());
                        }
                    });
                    for (UccEstoreLadderPriceBO each : eachBo) {
                        if (each.getStart() != null) {
                            each.setStart(MoneyUtils.haoToYuan(each.getStart()));
                        }
                        if (each.getStop() != null) {
                            each.setStop(MoneyUtils.haoToYuan(each.getStop()));
                        }
                        if (each.getPrice() == null) continue;
                        each.setPrice(MoneyUtils.haoToYuan(each.getPrice()));
                    }
                    longListMap.put(key, eachBo);
                }
                if (!longListMap.isEmpty()) {
                    for (UccSkuManagementListCombQryBO each : rspBo.getRows()) {
                        if (!longListMap.containsKey(each.getSkuId())) continue;
                        each.setLadderPriceInfo((List)longListMap.get(each.getSkuId()));
                    }
                }
            }
        }
        return rspBo;
    }

    private String searchInfo(String queryString) {
        String endPoint = "/" + this.esConfig.getIndexName() + "/" + this.esConfig.getEsType() + "/_search";
        log.info("[\u5546\u54c1\u4e2d\u5fc3-\u5546\u54c1\u4fe1\u606f\u67e5\u8be2]-searchInfo-\u5165\u53c2|queryString:{}", (Object)queryString);
        NStringEntity entity = new NStringEntity(queryString, ContentType.APPLICATION_JSON);
        try {
            Response response = this.elasticsearchUtil.getLowLevelClient().performRequest("POST", endPoint, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            if (log.isDebugEnabled()) {
                log.debug("[\u5546\u54c1\u4e2d\u5fc3-\u5546\u54c1\u4fe1\u606f\u67e5\u8be2]-searchInfo-\u5165\u53c2|result:{}", (Object)result);
            }
            return result;
        }
        catch (IOException e) {
            log.error("[\u5546\u54c1\u4e2d\u5fc3-\u5546\u54c1\u4fe1\u606f\u67e5\u8be2]-searchInfo-\u5f02\u5e38|", (Throwable)e);
            return null;
        }
    }

    private BoolQueryBuilder buildEsSql(UccSkuManagementListQryCombReqBO reqBo) {
        WildcardQueryBuilder wildcardQuery;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (!StringUtils.isEmpty((Object)reqBo.getApprovalType())) {
            if (reqBo.getApprovalType().equals("0")) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_approval_status", (String)reqBo.getApprovalType()));
            } else {
                String[] split = reqBo.getApprovalType().split(",");
                List<String> strings = Arrays.asList(split);
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_approval_status", strings));
            }
        }
        if (!CollectionUtils.isEmpty(reqBo.getExportSkuIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_id", reqBo.getExportSkuIds()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getNotSkuIds())) {
            boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"sku_id", reqBo.getNotSkuIds()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getSkuIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_id", reqBo.getSkuIds()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getCatalogIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"type_id", reqBo.getCatalogIds()));
        }
        if (reqBo.getCommodityTypeId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"type_id", (Object)reqBo.getCommodityTypeId()));
        }
        if (reqBo.getSkuSource() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_source", (Object)reqBo.getSkuSource()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSwitchOn())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"switch_on", (Object)reqBo.getSwitchOn()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getRefinedOil())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"expand17", (String)reqBo.getRefinedOil()));
        }
        if (reqBo.getSourceAssort() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sourceAssort", (Object)reqBo.getSourceAssort()));
        }
        if (reqBo.getApprovalStatus() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_approval_status", (Object)reqBo.getApprovalStatus()));
        }
        if (reqBo.getBrandId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"brand_id", (Object)reqBo.getBrandId()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getVirtualSkuIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"virtual_sku_id", reqBo.getVirtualSkuIds()));
        }
        if (reqBo.getVendorId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"vendor_id", (Object)reqBo.getVendorId()));
        }
        if (reqBo.getSupplierId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_id", (Object)reqBo.getSupplierId()));
        }
        if (reqBo.getCommodityType() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"commodity_type", (Object)reqBo.getCommodityType()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getExtSpuId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"ext_spu_id.keyword", (String)reqBo.getExtSpuId()));
        }
        if (reqBo.getSkuId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_id", (Object)reqBo.getSkuId()));
        }
        if (reqBo.getCommodityId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"commodity_id", (Object)reqBo.getCommodityId()));
        }
        if (reqBo.getL4mgCategoryId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"l4mg_category_id", (Object)reqBo.getL4mgCategoryId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getExtSkuId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"ext_sku_id.keyword", (String)reqBo.getExtSkuId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCreateOperId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"create_oper_id", (String)reqBo.getCreateOperId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getVendorCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"vendor_code", (String)reqBo.getVendorCode()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSupplierOrgId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_org_id", (String)reqBo.getSupplierOrgId()));
        }
        if (reqBo.getSupplierShopId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_shop_id", (Object)reqBo.getSupplierShopId()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getOperIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"operIds", reqBo.getOperIds()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getSkuStatus())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_status", reqBo.getSkuStatus()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getCommodityStatus())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"commodity_status", reqBo.getCommodityStatus()));
        }
        if (reqBo.getAgreementId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"agreement_id", (Object)reqBo.getAgreementId()));
        }
        if (reqBo.getAgreementDetailsId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"agreement_details_id", (Object)reqBo.getAgreementDetailsId()));
        }
        if (reqBo.getCreateTimeBegin() != null || reqBo.getCreateTimeEnd() != null) {
            RangeQueryBuilder rangequerybuilder = QueryBuilders.rangeQuery((String)"create_time");
            if (reqBo.getCreateTimeBegin() != null) {
                long startL = reqBo.getCreateTimeBegin().getTime();
                String startTime = String.valueOf(startL);
                rangequerybuilder.from((Object)startTime);
            }
            if (reqBo.getCreateTimeEnd() != null) {
                long endL = reqBo.getCreateTimeEnd().getTime();
                String endTime = String.valueOf(endL);
                rangequerybuilder.to((Object)endTime);
            }
            boolQueryBuilder.must((QueryBuilder)rangequerybuilder);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getManufacturer())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"manufacturer", (String)("*" + reqBo.getManufacturer() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCreateOperName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"create_oper_name.keyword", (String)("*" + reqBo.getCreateOperName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getBrandName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"brand_name.keyword", (String)("*" + reqBo.getBrandName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"commodity_name.keyword", (String)("*" + reqBo.getCommodityName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityExpand1())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"commodity_expand1.keyword", (String)("*" + reqBo.getCommodityExpand1() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getVendorName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"vendor_name.keyword", (String)("*" + reqBo.getVendorName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSkuName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"sku_name.keyword", (String)("*" + reqBo.getSkuName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMaterialCode())) {
            if (reqBo.getIsMaterCode() != null) {
                if (reqBo.getIsMaterCode() == 1) {
                    boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"material_code.keyword", (String[])new String[]{reqBo.getMaterialCode()}));
                }
            } else {
                wildcardQuery = QueryBuilders.wildcardQuery((String)"material_code.keyword", (String)("*" + reqBo.getMaterialCode() + "*"));
                boolQueryBuilder.must((QueryBuilder)wildcardQuery);
            }
        }
        if (!StringUtils.isEmpty((Object)reqBo.getOtherSourceName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"other_source_name.keyword", (String)("*" + reqBo.getOtherSourceName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getModel())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"model", (Object)reqBo.getModel()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSpec())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"spec", (Object)reqBo.getSpec()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityTypeName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"type_name.keyword", (String)("*" + reqBo.getCommodityTypeName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMaterialName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"material_name.keyword", (String)("*" + reqBo.getMaterialName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityCode())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"commodity_code.keyword", (String)("*" + reqBo.getCommodityCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSkuCode())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"sku_code.keyword", (String)("*" + reqBo.getSkuCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getOtherSourceCode())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"other_source_code.keyword", (String)("*" + reqBo.getOtherSourceCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        RangeQueryBuilder discountQb = null;
        if (!StringUtils.isEmpty((Object)reqBo.getDiscountStar())) {
            discountQb = QueryBuilders.rangeQuery((String)"discounts").gte((Object)reqBo.getDiscountStar());
        }
        if (!StringUtils.isEmpty((Object)reqBo.getDiscountEnd())) {
            discountQb = QueryBuilders.rangeQuery((String)"discounts").lte((Object)reqBo.getDiscountEnd());
        }
        if (discountQb != null) {
            boolQueryBuilder.must((QueryBuilder)discountQb);
        }
        RangeQueryBuilder maerketQb = null;
        if (!StringUtils.isEmpty((Object)reqBo.getMarketPriceStar())) {
            maerketQb = QueryBuilders.rangeQuery((String)"market_price").gte((Object)MoneyUtils.yuanToHaoToLong(reqBo.getMarketPriceStar()));
            boolQueryBuilder.must((QueryBuilder)maerketQb);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMarketPriceEnd())) {
            maerketQb = QueryBuilders.rangeQuery((String)"market_price").lte((Object)MoneyUtils.yuanToHaoToLong(reqBo.getMarketPriceEnd()));
            boolQueryBuilder.must((QueryBuilder)maerketQb);
        }
        RangeQueryBuilder saleQb = null;
        if (!StringUtils.isEmpty((Object)reqBo.getSalePriceStar())) {
            saleQb = QueryBuilders.rangeQuery((String)"sale_price").gte((Object)MoneyUtils.yuanToHaoToLong(reqBo.getSalePriceStar()));
            boolQueryBuilder.must((QueryBuilder)saleQb);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSalePriceEnd())) {
            saleQb = QueryBuilders.rangeQuery((String)"sale_price").lte((Object)MoneyUtils.yuanToHaoToLong(reqBo.getSalePriceEnd()));
            boolQueryBuilder.must((QueryBuilder)saleQb);
        }
        return boolQueryBuilder;
    }

    private String excuteEsSql(UccSkuManagementListQryCombReqBO reqBo, BoolQueryBuilder extBoolQueryBuilder) {
        JSONObject queryJson = new JSONObject();
        queryJson.put("size", (Object)reqBo.getPageSize());
        queryJson.put("from", (Object)(reqBo.getPageSize() * (reqBo.getPageNo() - 1)));
        String queryString = null;
        queryString = extBoolQueryBuilder.toString();
        queryJson.put("query", (Object)JSON.parseObject((String)queryString));
        SortOrder orderType = SortOrder.DESC;
        if (reqBo.getOrderType() != null && reqBo.getOrderType() == 1) {
            orderType = SortOrder.ASC;
        }
        String sortField = "";
        if (reqBo.getOrderByColumn() != null) {
            if (reqBo.getOrderByColumn() == 0) {
                sortField = "create_time";
            } else if (reqBo.getOrderByColumn() == 1) {
                sortField = "sold_number";
            } else if (reqBo.getOrderByColumn() == 2) {
                sortField = "on_shelve_time";
            } else if (reqBo.getOrderByColumn() == 3) {
                sortField = "sale_price";
            } else if (reqBo.getOrderByColumn() == 4) {
                sortField = "discounts";
            } else if (reqBo.getOrderByColumn() == 5) {
                sortField = "comment_number";
            } else if (reqBo.getOrderByColumn() == 6) {
                sortField = "insert_time";
            }
        }
        if (!StringUtils.isEmpty((Object)sortField)) {
            FieldSortBuilder sortQuery = (FieldSortBuilder)SortBuilders.fieldSort((String)sortField).order(orderType);
            queryJson.put("sort", (Object)JSONObject.parseObject((String)sortQuery.toString()));
        }
        return queryJson.toString();
    }

    private UccSkuManagementListQryCombRspBO dealSearchData(String result, UccSkuManagementListQryCombReqBO reqBo) {
        UccSkuManagementListQryCombRspBO rspBo = new UccSkuManagementListQryCombRspBO();
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = hitsObj.getInteger("total");
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (log.isDebugEnabled()) {
            log.debug("[\u5546\u54c1\u4e2d\u5fc3-\u5546\u54c1\u4fe1\u606f\u67e5\u8be2]-dealSearchData-\u5165\u53c2|\u603b\u8bb0\u5f55\u6570:{} \u8fd4\u56de\u8bb0\u5f55\u6570\u636e{}", (Object)total, (Object)listObject.size());
        }
        ArrayList<UccCombEsCommodityBo> commodityModels = new ArrayList<UccCombEsCommodityBo>();
        HashSet<Long> skuIdSet = new HashSet<Long>();
        if (listObject.size() > 0) {
            for (int i = 0; i < listObject.size(); ++i) {
                JSONObject hitObj = listObject.getJSONObject(i);
                JSONObject data = (JSONObject)hitObj.get((Object)"_source");
                UccCombEsCommodityBo commodity = new UccCombEsCommodityBo();
                try {
                    commodity = (UccCombEsCommodityBo)JSON.toJavaObject((JSON)data, UccCombEsCommodityBo.class);
                    commodityModels.add(commodity);
                    continue;
                }
                catch (Exception e) {
                    log.error("[\u5546\u54c1\u4e2d\u5fc3-\u5546\u54c1\u4fe1\u606f\u67e5\u8be2]-\u641c\u7d22es\u6570\u636e\u662f\u5355\u4e2a\u7684\u60c5\u51b5-\u5f02\u5e38|", (Throwable)e);
                    if (!skuIdSet.contains(commodity.getSku_id())) {
                        commodityModels.add(commodity);
                    }
                    skuIdSet.add(commodity.getSku_id());
                }
            }
        }
        rspBo = this.copyData(commodityModels, total, reqBo.getPageNo(), reqBo.getPageSize());
        return rspBo;
    }

    private UccSkuManagementListQryCombRspBO copyData(List<UccCombEsCommodityBo> commodityModels, Integer totalNum, int pageNo, int pageSize) {
        log.info("[\u5546\u54c1\u4e2d\u5fc3-\u5546\u54c1\u4fe1\u606f\u67e5\u8be2]-copyData-\u5165\u53c2|commodityModels.size():{} totalNum:{} pageNo:{} pageSize:{}", new Object[]{commodityModels.size(), totalNum, pageNo, pageSize});
        log.info("[\u5546\u54c1\u4e2d\u5fc3-\u5546\u54c1\u4fe1\u606f\u67e5\u8be2]-copyData-\u5165\u53c2|commodityModels:{}", (Object)commodityModels.toString());
        UccSkuManagementListQryCombRspBO rspBo = new UccSkuManagementListQryCombRspBO();
        ArrayList<UccSkuManagementListCombQryBO> uccSkuManagementListQryBOs = new ArrayList<UccSkuManagementListCombQryBO>();
        if (totalNum != null) {
            rspBo.setPageNo(pageNo);
            int size = pageSize;
            int totalPage = 0;
            int add = 0;
            Integer total = 0;
            totalPage = totalNum / size;
            add = totalNum % size == 0 ? 0 : 1;
            total = totalNum;
            rspBo.setTotal(totalPage + add);
            rspBo.setRecordsTotal(total);
            DicDictionaryPo dicDictionaryPo = null;
            if (!CollectionUtils.isEmpty(commodityModels)) {
                for (UccCombEsCommodityBo cnncEsCommodityBo : commodityModels) {
                    UccSkuManagementListCombQryBO uccSkuManagementListQryBO = new UccSkuManagementListCombQryBO();
                    uccSkuManagementListQryBO.setCommodityCode(cnncEsCommodityBo.getCommodity_code());
                    uccSkuManagementListQryBO.setCommodityId(cnncEsCommodityBo.getCommodity_id());
                    uccSkuManagementListQryBO.setCommodityName(cnncEsCommodityBo.getCommodity_name());
                    uccSkuManagementListQryBO.setSkuId(cnncEsCommodityBo.getSku_id());
                    uccSkuManagementListQryBO.setSkuCode(cnncEsCommodityBo.getSku_code());
                    uccSkuManagementListQryBO.setSkuName(cnncEsCommodityBo.getSku_name());
                    uccSkuManagementListQryBO.setSkuSource(cnncEsCommodityBo.getSku_source());
                    uccSkuManagementListQryBO.setSourceAssort(cnncEsCommodityBo.getSourceAssort());
                    uccSkuManagementListQryBO.setCommodityTypeId(cnncEsCommodityBo.getType_id());
                    uccSkuManagementListQryBO.setCommodityTypeName(cnncEsCommodityBo.getType_name());
                    uccSkuManagementListQryBO.setCatalogId(cnncEsCommodityBo.getType_id());
                    uccSkuManagementListQryBO.setCatalogName(cnncEsCommodityBo.getType_name());
                    uccSkuManagementListQryBO.setRefinedOil(cnncEsCommodityBo.getExpand17());
                    if (uccSkuManagementListQryBO.getRefinedOil() != null && uccSkuManagementListQryBO.getRefinedOil() == 0) {
                        uccSkuManagementListQryBO.setRefinedOilDesc("\u5426");
                    }
                    if (uccSkuManagementListQryBO.getRefinedOil() != null && uccSkuManagementListQryBO.getRefinedOil() == 1) {
                        uccSkuManagementListQryBO.setRefinedOilDesc("\u662f");
                    }
                    if ((dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(String.valueOf(cnncEsCommodityBo.getSku_status()), SkuEnum.SKU_STATUS.toString())) != null) {
                        uccSkuManagementListQryBO.setSkuStatusDesc(dicDictionaryPo.getTitle());
                        if (SkuStatusEnum.DOWN_FRAME_STATUS.getStatus().equals(cnncEsCommodityBo.getSku_status()) || SkuStatusEnum.EC_DOWN_STATUS.getStatus().equals(cnncEsCommodityBo.getSku_status()) || SkuStatusEnum.ENFORCE_DOWN_STATUS.getStatus().equals(cnncEsCommodityBo.getSku_status()) || SkuStatusEnum.WARN_DOWN_STATUS.getStatus().equals(cnncEsCommodityBo.getSku_status())) {
                            uccSkuManagementListQryBO.setDownTypeDesc(dicDictionaryPo.getTitle());
                            try {
                                List<UocSpuApproverLogPO> uocSpuApproverLogPOS;
                                UocApprovalObjPO uocApprovalObjPO = new UocApprovalObjPO();
                                uocApprovalObjPO.setObjId(uccSkuManagementListQryBO.getSkuId());
                                uocApprovalObjPO.setObjType(4);
                                List<UocApprovalObjPO> uocApprovalObjPOS = this.uocApprovalObjMapper.queryPo(uocApprovalObjPO);
                                if (!CollectionUtils.isEmpty(uocApprovalObjPOS) && !CollectionUtils.isEmpty(uocSpuApproverLogPOS = this.uocApprovalObjMapper.qryApproverLog(uocApprovalObjPOS.get(0).getAuditOrderId()))) {
                                    uccSkuManagementListQryBO.setDownReason(uocSpuApproverLogPOS.get(1).getAuditAdvice());
                                }
                            }
                            catch (Exception e) {
                                log.error("[\u5546\u54c1\u4e2d\u5fc3-\u5546\u54c1\u4fe1\u606f\u67e5\u8be2]-\u67e5\u8be2\u5ba1\u6279\u4e2d\u5fc3\u4e0b\u67b6\u539f\u56e0-\u5f02\u5e38|", (Throwable)e);
                            }
                        }
                    }
                    if (cnncEsCommodityBo.getSku_approval_status() != null && !"".equals(cnncEsCommodityBo.getSku_approval_status()) && cnncEsCommodityBo.getSku_approval_status() != 0 && (dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(String.valueOf(cnncEsCommodityBo.getSku_approval_status()), SkuEnum.SKU_APPROVAL_STATUS.toString())) != null) {
                        uccSkuManagementListQryBO.setApprovalStatusDesc(dicDictionaryPo.getTitle());
                    }
                    if ((dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(String.valueOf(cnncEsCommodityBo.getSku_source()), SkuEnum.SKU_SOURCE.toString())) != null) {
                        uccSkuManagementListQryBO.setSkuSourceDesc(dicDictionaryPo.getTitle());
                    }
                    uccSkuManagementListQryBO.setApprovalStatus(cnncEsCommodityBo.getSku_approval_status());
                    uccSkuManagementListQryBO.setBrandId(cnncEsCommodityBo.getBrand_id());
                    uccSkuManagementListQryBO.setBrandName(cnncEsCommodityBo.getBrand_name());
                    uccSkuManagementListQryBO.setVendorId(cnncEsCommodityBo.getVendor_id());
                    uccSkuManagementListQryBO.setCommodityStatus(cnncEsCommodityBo.getCommodity_status());
                    uccSkuManagementListQryBO.setSkuStatus(cnncEsCommodityBo.getSku_status());
                    uccSkuManagementListQryBO.setSettlementUnit(cnncEsCommodityBo.getSettlement_unit());
                    uccSkuManagementListQryBO.setTaxCatCode(cnncEsCommodityBo.getTax_cat_code());
                    if (cnncEsCommodityBo.getDown_time() != null) {
                        uccSkuManagementListQryBO.setDownTime(new Date(cnncEsCommodityBo.getDown_time()));
                    }
                    if (cnncEsCommodityBo.getUp_time() != null) {
                        uccSkuManagementListQryBO.setUpTime(new Date(cnncEsCommodityBo.getUp_time()));
                    }
                    if (cnncEsCommodityBo.getOn_shelve_time() != 0L) {
                        uccSkuManagementListQryBO.setOnShelveTime(new Date(cnncEsCommodityBo.getOn_shelve_time()));
                    }
                    uccSkuManagementListQryBO.setUpcCode(cnncEsCommodityBo.getUpc());
                    uccSkuManagementListQryBO.setSalePrice(MoneyUtils.haoToYuan(cnncEsCommodityBo.getSale_price()));
                    uccSkuManagementListQryBO.setAgreementPrice(MoneyUtils.haoToYuan(cnncEsCommodityBo.getAgreement_price()));
                    uccSkuManagementListQryBO.setMarketPrice(MoneyUtils.haoToYuan(cnncEsCommodityBo.getMarket_price()));
                    uccSkuManagementListQryBO.setSupplierShopId(cnncEsCommodityBo.getSupplier_shop_id());
                    uccSkuManagementListQryBO.setSpec(cnncEsCommodityBo.getSpec());
                    uccSkuManagementListQryBO.setModel(cnncEsCommodityBo.getModel());
                    uccSkuManagementListQryBO.setRate(cnncEsCommodityBo.getTaxRate());
                    uccSkuManagementListQryBO.setPreDeliverDay(cnncEsCommodityBo.getPre_deliver_day());
                    uccSkuManagementListQryBO.setMoq(cnncEsCommodityBo.getMoq());
                    uccSkuManagementListQryBO.setSalesUnitId(cnncEsCommodityBo.getSales_unit_id());
                    uccSkuManagementListQryBO.setSalesUnitName(cnncEsCommodityBo.getSales_unit_name());
                    uccSkuManagementListQryBO.setSwitchOn(cnncEsCommodityBo.getSwitch_on());
                    uccSkuManagementListQryBO.setManufacturer(cnncEsCommodityBo.getManufacturer());
                    uccSkuManagementListQryBO.setCreateOperName(cnncEsCommodityBo.getCreate_oper_name());
                    if (cnncEsCommodityBo.getSwitch_on() != null && !"".equals(cnncEsCommodityBo.getSwitch_on()) && (dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(String.valueOf(cnncEsCommodityBo.getSwitch_on()), "SWITCH_ON")) != null) {
                        uccSkuManagementListQryBO.setSwitchOnDesc(dicDictionaryPo.getTitle());
                    }
                    uccSkuManagementListQryBO.setVendorName(cnncEsCommodityBo.getVendor_name());
                    if (cnncEsCommodityBo.getComment_number() != null) {
                        uccSkuManagementListQryBO.setTotalNum(MoneyUtils.haoToYuan(cnncEsCommodityBo.getComment_number()));
                    } else {
                        uccSkuManagementListQryBO.setTotalNum(new BigDecimal("0"));
                    }
                    if (cnncEsCommodityBo.getCreate_time() == null) {
                        log.info("[\u5546\u54c1\u4e2d\u5fc3-\u5546\u54c1\u4fe1\u606f\u67e5\u8be2]-getCreate_time|\u8f93\u51fa\u65f6\u95f4\u4e3a\u7a7a");
                    } else {
                        uccSkuManagementListQryBO.setCreateTime(new Date(cnncEsCommodityBo.getCreate_time()));
                    }
                    if (cnncEsCommodityBo.getInsert_time() == null) {
                        log.info("[\u5546\u54c1\u4e2d\u5fc3-\u5546\u54c1\u4fe1\u606f\u67e5\u8be2]-getInsert_time|\u7533\u8bf7\u65f6\u95f4\u4e3a\u7a7a");
                    } else {
                        uccSkuManagementListQryBO.setInsertTime(new Date(cnncEsCommodityBo.getInsert_time()));
                    }
                    uccSkuManagementListQryBO.setPicUrl(cnncEsCommodityBo.getPicture_url());
                    List<Long> longs = this.uccOrgSkuMapper.qryAgreementIdsDel(uccSkuManagementListQryBO.getSkuId());
                    uccSkuManagementListQryBO.setAgrIdList(longs);
                    UccOrgSkuPO uccOrgSkuPO = new UccOrgSkuPO();
                    uccOrgSkuPO.setSkuId(uccSkuManagementListQryBO.getSkuId());
                    List<UccOrgSkuPO> list = this.uccOrgSkuMapper.getList(uccOrgSkuPO);
                    if (!CollectionUtils.isEmpty(list)) {
                        uccSkuManagementListQryBO.setIsVirtualSkuId(1);
                    } else {
                        uccSkuManagementListQryBO.setIsVirtualSkuId(0);
                    }
                    uccSkuManagementListQryBO.setVirtualSkuId(cnncEsCommodityBo.getVirtual_sku_id());
                    Long changeID = this.uccSkuChangeMapper.qryChangeIdBySkuCode(uccSkuManagementListQryBO.getSkuCode());
                    if (changeID != null) {
                        uccSkuManagementListQryBO.setChangeId(changeID.toString());
                    }
                    uccSkuManagementListQryBO.setFigure(cnncEsCommodityBo.getFigure());
                    uccSkuManagementListQryBO.setTexture(cnncEsCommodityBo.getTexture());
                    uccSkuManagementListQryBO.setSuppliesName(cnncEsCommodityBo.getSupplies_name());
                    if (!StringUtils.isEmpty((Object)cnncEsCommodityBo.getExpand1())) {
                        try {
                            uccSkuManagementListQryBO.setSalescapacity(new BigDecimal(cnncEsCommodityBo.getExpand1()));
                        }
                        catch (Exception e) {
                            log.error("[\u5546\u54c1\u4e2d\u5fc3-\u5546\u54c1\u4fe1\u606f\u67e5\u8be2]-\u9500\u552e\u5355\u4f4d\u5bb9\u91cf\u8f6c\u6362-\u5f02\u5e38|", (Throwable)e);
                        }
                    }
                    if (!StringUtils.isEmpty((Object)cnncEsCommodityBo.getExpand3())) {
                        uccSkuManagementListQryBO.setWarranty(cnncEsCommodityBo.getExpand3());
                    }
                    if (!StringUtils.isEmpty((Object)cnncEsCommodityBo.getExpand2())) {
                        uccSkuManagementListQryBO.setSalescapacityUnit(cnncEsCommodityBo.getExpand2());
                    }
                    if (cnncEsCommodityBo.getExpand21() != null) {
                        uccSkuManagementListQryBO.setSettlementUnitRate(cnncEsCommodityBo.getExpand21());
                    }
                    if (StringUtils.hasText((String)cnncEsCommodityBo.getVendor_code())) {
                        uccSkuManagementListQryBO.setVendorCode(cnncEsCommodityBo.getVendor_code());
                    }
                    uccSkuManagementListQryBO.setAgreementId(cnncEsCommodityBo.getAgreement_id());
                    uccSkuManagementListQryBOs.add(uccSkuManagementListQryBO);
                }
            }
            log.info("[\u5546\u54c1\u4e2d\u5fc3-\u5546\u54c1\u4fe1\u606f\u67e5\u8be2]-\u51fa\u53c2|uccSkuManagementListQryBOs:{}", (Object)((Object)uccSkuManagementListQryBOs).toString());
            rspBo.setRows(uccSkuManagementListQryBOs);
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

